/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test;

import junit.framework.Assert;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.qos.MsgQosData;

public class Msg
extends Assert {
    private String cbSessionId;
    private UpdateKey updateKey;
    private byte[] content;
    private UpdateQos updateQos;

    public Msg(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.cbSessionId = cbSessionId;
        this.updateKey = updateKey;
        this.content = content;
        this.updateQos = updateQos;
    }

    public String getCbSessionId() {
        return this.cbSessionId;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentStr() {
        return new String(this.content);
    }

    public int getContentInt() {
        try {
            return Integer.parseInt(this.getContentStr());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid number " + this.getContentStr() + ": " + e.toString() + ": " + this.updateKey.toXml());
        }
    }

    public UpdateKey getUpdateKey() {
        return this.updateKey;
    }

    public String getOid() {
        return this.updateKey == null ? null : this.updateKey.getOid();
    }

    public UpdateQos getUpdateQos() {
        return this.updateQos;
    }

    public String getState() {
        return this.updateQos == null ? null : this.updateQos.getState();
    }

    public void compareMsg(MsgUnit msgUnit) {
        MsgQosData qos = (MsgQosData)msgUnit.getQosData();
        Assert.assertEquals("The keyOid is wrong", msgUnit.getKeyOid(), this.updateKey.getOid());
        Assert.assertEquals("The persistence flag is lost", qos.isPersistent(), this.updateQos.isPersistent());
        Assert.assertEquals("The message content length is corrupted", msgUnit.getContent().length, this.content.length);
        Assert.assertTrue("The message content is corrupted, expected='" + msgUnit.getContentStr() + "' but was '" + new String(this.content) + "'", msgUnit.sameContent(this.content));
    }

    public void compareMsg(PublishReturnQos retQos) {
        Assert.assertEquals("The receive timestamp is corrupted", retQos.getRcvTimestamp(), this.updateQos.getRcvTimestamp());
    }
}

