/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test;

import java.lang.ref.WeakReference;
import java.util.Vector;
import junit.framework.Assert;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.client.qos.UpdateReturnQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class MsgInterceptor
extends Assert
implements I_Callback {
    private String ME = "Testsuite.MsgInterceptor";
    private final WeakReference weakglob;
    private final WeakReference weaklog;
    private I_Callback testsuite = null;
    private int verbosity = 2;
    private Vector updateVec = new Vector();

    public MsgInterceptor(Global glob, LogChannel log, I_Callback testsuite) {
        this.weakglob = new WeakReference<Global>(glob);
        this.weaklog = new WeakReference<LogChannel>(log);
        this.testsuite = testsuite;
    }

    public final Global getGlobal() {
        return (Global)this.weakglob.get();
    }

    public final LogChannel getLog() {
        return (LogChannel)this.weaklog.get();
    }

    public void setLogPrefix(String prefix) {
        this.ME = "Testsuite.MsgInterceptor-" + prefix;
    }

    public void setVerbosity(int val) {
        this.verbosity = val;
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        String contentStr = new String(content);
        if (this.verbosity == 1) {
            String cont = contentStr.length() > 10 ? contentStr.substring(0, 10) + "..." : contentStr;
            this.getLog().info(this.ME, "Receiving update of a message oid=" + updateKey.getOid() + " priority=" + updateQos.getPriority() + " state=" + updateQos.getState() + " content=" + cont);
        } else if (this.verbosity == 2) {
            this.getLog().info(this.ME, "Receiving update #" + (this.count() + 1) + " of a message cbSessionId=" + cbSessionId + updateKey.toXml() + "\n" + new String(content) + updateQos.toXml());
        }
        if (!updateQos.isErased()) {
            this.add(new Msg(cbSessionId, updateKey, content, updateQos));
        }
        if (this.testsuite != null) {
            return this.testsuite.update(cbSessionId, updateKey, content, updateQos);
        }
        UpdateReturnQos qos = new UpdateReturnQos(this.getGlobal());
        return qos.toXml();
    }

    public int waitOnUpdate(long timeout, int countExpected) {
        return this.waitOnUpdate(timeout, null, null, countExpected);
    }

    public int waitOnUpdate(long timeout, String oid, String state, int countExpected) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        int countArrived = 0;
        do {
            if ((countArrived = this.getMsgs(oid, state).length) >= countExpected) {
                return countArrived;
            }
            try {
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        } while ((sum += pollingInterval) <= timeout);
        this.getLog().error(this.ME, "timeout=" + timeout + " occurred for " + oid + " state=" + state + " countExpected=" + countExpected + " countArrived=" + countArrived);
        return countArrived;
    }

    public int waitOnUpdate(long timeout) {
        return this.waitOnUpdate(timeout, null, null);
    }

    public int waitOnUpdate(long timeout, String oid, String state) {
        try {
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        return this.getMsgs(oid, state).length;
    }

    public void add(Msg msg) {
        this.updateVec.addElement(msg);
    }

    public void remove(Msg msg) {
        this.updateVec.removeElement(msg);
    }

    public void clear() {
        this.updateVec.clear();
    }

    public Msg[] getMsgs(String oid, String state) {
        Vector<Msg> ret = new Vector<Msg>();
        int i = 0;
        while (i < this.updateVec.size()) {
            Msg msg = (Msg)this.updateVec.elementAt(i);
            if ((oid == null || oid.equals(msg.getOid())) && (state == null || state.equals(msg.getState()))) {
                ret.addElement(msg);
            }
            ++i;
        }
        return ret.toArray(new Msg[ret.size()]);
    }

    public Msg[] getMsgs() {
        return this.getMsgs(null, null);
    }

    public Msg getMsg(String oid, String state) throws XmlBlasterException {
        Msg[] msgs = this.getMsgs(oid, state);
        if (msgs.length > 1) {
            throw new XmlBlasterException("Msgs", "update(oid=" + oid + ", state=" + state + ") " + msgs.length + " arrived instead of zero or one");
        }
        if (msgs.length == 0) {
            return null;
        }
        return msgs[0];
    }

    public int count() {
        return this.updateVec.size();
    }

    public void compareToReceived(MsgUnit[] expectedArr, String secretCbSessionId) {
        Assert.assertEquals("We have received " + this.count() + " messages only", expectedArr.length, this.count());
        int i = 0;
        while (i < expectedArr.length) {
            MsgUnit expected = expectedArr[i];
            Msg msg = (Msg)this.updateVec.elementAt(i);
            if (secretCbSessionId != null) {
                Assert.assertEquals("The secretCbSessionId is wrong", secretCbSessionId, msg.getCbSessionId());
            }
            msg.compareMsg(expected);
            ++i;
        }
    }

    public void compareToReceived(PublishReturnQos[] expectedArr) {
        Assert.assertEquals("We have received " + this.count() + " messages only", expectedArr.length, this.count());
        int i = 0;
        while (i < expectedArr.length) {
            Msg msg = (Msg)this.updateVec.elementAt(i);
            msg.compareMsg(expectedArr[i]);
            ++i;
        }
    }
}

