/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.admin;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.QuerySpecQos;

public class TestAdminGet
extends TestCase
implements I_Callback {
    private static String ME = "TestAdminGet";
    private Global glob;
    private LogChannel log;
    private MsgInterceptor updateInterceptor;
    private String senderName;
    private final String contentMime = "text/plain";
    private String sessionName = "dispatchTester/1";

    public TestAdminGet(String testName) {
        this(null, testName);
    }

    public TestAdminGet(Global glob, String testName) {
        super(testName);
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("test");
        this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
        try {
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            connectQos.setSessionName(new SessionName(this.glob, this.sessionName));
            con.connect(connectQos, this);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestAdminGet-AGENT</key>";
        String qos = "<qos><forceDestroy>true</forceDestroy></qos>";
        I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
        try {
            try {
                EraseReturnQos[] arr = con.erase(xmlKey, qos);
                PropString defaultPlugin = new PropString("CACHE,1.0");
                String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
                this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                Object var8_9 = null;
                con.disconnect(null);
                this.glob = null;
                con = null;
                Global.instance().shutdown();
                return;
            }
            Object var8_8 = null;
            con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            con.disconnect(null);
            this.glob = null;
            con = null;
            Global.instance().shutdown();
            throw throwable;
        }
        this.glob = null;
        con = null;
        Global.instance().shutdown();
    }

    private void doSubscribe(String oid) {
        try {
            SubscribeKey key = new SubscribeKey(this.glob, oid);
            SubscribeQos qos = new SubscribeQos(this.glob);
            qos.setWantNotify(false);
            SubscribeReturnQos subscriptionId = this.glob.getXmlBlasterAccess().subscribe(key, qos, (I_Callback)this.updateInterceptor);
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + subscriptionId.getSubscriptionId() + " done");
            Assert.assertTrue("returned null subscriptionId", subscriptionId != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private void doUnSubscribe(String oid) {
        try {
            UnSubscribeKey key = new UnSubscribeKey(this.glob, oid);
            UnSubscribeQos qos = new UnSubscribeQos(this.glob);
            this.glob.getXmlBlasterAccess().unSubscribe(key, qos);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish(int counter, String oid) throws XmlBlasterException {
        this.log.info(ME, "Publishing a message " + oid + " ...");
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'><test></test></key>";
        String content = "" + counter;
        PublishQos qosWrapper = new PublishQos(this.glob);
        MsgUnit msgUnit = null;
        msgUnit = counter > -1 ? new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml()) : new MsgUnit(xmlKey, "", qosWrapper.toXml());
        this.glob.getXmlBlasterAccess().publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    public void testActivationFlag() {
        try {
            String oid = "TestActivationFlag";
            this.log.info(ME, "Going to publish 3 times on message '" + oid + "' (first time before subscribing)");
            this.doPublish(1, oid);
            this.doSubscribe(oid);
            this.doPublish(2, oid);
            this.doPublish(3, oid);
            Assert.assertEquals("wrong number of updates received", 3, this.updateInterceptor.waitOnUpdate(500L));
            this.updateInterceptor.clear();
            String getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive=one,two,three";
            MsgUnit[] msg = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), new GetQos(this.glob));
            Assert.assertEquals("wrong number of messages returned", 1, msg.length);
            int i = 0;
            while (i < msg.length) {
                this.log.info(ME, "testActivationFlag: dispatcherActive: (" + i + ") : '" + msg[i].getContentStr() + "'");
                Assert.assertEquals("wrong return value", "true", msg[i].getContentStr());
                ++i;
            }
            getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive=false";
            this.doPublish(-1, getOid);
            getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive";
            msg = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), new GetQos(this.glob));
            Assert.assertEquals("wrong number of messages returned", 1, msg.length);
            int i2 = 0;
            while (i2 < msg.length) {
                this.log.info(ME, "testActivationFlag: dispatcherActive (result): (" + i2 + ") : '" + msg[i2].getContentStr() + "'");
                Assert.assertEquals("wrong return value", "false", msg[i2].getContentStr());
                ++i2;
            }
            this.doPublish(4, oid);
            this.doPublish(5, oid);
            int numArrived = this.updateInterceptor.waitOnUpdate(2000L);
            Assert.assertEquals("wrong number of messages arrived", 0, numArrived);
            getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive=true";
            this.doPublish(-1, getOid);
            getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive";
            msg = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), new GetQos(this.glob));
            Assert.assertEquals("wrong number of messages returned", 1, msg.length);
            int i3 = 0;
            while (i3 < msg.length) {
                this.log.info(ME, "testActivationFlag: dispatcherActive (result): (" + i3 + ") : '" + msg[i3].getContentStr() + "'");
                Assert.assertEquals("wrong return value", "true", msg[i3].getContentStr());
                ++i3;
            }
            numArrived = this.updateInterceptor.waitOnUpdate(2000L);
            Assert.assertEquals("wrong number of messages arrived", 2, numArrived);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception should not occur here", false);
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        String contentStr = new String(content);
        String cont = contentStr.length() > 10 ? contentStr.substring(0, 10) + "..." : contentStr;
        this.log.info(ME, "Receiving update of a message oid=" + updateKey.getOid() + " priority=" + updateQos.getPriority() + " state=" + updateQos.getState() + " content=" + cont);
        this.log.info(ME, "further log for receiving update of a message cbSessionId=" + cbSessionId + updateKey.toXml() + "\n" + new String(content) + updateQos.toXml());
        this.log.error(ME, "update: should never be invoked (msgInterceptors take care of it since they are passed on subscriptions)");
        return "OK";
    }

    public void testGetQueueEntries() {
        try {
            String oid = "TestGetQueueEntries";
            this.doSubscribe(oid);
            String getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive=false";
            this.doPublish(-1, getOid);
            this.doPublish(1, oid);
            this.doPublish(2, oid);
            this.doPublish(3, oid);
            this.log.info(ME, "Going to publish 3 times on message '" + oid + "'");
            Assert.assertEquals("wrong number of updates received", 0, this.updateInterceptor.waitOnUpdate(500L));
            this.updateInterceptor.clear();
            GetQos getQos = new GetQos(this.glob);
            QuerySpecQos querySpecQos = new QuerySpecQos(this.glob, "QueueQuery", "1.0", "maxEntries=3&maxSize=-1&consumable=false&waitingDelay=0");
            getQos.addQuerySpec(querySpecQos);
            getOid = "__cmd:client/" + this.sessionName + "/?cbQueueEntries";
            MsgUnit[] mu = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), getQos);
            Assert.assertEquals("wrong number of retreived entries", 3, mu.length);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception should not occur here", false);
        }
    }

    private void doActivateDispatch(boolean doDispatch) throws XmlBlasterException {
        String getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive=" + doDispatch;
        this.doPublish(-1, getOid);
        getOid = "__cmd:client/" + this.sessionName + "/?dispatcherActive";
        MsgUnit[] msg = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), new GetQos(this.glob));
        Assert.assertEquals("wrong number of messages returned", 1, msg.length);
        Assert.assertEquals("wrong return value", "" + doDispatch, msg[0].getContentStr());
    }

    private void adminGet(String oid, boolean consumable, long waitingDelay, int maxEntries, int initialEntries, int endEntries, int entriesExpected) {
        try {
            boolean sizePerMsg = false;
            this.doActivateDispatch(false);
            Assert.assertEquals("wrong prerequisite: entries have arrived before starting the test: probably coming from an inconsistency in the previous test", 0, this.updateInterceptor.count());
            this.updateInterceptor.clear();
            int i = 0;
            while (i < initialEntries) {
                this.doPublish(i, oid);
                ++i;
            }
            this.log.info(ME, "In the callback queue there should now be '" + initialEntries + "' entries");
            int ret = this.updateInterceptor.waitOnUpdate(200L);
            Assert.assertEquals("no update should arrive here ", 0, ret);
            int extraEntries = endEntries - initialEntries;
            MsgUnit[] msgs = new MsgUnit[extraEntries];
            int i2 = 0;
            while (i2 < extraEntries) {
                String content = "extraMsg" + i2;
                msgs[i2] = new MsgUnit(new PublishKey(this.glob, oid), content, new PublishQos(this.glob));
                ++i2;
            }
            long delay = waitingDelay / 3L + 10L;
            PublisherThread pubThread = new PublisherThread(this.glob, delay, msgs);
            GetQos getQos = new GetQos(this.glob);
            QuerySpecQos querySpecQos = new QuerySpecQos(this.glob, "QueueQuery", "1.0", "maxEntries=" + maxEntries + "&maxSize=-1&consumable=" + consumable + "&waitingDelay=" + waitingDelay);
            getQos.addQuerySpec(querySpecQos);
            String getOid = "__cmd:client/" + this.sessionName + "/?cbQueueEntries";
            MsgUnit[] mu = this.glob.getXmlBlasterAccess().get(new GetKey(this.glob, getOid), getQos);
            Assert.assertEquals("an exception occured when it should not", false, pubThread.hasException());
            Assert.assertEquals("wrong number of retreived entries", entriesExpected, mu.length);
            Assert.assertEquals("messages should not arrive here", 0, this.updateInterceptor.count());
            this.doActivateDispatch(true);
            if (consumable) {
                int rest = endEntries - mu.length;
                int arrived = 0;
                arrived = rest < 1 ? this.updateInterceptor.waitOnUpdate(500L, 1) : this.updateInterceptor.waitOnUpdate(500L, rest);
                Assert.assertEquals("wrong number of messages arrived (some should have been consumed by the get", rest, arrived);
            } else {
                int arrived = this.updateInterceptor.waitOnUpdate(200L, endEntries);
                Assert.assertEquals("all published messages should arrive here", endEntries, arrived);
            }
            this.updateInterceptor.clear();
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception should not occur here", false);
        }
    }

    public void testGetNonConsumableNoWaiting() {
        String oid = "NonConsumableNoWaiting";
        this.doSubscribe(oid);
        boolean consumable = false;
        long waiting = 0L;
        int maxEntries = 3;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, 0);
        this.adminGet(oid, consumable, waiting, maxEntries, 2, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 2, 0);
        this.doUnSubscribe(oid);
    }

    public void testGetConsumableNoWaiting() {
        String oid = "ConsumableNoWaiting";
        this.doSubscribe(oid);
        boolean consumable = true;
        long waiting = 0L;
        int maxEntries = 3;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, 0);
        this.adminGet(oid, consumable, waiting, maxEntries, 2, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 2, 0);
        this.doUnSubscribe(oid);
    }

    public void testGetNonConsumableDoWaiting() {
        String oid = "NonConsumableDoWaiting";
        this.doSubscribe(oid);
        boolean consumable = false;
        long waiting = 200L;
        int maxEntries = 3;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 2, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 1, maxEntries, maxEntries);
        waiting = -1L;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 1, maxEntries, maxEntries);
        this.doUnSubscribe(oid);
    }

    public void testGetConsumableDoWaiting() {
        String oid = "ConsumableDoWaiting";
        this.doSubscribe(oid);
        boolean consumable = false;
        long waiting = 200L;
        int maxEntries = 3;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 2, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 2, 2);
        this.adminGet(oid, consumable, waiting, maxEntries, 1, maxEntries, maxEntries);
        waiting = -1L;
        this.adminGet(oid, consumable, waiting, maxEntries, 4, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 0, 4, maxEntries);
        this.adminGet(oid, consumable, waiting, maxEntries, 1, maxEntries, maxEntries);
        this.doUnSubscribe(oid);
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestAdminGet testSub = new TestAdminGet(glob, "TestAdminGet/1");
        testSub.setUp();
        testSub.testActivationFlag();
        testSub.tearDown();
        testSub.setUp();
        testSub.testGetQueueEntries();
        testSub.tearDown();
        testSub.setUp();
        testSub.testGetNonConsumableNoWaiting();
        testSub.tearDown();
        testSub.setUp();
        testSub.testGetNonConsumableDoWaiting();
        testSub.tearDown();
        testSub.setUp();
        testSub.testGetConsumableNoWaiting();
        testSub.tearDown();
        testSub.setUp();
        testSub.testGetConsumableDoWaiting();
        testSub.tearDown();
    }

    public class PublisherThread
    extends Thread {
        private Global global;
        private long delay;
        private MsgUnit[] msgUnits;
        private Exception ex;

        public PublisherThread(Global global, long timeToWaitBeforePublishing, MsgUnit[] msgUnits) {
            this.global = global;
            this.delay = timeToWaitBeforePublishing;
            this.msgUnits = msgUnits;
            this.start();
        }

        public boolean hasException() {
            return this.ex != null;
        }

        public void run() {
            try {
                if (this.delay > 0L) {
                    Thread.sleep(this.delay);
                }
                this.global.getXmlBlasterAccess().publishArr(this.msgUnits);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.ex = ex;
            }
        }
    }
}

