/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import java.io.File;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;

public class TestAuthenticationHtPassWd
extends TestCase {
    private EmbeddedXmlBlaster serverThread = null;
    private final String RIGHT_USERNAME = "existingUser";
    private final String PARTIAL_USERNAME = "existingSomeThingElseStandsBehind";
    private final String RIGHT_PASSWORD = "existingUserPW";
    private final String WRONG_USERNAME = "notExistingUser";
    private final String WRONG_PASSWORD = "notExistingUserPW";
    private String userhome = "";
    private Global glob = new Global();
    private LogChannel log = this.glob.getLog("test");
    private I_XmlBlasterAccess con = null;
    private int serverPort = 7604;
    public final String ME = "TestAuthenticationHtPassWd";

    public TestAuthenticationHtPassWd(String name) {
        super(name);
        this.userhome = this.glob.getProperty().get("user.home", "/home/astelzl") + File.separatorChar;
        try {
            FileUtil.writeFile(this.userhome + "test.htpasswd", "existingUser:yZum5CYzDk.EE\n");
            FileUtil.writeFile(this.userhome + "test.htpasswd2", "existing:yZum5CYzDk.EE\n");
            FileUtil.writeFile(this.userhome + "test.htpasswd1", "*");
        }
        catch (Exception ex) {
            Assert.assertTrue("Could not create password files in directory '" + this.userhome + "'. Tests won't work!", false);
        }
    }

    protected void setUp() {
    }

    private void setupTestCase(int testcase) {
        String[] ports = Util.getOtherServerPorts(this.serverPort);
        String[] args = new String[4 + ports.length];
        switch (testcase) {
            case 1: {
                args[0] = "-Security.Server.Plugin.htpasswd.secretfile";
                args[1] = this.userhome + "test.htpasswd2";
                args[2] = "-Security.Server.Plugin.htpasswd.allowPartialUsername";
                args[3] = "true";
                break;
            }
            case 2: {
                args[0] = "-Security.Server.Plugin.htpasswd.secretfile";
                args[1] = this.userhome + "test.htpasswd";
                args[2] = "-Security.Server.Plugin.htpasswd.allowPartialUsername";
                args[3] = "false";
                break;
            }
            case 3: {
                args[0] = "-Security.Server.Plugin.htpasswd.secretfile";
                args[1] = this.userhome + "test.htpasswd";
                args[2] = "-Security.Server.Plugin.htpasswd.allowPartialUsername";
                args[3] = "false";
                break;
            }
            case 4: {
                args[0] = "-Security.Server.Plugin.htpasswd.secretfile";
                args[1] = this.userhome + "test.htpasswd1";
                args[2] = "-Security.Server.Plugin.htpasswd.allowPartialUsername";
                args[3] = "false";
            }
        }
        int i = 0;
        while (i < ports.length) {
            args[i + 4] = ports[i];
            ++i;
        }
        this.glob.init(args);
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.stopServer(true);
        }
        this.glob.init(Util.getDefaultServerPorts());
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.con = null;
        Global.instance().shutdown();
    }

    public void testAuthHtPassWordCase1() {
        this.log.info("TestAuthenticationHtPassWd", "Testcase1");
        this.setupTestCase(1);
        boolean isValue = true;
        try {
            this.con = this.glob.getXmlBlasterAccess();
        }
        catch (Exception ex) {
            this.log.error("TestAuthenticationHtPassWd", "Could not initialize I_XmlBlasterAccess: " + ex.toString());
            ex.printStackTrace();
        }
        try {
            ConnectQos qos = new ConnectQos(this.glob, "existingSomeThingElseStandsBehind", "existingUserPW");
            ConnectReturnQos conRetQos = this.con.connect(qos, null);
            this.con.disconnect(null);
        }
        catch (Exception ex) {
            this.log.info("TestAuthenticationHtPassWd", "Could not connect: " + ex.toString());
            ex.printStackTrace();
            isValue = false;
        }
        Assert.assertTrue("Could not connect although it should have been possible with the specified beginning of username and password", isValue);
    }

    public void testAuthHtPassWordCase2() {
        this.log.info("TestAuthenticationHtPassWd", "Testcase2");
        this.setupTestCase(2);
        boolean isValue = true;
        try {
            this.con = this.glob.getXmlBlasterAccess();
        }
        catch (Exception ex) {
            this.log.error("TestAuthenticationHtPassWd", "Could not initialize I_XmlBlasterAccess");
        }
        try {
            ConnectQos qos = new ConnectQos(this.glob, "existingUser", "existingUserPW");
            ConnectReturnQos conRetQos = this.con.connect(qos, null);
            this.con.disconnect(null);
        }
        catch (Exception ex) {
            this.log.info("TestAuthenticationHtPassWd", "Could not connect");
            isValue = false;
            ex.printStackTrace();
        }
        Assert.assertTrue("Could not connect although it should have been possible with the specified username and password", isValue);
    }

    public void testAuthHtPassWordCaseWrongPassword() {
        this.log.info("TestAuthenticationHtPassWd", "Testcase3");
        this.setupTestCase(3);
        boolean isValue = false;
        try {
            this.con = this.glob.getXmlBlasterAccess();
        }
        catch (Exception ex) {
            this.log.error("TestAuthenticationHtPassWd", "Could not initialize I_XmlBlasterAccess");
        }
        try {
            ConnectQos qos = new ConnectQos(this.glob, "notExistingUser", "notExistingUserPW");
            ConnectReturnQos conRetQos = this.con.connect(qos, null);
            this.con.disconnect(null);
            Assert.assertTrue("Could connect although it should not have been possible with the specified username and password", isValue);
        }
        catch (Exception ex) {
            isValue = true;
            this.log.info("TestAuthenticationHtPassWd", "Could not connect");
        }
    }

    public void testAuthHtPassWordCase3() {
        this.log.info("TestAuthenticationHtPassWd", "Testcase4");
        this.setupTestCase(4);
        boolean isValue = true;
        try {
            this.con = this.glob.getXmlBlasterAccess();
        }
        catch (Exception ex) {
            this.log.error("TestAuthenticationHtPassWd", "Could not initialize I_XmlBlasterAccess");
        }
        try {
            ConnectQos qos = new ConnectQos(this.glob, "notExistingUser", "notExistingUserPW");
            ConnectReturnQos conRetQos = this.con.connect(qos, null);
            this.con.disconnect(null);
        }
        catch (Exception ex) {
            this.log.info("TestAuthenticationHtPassWd", "Could not connect");
            isValue = false;
        }
        Assert.assertTrue("Could not connect although it should have been possible as any username and password is authenticated", isValue);
    }
}

