/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.address.Destination;

public class TestLogin
extends TestCase
implements I_Callback {
    private static String ME = "TestLogin";
    private final Global glob;
    private final LogChannel log;
    private String publishOid = "";
    private String firstOid = "FirstOid";
    private I_XmlBlasterAccess callbackConnection;
    private String senderName;
    private String senderContent;
    private I_XmlBlasterAccess secondConnection;
    private String secondName;
    private String secondOid = "SecondOid";
    private MsgUnit msgUnit;
    private int numReceived = 0;
    private final String contentMime = "text/plain";
    private final String contentMimeExtended = "1.0";
    private final boolean IS_PTP = true;
    private final boolean IS_PUBSUB = false;

    public TestLogin(Global glob, String testName, String senderName, String secondName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = senderName;
        this.secondName = secondName;
    }

    protected void setUp() {
        block4: {
            this.log.info(ME, "######## Entering setup");
            try {
                String passwd = "secret";
                this.callbackConnection = this.glob.getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(this.glob, this.senderName, passwd);
                this.callbackConnection.connect(qos, this);
                Global secondGlobal = this.glob.getClone(null);
                this.secondConnection = secondGlobal.getXmlBlasterAccess();
                qos = new ConnectQos(secondGlobal, this.secondName, passwd);
                this.secondConnection.connect(qos, this);
            }
            catch (XmlBlasterException e) {
                if (e.getErrorCode() == ErrorCode.USER_CONNECT_MULTIPLE) break block4;
                this.log.error(ME, e.toString());
                Assert.fail(ME + ".setup failed: " + e.toString());
            }
        }
        String xmlKey = "<key oid='" + this.firstOid + "' contentMime='" + "text/plain" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <TestLogin-AGENT>" + "   </TestLogin-AGENT>" + "</key>";
        this.senderContent = "Some content";
        try {
            this.msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "setup() failed: " + e.getMessage());
            Assert.fail(e.getMessage());
        }
    }

    protected void tearDown() {
        EraseReturnQos[] arr;
        String xmlKey = "<key oid='" + this.firstOid + "' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            arr = this.callbackConnection.erase(xmlKey, qos);
            if (arr != null && arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages:");
            }
            Assert.assertEquals("Wrong number of messages erased", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME + "-tearDown()", "XmlBlasterException in erase(): " + e.getMessage());
            Assert.fail(ME + "-tearDown() XmlBlasterException in erase(): " + e.getMessage());
        }
        xmlKey = "<key oid='" + this.secondOid + "' queryType='EXACT'>\n</key>";
        qos = "<qos></qos>";
        try {
            arr = this.callbackConnection.erase(xmlKey, qos);
            if (arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages of '" + this.secondOid + "'");
            }
            Assert.assertEquals("Wrong number of messages '" + this.secondOid + "' erased", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME + "-tearDown()", "XmlBlasterException in erase(): " + e.getMessage());
            Assert.fail(ME + "-tearDown() XmlBlasterException in erase(): " + e.getMessage());
        }
        DisconnectQos qos2 = new DisconnectQos(this.glob);
        qos2.clearSessions(true);
        this.callbackConnection.disconnect(qos2);
        this.secondConnection.disconnect(null);
    }

    public void doSubscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestLogin-AGENT</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        try {
            String subscribeOid = this.callbackConnection.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
            Assert.assertTrue("returned subscribeOid is empty", 0 != subscribeOid.length());
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME + "-doSubscribeXPath", "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish(boolean ptp) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        try {
            PublishQos publishQos = new PublishQos(this.glob);
            this.msgUnit = new MsgUnit(this.msgUnit, null, null, publishQos.getData());
            if (ptp) {
                PublishKey pk = new PublishKey(this.glob);
                PublishQos pq = new PublishQos(this.glob);
                pq.addDestination(new Destination(new SessionName(this.glob, this.secondName)));
                this.msgUnit = new MsgUnit(this.msgUnit, pk.getData(), null, pq.getData());
            }
            this.publishOid = this.callbackConnection.publish(this.msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publish " + this.msgUnit.getKey() + " done");
            if (!ptp) {
                Assert.assertEquals("oid is different", this.firstOid, this.publishOid);
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME + "-doPublish", "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
    }

    public void testLoginLogout() {
        this.log.info(ME, "TEST 1: Subscribe and publish -> Expecting one update");
        this.numReceived = 0;
        this.doSubscribeXPath();
        this.doPublish(false);
        this.waitOnUpdate(2000L, 1);
        this.log.info(ME, "TEST 2: Login again without logout and publish PtP -> Expecting one update");
        this.setUp();
        this.doPublish(true);
        this.waitOnUpdate(2000L, 1);
        this.log.info(ME, "TEST 3: Login again without logout and publish Pub/Sub -> Expecting no update");
        this.setUp();
        this.doPublish(false);
        this.waitOnUpdate(2000L, 1);
        this.numReceived = 0;
        this.log.info(ME, "TEST 4: Now subscribe -> Expecting one update");
        this.numReceived = 0;
        this.doSubscribeXPath();
        this.waitOnUpdate(2000L, 1);
        this.log.info(ME, "TEST 5: Test publish from other user -> Expecting one update");
        this.numReceived = 0;
        try {
            String xmlKey = "<key oid='" + this.secondOid + "' contentMime='" + "text/plain" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <TestLogin-AGENT>" + "   </TestLogin-AGENT>" + "</key>";
            String content = "Some content";
            MsgUnit mu = new MsgUnit(xmlKey, content.getBytes(), "<qos></qos>");
            this.publishOid = this.secondConnection.publish(mu).getKeyOid();
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME + "-secondPublish", "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("second - publish - XmlBlasterException: " + e.getMessage(), false);
        }
        this.waitOnUpdate(2000L, 2);
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
        this.log.info(ME, "TEST 6: Test logout with following publish -> Should not be possible");
        this.callbackConnection.disconnect(null);
        try {
            this.publishOid = this.callbackConnection.publish(this.msgUnit).getKeyOid();
            Assert.assertTrue("Didn't expect successful publish after logout", false);
        }
        catch (XmlBlasterException e) {
            this.log.info(ME, "Success got exception for publishing after logout: " + e.toString());
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals("Didn't expect an update", 0, this.numReceived);
        this.log.info(ME, "SUCCESS in testLoginLogout()");
        this.setUp();
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " state=" + updateQos.getState() + " rcvTime=" + updateQos.getRcvTimestamp().toString());
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + updateQos.toXml());
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) > timeout) {
                this.log.error(ME, "Timeout of " + timeout + " occurred without update");
                Thread.currentThread();
                Thread.dumpStack();
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", sum <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        if (numWait != this.numReceived) {
            this.log.error(ME, "Wrong number of messages arrived, expected numWait=" + numWait + " but got numReceived=" + this.numReceived);
            Thread.currentThread();
            Thread.dumpStack();
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.numReceived);
        this.numReceived = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestLogin(new Global(), "testLoginLogout", "Tim", "Joe"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestLogin testSub = new TestLogin(glob, "TestLogin", "Tim", "Joe");
        testSub.setUp();
        testSub.testLoginLogout();
        testSub.tearDown();
    }
}

