/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import java.util.StringTokenizer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;

public class TestLoginLogoutEvent
extends TestCase {
    private static String ME = "TestLoginLogoutEvent";
    private Global glob;
    private LogChannel log;
    private I_XmlBlasterAccess firstConnection;
    private String firstName;
    private I_XmlBlasterAccess secondConnection;
    private String secondName;
    private String expectedName;
    private String passwd = "secret";
    private int numReceived = 0;
    private final String contentMime = "text/plain";
    private final String contentMimeExtended = "1.0";
    private MsgInterceptor updateInterceptFirst;
    private MsgInterceptor updateInterceptSecond;

    public TestLoginLogoutEvent(Global glob, String testName, String firstName, String secondName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.firstName = firstName;
        this.secondName = secondName;
    }

    protected void setUp() {
        try {
            Global firstGlob = this.glob.getClone(null);
            this.firstConnection = firstGlob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(firstGlob, this.firstName, this.passwd);
            this.updateInterceptFirst = new MsgInterceptor(firstGlob, this.log, null);
            this.firstConnection.connect(qos, this.updateInterceptFirst);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
        this.updateInterceptFirst.clear();
    }

    protected void tearDown() {
        String xmlKey = "<key oid='__sys__Logout' queryType='EXACT'></key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        if (this.firstConnection != null) {
            try {
                this.firstConnection.unSubscribe(xmlKey, qos);
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME + "-subscribe", "XmlBlasterException: " + e.getMessage());
                Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
            }
            this.firstConnection.disconnect(null);
            this.firstConnection = null;
        }
        if (this.secondConnection != null) {
            this.secondConnection.disconnect(null);
            this.secondConnection = null;
        }
        this.glob = null;
        this.log = null;
        Global.instance().shutdown();
    }

    public void subscribe(String oid) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing to login events ...");
        }
        String xmlKey = "<key oid='" + oid + "' queryType='EXACT'></key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        try {
            String subscribeOid = this.firstConnection.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME + "-subscribe", "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testLoginLogout() {
        long sleep = 1000L;
        this.numReceived = 0;
        this.expectedName = this.firstName;
        this.subscribe("__sys__Login");
        Assert.assertEquals("Missing my login event", 1, this.updateInterceptFirst.waitOnUpdate(sleep, "__sys__Login", "OK"));
        String content = this.updateInterceptFirst.getMsgs()[0].getContentStr();
        this.log.info(ME, "Received login event for " + content);
        Assert.assertEquals("Wrong login name", this.expectedName, content);
        this.updateInterceptFirst.clear();
        this.numReceived = 0;
        this.expectedName = null;
        this.subscribe("__sys__Logout");
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.updateInterceptFirst.clear();
        this.numReceived = 0;
        this.expectedName = this.secondName;
        try {
            Global secondGlob = this.glob.getClone(null);
            this.secondConnection = secondGlob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(secondGlob, this.secondName, this.passwd);
            this.updateInterceptSecond = new MsgInterceptor(secondGlob, this.log, null);
            this.secondConnection.connect(qos, this.updateInterceptSecond);
            Assert.assertEquals("Missing my login event", 1, this.updateInterceptFirst.waitOnUpdate(sleep, "__sys__Login", "OK"));
            String content2 = this.updateInterceptFirst.getMsgs()[0].getContentStr();
            this.log.info(ME, "Received login event for " + content2);
            Assert.assertEquals("Wrong login name", this.expectedName, content2);
            this.updateInterceptFirst.clear();
            Assert.assertEquals("Not expected update for second con", 0, this.updateInterceptSecond.waitOnUpdate(500L));
            this.updateInterceptSecond.clear();
            MsgUnit[] msgArr = this.secondConnection.get("<key oid='__sys__UserList' queryType='EXACT'></key>", "<qos></qos>");
            Assert.assertTrue("Expected on __sys__UserList", msgArr.length == 1);
            String clients = new String(msgArr[0].getContent());
            this.log.info(ME, "Current '__sys__UserList' is\n" + clients);
            StringTokenizer st = new StringTokenizer(clients, ",");
            int found = 0;
            while (st.hasMoreTokens()) {
                String client = st.nextToken();
                this.log.info(ME, "Parsing name=" + client);
                SessionName sessionName = new SessionName(this.glob, client);
                if (sessionName.getLoginName().equals(this.firstName)) {
                    ++found;
                    continue;
                }
                if (!sessionName.getLoginName().equals(this.secondName)) continue;
                ++found;
            }
            Assert.assertTrue("Check of '__sys__UserList' failed", found == 2);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, e.getMessage());
            Assert.assertTrue("Second login failed", false);
        }
        this.numReceived = 0;
        this.expectedName = this.secondName;
        this.secondConnection.disconnect(null);
        this.secondConnection = null;
        Assert.assertEquals("Missing my logout event", 1, this.updateInterceptFirst.waitOnUpdate(sleep, "__sys__Logout", "OK"));
        content = this.updateInterceptFirst.getMsgs()[0].getContentStr();
        this.log.info(ME, "Received logout event for " + content);
        Assert.assertEquals("Wrong logout name", this.expectedName, content);
        this.updateInterceptFirst.clear();
        Assert.assertEquals("Not expected update for second con", 0, this.updateInterceptSecond.waitOnUpdate(500L));
        this.updateInterceptSecond.clear();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestLoginLogoutEvent(new Global(), "testLoginLogout", "Gesa", "Ben"));
        return suite;
    }

    public static void main(String[] args) {
        TestLoginLogoutEvent testSub = new TestLoginLogoutEvent(new Global(args), "TestLoginLogoutEvent", "Tim", "Joe");
        testSub.setUp();
        testSub.testLoginLogout();
        testSub.tearDown();
    }
}

