/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class TestLogout
extends TestCase
implements I_Callback {
    private static String ME = "TestLogout";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con;

    public TestLogout(Global glob) {
        super("TestLogout");
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    public TestLogout(String name) {
        super(name);
        this.glob = new Global();
        this.log = this.glob.getLog(null);
    }

    protected void setUp() {
        try {
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, ME, "secret");
            this.con.connect(qos, this);
            this.log.info(ME, "Successful login");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        if (this.con != null) {
            this.con.disconnect(null);
        }
    }

    public void testDisconnect() {
        this.log.info(ME, "*** Enter testDisconnect() ...");
        if (!this.con.disconnect(null)) {
            this.log.error(ME, "Expected successful disconnect");
            Assert.fail("Expected successful disconnect");
        }
        if (this.con.disconnect(null)) {
            this.log.error(ME, "Expected disconnect to fail, we have disconnected already");
            Assert.fail("Expected disconnect to fail, we have disconnected already");
        }
        this.con = null;
        this.log.info(ME, "*** Leave testDisconnect() ...");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        Assert.fail("Receiving update of a message " + updateKey.getOid());
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(1);
        }
        TestLogout testSub = new TestLogout(glob);
        testSub.setUp();
        testSub.testDisconnect();
        testSub.tearDown();
    }
}

