/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSession
extends TestCase
implements I_Callback {
    private static String ME = "TestSession";
    private final Global glob;
    private final LogChannel log;
    private String name;
    private String passwd = "secret";
    private int numReceived = 0;

    public TestSession(Global glob, String testName, String name) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
        this.name = name;
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testZeroSessions() {
        this.log.info(ME, "testZeroSessions() ...");
        try {
            this.log.info(ME, "Connecting ...");
            I_XmlBlasterAccess con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            qos.setMaxSessions(-16);
            con.connect(qos, this);
            Assert.assertTrue("Connecting with zero sessions should not be possible", false);
        }
        catch (Exception e) {
            this.log.info(ME, "Success, can't connect with zero sessions");
        }
        this.log.info(ME, "Success in testZeroSessions()");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSessionOverflow() {
        block15: {
            this.log.info(TestSession.ME, "testSessionOverflow() ...");
            numLogin = 5;
            maxSessions = numLogin - 2;
            con = new I_XmlBlasterAccess[5];
            try {
                ii = 0;
                while (true) {
                    if (ii >= numLogin) {
                        var7_7 = null;
                        break;
                    }
                    try {
                        this.log.info(TestSession.ME, "Connecting number " + ii + " of " + numLogin + " max=" + maxSessions);
                        con[ii] = this.glob.getClone(null).getXmlBlasterAccess();
                        qos = new ConnectQos(con[ii].getGlobal(), this.name, this.passwd);
                        qos.setMaxSessions(maxSessions);
                        con[ii].connect(qos, this);
                        if (ii >= maxSessions) {
                            Assert.assertTrue("Connecting number " + ii + " of max=" + maxSessions + " is not allowed", false);
                        }
                    }
                    catch (Exception e) {
                        if (ii >= maxSessions) {
                            this.log.info(TestSession.ME, "Success, connecting number " + ii + " of max=" + maxSessions + " was denied: " + e.toString());
                        }
                        this.log.error(TestSession.ME, e.toString());
                        Assert.assertTrue("Connecting number " + ii + " of max=" + maxSessions + " should be possible", false);
                    }
                    ++ii;
                }
            }
            catch (Throwable var6_15) {
                var7_8 = null;
                try {
                    ii = 0;
                    while (true) {
                        if (ii >= maxSessions) {
                            throw var6_15;
                        }
                        disQos = null;
                        con[ii].disconnect(disQos);
                        ++ii;
                    }
                }
                catch (Throwable e) {
                    Assert.assertTrue(e.toString(), false);
                    throw var6_15;
                }
            }
            ** try [egrp 2[TRYBLOCK] [2 : 325->358)] { 
lbl48:
            // 1 sources

            ii = 0;
            while (ii < maxSessions) {
                disQos = null;
                con[ii].disconnect(disQos);
                ++ii;
            }
            break block15;
lbl56:
            // 1 sources

            catch (Throwable e) {
                Assert.assertTrue(e.toString(), false);
            }
        }
        this.log.info(TestSession.ME, "Success in testSessionOverflow()");
    }

    public void testSessionTimeout() {
        this.log.info(ME, "testSessionTimeout() ...");
        long timeout = 1000L;
        I_XmlBlasterAccess con = null;
        try {
            try {
                con = this.glob.getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
                qos.setSessionTimeout(timeout);
                con.connect(qos, this);
            }
            catch (Exception e) {
                this.log.error(ME, e.toString());
                Assert.assertTrue("Login failed" + e.toString(), false);
            }
            try {
                Thread.currentThread();
                Thread.sleep(timeout * 2L);
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.log.info(ME, "Check access ...");
                con.get("<key oid='__cmd:?freeMem'/>", null);
                Assert.assertTrue("get of expired login session is not possible", false);
            }
            catch (Exception e) {
                this.log.info(ME, "Success, no access after session expiry");
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                con.disconnect(null);
            }
            catch (Throwable e) {
                Assert.assertTrue(e.toString(), false);
            }
            throw throwable;
        }
        try {
            con.disconnect(null);
        }
        catch (Throwable e) {
            Assert.assertTrue(e.toString(), false);
        }
        this.log.info(ME, "Success in testSessionTimeout()");
    }

    public void testSessionTimeoutRespan() {
        this.log.info(ME, "testSessionTimeoutRespan() ...");
        long timeout = 2000L;
        I_XmlBlasterAccess con = null;
        try {
            try {
                con = this.glob.getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
                qos.setSessionTimeout(timeout);
                con.connect(qos, this);
            }
            catch (Exception e) {
                this.log.error(ME, e.toString());
                Assert.assertTrue("Login failed" + e.toString(), false);
            }
            try {
                int ii = 0;
                while (ii < 4) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(timeout / 2L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.log.info(ME, "Check access #" + ii + " ...");
                    con.get("<key oid='__cmd:?freeMem'/>", null);
                    this.log.info(ME, "Check access #" + ii + " OK");
                    ++ii;
                }
            }
            catch (Exception e) {
                this.log.error(ME, "No access: " + e.toString());
                Assert.assertTrue("Session is expired", false);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                con.disconnect(null);
            }
            catch (Throwable e) {
                Assert.assertTrue(e.toString(), false);
            }
            throw throwable;
        }
        try {
            con.disconnect(null);
        }
        catch (Throwable e) {
            Assert.assertTrue(e.toString(), false);
        }
        this.log.info(ME, "Success in testSessionTimeoutRespan()");
    }

    public void testClearSession() {
        this.log.info(ME, "***testClearSession() ...");
        int numLogin = 5;
        int maxSessions = numLogin - 2;
        I_XmlBlasterAccess[] con = new I_XmlBlasterAccess[5];
        int ii = 0;
        while (ii < numLogin) {
            try {
                this.log.info(ME, "Connecting number " + ii + " of " + numLogin + " max=" + maxSessions);
                con[ii] = this.glob.getClone(null).getXmlBlasterAccess();
                ConnectQos qos = new ConnectQos(con[ii].getGlobal(), this.name, this.passwd);
                qos.setMaxSessions(maxSessions);
                con[ii].connect(qos, this);
            }
            catch (XmlBlasterException e) {
                if (ii >= maxSessions) {
                    this.log.info(ME, "Success, connecting number " + ii + " of max=" + maxSessions + " was denied: " + e.toString());
                    this.log.info(ME, "We try to clear the old sessions now");
                    try {
                        ConnectQos qos = new ConnectQos(null, this.name, this.passwd);
                        qos.setMaxSessions(maxSessions);
                        qos.clearSessions(true);
                        con[ii].connect(qos, this);
                        this.log.info(ME, "Success, login is possible again");
                        con[ii].get("<key oid='__cmd:?freeMem'/>", null);
                        this.log.info(ME, "Success, get works");
                    }
                    catch (Exception e2) {
                        this.log.error(ME, "Clear session failed: " + e2.toString());
                        e2.printStackTrace();
                        Assert.fail("Login failed" + e2.toString());
                    }
                }
                this.log.error(ME, e.toString());
                Assert.assertTrue("Connecting number " + ii + " of max=" + maxSessions + " should be possible", false);
            }
            ++ii;
        }
        int ii2 = maxSessions;
        while (ii2 < numLogin) {
            DisconnectQos disQos = null;
            con[ii2].disconnect(disQos);
            ++ii2;
        }
        this.log.info(ME, "***Success in testClearSession()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid());
        ++this.numReceived;
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.numReceived);
        this.numReceived = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        Global glob = new Global();
        suite.addTest(new TestSession(glob, "testZeroSessions", "Tim"));
        suite.addTest(new TestSession(glob, "testSessionOverflow", "Tim"));
        suite.addTest(new TestSession(glob, "testSessionTimeout", "Tim"));
        suite.addTest(new TestSession(glob, "testSessionTimeoutRespan", "Tim"));
        suite.addTest(new TestSession(glob, "testClearSession", "Tim"));
        return suite;
    }

    public static void main(String[] args) {
        TestSession testSub = new TestSession(new Global(args), "TestSession", "Tim");
        testSub.setUp();
        testSub.testZeroSessions();
        testSub.testSessionOverflow();
        testSub.testSessionTimeout();
        testSub.testSessionTimeoutRespan();
        testSub.testClearSession();
        testSub.tearDown();
    }
}

