/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSessionCb
extends TestCase {
    private static String ME = "TestSessionCb";
    private final Global glob;
    private final LogChannel log;
    private I_XmlBlasterAccess con1 = null;
    private I_XmlBlasterAccess con2 = null;
    private String assertInUpdate = null;
    private String oid = "TestSessionCb-msg";
    private int deadMessageCounter = 0;
    private boolean isSocket = false;

    public TestSessionCb(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        String driverType = this.glob.getProperty().get("client.protocol", "dummy");
        if (driverType.equalsIgnoreCase("SOCKET")) {
            this.isSocket = true;
        }
        if (this.isSocket) {
            this.log.warn(ME, "callback test ignored for driverType=" + driverType + " as callback server uses same socket as invoce channel");
            return;
        }
    }

    protected void tearDown() {
        if (this.isSocket) {
            return;
        }
        if (this.con2 != null) {
            try {
                EraseKey ek = new EraseKey(this.glob, this.oid);
                EraseQos eq = new EraseQos(this.glob);
                this.con2.erase(ek.toXml(), eq.toXml());
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, e.toString());
            }
            this.con2.disconnect(null);
        }
    }

    public void testSessionCb() {
        if (this.isSocket) {
            return;
        }
        this.log.info(ME, "testSessionCb() ...");
        final Global glob1 = this.glob.getClone(null);
        final Global glob2 = this.glob.getClone(null);
        try {
            this.log.info(ME, "Connecting ...");
            this.con1 = glob1.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(glob1);
            this.assertInUpdate = null;
            this.con1.connect(qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSessionCb.this.log.info(ME, "****** Con1 update arrived" + updateKey.toXml() + updateQos.toXml());
                    TestSessionCb.this.assertInUpdate = glob1.getId() + ": Did not expect message update in first handler";
                    Assert.fail(TestSessionCb.this.assertInUpdate);
                    return "";
                }
            });
            SubscribeKey sk = new SubscribeKey(glob1, this.oid);
            SubscribeQos sq = new SubscribeQos(glob1);
            SubscribeReturnQos sr1 = this.con1.subscribe(sk.toXml(), sq.toXml());
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
            this.con1.getCbServer().shutdown();
            this.log.info(ME, "############ Con1 is down");
            this.assertInUpdate = null;
            this.con2 = glob2.getXmlBlasterAccess();
            qos = new ConnectQos(glob2);
            this.con2.connect(qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSessionCb.this.log.info(ME, "****** Con2 update arrived" + updateKey.toXml() + updateQos.toXml());
                    TestSessionCb.this.assertInUpdate = glob2.getId() + "Reveiving asynchronous message '" + updateKey.getOid() + "' in second handler";
                    TestSessionCb.this.log.info(ME, TestSessionCb.this.assertInUpdate);
                    return "";
                }
            });
            sk = new SubscribeKey(glob2, this.oid);
            sq = new SubscribeQos(glob2);
            SubscribeReturnQos sr2 = this.con2.subscribe(sk.toXml(), sq.toXml());
            sk = new SubscribeKey(glob2, "__sys__deadMessage");
            sq = new SubscribeQos(glob2);
            SubscribeReturnQos srDeadMessage = this.con2.subscribe(sk.toXml(), sq.toXml(), new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSessionCb.this.deadMessageCounter++;
                    TestSessionCb.this.log.info(ME, "****** Reveiving asynchronous message '" + updateKey.getOid() + "' in deadMessage handler, content=" + new String(content));
                    Assert.assertEquals("No dead letter received", "__sys__deadMessage", updateKey.getOid());
                    return "";
                }
            });
            this.log.info(ME, "############ Con2 subscribed for msg and for DEAD letter, publishing now msg");
            PublishKey pk = new PublishKey(glob2, this.oid, "text/plain", "1.0");
            PublishQos pq = new PublishQos(glob2);
            MsgUnit msgUnit = new MsgUnit(pk.toXml(), "Hi".getBytes(), pq.toXml());
            PublishReturnQos retQos = this.con2.publish(msgUnit);
            this.log.info(ME, "Published message oid=" + this.oid);
            this.log.info(ME, "############ Con2 is waiting for msg and for DEAD letter ...");
            try {
                Thread.currentThread();
                Thread.sleep(2000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertEquals("DeadMessage is missing", 1, this.deadMessageCounter);
            Assert.assertTrue("Update is missing", this.assertInUpdate != null);
            try {
                this.con1.get("<key oid='__cmd:?freeMem'/>", null);
                Assert.fail("XmlBlaster should have killed us because of callback problems");
            }
            catch (XmlBlasterException e) {
                this.log.info(ME, "OK, expected destroyed session: " + e.toString());
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail("SessionCb test failed: " + e.toString());
        }
        this.log.info(ME, "Success in testSessionCb()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        Global glob = new Global();
        suite.addTest(new TestSessionCb(glob, "testSessionCb"));
        suite.addTest(new TestSessionCb(glob, "testSessionCb"));
        return suite;
    }

    public static void main(String[] args) {
        TestSessionCb testSub = new TestSessionCb(new Global(args), "testSessionCb");
        testSub.setUp();
        testSub.testSessionCb();
        testSub.testSessionCb();
        testSub.tearDown();
    }
}

