/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.authentication;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestSessionReconnect
extends TestCase {
    private static String ME = "TestSessionReconnect";
    private final Global glob;
    private final LogChannel log;
    private String passwd = "secret";
    private int serverPort = 7615;
    private String oid = "TestSessionReconnect.Msg";
    private EmbeddedXmlBlaster serverThread = null;
    private String sessionNameSub = "TestSessionReconnectSubscriber";
    private I_XmlBlasterAccess conSub;
    private I_XmlBlasterAccess conSub2;
    private MsgInterceptor updateInterceptorSub;
    private String sessionNamePub = "TestSessionReconnectPublisher";
    private I_XmlBlasterAccess conPub;

    public TestSessionReconnect() {
        this(new Global(), "TestSessionReconnect");
    }

    public TestSessionReconnect(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing");
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.serverThread != null) {
            this.serverThread.stopServer(true);
        }
        Util.resetPorts();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSessionReconnect() {
        block10: {
            this.log.info(ME, "testSessionReconnect(" + this.sessionNameSub + ") ...");
            try {
                try {
                    this.log.info(ME, "============ STEP 1: Start subscriber");
                    Global globSub = this.glob.getClone(null);
                    this.updateInterceptorSub = new MsgInterceptor(globSub, this.log, null);
                    this.conSub = globSub.getXmlBlasterAccess();
                    ConnectReturnQos crqSub = null;
                    ConnectQos qosSub = new ConnectQos(globSub, this.sessionNameSub, this.passwd);
                    CallbackAddress addr = new CallbackAddress(globSub);
                    addr.setRetries(-1);
                    String secretCbSessionId = "TrustMeSub";
                    addr.setSecretCbSessionId(secretCbSessionId);
                    qosSub.getSessionCbQueueProperty().setCallbackAddress(addr);
                    this.log.info(ME, "First subscribe connect QoS = " + qosSub.toXml());
                    crqSub = this.conSub.connect(qosSub, this.updateInterceptorSub);
                    this.log.info(ME, "Connect as subscriber '" + crqSub.getSessionName() + "' success");
                    SubscribeKey sk = new SubscribeKey(globSub, this.oid);
                    SubscribeQos sq = new SubscribeQos(globSub);
                    sq.setWantInitialUpdate(false);
                    sq.setWantLocal(true);
                    sq.setWantContent(true);
                    HistoryQos historyQos = new HistoryQos(globSub);
                    historyQos.setNumEntries(1);
                    sq.setHistoryQos(historyQos);
                    SubscribeReturnQos srq = this.conSub.subscribe(sk.toXml(), sq.toXml());
                    this.log.info(ME, "Subscription to '" + this.oid + "' done");
                    this.log.info(ME, "============ STEP 2: Start publisher");
                    Global globPub = this.glob.getClone(null);
                    this.conPub = globPub.getXmlBlasterAccess();
                    ConnectQos qosPub = new ConnectQos(globPub, this.sessionNamePub, this.passwd);
                    ConnectReturnQos crqPub = this.conPub.connect(qosPub, null);
                    this.log.info(ME, "Connect success as " + crqPub.getSessionName());
                    this.log.info(ME, "============ STEP 3: Stop subscriber callback");
                    try {
                        this.conSub.getCbServer().shutdown();
                    }
                    catch (XmlBlasterException e) {
                        Assert.fail("ShutdownCB: " + e.getMessage());
                    }
                    this.log.info(ME, "============ STEP 4: Publish messages");
                    int numPub = 8;
                    MsgUnit[] sentArr = new MsgUnit[numPub];
                    PublishReturnQos[] sentQos = new PublishReturnQos[numPub];
                    int i = 0;
                    while (true) {
                        PublishReturnQos prq;
                        MsgUnit msgUnit;
                        if (i >= numPub) {
                            this.log.info(ME, "============ STEP 5: Start subscriber callback with same public sessionId");
                            Global globSub2 = this.glob.getClone(null);
                            MsgInterceptor updateInterceptorSub2 = new MsgInterceptor(globSub2, this.log, null);
                            updateInterceptorSub2.setLogPrefix("TrustMeSub2");
                            this.conSub2 = globSub2.getXmlBlasterAccess();
                            String secretCbSessionId2 = "TrustMeSub2";
                            ConnectQos qosSub2 = new ConnectQos(globSub, this.sessionNameSub, this.passwd);
                            CallbackAddress addr2 = new CallbackAddress(globSub);
                            addr2.setRetries(-1);
                            addr2.setSecretCbSessionId(secretCbSessionId2);
                            qosSub2.getSessionCbQueueProperty().setCallbackAddress(addr2);
                            qosSub2.getSessionQos().setSessionName(crqSub.getSessionQos().getSessionName());
                            this.log.info(ME, "Second subscribe connect QoS = " + qosSub2.toXml());
                            ConnectReturnQos crqSub2 = this.conSub2.connect(qosSub2, updateInterceptorSub2);
                            this.log.info(ME, "Connect as subscriber '" + crqSub2.getSessionName() + "' success");
                            Assert.assertEquals("", 0, this.updateInterceptorSub.count());
                            Assert.assertEquals("", numPub, updateInterceptorSub2.waitOnUpdate(2000L, this.oid, "OK"));
                            updateInterceptorSub2.compareToReceived(sentArr, secretCbSessionId2);
                            updateInterceptorSub2.compareToReceived(sentQos);
                            updateInterceptorSub2.clear();
                            break;
                        }
                        PublishKey pk = new PublishKey(globPub, this.oid, "text/xml", "1.0");
                        pk.setClientTags("<org.xmlBlaster><demo/></org.xmlBlaster>");
                        PublishQos pq = new PublishQos(globPub);
                        pq.setPriority(PriorityEnum.NORM_PRIORITY);
                        pq.setPersistent(false);
                        pq.setLifeTime(60000L);
                        if (i == 0) {
                            TopicProperty topicProperty = new TopicProperty(globPub);
                            topicProperty.setDestroyDelay(60000L);
                            topicProperty.setCreateDomEntry(true);
                            topicProperty.setReadonly(false);
                            topicProperty.getHistoryQueueProperty().setMaxEntries(numPub + 5);
                            pq.setTopicProperty(topicProperty);
                            this.log.info(ME, "Added TopicProperty on first publish: " + topicProperty.toXml());
                        }
                        byte[] content = "Hello".getBytes();
                        sentArr[i] = msgUnit = new MsgUnit(pk, content, pq);
                        sentQos[i] = prq = this.conPub.publish(msgUnit);
                        this.log.info(ME, "Got status='" + prq.getState() + "' rcvTimestamp=" + prq.getRcvTimestamp().toString() + " for published message '" + prq.getKeyOid() + "'");
                        ++i;
                    }
                }
                catch (XmlBlasterException e) {
                    this.log.error(ME, e.toString());
                    Assert.fail(e.toString());
                    Object var21_23 = null;
                    this.log.info(ME, "Disconnecting '" + this.sessionNameSub + "'");
                    this.conSub.disconnect(null);
                    this.conSub2.disconnect(null);
                    break block10;
                }
                Object var21_22 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameSub + "'");
                this.conSub.disconnect(null);
            }
            catch (Throwable throwable) {
                Object var21_24 = null;
                this.log.info(ME, "Disconnecting '" + this.sessionNameSub + "'");
                this.conSub.disconnect(null);
                this.conSub2.disconnect(null);
                throw throwable;
            }
            this.conSub2.disconnect(null);
        }
        this.log.info(ME, "Success in testSessionReconnect()");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "TestSessionReconnect";
        suite.addTest(new TestSessionReconnect(Global.instance(), "testSessionReconnect"));
        return suite;
    }

    public static void main(String[] args) {
        TestSessionReconnect testSub = new TestSessionReconnect(new Global(args), "TestSessionReconnect");
        testSub.setUp();
        testSub.testSessionReconnect();
        testSub.tearDown();
    }
}

