/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classloader;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;

public class XmlBlasterClassloaderTest
extends TestCase {
    protected Global glob;
    protected LogChannel log;
    private MsgUnit msgUnit;

    public XmlBlasterClassloaderTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog(null);
        URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = cl.getURLs();
        String path = "";
        int i = 0;
        while (i < urls.length) {
            String file = urls[i].getFile();
            if (file.endsWith("parser.jar")) {
                int pos = file.indexOf("parser.jar");
                path = urls[i].getProtocol() + "://" + file.substring(0, pos);
                break;
            }
            ++i;
        }
        try {
            urls = new URL[]{new URL(path + "ant/xerces.jar"), new URL(path + "xmlBlaster.jar")};
        }
        catch (MalformedURLException ex) {
            this.log.error("XmlBlasterClassloaderTest", "error. >>>" + ex.toString());
        }
        cl = URLClassLoader.newInstance(urls);
        try {
            Class<?> clazz = cl.loadClass("org.xmlBlaster.util.EmbeddedXmlBlaster");
        }
        catch (ClassNotFoundException ex) {
            Assert.assertTrue(ex.getMessage(), true);
        }
    }

    public void testClassloader() {
        System.out.println("***XmlBlasterClassloaderTest: testClassloader ...");
        try {
            EmbeddedXmlBlaster embed = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            I_XmlBlasterAccess conn = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, "marcel", "secret");
            conn.connect(qos, null);
            String xmlKey = "<key oid='123' contentMime='text/plain' contentMimeExtended='myMime'>\n   <TestLogin-AGENT>   </TestLogin-AGENT></key>";
            String senderContent = "Some content";
            MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos></qos>");
            conn.publish(msgUnit);
        }
        catch (Throwable t) {
            Assert.assertTrue("Some error occured:" + t.toString(), true);
        }
        System.out.println("***XmlBlasterClassloaderTest: testClassloader [SUCCESS]");
    }

    protected void tearDown() {
    }

    public static void main(String[] args) {
        XmlBlasterClassloaderTest testCl = new XmlBlasterClassloaderTest("XmlBlasterClassloaderTest");
        testCl.setUp();
        testCl.testClassloader();
        testCl.tearDown();
    }
}

