/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLTestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.EncodableData;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.ClientProperty;

public class ClientPropertyTest
extends XMLTestCase {
    protected Global glob;
    protected LogChannel log;
    int counter = 0;

    public ClientPropertyTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    public void testClientProperty() throws Exception {
        ClientProperty clientProperty = new ClientProperty(this.glob, "StringKey", null, null);
        Assert.assertEquals("", "StringKey", clientProperty.getName());
        Assert.assertEquals("", null, clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", false, clientProperty.isBase64());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        String xml = clientProperty.toXml();
        this.assertXpathExists("/clientProperty[@name='StringKey']", xml);
        System.out.println(xml);
    }

    public void testClientPropertyEncoding() throws Exception {
        ClientProperty clientProperty = new ClientProperty(this.glob, "StringKey", "String", "base64");
        Assert.assertEquals("", "StringKey", clientProperty.getName());
        Assert.assertEquals("", "String", clientProperty.getType());
        Assert.assertEquals("", "base64", clientProperty.getEncoding());
        Assert.assertEquals("", true, clientProperty.isBase64());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        String xml = clientProperty.toXml();
        this.assertXpathExists("/clientProperty[@name='StringKey']", xml);
        this.assertXpathExists("/clientProperty[@type='String']", xml);
        this.assertXpathExists("/clientProperty[@encoding='base64']", xml);
        System.out.println(xml);
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='StringKey' type='String' encoding='base64'/>", xml);
        clientProperty.setValue("BlaBlaBla");
        xml = clientProperty.toXml();
        Assert.assertEquals("Base64?", "QmxhQmxhQmxh", clientProperty.getValueRaw());
        Assert.assertEquals("", "BlaBlaBla", clientProperty.getStringValue());
        System.out.println(xml);
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='StringKey' type='String' encoding='base64'>QmxhQmxhQmxh</clientProperty>", xml);
        try {
            Assert.assertEquals("", 99, clientProperty.getIntValue());
            Assert.fail("String to int not possible");
        }
        catch (NumberFormatException e) {
            System.out.println("OK Expected exception NumberFormatException");
        }
        System.out.println(xml);
    }

    public void testClientPropertyCtorEncoding() throws Exception {
        String value = "Bla<<";
        ClientProperty clientProperty = new ClientProperty(this.glob, "StringKey", EncodableData.getPropertyType(value), null, value);
        Assert.assertEquals("", "StringKey", clientProperty.getName());
        Assert.assertEquals("", null, clientProperty.getType());
        Assert.assertEquals("", "base64", clientProperty.getEncoding());
        Assert.assertEquals("", true, clientProperty.isBase64());
        Assert.assertEquals("", value, clientProperty.getStringValue());
        String xml = clientProperty.toXml();
        this.assertXpathExists("/clientProperty[@name='StringKey']", xml);
        this.assertXpathExists("/clientProperty[@encoding='base64']", xml);
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='StringKey' encoding='base64'>QmxhPDw=</clientProperty>", xml);
        System.out.println(xml);
    }

    public void testClientPropertyAutoEncoding() throws Exception {
        ClientProperty clientProperty = new ClientProperty(this.glob, "StringKey", "", "");
        Assert.assertEquals("", "StringKey", clientProperty.getName());
        Assert.assertEquals("", "", clientProperty.getType());
        Assert.assertEquals("", "", clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        clientProperty.setValue("Bla<BlaBla");
        Assert.assertEquals("", "base64", clientProperty.getEncoding());
        String xml = clientProperty.toXml();
        System.out.println(xml);
        Assert.assertEquals("Base64?", "QmxhPEJsYUJsYQ==", clientProperty.getValueRaw());
        Assert.assertEquals("", "Bla<BlaBla", clientProperty.getStringValue());
        System.out.println(xml);
        clientProperty.setValue("Bla]]>BlaBla");
        Assert.assertEquals("", "base64", clientProperty.getEncoding());
        xml = clientProperty.toXml();
        Assert.assertEquals("", "Bla]]>BlaBla", clientProperty.getStringValue());
        System.out.println(xml);
    }

    public void testClientPropertyTypes() throws Exception {
        ClientProperty clientProperty = new ClientProperty(this.glob, "key", "int", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "int", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("9988");
        String xml = clientProperty.toXml();
        Assert.assertEquals("", "9988", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='int'>9988</clientProperty>", xml);
        Assert.assertEquals("", 9988, clientProperty.getIntValue());
        Assert.assertTrue("Expecting Integer", clientProperty.getObjectValue() instanceof Integer);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "boolean", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "boolean", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("true");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "true", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='boolean'>true</clientProperty>", xml);
        Assert.assertEquals("", true, clientProperty.getBooleanValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Boolean);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "double", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "double", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("12.78");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "12.78", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='double'>12.78</clientProperty>", xml);
        Assert.assertTrue("", 12.78 == clientProperty.getDoubleValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Double);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "float", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "float", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", false, clientProperty.isBase64());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("12.54");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "12.54", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='float'>12.54</clientProperty>", xml);
        Assert.assertTrue("", 12.54f == clientProperty.getFloatValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Float);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "byte", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "byte", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("6");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "6", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='byte'>6</clientProperty>", xml);
        Assert.assertTrue("", 6 == clientProperty.getByteValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Byte);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "long", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "long", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("888888");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "888888", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='long'>888888</clientProperty>", xml);
        Assert.assertTrue("", 888888L == clientProperty.getLongValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Long);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", "short", null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", "short", clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        clientProperty.setValue("12");
        xml = clientProperty.toXml();
        Assert.assertEquals("", "12", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='short'>12</clientProperty>", xml);
        Assert.assertTrue("", 12 == clientProperty.getShortValue());
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof Short);
        System.out.println(xml);
        clientProperty = new ClientProperty(this.glob, "key", null, null);
        Assert.assertEquals("", "key", clientProperty.getName());
        Assert.assertEquals("", null, clientProperty.getType());
        Assert.assertEquals("", null, clientProperty.getEncoding());
        Assert.assertEquals("", null, clientProperty.getValueRaw());
        Assert.assertEquals("", null, clientProperty.getStringValue());
        Assert.assertEquals("", null, clientProperty.getObjectValue());
        byte[] bb = new byte[]{0, 65, 0, 99, 0, 0};
        clientProperty.setValue(bb);
        Assert.assertEquals("", "byte[]", clientProperty.getType());
        Assert.assertEquals("", "base64", clientProperty.getEncoding());
        Assert.assertEquals("", true, clientProperty.isBase64());
        String xml2 = clientProperty.toXml();
        byte[] newVal = clientProperty.getBlobValue();
        int i = 0;
        while (i < bb.length) {
            Assert.assertTrue("Index #" + i, bb[i] == newVal[i]);
            ++i;
        }
        this.assertXpathExists("/clientProperty[@name='key']", xml2);
        this.assertXpathExists("/clientProperty[@type='byte[]']", xml2);
        this.assertXpathExists("/clientProperty[@encoding='base64']", xml2);
        Assert.assertEquals("", "AEEAYwAA", clientProperty.getValueRaw());
        this.assertXMLEqual("comparing test xml to control xml", "<clientProperty name='key' type='byte[]' encoding='base64'>AEEAYwAA</clientProperty>", xml2);
        Assert.assertTrue("", clientProperty.getObjectValue() instanceof byte[]);
        newVal = (byte[])clientProperty.getObjectValue();
        int i2 = 0;
        while (i2 < bb.length) {
            Assert.assertTrue("Index #" + i2, bb[i2] == newVal[i2]);
            ++i2;
        }
        System.out.println(xml2);
    }

    public static void main(String[] args) {
        try {
            ClientPropertyTest testSub = new ClientPropertyTest("ClientPropertyTest");
            testSub.setUp();
            testSub.testClientPropertyCtorEncoding();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

