/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.admin.CommandWrapper;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.QueryQosData;

public class CommandWrapperTest
extends TestCase {
    private String ME = "CommandWrapperTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();

    public CommandWrapperTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = new Global();
        this.log = this.glob.getLog(null);
        this.glob.setId("heron");
    }

    protected void tearDown() {
    }

    public void testBasic() {
        Assert.assertEquals("Wrong node id", "heron", this.glob.getId());
        String cmd = null;
        CommandWrapper w = null;
        try {
            cmd = "/node/heron/client/joe/?sessionList";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "joe/?sessionList", w.getTail());
            cmd = "/node/heron/client/joe/";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "joe/", w.getTail());
            cmd = "/node/heron/client/joe";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "joe", w.getTail());
            cmd = "/node/heron/client/";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", null, w.getTail());
            cmd = "/node/heron/client";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "/node/heron/client", w.getCommand());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", null, w.getTail());
            cmd = "client/joe/?sessionList";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "joe/?sessionList", w.getTail());
            cmd = "client";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "/node/heron/client", w.getCommand());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "node", w.getRoot());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "heron", w.getClusterNodeId());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", "client", w.getThirdLevel());
            Assert.assertEquals("Command '" + cmd + "' wrong parsed", null, w.getTail());
        }
        catch (XmlBlasterException e) {
            Assert.fail("Failed: " + e.toString());
        }
    }

    public void testInvalid() {
        Assert.assertEquals("Wrong node id", "heron", this.glob.getId());
        String cmd = null;
        CommandWrapper w = null;
        try {
            cmd = "/node/heron/";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "/node/foeignNode/client/?joe";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "/strangeNode/heron/client/?joe";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "/node/";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "/";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = null;
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
        try {
            cmd = "/////";
            w = new CommandWrapper(this.glob, cmd, null);
            Assert.fail("Failed, expected exception for '" + cmd + "'");
        }
        catch (XmlBlasterException e) {
            System.out.println("OK - expected Exception: " + e.toString());
        }
    }

    public void testQosData() {
        String cmd = null;
        GetQos getQos = new GetQos(this.glob);
        getQos.addClientProperty("_one", "1");
        getQos.addClientProperty("_two", "2");
        cmd = "client/joe/1/?queue&xmlBlaster.qos=" + getQos.toXml();
        QueryKeyData keyData = new QueryKeyData(this.glob);
        keyData.setOid("__cmd:" + cmd);
        try {
            CommandWrapper w = new CommandWrapper(this.glob, keyData, null);
            QueryQosData qos = w.getQueryQosData();
            this.log.info(this.ME, qos.toXml());
            ClientProperty clp = qos.getClientProperty("_one");
            Assert.assertNotNull("should not be null", clp);
            Assert.assertEquals("wrong value for this property", "1", clp.getStringValue());
            clp = qos.getClientProperty("_two");
            Assert.assertNotNull("should not be null", clp);
            Assert.assertEquals("wrong value for this property", "2", clp.getStringValue());
            clp = qos.getClientProperty("_three");
            Assert.assertNull("should be null", clp);
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.assertTrue("exception should not occur here: " + e.getMessage(), false);
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println("Init failed");
            System.exit(1);
        }
        CommandWrapperTest test = new CommandWrapperTest("CommandWrapperTest");
        test.setUp();
        test.testQosData();
        test.tearDown();
    }
}

