/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.ConnectQosData;
import org.xmlBlaster.util.qos.I_ConnectQosFactory;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.qos.address.AddressBase;
import org.xmlBlaster.util.qos.address.ServerRef;
import org.xmlBlaster.util.qos.storage.ClientQueueProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;

public class ConnectQosTest
extends TestCase {
    protected Global glob;
    protected LogChannel log;
    int counter = 0;

    public ConnectQosTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    public void testParse() {
        System.out.println("***ConnectQosTest: testParse ...");
        try {
            long sessionTimeout = 3600001L;
            String xml = "<qos>\n   <securityService type='htpasswd' version='1.0'>\n      <![CDATA[\n         <user>joe</user>\n         <passwd>theUsersPwd</passwd>\n      ]]>\n   </securityService>\n   <ptp>false</ptp>\n   <clusterNode>true</clusterNode>\n   <duplicateUpdates>false</duplicateUpdates>\n   <session name='/node/avalon/client/joe/2' timeout='" + sessionTimeout + "' maxSessions='27' clearSessions='true' sessionId='xyz'/>\n" + "   <queue relating='subject' type='XY' version='7.0' maxEntries='1009' maxBytes='4009' maxEntriesCache='509' maxBytesCache='777' storeSwapLevel='20009' storeSwapBytes='10000' reloadSwapLevel='20000' reloadSwapBytes='30000' onOverflow='deadMessage'>\n" + "   </queue>\n" + "   <queue relating='connection' type='RAM' version='4.0' maxEntries='22' maxBytes='44'>\n" + "      <address type='XMLRPC'>\n" + "         http:/www.mars.universe:8080/RPC2\n" + "      </address>\n" + "   </queue>\n" + "   <queue relating='callback' maxEntries='1600' maxBytes='2000'>\n" + "      <callback type='XMLRPC'>\n" + "         <ptp>true</ptp>\n" + "         http:/www.mars.universe:8080/RPC2\n" + "         <compress type='gzip' minSize='1000' />\n" + "         <burstMode collectTime='400' maxEntries='12' maxBytes='24' />\n" + "      </callback>\n" + "   </queue>\n" + "   <serverRef type='IOR'>\n" + "      IOR:00011200070009990000....\n" + "   </serverRef>\n" + "   <serverRef type='EMAIL'>\n" + "      et@mars.universe\n" + "   </serverRef>\n" + "   <serverRef type='XMLRPC'>\n" + "      http:/www.mars.universe:8080/RPC2\n" + "   </serverRef>\n" + "   <clientProperty name='intKey' type='int'>123</clientProperty>\n" + "   <clientProperty name='StringKey' type='String' encoding='" + "base64" + "'>QmxhQmxhQmxh</clientProperty>\n" + "   <persistent>true</persistent>\n" + "</qos>\n";
            I_ConnectQosFactory factory = this.glob.getConnectQosFactory();
            ConnectQosData qos = factory.readObject(xml);
            Assert.assertEquals("", true, qos.getPersistentProp().getValue());
            String newXml = qos.toXml();
            qos = factory.readObject(newXml);
            if (this.log.TRACE) {
                this.log.trace("ConnectQosTest", "ORIG=\n" + xml + "\n NEW=\n" + newXml);
            }
            SessionQos sessionQos = qos.getSessionQos();
            Assert.assertEquals("sessionTimeout failed", sessionTimeout, sessionQos.getSessionTimeout());
            Assert.assertEquals("", "/node/avalon/client/joe/2", sessionQos.getSessionName().getAbsoluteName());
            Assert.assertEquals("", true, sessionQos.hasPublicSessionId());
            Assert.assertEquals("", 2L, sessionQos.getPublicSessionId());
            Assert.assertEquals("", sessionTimeout, sessionQos.getSessionTimeout());
            Assert.assertEquals("", 27, sessionQos.getMaxSessions());
            Assert.assertEquals("", true, sessionQos.clearSessions());
            Assert.assertEquals("", "xyz", sessionQos.getSecretSessionId());
            Assert.assertEquals("", false, qos.isPtpAllowed());
            Assert.assertEquals("", true, qos.isClusterNode());
            Assert.assertEquals("", false, qos.duplicateUpdates());
            Assert.assertEquals("", true, qos.getPersistentProp().getValue());
            Object prop = qos.getClientQueueProperty();
            Assert.assertEquals("", 22L, ((QueuePropertyBase)prop).getMaxEntries());
            Assert.assertEquals("", "RAM", ((QueuePropertyBase)prop).getType());
            Assert.assertEquals("", "4.0", ((QueuePropertyBase)prop).getVersion());
            Assert.assertEquals("", 44L, ((QueuePropertyBase)prop).getMaxBytes());
            prop = qos.getSubjectQueueProperty();
            Assert.assertEquals("", 1009L, ((QueuePropertyBase)prop).getMaxEntries());
            Assert.assertEquals("", "XY", ((QueuePropertyBase)prop).getType());
            Assert.assertEquals("", "7.0", ((QueuePropertyBase)prop).getVersion());
            Assert.assertEquals("", 4009L, ((QueuePropertyBase)prop).getMaxBytes());
            Assert.assertEquals("", 509L, ((QueuePropertyBase)prop).getMaxEntriesCache());
            Assert.assertEquals("", 777L, ((QueuePropertyBase)prop).getMaxBytesCache());
            Assert.assertEquals("", "deadMessage", ((QueuePropertyBase)prop).getOnOverflow());
            Assert.assertEquals("", true, qos.hasSubjectQueueProperty());
            prop = qos.getSessionCbQueueProperty();
            Assert.assertEquals("", 1600L, ((QueuePropertyBase)prop).getMaxEntries());
            AddressBase[] addrArr = ((QueuePropertyBase)prop).getAddresses();
            Assert.assertEquals("Address array", 1, addrArr.length);
            AddressBase addr = addrArr[0];
            Assert.assertEquals("", 400L, addr.getCollectTime());
            Assert.assertEquals("", 12, addr.getBurstModeMaxEntries());
            Assert.assertEquals("", 24L, addr.getBurstModeMaxBytes());
            Assert.assertEquals("Wrong number of clientProperties", 2, qos.getClientProperties().size());
            prop = qos.getClientProperty("StringKey", (String)null);
            Assert.assertTrue("Missing client property", prop != null);
            Assert.assertEquals("Wrong base64 decoding", "BlaBlaBla", (String)prop);
            int prop2 = qos.getClientProperty("intKey", -1);
            Assert.assertEquals("Wrong value", 123, prop2);
            ServerRef[] refArr = qos.getServerRefs();
            Assert.assertEquals("", 3, refArr.length);
            ServerRef ref = qos.getServerRef();
            Assert.assertTrue("", ref != null);
            AddressBase[] addrArr2 = qos.getAddresses();
            Assert.assertEquals("Address array", 1, addrArr2.length);
            Address addr2 = qos.getAddress();
            Assert.assertEquals("", false, qos.isPtpAllowed());
            Assert.assertEquals("", "joe", qos.getUserId());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***ConnectQosTest: testParse [SUCCESS]");
    }

    public void testParse2() {
        System.out.println("***ConnectQosTest: testParse2 ...");
        try {
            long sessionTimeout = 3600001L;
            String xml = "<qos>\n  <securityService type='htpasswd' version='1.0'><![CDATA[\n   <user>A-native-client-plugin</user>\n   <passwd>secret</passwd>\n  ]]></securityService>\n  <session name='client/A-native-client-plugin' timeout='86400000' maxSessions='10' clearSessions='false' reconnectSameClientOnly='false'/>\n  <queue relating='connection' type='RAM' version='1.0' maxEntries='10000000' maxEntriesCache='1000'>\n   <address type='LOCAL' pingInterval='0' dispatchPlugin='undef'>\n    <burstMode collectTime='0'/>\n   </address>\n  </queue>\n </qos>\n";
            I_ConnectQosFactory factory = this.glob.getConnectQosFactory();
            ConnectQosData qos = factory.readObject(xml);
            String newXml = qos.toXml();
            qos = factory.readObject(newXml);
            if (this.log.TRACE) {
                this.log.trace("ConnectQosTest", "ORIG=\n" + xml + "\n NEW=\n" + newXml);
            }
            ClientQueueProperty prop = qos.getClientQueueProperty();
            Assert.assertEquals("", "RAM", prop.getType());
            Assert.assertEquals("", "1.0", prop.getVersion());
            System.out.println(qos.toXml());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse2 failed: " + e.toString());
        }
        System.out.println("***ConnectQosTest: testParse2 [SUCCESS]");
    }

    public void testClientConnectQos() {
        System.out.println("***ConnectQosTest: testClientConnectQos ...");
        System.out.println("***ConnectQosTest: testClientConnectQos [SUCCESS]");
    }

    public void testCredential() {
        System.out.println("***ConnectQosTest: testCredential ...");
        String loginName = "avalon";
        String passwd = "avalonSecret";
        String[] args = new String[]{"-cluster.node.id", loginName, "-passwd[avalon]", passwd};
        try {
            Global g = this.glob.getClone(args);
            ConnectQos qos = new ConnectQos(g);
            qos.setUserId(g.getId());
            Assert.assertEquals("Wrong user id", loginName, qos.getSecurityQos().getUserId());
            Assert.assertTrue("Wrong password, expected '" + passwd + "': " + qos.toXml(), qos.toXml().indexOf(passwd) > 0);
        }
        catch (XmlBlasterException e) {
            Assert.fail("testCredential failed: " + e.toString());
        }
        System.out.println("***ConnectQosTest: testCredential [SUCCESS]");
    }

    public static void main(String[] args) {
        ConnectQosTest testSub = new ConnectQosTest("ConnectQosTest");
        testSub.setUp();
        testSub.testCredential();
        testSub.testParse();
        testSub.testClientConnectQos();
        testSub.testParse2();
    }
}

