/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.recorder.file.FileIO;
import org.xmlBlaster.util.recorder.file.I_UserDataHandler;

public class FileIOTest
extends TestCase {
    private String ME = "FileIOTest";
    protected Global glob;
    protected LogChannel log;
    private String fileName = null;
    private StopWatch stopWatch = new StopWatch();
    private boolean testDiscardOldest = false;

    public FileIOTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = new Global();
        this.log = this.glob.getLog(null);
    }

    protected void tearDown() {
        File file = new File("testSync.txt");
        file.delete();
        file = new File("testNoSync.txt");
        file.delete();
        if (this.fileName != null) {
            file = new File(this.fileName);
            file.delete();
        }
    }

    public void testBasic() {
        this.testSync(false);
        this.testSync(true);
    }

    public void testSync(boolean sync) {
        block14: {
            String testName = sync ? "testSync" : "testNoSync";
            System.out.println("***** Test " + testName + " write ...");
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 2000L;
            if (sync) {
                num = 100L;
            }
            FileIO fileIO = null;
            try {
                try {
                    String data;
                    this.log.info(this.ME, "Opening file '" + this.fileName + "' num=" + num + " sync=" + sync + " ...");
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, sync);
                    File f = new File(this.fileName);
                    long emptyLength = f.length();
                    System.out.println("Write " + num + " ...");
                    long start = System.currentTimeMillis();
                    int ii = 0;
                    while ((long)ii < num) {
                        fileIO.writeNext("World-" + ii);
                        ++ii;
                    }
                    long elapsed = System.currentTimeMillis() - start;
                    if (num > 0L && elapsed > 0L) {
                        System.out.println("For num=" + num + " writes numLost=" + fileIO.getNumLost() + " numUnread=" + fileIO.getNumUnread() + " we needed " + elapsed + " millis -> " + num * 1000L / elapsed + " writes/sec " + elapsed / num + " millis/write");
                    }
                    Assert.assertEquals("NumUnread", num, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                    File file = new File(this.fileName);
                    Assert.assertTrue("File size emptyLength=" + emptyLength + " file.length()=" + file.length(), file.length() > emptyLength);
                    System.out.println("***** Test " + testName + " read ...");
                    long count = 0L;
                    long start2 = System.currentTimeMillis();
                    while ((data = (String)fileIO.readNext(true)) != null) {
                        ++count;
                    }
                    long elapsed2 = System.currentTimeMillis() - start2;
                    if (count > 0L && elapsed2 > 0L) {
                        System.out.println("For count=" + count + " numLost=" + fileIO.getNumLost() + " numUnread=" + fileIO.getNumUnread() + " reades we needed " + elapsed2 + " millis -> " + count * 1000L / elapsed2 + " reads/sec " + elapsed2 / count + " millis/read");
                    }
                    Assert.assertEquals("NumUnread", 0L, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                    File file2 = new File(this.fileName);
                    Assert.assertEquals("File size emptyLength=" + emptyLength + " file.length()=" + file2.length(), emptyLength, file2.length());
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var18_19 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block14;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var18_20 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var18_18 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var18_21 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public void testOverflow() {
        block14: {
            String testName = "testOverflow";
            System.out.println("***** Test " + testName);
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 10L;
            long numOverflow = 2L;
            FileIO fileIO = null;
            try {
                try {
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num - numOverflow, false);
                    fileIO.setModeDiscardOldest();
                    System.out.println("Write " + num + " data objects (DISCARD_OLDEST) ...");
                    int ii = 0;
                    while ((long)ii < num) {
                        fileIO.writeNext("World-" + ii);
                        ++ii;
                    }
                    Assert.assertEquals("NumUnread", num - numOverflow, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", numOverflow, fileIO.getNumLost());
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num - numOverflow, false);
                    fileIO.setModeDiscard();
                    System.out.println("Write " + num + " data objects (DISCARD) ...");
                    ii = 0;
                    while ((long)ii < num) {
                        fileIO.writeNext("World-" + ii);
                        ++ii;
                    }
                    Assert.assertEquals("NumUnread", num - numOverflow, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", numOverflow, fileIO.getNumLost());
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num - numOverflow, false);
                    fileIO.setModeException();
                    System.out.println("Write " + num + " data objects (EXCEPTION) ...");
                    int numExceptions = 0;
                    int ii2 = 0;
                    while ((long)ii2 < num) {
                        try {
                            fileIO.writeNext("World-" + ii2);
                        }
                        catch (XmlBlasterException e) {
                            ++numExceptions;
                        }
                        ++ii2;
                    }
                    Assert.assertEquals("NumUnread", num - numOverflow, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", numOverflow, fileIO.getNumLost());
                    Assert.assertEquals("NumExceptions", numOverflow, (long)numExceptions);
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_12 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block14;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_13 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var12_11 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public void testDataCorruption() {
        block9: {
            String testName = "testDataCorruption";
            System.out.println("***** Test " + testName);
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 20L;
            FileIO fileIO = null;
            try {
                try {
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, false);
                    fileIO.writeNext("AFirstValue");
                    fileIO.writeNext("ASecondValue");
                    Assert.assertEquals("Data corrupted", "AFirstValue", (String)fileIO.readNext(true));
                    Assert.assertEquals("Data corrupted", "ASecondValue", (String)fileIO.readNext(true));
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var9_6 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block9;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var9_7 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var9_5 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public void testKilledFileOnWrite() {
        block15: {
            String testName = "testKilledFileOnWrite";
            System.out.println("***** Test " + testName);
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 20L;
            long numKill = 5L;
            FileIO fileIO = null;
            try {
                try {
                    String data;
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, false);
                    int ii = 0;
                    while ((long)ii < num) {
                        if ((long)ii == numKill) {
                            File ff = new File(this.fileName);
                            ff.delete();
                        }
                        try {
                            fileIO.writeNext("World-" + ii);
                        }
                        catch (XmlBlasterException e) {
                            if (e.getErrorCode() == ErrorCode.RESOURCE_FILEIO) {
                                Assert.fail("Wrong exception thrown: " + e.toString());
                            }
                            System.out.println(e.getMessage());
                        }
                        ++ii;
                    }
                    Assert.assertEquals("NumUnread", num - numKill, fileIO.getNumUnread());
                    int count = 0;
                    while ((data = (String)fileIO.readNext(true)) != null) {
                        ++count;
                    }
                    Assert.assertEquals("num after kill", num - numKill, (long)count);
                    Assert.assertEquals("NumUnread", 0L, fileIO.getNumUnread());
                    Assert.assertEquals("NumKillLost", numKill, fileIO.getNumFileDeleteLost());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_14 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block15;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_15 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var12_13 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var12_16 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public void testKilledFileOnRead() {
        block15: {
            String testName = "testKilledFileOnRead";
            System.out.println("***** Test " + testName);
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 20L;
            long numKill = 5L;
            FileIO fileIO = null;
            try {
                try {
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, false);
                    int ii = 0;
                    while ((long)ii < num) {
                        fileIO.writeNext("World-" + ii);
                        ++ii;
                    }
                    Assert.assertEquals("NumUnread", num, fileIO.getNumUnread());
                    int count = 0;
                    while (true) {
                        if ((long)count == numKill) {
                            File ff = new File(this.fileName);
                            ff.delete();
                        }
                        try {
                            String data = (String)fileIO.readNext(true);
                            if (data == null) break;
                            ++count;
                            continue;
                        }
                        catch (XmlBlasterException e) {
                            if (e.getErrorCode() == ErrorCode.RESOURCE_FILEIO_FILELOST) {
                                Assert.fail("Wrong exception thrown: " + e.toString());
                                continue;
                            }
                            System.out.println(e.getMessage());
                        }
                        break;
                    }
                    Assert.assertEquals("num after kill", numKill, (long)count);
                    Assert.assertEquals("NumUnread", 0L, fileIO.getNumUnread());
                    Assert.assertEquals("NumKillLost", num - numKill, fileIO.getNumFileDeleteLost());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_13 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block15;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var12_14 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var12_12 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public void testRestart() {
        block12: {
            String testName = "testRestart";
            System.out.println("***** Test " + testName);
            this.fileName = testName + ".txt";
            UserDataHandler userDataHandler = new UserDataHandler();
            long num = 20L;
            long numRead = 8L;
            FileIO fileIO = null;
            try {
                try {
                    String data;
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, false);
                    int ii = 0;
                    while ((long)ii < num) {
                        fileIO.writeNext("World-" + ii);
                        ++ii;
                    }
                    Assert.assertEquals("NumUnread", num, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                    int ii2 = 0;
                    while ((long)ii2 < numRead) {
                        fileIO.readNext(true);
                        ++ii2;
                    }
                    Assert.assertEquals("NumUnread", num - numRead, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                    fileIO = new FileIO(this.glob, this.fileName, userDataHandler, num, false);
                    int count = 0;
                    while ((data = (String)fileIO.readNext(true)) != null) {
                        ++count;
                    }
                    Assert.assertEquals("num after restart", num - numRead, (long)count);
                    Assert.assertEquals("NumUnread", 0L, fileIO.getNumUnread());
                    Assert.assertEquals("NumLost", 0L, fileIO.getNumLost());
                }
                catch (IOException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var11_12 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                    break block12;
                }
                catch (XmlBlasterException e) {
                    Assert.fail(testName + " failed: " + e.toString());
                    Object var11_13 = null;
                    if (fileIO != null) {
                        fileIO.destroy();
                        fileIO = null;
                    }
                }
                Object var11_11 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (fileIO != null) {
                    fileIO.destroy();
                    fileIO = null;
                }
                throw throwable;
            }
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("******* FileIOTest: Init failed");
        }
        FileIOTest testSub = new FileIOTest("FileIOTest");
        testSub.setUp();
        testSub.testBasic();
        testSub.tearDown();
    }

    class UserDataHandler
    implements I_UserDataHandler {
        UserDataHandler() {
        }

        public final void writeData(RandomAccessFile ra, Object userData) throws IOException {
            ra.writeUTF((String)userData);
        }

        public final Object readData(RandomAccessFile ra) throws IOException {
            return ra.readUTF();
        }
    }
}

