/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.log.LogableDevice;
import org.xmlBlaster.test.classtest.GlobalLogTest;
import org.xmlBlaster.util.Global;

public class GlobalLogTest
extends TestCase {
    protected Global glob;
    int counter = 0;

    public GlobalLogTest(String name) {
        super(name);
    }

    protected void setUp() {
        System.out.println("***GlobalLogTest: setup ...");
        String[] args = new String[]{"-call[cluster]", "true"};
        this.glob = new Global(args);
    }

    public void testLog() {
        System.out.println("***GlobalLogTest: testLog ...");
        this.counter = 0;
        Assert.assertEquals("call = true is lost", true, this.glob.getProperty().get("call[cluster]", true));
        LogChannel clusterChannel = new LogChannel("cluster", this.glob.getProperty());
        class MyApp
        implements LogableDevice {
            private final /* synthetic */ GlobalLogTest this$0;

            MyApp(GlobalLogTest this$0) {
                this.this$0 = this$0;
            }

            public void log(int level, String source, String str) {
                if (!str.equals("OK") && !str.equals("ERROR")) {
                    return;
                }
                Assert.assertEquals("Logging device error", "OK", str);
                ++this.this$0.counter;
            }
        }
        MyApp myApp = new MyApp(this);
        clusterChannel.addLogDevice(myApp);
        this.glob.addLogChannel(clusterChannel);
        LogChannel logC = this.glob.getLog("cluster");
        Assert.assertEquals("call = true is lost", true, logC.isLoglevelEnabled(8));
        Assert.assertEquals("trace = false is lost", false, logC.isLoglevelEnabled(32));
        logC.info("ClusterManager", "OK");
        if (logC.TRACE) {
            logC.trace("ClusterManager", "ERROR");
        }
        if (logC.CALL) {
            logC.call("ClusterManager", "OK");
        }
        if (logC.DUMP) {
            logC.info("ClusterManager", "ERROR");
        }
        Assert.assertEquals("logging was not called correct", 2, this.counter);
        System.out.println("***GlobalLogTest: testLog [SUCCESS]");
    }

    public static void main(String[] args) {
        GlobalLogTest testSub = new GlobalLogTest("GlobalLogTest");
        testSub.setUp();
        testSub.testLog();
    }
}

