/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.xmlBlaster.engine.Global;

public class GlobalTest
extends TestCase {
    protected org.xmlBlaster.util.Global glob;

    public GlobalTest(String name) {
        super(name);
    }

    protected void setUp() {
        System.out.println("***GlobalTest: setup ...");
        String[] args = new String[]{"-test.xy", "true"};
        org.xmlBlaster.util.Global tmp = org.xmlBlaster.util.Global.instance();
        tmp.init(args);
        Assert.assertEquals("Argument not set", true, tmp.getProperty().get("test.xy", false));
    }

    public void testInstanceAccess() {
        System.out.println("***GlobalTest: testInstanceAccess ...");
        org.xmlBlaster.util.Global glob = org.xmlBlaster.util.Global.instance();
        Assert.assertEquals("Argument is lost", true, glob.getProperty().get("test.xy", false));
        System.out.println("***GlobalTest: testInstanceAccess [SUCCESS]");
    }

    public void testClone() {
        System.out.println("***GlobalTest: testClone ...");
        org.xmlBlaster.util.Global old = org.xmlBlaster.util.Global.instance();
        Assert.assertEquals("Argument not set", true, old.getProperty().get("test.xy", false));
        String[] args = new String[]{"-test.clone", "true"};
        org.xmlBlaster.util.Global glob = old.getClone(args);
        Assert.assertEquals("Argument not set anymore", true, old.getProperty().get("test.xy", false));
        Assert.assertEquals("Second argument should not be in original instance", false, old.getProperty().get("test.clone", false));
        Assert.assertEquals("First argument is lost", true, glob.getProperty().get("test.xy", false));
        Assert.assertEquals("Second argument is lost", true, glob.getProperty().get("test.clone", false));
        System.out.println("***GlobalTest: testClone [SUCCESS]");
    }

    public void testPropertyFile() {
        System.out.println("***GlobalTest: testPropertyFile ...");
        try {
            FileUtil.writeFile(System.getProperty("user.home"), "_tmp.properties", "oo=aa\ncluster.node.id=bilbo");
            String path = FileUtil.concatPath(System.getProperty("user.home"), "_tmp.properties");
            String[] args = new String[]{"-propertyFile", path};
            System.err.println("***GlobalTest: testPropertyFile -propertyFile " + path);
            org.xmlBlaster.util.Global.instance().init(args);
            Assert.assertEquals("Argument not set", path, org.xmlBlaster.util.Global.instance().getProperty().get("propertyFile", (String)null));
            Assert.assertEquals("Argument not set", "aa", org.xmlBlaster.util.Global.instance().getProperty().get("oo", (String)null));
            Assert.assertEquals("Argument not set", "bilbo", org.xmlBlaster.util.Global.instance().getProperty().get("cluster.node.id", (String)null));
            Assert.assertEquals("Invalid cluster node id", "bilbo", org.xmlBlaster.util.Global.instance().getId());
            Global eGlobal = new Global(org.xmlBlaster.util.Global.instance().getProperty().getProperties(), false);
            Assert.assertEquals("Argument not set after creating engine.Global", true, eGlobal.getProperty().get("test.xy", false));
            Assert.assertEquals("Argument not set after creating engine.Global", "aa", eGlobal.getProperty().get("oo", (String)null));
            Assert.assertEquals("Argument not set", "bilbo", eGlobal.getProperty().get("cluster.node.id", (String)null));
            org.xmlBlaster.util.Global bilboGlob = org.xmlBlaster.util.Global.instance().getClone(null);
            Assert.assertEquals("Argument not set", "bilbo", eGlobal.getProperty().get("cluster.node.id", (String)null));
            Assert.assertEquals("Invalid cluster node id", "bilbo", bilboGlob.getId());
        }
        catch (JUtilsException e) {
            Assert.fail("property file check failed: " + e.toString());
        }
        System.out.println("***GlobalTest: testPropertyFile [SUCCESS]");
    }

    public void testUtilToEngine() {
        System.out.println("***GlobalTest: testUtilToEngine ...");
        Assert.assertEquals("Argument not set", true, org.xmlBlaster.util.Global.instance().getProperty().get("test.xy", false));
        Global eGlobal = new Global(org.xmlBlaster.util.Global.instance().getProperty().getProperties(), false);
        Assert.assertEquals("Argument not set after creating engine.Global", true, eGlobal.getProperty().get("test.xy", false));
        System.out.println("***GlobalTest: testUtilToEngine [SUCCESS]");
    }
}

