/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.protocol.I_XmlBlaster;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.recorder.I_InvocationRecorder;
import org.xmlBlaster.util.recorder.file.FileRecorder;
import org.xmlBlaster.util.recorder.ram.RamRecorder;

public class InvocationRecorderTest
extends TestCase {
    private String ME = "InvocationRecorderTest";
    protected Global glob;
    protected LogChannel log;
    private int numSubscribe;
    private int numUnSubscribe;
    private int numGet;
    private int numPublish;
    private int numPublishOneway;
    private int numPublishArr;
    private int numErase;
    private int numUpdate;
    private int numUpdateOneway;
    private StopWatch stopWatch = new StopWatch();
    private boolean testDiscardOldest = false;

    public InvocationRecorderTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = new Global();
        this.log = this.glob.getLog(null);
    }

    public void testPlayback() {
        this.playback(new FileRecorder());
        this.playback(new RamRecorder());
    }

    private void playback(I_InvocationRecorder recorder) {
        this.ME = "InvocationRecorderTest.testPlayback()";
        System.out.println("***InvocationRecorderTest: testPlayback ...");
        try {
            try {
                MsgUnit[] msgs;
                Tester tester = new Tester();
                long maxEntries = 1000L;
                recorder.initialize(this.glob, "test.txt", maxEntries, tester);
                MethodName methodName = MethodName.SUBSCRIBE;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                int ii = 0;
                while ((long)ii < maxEntries) {
                    recorder.subscribe("<key oid='" + methodName + "'/>", "<qos/>");
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numSubscribe);
                this.numSubscribe = 0;
                methodName = MethodName.GET;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    recorder.get("<key oid='" + methodName + "'/>", "<qos/>");
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numGet);
                this.numGet = 0;
                methodName = MethodName.UNSUBSCRIBE;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    recorder.unSubscribe("<key oid='" + methodName + "'/>", "<qos/>");
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numUnSubscribe);
                this.numUnSubscribe = 0;
                methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    MsgUnit msgUnit = new MsgUnit("<key oid='" + methodName + "'/>", "Ho-" + ii, "<qos/>");
                    recorder.publish(msgUnit);
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numPublish);
                this.numPublish = 0;
                methodName = MethodName.PUBLISH_ONEWAY;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    msgs = new MsgUnit[]{new MsgUnit("<key oid='" + methodName + "'/>", "Ha-" + ii, "<qos/>"), new MsgUnit("<key oid='" + methodName + "'/>", "Hu-" + ii, "<qos/>")};
                    recorder.publishOneway(msgs);
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries * 2L));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numPublishOneway);
                this.numPublishOneway = 0;
                methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    msgs = new MsgUnit[]{new MsgUnit("<key oid='" + methodName + "'/>", "Ha-" + ii, "<qos/>"), new MsgUnit("<key oid='" + methodName + "'/>", "Hu-" + ii, "<qos/>")};
                    recorder.publishArr(msgs);
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries * 2L));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numPublishArr);
                this.numPublishArr = 0;
                methodName = MethodName.ERASE;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                this.stopWatch = new StopWatch();
                ii = 0;
                while ((long)ii < maxEntries) {
                    recorder.erase("<key oid='" + methodName + "'/>", "<qos/>");
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                this.log.info(this.ME, methodName + " round trip performance: " + this.stopWatch.nice(maxEntries));
                Assert.assertEquals("Wrong number of " + methodName, maxEntries, (long)this.numErase);
                this.numErase = 0;
                System.out.println("***InvocationRecorderTest: testPlayback [SUCCESS]");
            }
            catch (XmlBlasterException e) {
                Assert.fail("Exception thrown: " + e.toString());
                Object var9_9 = null;
                recorder.destroy();
            }
            Object var9_8 = null;
            recorder.destroy();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            recorder.destroy();
            throw throwable;
        }
    }

    public void testOnOverflowException() {
        this.onOverflowException(new FileRecorder());
        this.onOverflowException(new RamRecorder());
    }

    private void onOverflowException(I_InvocationRecorder recorder) {
        this.ME = "InvocationRecorderTest.testOnOverflowException()";
        System.out.println("***InvocationRecorderTest: testOnOverflowException ...");
        try {
            try {
                Tester tester = new Tester();
                int maxInvoke = 4;
                int maxQueueSize = maxInvoke / 2;
                recorder.initialize(this.glob, "testOverflow.txt", maxQueueSize, tester);
                MethodName methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                int ii = 0;
                while (ii < maxInvoke) {
                    MsgUnit msgUnit = new MsgUnit("<key oid='" + methodName + "'/>", "Ho-" + ii, "<qos/>");
                    try {
                        this.log.info(this.ME, "Publish ii=" + ii);
                        recorder.publish(msgUnit);
                        if (ii >= maxQueueSize) {
                            Assert.fail(this.ME + " Expected exception because of full queue ii=" + ii);
                        }
                    }
                    catch (XmlBlasterException e) {
                        if (ii >= maxQueueSize && e.getErrorCode() == ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES) {
                            this.log.info(this.ME, "OK, expected exception ii=" + ii);
                        }
                        Assert.fail(this.ME + " ii=" + ii + " : " + e.toString());
                    }
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                Assert.assertEquals("Wrong number of " + methodName, maxQueueSize, this.numPublish);
                this.numPublish = 0;
                methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                ii = 0;
                while (ii < maxInvoke) {
                    MsgUnit[] msgs = new MsgUnit[]{new MsgUnit("<key oid='" + methodName + "'/>", "Ha-" + ii, "<qos/>"), new MsgUnit("<key oid='" + methodName + "'/>", "Hu-" + ii, "<qos/>")};
                    try {
                        recorder.publishArr(msgs);
                        if (ii >= maxQueueSize) {
                            Assert.fail(this.ME + " Expected exception because of full queue ii=" + ii);
                        }
                    }
                    catch (XmlBlasterException e) {
                        if (ii >= maxQueueSize && e.getErrorCode() == ErrorCode.RESOURCE_OVERFLOW_QUEUE_ENTRIES) {
                            this.log.info(this.ME, "OK, expected exception ii=" + ii);
                        }
                        Assert.fail(this.ME + " ii=" + ii + " : " + e.toString());
                    }
                    ++ii;
                }
                recorder.pullback(0L, 0L, 0.0);
                Assert.assertEquals("Wrong number of " + methodName, maxQueueSize, this.numPublishArr);
                this.numPublishArr = 0;
                System.out.println("***InvocationRecorderTest: testOnOverflowException [SUCCESS]");
            }
            catch (XmlBlasterException e) {
                Assert.fail("Exception thrown: " + e.toString());
                Object var10_13 = null;
                recorder.destroy();
            }
            Object var10_12 = null;
            recorder.destroy();
        }
        catch (Throwable throwable) {
            Object var10_14 = null;
            recorder.destroy();
            throw throwable;
        }
    }

    public void testOnOverflowDiscardOldest() {
        this.onOverflowDiscardOldest(new FileRecorder());
        this.onOverflowDiscardOldest(new RamRecorder());
    }

    private void onOverflowDiscardOldest(I_InvocationRecorder recorder) {
        this.ME = "InvocationRecorderTest.testOnOverflowDiscardOldest()";
        System.out.println("***InvocationRecorderTest: testOnOverflowDiscardOldest ...");
        this.testDiscardOldest = true;
        try {
            try {
                Tester tester = new Tester();
                int maxInvoke = 4;
                int maxQueueSize = maxInvoke / 2;
                recorder.initialize(this.glob, null, maxQueueSize, tester);
                recorder.setMode("discardOldest");
                MethodName methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                int ii = 0;
                while (ii < maxInvoke) {
                    MsgUnit msgUnit = new MsgUnit("<key oid='" + methodName + "'/>", "Ho-" + ii, "<qos/>");
                    try {
                        recorder.publish(msgUnit);
                    }
                    catch (XmlBlasterException e) {
                        Assert.fail(this.ME + " ii=" + ii + " : " + e.toString());
                    }
                    ++ii;
                }
                Assert.assertEquals("Wrong number of lost messages in " + methodName, (long)(maxInvoke - maxQueueSize), recorder.getNumLost());
                recorder.pullback(0L, 0L, 0.0);
                Assert.assertEquals("Wrong number of " + methodName, maxQueueSize, this.numPublish);
                this.numPublish = 0;
                System.out.println("***InvocationRecorderTest: testOnOverflowDiscardOldest [SUCCESS]");
            }
            catch (XmlBlasterException e) {
                Assert.fail("Exception thrown: " + e.toString());
                Object var10_11 = null;
                recorder.destroy();
            }
            Object var10_10 = null;
            recorder.destroy();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            recorder.destroy();
            throw throwable;
        }
    }

    public void testOnOverflowDiscard() {
        this.onOverflowDiscard(new FileRecorder());
        this.onOverflowDiscard(new RamRecorder());
    }

    private void onOverflowDiscard(I_InvocationRecorder recorder) {
        this.ME = "InvocationRecorderTest.testOnOverflowDiscard()";
        System.out.println("***InvocationRecorderTest: testOnOverflowDiscard ...");
        try {
            try {
                Tester tester = new Tester();
                int maxInvoke = 4;
                int maxQueueSize = maxInvoke / 2;
                recorder.initialize(this.glob, null, maxQueueSize, tester);
                recorder.setMode("discard");
                MethodName methodName = MethodName.PUBLISH;
                this.log.info(this.ME, "Testing '" + methodName + "' ...");
                int ii = 0;
                while (ii < maxInvoke) {
                    MsgUnit msgUnit = new MsgUnit("<key oid='" + methodName + "'/>", "Ho-" + ii, "<qos/>");
                    try {
                        recorder.publish(msgUnit);
                    }
                    catch (XmlBlasterException e) {
                        Assert.fail(this.ME + " ii=" + ii + " : " + e.toString());
                    }
                    ++ii;
                }
                Assert.assertEquals("Wrong number of lost messages in " + methodName, (long)(maxInvoke - maxQueueSize), recorder.getNumLost());
                recorder.pullback(0L, 0L, 0.0);
                Assert.assertEquals("Wrong number of " + methodName, maxQueueSize, this.numPublish);
                this.numPublish = 0;
                System.out.println("***InvocationRecorderTest: testOnOverflowDiscard [SUCCESS]");
            }
            catch (XmlBlasterException e) {
                Assert.fail("Exception thrown: " + e.toString());
                Object var10_11 = null;
                recorder.destroy();
            }
            Object var10_10 = null;
            recorder.destroy();
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            recorder.destroy();
            throw throwable;
        }
    }

    protected void tearDown() {
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        InvocationRecorderTest testSub = new InvocationRecorderTest("InvocationRecorderTest");
        testSub.setUp();
        testSub.onOverflowDiscard(new FileRecorder());
        testSub.tearDown();
    }

    class Tester
    implements I_XmlBlaster {
        Tester() {
        }

        public SubscribeReturnQos subscribe(String xmlKey, String qos) throws XmlBlasterException {
            Assert.assertEquals("Wrong message key", "<key oid='subscribe'/>", xmlKey);
            Assert.assertEquals("Wrong message qos", "<qos/>", qos);
            InvocationRecorderTest.this.numSubscribe++;
            return null;
        }

        public MsgUnit[] get(String xmlKey, String qos) throws XmlBlasterException {
            Assert.assertEquals("Wrong message key", "<key oid='get'/>", xmlKey);
            Assert.assertEquals("Wrong message qos", "<qos/>", qos);
            InvocationRecorderTest.this.numGet++;
            return new MsgUnit[0];
        }

        public UnSubscribeReturnQos[] unSubscribe(String xmlKey, String qos) throws XmlBlasterException {
            Assert.assertEquals("Wrong message key", "<key oid='unSubscribe'/>", xmlKey);
            Assert.assertEquals("Wrong message qos", "<qos/>", qos);
            InvocationRecorderTest.this.numUnSubscribe++;
            return null;
        }

        public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
            Assert.assertEquals("Wrong message key", "<key oid='publish'/>", msgUnit.getKey().trim());
            if (InvocationRecorderTest.this.testDiscardOldest) {
                Assert.assertEquals("Wrong message content", "Ho-" + (InvocationRecorderTest.this.numPublish + 2), msgUnit.getContentStr());
            } else {
                Assert.assertEquals("Wrong message content", "Ho-" + InvocationRecorderTest.this.numPublish, msgUnit.getContentStr());
            }
            Assert.assertEquals("Wrong message qos", "<qos/>", msgUnit.getQos());
            InvocationRecorderTest.this.numPublish++;
            return null;
        }

        public void publishOneway(MsgUnit[] msgUnitArr) {
            Assert.assertEquals("Wrong message array length", 2, msgUnitArr.length);
            Assert.assertEquals("Wrong message key", "<key oid='publishOneway'/>", msgUnitArr[0].getKey().trim());
            Assert.assertEquals("Wrong message content", "Ha-" + InvocationRecorderTest.this.numPublishOneway, msgUnitArr[0].getContentStr());
            Assert.assertEquals("Wrong message qos", "<qos/>", msgUnitArr[0].getQos());
            Assert.assertEquals("Wrong message key", "<key oid='publishOneway'/>", msgUnitArr[1].getKey().trim());
            Assert.assertEquals("Wrong message content", "Hu-" + InvocationRecorderTest.this.numPublishOneway, msgUnitArr[1].getContentStr());
            Assert.assertEquals("Wrong message qos", "<qos/>", msgUnitArr[1].getQos());
            InvocationRecorderTest.this.numPublishOneway++;
        }

        public PublishReturnQos[] publishArr(MsgUnit[] msgUnitArr) throws XmlBlasterException {
            Assert.assertEquals("Wrong message array length", 2, msgUnitArr.length);
            Assert.assertEquals("Wrong message key", "<key oid='" + MethodName.PUBLISH + "'/>", msgUnitArr[0].getKey().trim());
            Assert.assertEquals("Wrong message content", "Ha-" + InvocationRecorderTest.this.numPublishArr, msgUnitArr[0].getContentStr());
            Assert.assertEquals("Wrong message qos", "<qos/>", msgUnitArr[0].getQos());
            Assert.assertEquals("Wrong message key", "<key oid='" + MethodName.PUBLISH + "'/>", msgUnitArr[1].getKey().trim());
            Assert.assertEquals("Wrong message content", "Hu-" + InvocationRecorderTest.this.numPublishArr, msgUnitArr[1].getContentStr());
            Assert.assertEquals("Wrong message qos", "<qos/>", msgUnitArr[1].getQos());
            InvocationRecorderTest.this.numPublishArr++;
            return new PublishReturnQos[0];
        }

        public EraseReturnQos[] erase(String xmlKey, String qos) throws XmlBlasterException {
            Assert.assertEquals("Wrong message key", "<key oid='erase'/>", xmlKey);
            Assert.assertEquals("Wrong message qos", "<qos/>", qos);
            InvocationRecorderTest.this.numErase++;
            return new EraseReturnQos[0];
        }
    }
}

