/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Hashtable;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.protocol.http.common.BufferedInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.Msg;
import org.xmlBlaster.client.protocol.http.common.MsgHolder;
import org.xmlBlaster.client.protocol.http.common.ObjectInputStreamMicro;
import org.xmlBlaster.client.protocol.http.common.ObjectOutputStreamMicro;
import org.xmlBlaster.util.Global;

public class MicroEditionTest
extends TestCase {
    static final String ME = "MicroEditionTest";
    protected Global glob = Global.instance();
    protected LogChannel log;
    int counter = 0;

    public MicroEditionTest(String name, String[] args) {
        super(name);
        this.glob.init(args);
        this.log = this.glob.getLog("test");
    }

    public MicroEditionTest(String name) {
        super(name);
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    private void assertHashtableContent(String key, Hashtable ref, Hashtable is) {
        Object val1 = ref.get(key);
        Object val2 = is.get(key);
        Assert.assertEquals("wrong value for key '" + key + "'", val1, val2);
    }

    public void testVectorIO() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStreamMicro oosm = new ObjectOutputStreamMicro(baos);
            Hashtable<String, String> key = new Hashtable<String, String>();
            key.put("one", "1");
            key.put("two", "2");
            key.put("three", "3");
            key.put("four", "4");
            Hashtable<String, String> qos = new Hashtable<String, String>();
            qos.put("one-qos", "1");
            qos.put("two-qos", "2");
            qos.put("three-qos", "3");
            byte[] content = "This is the content".getBytes();
            Msg msg = new Msg(key, content, qos);
            Vector<Object> inVec = new Vector<Object>();
            inVec.add(key);
            inVec.add(qos);
            inVec.add(content);
            inVec.add(key);
            inVec.add(qos);
            inVec.add(content);
            oosm.writeObject(inVec);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStreamMicro oism = new ObjectInputStreamMicro(bais);
            Object obj = oism.readObject();
            Assert.assertTrue("hashtable is not of type 'Vector', it is " + obj.getClass().getName(), obj instanceof Vector);
            Vector vec = (Vector)obj;
            Assert.assertEquals("wrong number of entries in vector", 6, vec.size());
            Hashtable keyOut = (Hashtable)vec.get(0);
            Hashtable qosOut = (Hashtable)vec.get(1);
            byte[] contentOut = (byte[])vec.get(2);
            this.assertHashtableContent("one", key, keyOut);
            this.assertHashtableContent("two", key, keyOut);
            this.assertHashtableContent("three", key, keyOut);
            this.assertHashtableContent("four", key, keyOut);
            this.assertHashtableContent("one-qos", qos, qosOut);
            this.assertHashtableContent("two-qos", qos, qosOut);
            this.assertHashtableContent("three-qos", qos, qosOut);
            keyOut = (Hashtable)vec.get(3);
            qosOut = (Hashtable)vec.get(4);
            contentOut = (byte[])vec.get(5);
            this.assertHashtableContent("one", key, keyOut);
            this.assertHashtableContent("two", key, keyOut);
            this.assertHashtableContent("three", key, keyOut);
            this.assertHashtableContent("four", key, keyOut);
            this.assertHashtableContent("one-qos", qos, qosOut);
            this.assertHashtableContent("two-qos", qos, qosOut);
            this.assertHashtableContent("three-qos", qos, qosOut);
            this.log.info(ME, "testVectorIO successfully completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public void testHashtableIO() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStreamMicro oosm = new ObjectOutputStreamMicro(baos);
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("one", "1");
            hashtable.put("two", "2");
            hashtable.put("three", "3");
            hashtable.put("four", "4");
            oosm.writeObject(hashtable);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStreamMicro oism = new ObjectInputStreamMicro(bais);
            Object obj = oism.readObject();
            Assert.assertTrue("hashtable is not of type 'Hashtable', it is " + obj.getClass().getName(), obj instanceof Hashtable);
            Hashtable table = (Hashtable)obj;
            Assert.assertEquals("wrong number of entries in hashtable", hashtable.size(), table.size());
            this.assertHashtableContent("one", hashtable, table);
            this.assertHashtableContent("two", hashtable, table);
            this.assertHashtableContent("three", hashtable, table);
            this.assertHashtableContent("four", hashtable, table);
            this.log.info(ME, "testHashtableIO successfully completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public void testStringIO() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStreamMicro oosm = new ObjectOutputStreamMicro(baos);
            String testString = "this is\n\na simple\nmultiline string\n";
            oosm.writeObject(testString);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStreamMicro oism = new ObjectInputStreamMicro(bais);
            Object obj = oism.readObject();
            Assert.assertTrue("string is not of type 'String', it is " + obj.getClass().getName(), obj instanceof String);
            String response = (String)obj;
            Assert.assertEquals("wrong content for the string", testString, response);
            this.log.info(ME, "testStringIO successfully completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public void testReadLine() {
        try {
            String line1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ps.println("first line");
            ps.println("");
            ps.println("");
            ps.println("");
            ps.println("second line");
            ps.println("third line");
            ps.println("");
            ps.println("");
            ps.close();
            byte[] buf = baos.toByteArray();
            byte[] buf1 = new byte[buf.length];
            int i = 0;
            while (i < buf.length) {
                buf1[i] = buf[i];
                ++i;
            }
            BufferedInputStreamMicro bism = new BufferedInputStreamMicro(new ByteArrayInputStream(buf));
            BufferedReader br = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(buf1)));
            while ((line1 = br.readLine()) != null) {
                String line2 = bism.readLine();
                if (line2 == null) {
                    Assert.assertTrue("second line is unexpectedly null", false);
                }
                Assert.assertEquals("wrong content", line1, line2);
            }
            this.log.info(ME, "testReadLine successfully completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public void testReadLineDelayed() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            ps.println("first line");
            ps.println("");
            ps.println("");
            ps.println("");
            ps.println("second line");
            ps.println("third line");
            ps.println("");
            ps.println("");
            ps.close();
            byte[] buf = baos.toByteArray();
            int port1 = 26666;
            int port2 = 26667;
            Receiver receiver1 = new Receiver(port1, false);
            Receiver receiver2 = new Receiver(port2, true);
            this.log.info(ME, "testReadLineDelayed create sender 1");
            Sender sender1 = new Sender(receiver1.startListener(), port1, buf, 1L);
            this.log.info(ME, "testReadLineDelayed create sender 2");
            Sender sender2 = new Sender(receiver2.startListener(), port2, buf, 10L);
            while (!receiver1.isFinished() || !receiver2.isFinished()) {
                Thread.sleep(200L);
            }
            String[] resp1 = receiver1.getLines();
            String[] resp2 = receiver2.getLines();
            Assert.assertEquals("wrong number of lines returned", resp1.length, resp2.length);
            int i = 0;
            while (i < resp1.length) {
                this.log.info(ME, ".testReadLineDelayed '" + resp1[i] + "' '" + resp2[i] + "'");
                ++i;
            }
            int i2 = 0;
            while (i2 < resp1.length) {
                Assert.assertEquals("wrong content of line " + i2, resp1[i2], resp2[i2]);
                ++i2;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public void testMessageIO() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStreamMicro oosm = new ObjectOutputStreamMicro(baos);
            String oid = "someOid";
            String key = "<key oid='100'></key>";
            String qos = "<qos><persistent/></qos>";
            byte[] content = "This is the content".getBytes();
            int length = ObjectOutputStreamMicro.writeMessage(baos, oid, key, qos, content);
            Assert.assertEquals("wrong length returned", oid.length() + key.length() + qos.length() + content.length + 3, length);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStreamMicro oism = new ObjectInputStreamMicro(bais);
            int size = bais.available();
            Assert.assertEquals("wrong length of bytes available", length, size);
            byte[] msg = new byte[size];
            bais.read(msg);
            MsgHolder msgHolder = ObjectInputStreamMicro.readMessage(msg);
            Assert.assertEquals("wrong content for the oid", oid, msgHolder.getOid());
            Assert.assertEquals("wrong content for the key", key, msgHolder.getKey());
            Assert.assertEquals("wrong content for the qos", qos, msgHolder.getQos());
            Assert.assertEquals("wrong content for the content", new String(content), new String(msgHolder.getContent()));
            this.log.info(ME, "testMessageIO successfully completed");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("exception occured: " + ex.getMessage(), false);
        }
    }

    public static void main(String[] args) {
        MicroEditionTest test = new MicroEditionTest(ME, args);
        test.setUp();
        test.testStringIO();
        test.tearDown();
        test.setUp();
        test.testHashtableIO();
        test.tearDown();
        test.setUp();
        test.testVectorIO();
        test.tearDown();
        test.setUp();
        test.testReadLine();
        test.tearDown();
        test.setUp();
        test.testReadLineDelayed();
        test.tearDown();
        test.setUp();
        test.testMessageIO();
        test.tearDown();
    }

    public class Receiver
    extends Thread {
        private int port;
        private Vector lines = new Vector();
        private ServerSocket serverSocket;
        private boolean isMicro;
        private boolean finished;

        public Receiver(int port, boolean isMicro) throws IOException {
            this.port = port;
            this.serverSocket = new ServerSocket(this.port);
        }

        public InetAddress startListener() {
            this.start();
            return this.serverSocket.getInetAddress();
        }

        public String[] getLines() {
            return this.lines.toArray(new String[this.lines.size()]);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public void run() {
            System.out.println("starting thread");
            try {
                Socket sock = this.serverSocket.accept();
                InputStream in = sock.getInputStream();
                if (this.isMicro) {
                    String line;
                    BufferedInputStreamMicro br = new BufferedInputStreamMicro(in);
                    while ((line = br.readLine()) != null) {
                        this.lines.add(line);
                    }
                } else {
                    String line;
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null) {
                        this.lines.add(line);
                    }
                }
                sock.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.finished = true;
        }
    }

    public class Sender
    extends Thread {
        private int port;
        private byte[] content;
        private long delay;
        private InetAddress addr;

        public Sender(InetAddress addr, int port, byte[] content, long delay) {
            this.port = port;
            this.content = content;
            this.delay = delay;
            this.addr = addr;
            this.start();
        }

        public void run() {
            try {
                Socket sock = new Socket(this.addr, this.port);
                OutputStream out = sock.getOutputStream();
                int i = 0;
                while (i < this.content.length) {
                    out.write(this.content[i]);
                    Thread.sleep(this.delay);
                    ++i;
                }
                out.flush();
                sock.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

