/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.engine.runlevel.PluginConfig;
import org.xmlBlaster.engine.runlevel.PluginConfigComparator;
import org.xmlBlaster.engine.runlevel.PluginConfigSaxFactory;
import org.xmlBlaster.engine.runlevel.PluginHolder;
import org.xmlBlaster.engine.runlevel.PluginHolderSaxFactory;
import org.xmlBlaster.engine.runlevel.RunLevelAction;
import org.xmlBlaster.engine.runlevel.RunLevelActionSaxFactory;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class RunLevelTest
extends TestCase {
    static final String ME = "RunLevelTest";
    protected Global glob = Global.instance();
    protected LogChannel log;
    int counter = 0;

    public RunLevelTest(String name, String[] args) {
        super(name);
        this.glob.init(args);
        this.log = this.glob.getLog("test");
    }

    public RunLevelTest(String name) {
        super(name);
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testAction() {
        String me = "RunLevelTest-testAction";
        this.log.info(me, "start");
        try {
            String xml = "<action do='LOAD'\n        onStartupRunlevel='3'\n        sequence='5'\n        onFail='resource.configuration.pluginFailed'/>";
            RunLevelActionSaxFactory factory = new RunLevelActionSaxFactory(this.glob);
            RunLevelAction action = factory.readObject(xml);
            int i = 0;
            while (i < 2) {
                Assert.assertEquals(me + " checking do attribute", "LOAD", action.getDo());
                Assert.assertEquals(me + " checking onFail attribute", "resource.configuration.pluginFailed", action.getOnFail().getErrorCode());
                Assert.assertEquals(me + " checking onShutdownLevel attribute", -1, action.getOnShutdownRunlevel());
                Assert.assertEquals(me + " checking onStartupLevel attribute", 3, action.getOnStartupRunlevel());
                Assert.assertEquals(me + " checking sequence attribute", 5, action.getSequence());
                Assert.assertEquals(me + " checking hasOnFail", true, action.hasOnFail());
                Assert.assertEquals(me + " checking isOnShutdownLevel", false, action.isOnShutdownRunlevel());
                Assert.assertEquals(me + " checking isOnStartupLevel", true, action.isOnStartupRunlevel());
                xml = action.toXml();
                action = factory.readObject(xml);
                this.log.info(me, "going to test the second time ...");
                ++i;
            }
            try {
                xml = null;
                action = factory.readObject(xml);
                Assert.assertTrue(me + " a null string is not allowed here. Should have thrown an exception", true);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the exception is allowed here since a null string is not allowed here." + ex.getMessage());
            }
            try {
                xml = "";
                action = factory.readObject(xml);
                Assert.assertTrue(me + " an empty string is not allowed here. Should have thrown an exception", true);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the exception is allowed here since an empty string is not allowed here." + ex.getMessage());
            }
            try {
                xml = "xyz";
                action = factory.readObject(xml);
                Assert.assertTrue(me + " a non-xml string is not allowed here. Should have thrown an exception", true);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the exception is allowed here since a non-xml string is not allowed here." + ex.getMessage());
            }
            try {
                xml = "<xmlBlaster></xmlBlaster>";
                action = factory.readObject(xml);
                Assert.assertTrue(me + " a wrong tag name is not allowed here. Should have thrown an exception", true);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the exception is allowed here since  a wrong tag name is not allowed here." + ex.getMessage());
            }
            xml = "<action/>";
            action = factory.readObject(xml);
        }
        catch (XmlBlasterException e) {
            Assert.fail("RunLevelTest failed: " + e.toString());
        }
        this.log.info(ME, "successfully ended");
    }

    public void testPluginConfig() {
        String me = "RunLevelTest-testPluginConfig";
        try {
            this.log.info(me, "start");
            PluginConfig config = new PluginConfig(this.glob, "queueJDBC", "org.xmlBlaster.util.queue.jdbc.JDBCQueueCommonTablePlugin");
            config.addAttribute("url", "jdbc:oracle:thin:@localhost:1521:noty");
            config.addAttribute("user", "joe");
            config.addAttribute("password", "secret");
            config.addAttribute("connectionBusyTimeout", "90000");
            config.addAttribute("maxWaitingThreads", "300");
            RunLevelAction action = new RunLevelAction(this.glob, "LOAD", 3, -1, ErrorCode.toErrorCode("internal.unknown"), 5);
            config.addAction(action);
            action = new RunLevelAction(this.glob, "STOP", -1, 2, null, 4);
            config.addAction(action);
            String xml = config.toXml();
            this.log.info(me, xml);
            PluginConfigSaxFactory factory = new PluginConfigSaxFactory(this.glob);
            config = factory.readObject(xml);
            RunLevelAction[] actions = config.getActions();
            Assert.assertEquals(me + " number of actions", 2, actions.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("RunLevelTest failed: " + e.toString());
        }
        this.log.info(me, "successfully ended");
    }

    public void testPluginHolder() {
        String me = "RunLevelTest-testPluginHolder";
        try {
            this.log.info(me, "start");
            PluginHolder holder = new PluginHolder(this.glob);
            PluginConfig tmp = new PluginConfig(this.glob, "queueJDBC", "org.xmlBlaster.util.queue.jdbc.JDBCQueueCommonTablePlugin");
            holder.addDefaultPluginConfig(tmp);
            tmp = new PluginConfig(this.glob, "queueRAM", "org.xmlBlaster.util.queue.ram.RAMQueuePlugin");
            holder.addPluginConfig("avalon", tmp);
            tmp = holder.getPluginConfig("avalon", "queueRAM");
            if (tmp == null) {
                Assert.assertTrue(me + " getting 'avalon queueRAM'", false);
            }
            this.log.info(me, tmp.toXml());
            tmp = holder.getPluginConfig("avalon", "queueJDBC");
            if (tmp == null) {
                Assert.assertTrue(me + " getting 'avalon queueJDBC'", false);
            }
            this.log.info(me, tmp.toXml());
            PluginConfig[] help = holder.getAllPluginConfig("avalon");
            Assert.assertEquals(me + " get all plugins for avalon", 2, help.length);
            String xml = new String();
            xml = xml + "<xmlBlaster>\n   <!-- A typical plugin which is loaded by client request -->\n   <plugin id='dispatchPriority'\n           className='org.xmlBlaster.util.dispatch.plugins.prio.PriorizedDispatchPlugin'\n           jar='/tmp/my.jar'>\n      <attribute id='config'>\n         <![CDATA[\n         <msgDispatch defaultStatus='64k' defaultAction='send'>\n         <onStatus oid='_bandwidth.status' content='64k' defaultAction='destroy'>\n            <action do='send'  ifPriority='7-9'/>\n            <action do='queue'  ifPriority='2-6'/>\n         </onStatus>\n         <onStatus oid='_bandwidth.status' content='2M'>\n            <action do='send'  ifPriority='0-9'/>\n         </onStatus>\n         </msgDispatch>\n         ]]>\n      </attribute>\n   </plugin>\n\n   <plugin id='queueCACHE' className='org.xmlBlaster.util.queue.cache.CacheQueueInterceptorPlugin'>\n      <attribute id='transientQueue'>queueRAM</attribute>\n      <attribute id='persistentQueue'>queueJDBC</attribute>\n   </plugin>\n   \n  <plugin id='queueRAM' className='org.xmlBlaster.util.queue.ram.RamQueuePlugin'/>\n\n   <plugin id='storage:CACHE' className='org.xmlBlaster.engine.msgstore.cache.PersistenceCachePlugin'>\n      <attribute id='transientQueue'>storage:RAM</attribute>\n      <attribute id='persistentQueue'>storage:JDBC</attribute>\n   </plugin>\n   \n   <plugin id='storage:RAM' className='org.xmlBlaster.engine.msgstore.ram.MapPlugin'/>\n   \n   <!-- and here the declarations which are specific to the given nodes -->\n   <node id='heron'>\n      <plugin id='protocol:SOCKET:admin' \n              className='org.xmlBlaster.protocol.socket.SocketDriver'>\n         <attribute id='port'>69000</attribute>\n      </plugin>\n     \n      <!-- /node/heron/plugin/protocol:SOCKET:users/attribute/port=6901 -->\n      <!-- /node/heron/plugin/protocol:SOCKET:users/action/LOAD/onStartupRunlevel=3 -->\n      <!-- /node/heron/plugin/protocol:SOCKET:users/action/LOAD/sequence=5 -->\n      <plugin id='protocol:SOCKET:users' className='org.xmlBlaster.protocol.socket.SocketDriver'>\n         <attribute id='port'>6901</attribute>\n         <action do='LOAD' onStartupRunlevel='3' sequence='5' onFail='resource.configuration.pluginFailed'/>\n         <action do='STOP' onShutdownRunlevel='2' sequence='4'/>\n      </plugin>\n     \n      <plugin id='queueJDBC' className='org.xmlBlaster.util.queue.jdbc.JDBCQueueCommonTablePlugin'>\n         <attribute id='url'>jdbc:oracle:thin:@localhost:1521:noty</attribute>\n         <attribute id='user'>joe</attribute>\n         <attribute id='password'>secret</attribute>\n         <attribute id='connectionBusyTimeout'>90000</attribute>\n         <attribute id='maxWaitingThreads'>300</attribute>\n      </plugin>\n     \n      <plugin id='storage:JDBC' className='org.xmlBlaster.engine.msgstore.cache.PersistenceCachePlugin'>\n         <attribute id='url'>jdbc:oracle:thin:@localhost:1521:noty</attribute>\n         <attribute id='user'>joe</attribute>\n         <attribute id='password'>secret</attribute>\n         <attribute id='connectionBusyTimeout'>90000</attribute>\n         <attribute id='maxWaitingThreads'>300</attribute>\n      </plugin>\n    </node> <!-- heron -->\n \n    <node id='avalon'>\n       ...\n      <plugin id='queueJDBC' className='org.xmlBlaster.util.queue.jdbc.JDBCQueueCommonTablePlugin'>\n         <attribute id='url'>jdbc:oracle:thin:@localhost:1521:noty</attribute>\n         <attribute id='user'>joe</attribute>\n         <attribute id='password'>secret</attribute>\n         <attribute id='connectionBusyTimeout'>90000</attribute>\n         <attribute id='maxWaitingThreads'>300</attribute>\n        <attribute id='tableNamePrefix'>AVALON_</attribute>\n      </plugin>\n      ...\n    </node>\n</xmlBlaster>\n";
            PluginHolderSaxFactory factory = new PluginHolderSaxFactory(this.glob);
            PluginHolder pluginHolder = null;
            int i = 0;
            while (i < 2) {
                this.log.info(me, "looping through the loop. sweep '" + i + "'");
                pluginHolder = factory.readObject(xml);
                PluginConfig[] plugins = pluginHolder.getAllPluginConfig("avalon");
                Assert.assertEquals(me + " number of plugins for 'avalon' in plugin holder", 6, plugins.length);
                PluginConfig pluginConfig = null;
                pluginConfig = pluginHolder.getPluginConfig("avalon", "dispatchPriority");
                if (pluginConfig == null) {
                    Assert.assertTrue(me + " getting plugin 'dispatchPriority' for avalon gives null", false);
                }
                String id = pluginConfig.getId();
                Assert.assertEquals(me + " id for avalon/dispatchPriority", "dispatchPriority", id);
                String className = pluginConfig.getClassName();
                Assert.assertEquals(me + " className for avalon/dispatchPriority", "org.xmlBlaster.util.dispatch.plugins.prio.PriorizedDispatchPlugin", className);
                pluginConfig = pluginHolder.getPluginConfig("avalon", "queueCACHE");
                pluginConfig = pluginHolder.getPluginConfig("avalon", "queueRAM");
                pluginConfig = pluginHolder.getPluginConfig("avalon", "queueJDBC");
                pluginConfig = pluginHolder.getPluginConfig("avalon", "storage:CACHE");
                pluginConfig = pluginHolder.getPluginConfig("avalon", "storage:RAM");
                pluginConfig = pluginHolder.getPluginConfig("avalon", "storage:JDBC");
                pluginConfig = pluginHolder.getPluginConfig("heron", "queueJDBC");
                xml = pluginHolder.toXml();
                this.log.info(ME, xml);
                ++i;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(me + " failed: " + e.toString());
        }
        this.log.info(me, "successfully ended");
    }

    public void testPluginConfigComparator() {
        String me = "RunLevelTest-testPluginConfigConparator";
        this.log.info(me, "start");
        PluginConfigComparator upComparator = new PluginConfigComparator(this.glob, true);
        PluginConfigComparator downComparator = new PluginConfigComparator(this.glob, false);
        PluginConfig config1 = new PluginConfig(this.glob, "test:PLUGIN1", "org.universe.Plugin1");
        RunLevelAction action = new RunLevelAction(this.glob, "LOAD", 3, -1, null, 5);
        config1.addAction(action);
        action = new RunLevelAction(this.glob, "STOP", -1, 2, null, 4);
        config1.addAction(action);
        PluginConfig config2 = new PluginConfig(this.glob, "test:PLUGIN2", "org.universe.Plugin2");
        action = new RunLevelAction(this.glob, "LOAD", 3, -1, null, 5);
        config2.addAction(action);
        action = new RunLevelAction(this.glob, "STOP", -1, 2, null, 4);
        config2.addAction(action);
        int cmp = upComparator.compare(config1, config2);
        Assert.assertTrue(me + " number of actions", cmp < 0);
        cmp = downComparator.compare(config1, config2);
        Assert.assertTrue(me + " number of actions", cmp > 0);
        PluginConfig config3 = new PluginConfig(this.glob, "test:PLUGIN3", "org.universe.Plugin3");
        action = new RunLevelAction(this.glob, "LOAD", 2, -1, null, 3);
        config3.addAction(action);
        action = new RunLevelAction(this.glob, "STOP", -1, 1, null, 3);
        config3.addAction(action);
        cmp = upComparator.compare(config1, config3);
        Assert.assertTrue(me + " number of actions", cmp > 0);
        cmp = downComparator.compare(config1, config3);
        Assert.assertTrue(me + " number of actions", cmp < 0);
        PluginConfig config4 = new PluginConfig(this.glob, "test:PLUGIN4", "org.universe.Plugin4");
        action = new RunLevelAction(this.glob, "LOAD", 2, -1, null, 4);
        config4.addAction(action);
        action = new RunLevelAction(this.glob, "STOP", -1, 1, null, 4);
        config4.addAction(action);
        cmp = upComparator.compare(config3, config4);
        Assert.assertTrue(me + " number of actions", cmp < 0);
        cmp = downComparator.compare(config3, config4);
        Assert.assertTrue(me + " number of actions", cmp < 0);
        try {
            cmp = upComparator.compare(config3, (Object)null);
            Assert.assertTrue(me + " number of actions", true);
        }
        catch (ClassCastException ex) {
            this.log.info(me, "exception is OK and expected in this context");
        }
        try {
            cmp = upComparator.compare(config3, (Object)null);
            Assert.assertTrue(me + " number of actions", true);
        }
        catch (ClassCastException ex) {
            this.log.info(me, "exception is OK and expected in this context");
        }
        try {
            cmp = upComparator.compare((Object)null, config4);
            Assert.assertTrue(me + " number of actions", true);
        }
        catch (ClassCastException ex) {
            this.log.info(me, "exception is OK and expected in this context");
        }
        try {
            cmp = downComparator.compare((Object)null, config4);
            Assert.assertTrue(me + " number of actions", true);
        }
        catch (ClassCastException ex) {
            this.log.info(me, "exception is OK and expected in this context");
        }
        this.log.info(me, "successfully ended");
    }

    public static void main(String[] args) {
        RunLevelTest testSub = new RunLevelTest(ME, args);
        testSub.setUp();
        testSub.testAction();
        testSub.tearDown();
        testSub.setUp();
        testSub.testPluginConfig();
        testSub.tearDown();
        testSub.setUp();
        testSub.testPluginHolder();
        testSub.tearDown();
        testSub.setUp();
        testSub.testPluginConfigComparator();
        testSub.tearDown();
    }
}

