/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.cluster.NodeId;

public class SessionNameTest
extends TestCase {
    protected Global glob;
    int counter = 0;

    public SessionNameTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
    }

    public void testParse() {
        SessionName sessionName;
        SessionName tmp;
        SessionName sessionName2;
        System.out.println("***SessionNameTest: testParse ...");
        try {
            sessionName2 = new SessionName(this.glob, "jack");
            Assert.assertEquals("", "client/jack", sessionName2.getAbsoluteName());
            Assert.assertEquals("", null, sessionName2.getNodeIdStr());
            Assert.assertEquals("", "client/jack", sessionName2.getRelativeName());
            Assert.assertEquals("", "jack", sessionName2.getLoginName());
            Assert.assertEquals("", 0L, sessionName2.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "client/jack");
            System.out.println("AbsoluteName=" + sessionName2.getAbsoluteName() + " RelativeName=" + sessionName2.getRelativeName());
            Assert.assertEquals("", "client/jack", sessionName2.getAbsoluteName());
            Assert.assertEquals("", null, sessionName2.getNodeIdStr());
            Assert.assertEquals("", "client/jack", sessionName2.getRelativeName());
            Assert.assertEquals("", "jack", sessionName2.getLoginName());
            Assert.assertEquals("", 0L, sessionName2.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "client/jack/99");
            System.out.println("AbsoluteName=" + sessionName2.getAbsoluteName() + " RelativeName=" + sessionName2.getRelativeName());
            Assert.assertEquals("", "client/jack/99", sessionName2.getAbsoluteName());
            Assert.assertEquals("", null, sessionName2.getNodeIdStr());
            Assert.assertEquals("", "client/jack/99", sessionName2.getRelativeName());
            Assert.assertEquals("", "jack", sessionName2.getLoginName());
            Assert.assertEquals("", 99L, sessionName2.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "/node/heron/client/jack/99");
            System.out.println("AbsoluteName=" + sessionName2.getAbsoluteName() + " RelativeName=" + sessionName2.getRelativeName());
            Assert.assertEquals("", "/node/heron/client/jack/99", sessionName2.getAbsoluteName());
            Assert.assertEquals("", "heron", sessionName2.getNodeId().getId());
            Assert.assertEquals("", "client/jack/99", sessionName2.getRelativeName());
            Assert.assertEquals("", "jack", sessionName2.getLoginName());
            Assert.assertEquals("", 99L, sessionName2.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            tmp = new SessionName(this.glob, "client/jack");
            sessionName = new SessionName(this.glob, tmp, -4L);
            System.out.println("AbsoluteName=" + sessionName.getAbsoluteName() + " RelativeName=" + sessionName.getRelativeName());
            Assert.assertEquals("", "client/jack/-4", sessionName.getAbsoluteName());
            Assert.assertEquals("", null, sessionName.getNodeIdStr());
            Assert.assertEquals("", "client/jack/-4", sessionName.getRelativeName());
            Assert.assertEquals("", "jack", sessionName.getLoginName());
            Assert.assertEquals("", -4L, sessionName.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            tmp = new SessionName(this.glob, new NodeId("avalon"), "client/jack");
            sessionName = new SessionName(this.glob, tmp, -4L);
            System.out.println("AbsoluteName=" + sessionName.getAbsoluteName() + " RelativeName=" + sessionName.getRelativeName());
            Assert.assertEquals("Expected /node/avalon/client/jack/-4 but was:" + sessionName.getAbsoluteName(), "/node/avalon/client/jack/-4", sessionName.getAbsoluteName());
            Assert.assertEquals("", "avalon", sessionName.getNodeId().getId());
            Assert.assertEquals("", "client/jack/-4", sessionName.getRelativeName());
            Assert.assertEquals("", "jack", sessionName.getLoginName());
            Assert.assertEquals("", -4L, sessionName.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            tmp = new SessionName(this.glob, new NodeId("/node/avalon"), "client/jack");
            sessionName = new SessionName(this.glob, tmp, -4L);
            System.out.println("AbsoluteName=" + sessionName.getAbsoluteName() + " RelativeName=" + sessionName.getRelativeName());
            Assert.assertEquals("", "/node/avalon/client/jack/-4", sessionName.getAbsoluteName());
            Assert.assertEquals("", "avalon", sessionName.getNodeId().getId());
            Assert.assertEquals("", "client/jack/-4", sessionName.getRelativeName());
            Assert.assertEquals("", "jack", sessionName.getLoginName());
            Assert.assertEquals("", -4L, sessionName.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, new NodeId("/node/sauron/client/jack/99"), "/node/heron/client/jack/99");
            System.out.println("AbsoluteName=" + sessionName2.getAbsoluteName() + " RelativeName=" + sessionName2.getRelativeName());
            Assert.assertEquals("", "/node/sauron/client/jack/99", sessionName2.getAbsoluteName());
            Assert.assertEquals("", "sauron", sessionName2.getNodeId().getId());
            Assert.assertEquals("", "client/jack/99", sessionName2.getRelativeName());
            Assert.assertEquals("", "jack", sessionName2.getLoginName());
            Assert.assertEquals("", 99L, sessionName2.getPublicSessionId());
        }
        catch (IllegalArgumentException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            tmp = new SessionName(this.glob, new NodeId("/avalon"), "client/jack");
            Assert.fail("testParse failed, nodeId is invalid.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, null);
            Assert.fail("testParse failed, null should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "");
            Assert.fail("testParse failed, \"\" should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "/");
            Assert.fail("testParse failed, \"/\" should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "//////");
            Assert.fail("testParse failed, \"//////\" should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "/node//joe/2");
            Assert.fail("testParse failed, \"/node//joe/2\" should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        try {
            sessionName2 = new SessionName(this.glob, "/node//client/joe/2");
            Assert.fail("testParse failed, \"/node//client/joe/2\" should throw an exception.");
        }
        catch (IllegalArgumentException e) {
            System.out.println("SUCCESS: " + e.toString());
        }
        System.out.println("***SessionNameTest: testParse [SUCCESS]");
    }

    public static void main(String[] args) {
        SessionNameTest testSub = new SessionNameTest("SessionNameTest");
        testSub.setUp();
        testSub.testParse();
    }
}

