/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.protocol.socket.SocketUrl;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Address;

public class SocketUrlTest
extends TestCase {
    private String ME = "SocketUrlTest";
    protected Global glob;
    protected LogChannel log;

    public SocketUrlTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = new Global();
        this.log = this.glob.getLog(null);
    }

    protected void tearDown() {
    }

    public void testBasic() {
        try {
            String hostname = null;
            int port = -1;
            SocketUrl s = new SocketUrl(this.glob, hostname, port);
            Assert.assertEquals("", this.glob.getLocalIP(), s.getHostname());
            Assert.assertEquals("", port, s.getPort());
            Assert.assertEquals("", "socket://" + this.glob.getLocalIP() + ":" + port, s.getUrl());
            this.log.info(this.ME, "SUCCESS testBasic(): hostname=" + hostname + " port=" + port + " resultUrl=" + s.getUrl());
            hostname = "127.1.5.4";
            port = 9999;
            s = new SocketUrl(this.glob, hostname, port);
            Assert.assertEquals("", hostname, s.getHostname());
            Assert.assertEquals("", port, s.getPort());
            Assert.assertEquals("", "socket://" + hostname + ":" + port, s.getUrl());
            this.log.info(this.ME, "SUCCESS testBasic(): hostname=" + hostname + " port=" + port + " resultUrl=" + s.getUrl());
            SocketUrl s2 = new SocketUrl(this.glob, "192.1.1.5:911");
            SocketUrl other = new SocketUrl(this.glob, "192.1.1.5", 911);
            Assert.assertTrue("", s2.equals(other));
            this.log.info(this.ME, "SUCCESS testBasic(): equals=true");
            s2 = new SocketUrl(this.glob, "192.1.1.5");
            other = new SocketUrl(this.glob, "192.1.1.5", 7607);
            Assert.assertTrue("", s2.equals(other));
            this.log.info(this.ME, "SUCCESS testBasic(): equals=true");
            s2 = new SocketUrl(this.glob, "192.1.1.5:900");
            other = new SocketUrl(this.glob, "192.1.1.5", 911);
            Assert.assertTrue("", !s2.equals(other));
            this.log.info(this.ME, "SUCCESS testBasic(): equals=false");
            s2 = new SocketUrl(this.glob, "192.1.1.5:911");
            other = new SocketUrl(this.glob, "192.1.77.5", 911);
            Assert.assertTrue("", !s2.equals(other));
            this.log.info(this.ME, "SUCCESS testBasic(): equals=false");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "ERROR: " + e.toString());
            Assert.fail(e.toString());
        }
        this.log.info(this.ME, "SUCCESS testBasic()");
    }

    public void testAddress() {
        try {
            String hostname = "168.2.2.2";
            int port = 8888;
            String type = "socket";
            String[] args = new String[]{"-plugin/" + type + "/hostname", hostname, "-plugin/" + type + "/port", "" + port};
            this.glob.init(args);
            Address address = new Address(this.glob, type);
            SocketUrl s = new SocketUrl(this.glob, address);
            Assert.assertEquals("", hostname, s.getHostname());
            Assert.assertEquals("", port, s.getPort());
            Assert.assertEquals("", "socket://" + hostname + ":" + port, s.getUrl());
            this.log.info(this.ME, "SUCCESS testAddress(): resultUrl=" + s.getUrl());
            hostname = "168.99.55.2";
            port = 6666;
            Address address2 = new Address(this.glob);
            address2.setPluginProperty("hostname", hostname);
            address2.setPluginProperty("port", "" + port);
            SocketUrl s2 = new SocketUrl(this.glob, address2);
            Assert.assertEquals("", hostname, s2.getHostname());
            Assert.assertEquals("", port, s2.getPort());
            Assert.assertEquals("", "socket://" + hostname + ":" + port, s2.getUrl());
            this.log.info(this.ME, "SUCCESS testAddress(): resultUrl=" + s2.getUrl());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "ERROR: " + e.toString());
            Assert.fail(e.toString());
        }
        this.log.info(this.ME, "SUCCESS testAddress()");
    }

    public void testParseUrl() {
        try {
            SocketUrl s;
            String url;
            try {
                url = null;
                s = new SocketUrl(this.glob, url);
                Assert.fail("Null url is not allowed");
            }
            catch (XmlBlasterException e) {
                this.log.info(this.ME, "SUCCESS testParseUrl(): expected exception: " + e.toString());
            }
            url = "";
            s = new SocketUrl(this.glob, url);
            Assert.assertEquals("", this.glob.getLocalIP(), s.getHostname());
            Assert.assertEquals("", 7607, s.getPort());
            Assert.assertEquals("", "socket://" + this.glob.getLocalIP() + ":" + 7607, s.getUrl());
            this.log.info(this.ME, "SUCCESS testParseUrl(): url=" + url + " resultUrl=" + s.getUrl());
            url = "127.1.1.1";
            s = new SocketUrl(this.glob, url);
            Assert.assertEquals("", url, s.getHostname());
            Assert.assertEquals("", 7607, s.getPort());
            Assert.assertEquals("", "socket://" + url + ":" + 7607, s.getUrl());
            this.log.info(this.ME, "SUCCESS testParseUrl(): url=" + url + " resultUrl=" + s.getUrl());
            url = "127.1.1.1:8080";
            s = new SocketUrl(this.glob, url);
            Assert.assertEquals("", "127.1.1.1", s.getHostname());
            Assert.assertEquals("", 8080, s.getPort());
            Assert.assertEquals("", "socket://" + url, s.getUrl());
            this.log.info(this.ME, "SUCCESS testParseUrl(): url=" + url + " resultUrl=" + s.getUrl());
            url = "socket:127.1.1.1:8080";
            s = new SocketUrl(this.glob, url);
            Assert.assertEquals("", "127.1.1.1", s.getHostname());
            Assert.assertEquals("", 8080, s.getPort());
            Assert.assertEquals("", "socket://127.1.1.1:8080", s.getUrl());
            this.log.info(this.ME, "SUCCESS testParseUrl(): url=" + url + " resultUrl=" + s.getUrl());
            url = "socket://127.1.1.1:8080";
            s = new SocketUrl(this.glob, url);
            Assert.assertEquals("", "127.1.1.1", s.getHostname());
            Assert.assertEquals("", 8080, s.getPort());
            Assert.assertEquals("", url, s.getUrl());
            this.log.info(this.ME, "SUCCESS testParseUrl(): url=" + url + " resultUrl=" + s.getUrl());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "ERROR: " + e.toString());
            Assert.fail(e.toString());
        }
        this.log.info(this.ME, "SUCCESS testParseUrl()");
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("******* SocketUrlTest: Init failed");
        }
        SocketUrlTest testSub = new SocketUrlTest("SocketUrlTest");
        testSub.setUp();
        testSub.testBasic();
        testSub.testAddress();
        testSub.testParseUrl();
        testSub.tearDown();
    }
}

