/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.StringPairTokenizer;
import org.xmlBlaster.util.qos.ClientProperty;

public class StringPairTokenizerTest
extends TestCase {
    static final String ME = "StringPairTokenizerTest";
    protected Global glob = Global.instance();
    protected LogChannel log;
    int counter = 0;

    public StringPairTokenizerTest(String name, String[] args) {
        super(name);
        this.glob.init(args);
        this.log = this.glob.getLog("test");
    }

    public StringPairTokenizerTest(String name) {
        super(name);
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testClientProperties() {
        try {
            int maxEntries = 0;
            long maxSize = 0L;
            boolean consumable = false;
            long waitingDelay = 4000L;
            String cmd = "maxEntries=4&maxSize=-1&consumable=true&waitingDelay=1000";
            Map props = StringPairTokenizer.parseToStringClientPropertyPairs(this.glob, cmd, "&", "=");
            ClientProperty prop = (ClientProperty)props.get("maxEntries");
            Assert.assertNotNull("property should not be null", prop);
            maxEntries = prop.getIntValue();
            Assert.assertEquals("maxEntries", 4, maxEntries);
            prop = (ClientProperty)props.get("maxSize");
            Assert.assertNotNull("property should not be null", prop);
            maxSize = prop.getLongValue();
            Assert.assertEquals("maxSize", -1L, maxSize);
            prop = (ClientProperty)props.get("consumable");
            Assert.assertNotNull("property should not be null", prop);
            consumable = prop.getBooleanValue();
            Assert.assertEquals("consumable", true, consumable);
            prop = (ClientProperty)props.get("waitingDelay");
            Assert.assertNotNull("property should not be null", prop);
            waitingDelay = prop.getLongValue();
            Assert.assertEquals("waitingDelay", 1000L, waitingDelay);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.assertTrue("an exception should not occur here", false);
        }
    }

    public static void main(String[] args) {
        StringPairTokenizerTest test = new StringPairTokenizerTest(ME, args);
        test.setUp();
        test.testClientProperties();
        test.tearDown();
    }
}

