/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.runtime.Sleeper;
import org.xmlBlaster.test.classtest.TestPoolManager;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.pool.I_PoolManager;
import org.xmlBlaster.util.pool.PoolManager;
import org.xmlBlaster.util.pool.ResourceWrapper;

public class TestPoolManager
extends TestCase {
    private final String ME = "TestPoolManager";

    public TestPoolManager(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testWithGeneratedInstanceIdAndBusyTimeout() {
        System.out.println("\n\n=========================\nStarting TEST 1 ...");
        TestPool testPool = new TestPool(3, 2000L, 0L);
        TestResource r0 = testPool.reserve();
        TestResource r1 = testPool.reserve("r");
        TestResource r2 = testPool.reserve();
        testPool.reserve();
        if (testPool.poolManager.getNumBusy() != 3 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 1.1 FAILED: Wrong number of busy/idle resources");
        }
        testPool.release(r0);
        if (testPool.poolManager.getNumBusy() != 2 || testPool.poolManager.getNumIdle() != 1) {
            Assert.fail("TEST 1.2 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve();
        testPool.release(r2);
        System.out.println(testPool.poolManager.toXml());
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 3) {
            Assert.fail("TEST 1.3 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve();
        if (testPool.poolManager.getNumBusy() != 1 || testPool.poolManager.getNumIdle() != 2) {
            Assert.fail("TEST 1.4 FAILED: Wrong number of busy/idle resources");
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
    }

    public void testWithSuppliedInstanceIdAndBusyTimeout() {
        System.out.println("\n\n=========================\nStarting TEST 2 ...");
        TestPool testPool = new TestPool(3, 2000L, 0L);
        TestResource r0 = testPool.reserve("ID-0");
        TestResource r1 = testPool.reserve("ID-1");
        TestResource r2 = testPool.reserve("ID-2");
        r2 = testPool.reserve("ID-2");
        r2 = testPool.reserve("ID-2");
        r2 = testPool.reserve("ID-2");
        if (testPool.poolManager.getNumBusy() != 3 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 2.1 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve("ID-3");
        testPool.release(r0);
        if (testPool.poolManager.getNumBusy() != 2 || testPool.poolManager.getNumIdle() != 1) {
            Assert.fail("TEST 2.2 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve("ID-4");
        testPool.release(r2);
        System.out.println(testPool.poolManager.toXml());
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 3) {
            Assert.fail("TEST 2.3 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve("ID-5");
        if (testPool.poolManager.getNumBusy() != 1 || testPool.poolManager.getNumIdle() != 2) {
            Assert.fail("TEST 2.4 FAILED: Wrong number of busy/idle resources");
        }
        testPool.poolManager.destroy();
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 2.5 FAILED: Wrong number of busy/idle resources");
        }
        testPool.reserve("ID-6");
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 1 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 2.6 FAILED: Wrong number of busy/idle resources");
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
    }

    public void testWithSuppliedInstanceIdBusyTimeoutAndEraseTimeout() {
        System.out.println("\n\n=========================\nStarting TEST 3 ...");
        TestPool testPool = new TestPool(3, 2000L, 3000L);
        TestResource r0 = testPool.reserve("ID-0");
        TestResource r1 = testPool.reserve("ID-1");
        TestResource r2 = testPool.reserve("ID-2");
        testPool.poolManager.erase("ID-2");
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 2 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 3.1 FAILED: Wrong number of busy/idle resources");
        }
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        testPool.poolManager.erase("ID-1");
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 1) {
            Assert.fail("TEST 3.2 FAILED: Wrong number of busy/idle resources");
        }
        try {
            Thread.currentThread();
            Thread.sleep(4000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 3.3 FAILED: Wrong number of busy/idle resources");
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        System.out.println(testPool.poolManager.toXml());
    }

    public void testMultiThreaded() {
        System.out.println("\n\n=========================\nStarting TEST 4 ...");
        int numThreads = 6;
        long busyToIdle = 5000L;
        long idleToErase = 4000L;
        TestPool testPool = new TestPool(60, busyToIdle, idleToErase);
        int jj = 0;
        while (jj < 2) {
            System.out.println("\n run # " + jj);
            int ii = 0;
            while (ii < numThreads) {
                String name = "TestThread-" + ii;
                class Test
                extends Thread {
                    String ME;
                    TestPool testPool;
                    private final /* synthetic */ TestPoolManager this$0;

                    Test(TestPoolManager this$0, String name, TestPool testPool) {
                        this.this$0 = this$0;
                        this.ME = "TestThread";
                        this.ME = name;
                        this.testPool = testPool;
                    }

                    public void run() {
                        try {
                            System.out.println("\n\nStarted " + this.ME + " ...");
                            TestResource r0 = this.testPool.reserve("o");
                            TestResource r1 = this.testPool.reserve("o");
                            TestResource r2 = this.testPool.reserve("o");
                            TestResource r3 = this.testPool.reserve("o");
                            TestResource r4 = this.testPool.reserve("o");
                            Sleeper.sleep(20L);
                            this.testPool.poolManager.isBusy("unknown");
                            this.testPool.poolManager.isBusy("TestResource-1");
                            this.testPool.poolManager.busyRefresh("TestResource-1");
                            this.testPool.poolManager.busyRefresh("TestResource-1");
                            this.testPool.poolManager.busyRefresh("TestResource-1");
                            this.testPool.poolManager.getNumBusy();
                            this.testPool.poolManager.getNumIdle();
                            this.testPool.poolManager.getState();
                            this.testPool.poolManager.toXml();
                            this.testPool.poolManager.erase("" + r2);
                            r2 = this.testPool.reserve();
                            this.testPool.release(r2);
                            r2 = this.testPool.reserve();
                            this.testPool.release(r2);
                            this.testPool.release(r3);
                            System.out.println("\n\nFinished " + this.ME + " ...");
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                            Assert.fail("\n++++++++++++++++++++++++\nTEST 4.1 FAILED: " + e.toString());
                        }
                    }
                }
                Test p = new Test(this, name, testPool);
                p.setDaemon(true);
                p.start();
                ++ii;
            }
            Sleeper.sleep(2000L);
            if (testPool.poolManager.getNumBusy() != 3 * numThreads) {
                Assert.fail("TEST 4.2 FAILED: Wrong number " + testPool.poolManager.getNumBusy() + " of busy resources");
            }
            if (jj == 0) {
                Sleeper.sleep(4000L);
            }
            ++jj;
        }
        Sleeper.sleep(1000L);
        testPool.poolManager.destroy();
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 4.3 FAILED: Wrong number of busy/idle resources");
        }
    }

    public void testDestroy() {
        System.out.println("\n\n=========================\nStarting TEST 5 ...");
        TestPool testPool = new TestPool(10, 2000L, 3000L);
        TestResource r0 = testPool.reserve("h");
        TestResource r1 = testPool.reserve("r");
        TestResource r2 = testPool.reserve("h");
        TestResource r3 = testPool.reserve("o");
        TestResource r4 = testPool.reserve();
        testPool.release(r2);
        r2 = testPool.reserve();
        testPool.release(r2);
        testPool.release(r3);
        System.out.println(testPool.poolManager.toXml());
        testPool.poolManager.destroy();
        System.out.println(testPool.poolManager.toXml());
        if (testPool.poolManager.getNumBusy() != 0 || testPool.poolManager.getNumIdle() != 0) {
            Assert.fail("TEST 5.1 FAILED: Wrong number of busy/idle resources");
        }
    }

    class TestPool
    implements I_PoolManager {
        private int counter = 0;
        PoolManager poolManager;

        TestPool(int maxInstances, long busyToIdle, long idleToErase) {
            this.poolManager = new PoolManager("TestPoolManager", this, maxInstances, busyToIdle, idleToErase);
        }

        public void idleToBusy(Object resource) {
            TestResource rr = (TestResource)resource;
            System.out.println("Entering idleToBusy(" + rr.name + ") ...");
            rr.isBusy = true;
        }

        public void busyToIdle(Object resource) {
            TestResource rr = (TestResource)resource;
            System.out.println("Entering busyToIdle(" + rr.name + ") ...");
            rr.isBusy = false;
        }

        public Object toCreate(String instanceId) throws XmlBlasterException {
            TestResource rr = new TestResource("TestResource-" + this.counter++, instanceId, true);
            System.out.println("Entering toCreate(instanceId='" + instanceId + "', " + rr.name + ") ...");
            return rr;
        }

        public void toErased(Object resource) {
            TestResource rr = (TestResource)resource;
            System.out.println("Entering toErased(" + rr.name + ") ...");
            rr.isErased = true;
        }

        TestResource reserve() {
            return this.reserve("r");
        }

        TestResource reserve(String instanceId) {
            System.out.println("Entering reserve(" + instanceId + ") ...");
            try {
                TestPool testPool = this;
                synchronized (testPool) {
                    ResourceWrapper rw = this.poolManager.reserve(instanceId);
                    TestResource rr = (TestResource)rw.getResource();
                    if (rr == null) {
                        Assert.fail("*****ERROR:rr==null");
                    }
                    rr.instanceId = rw.getInstanceId();
                    TestResource testResource = rr;
                    return testResource;
                }
            }
            catch (XmlBlasterException e) {
                System.err.println("*****WARNING:Caught exception in reserve(): " + e.getMessage());
                return null;
            }
        }

        void release(TestResource rr) {
            System.out.println("Entering release() ...");
            try {
                TestPool testPool = this;
                synchronized (testPool) {
                    this.poolManager.release(rr.instanceId);
                }
            }
            catch (XmlBlasterException e) {
                System.err.println("*****WARNING:Caught exception in release(): " + e.getMessage());
            }
        }
    }

    class TestResource {
        String name;
        String instanceId;
        boolean isBusy;
        boolean isErased = false;

        public TestResource(String name, String instanceId, boolean isBusy) {
            this.name = name;
            this.instanceId = instanceId;
            this.isBusy = isBusy;
        }

        public String toString() {
            return this.name;
        }
    }
}

