/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.test.classtest.TimeoutTest;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;

public class TimeoutTest
extends TestCase {
    private String ME = "TimeoutTest";
    private LogChannel log = Global.instance().getLog(null);
    private boolean event = false;
    private int counter = 0;

    public TimeoutTest(String name) {
        super(name);
    }

    public void testTimeout() {
        System.out.println("***TimeoutTest: testTimeout ...");
        this.event = false;
        Timeout timeout = new Timeout(this.ME);
        Timestamp timeoutHandle = timeout.addTimeoutListener(new I_Timeout(){

            public void timeout(Object userData) {
                TimeoutTest.this.event = true;
                TimeoutTest.this.log.info(TimeoutTest.this.ME, "Timeout happened after 0 millisec");
            }
        }, 0L, null);
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals("Timeout not occurred after 0 msec.", true, this.event);
        this.event = false;
        timeout = new Timeout(this.ME);
        timeoutHandle = timeout.addTimeoutListener(new I_Timeout(){

            public void timeout(Object userData) {
                TimeoutTest.this.event = true;
                TimeoutTest.this.log.info(TimeoutTest.this.ME, "Timeout happened after 500 millisec");
            }
        }, 500L, null);
        try {
            Thread.currentThread();
            Thread.sleep(800L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals("Timeout not occurred after 1 sec.", true, this.event);
        this.event = false;
        timeout = new Timeout(this.ME);
        timeoutHandle = timeout.addTimeoutListener(new I_Timeout(){

            public void timeout(Object userData) {
                TimeoutTest.this.event = true;
                TimeoutTest.this.log.error(TimeoutTest.this.ME, "Timeout happened after 1 sec");
            }
        }, 1000L, null);
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Assert.assertEquals("Timeout occurred unexpected", false, this.event);
        timeout.removeTimeoutListener(timeoutHandle);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("Timeout occurred unexpected", false, this.event);
        System.out.println("***TimeoutTest: testTimeout [SUCCESS]");
    }

    public void testFunctionality() {
        System.out.println("***TimeoutTest: testFunctionality ...");
        Timeout timeout = new Timeout();
        this.counter = 0;
        timeout.removeTimeoutListener(null);
        timeout.removeTimeoutListener(new Timestamp(12L));
        Timestamp[] keyArr = new Timestamp[4];
        class Dummy1
        implements I_Timeout {
            private String ME;
            private final /* synthetic */ Timestamp[] val$keyArr;
            private final /* synthetic */ TimeoutTest this$0;

            Dummy1(TimeoutTest this$0, Timestamp[] val$keyArr) {
                this.this$0 = this$0;
                this.val$keyArr = val$keyArr;
                this.ME = "Dummy1";
            }

            public void timeout(Object userData) {
                long time = System.currentTimeMillis();
                long diff = time - this.val$keyArr[TimeoutTest.access$300(this.this$0)].getMillis();
                if (Math.abs(diff) < 40L) {
                    TimeoutTest.access$200(this.this$0).info(this.ME, "Timeout occurred for " + userData.toString() + " at " + time + " millis, real time failure=" + diff + " millis.");
                } else {
                    System.err.println("*****ERROR: Wrong timeout occurred for " + userData.toString() + " at " + time + " millis, scheduled was " + this.val$keyArr[TimeoutTest.access$300(this.this$0)] + " , real time failure=" + diff + " millis.");
                    Assert.fail("*****ERROR: Wrong timeout occurred for " + userData.toString() + " at " + time + " millis, scheduled was " + this.val$keyArr[TimeoutTest.access$300(this.this$0)] + " , real time failure=" + diff + " millis.");
                }
                TimeoutTest.access$308(this.this$0);
            }
        }
        Dummy1 dummy = new Dummy1(this, keyArr);
        keyArr[2] = timeout.addTimeoutListener(dummy, 4000L, "timer-4000");
        keyArr[3] = timeout.addTimeoutListener(dummy, 2000L, "timer-5500");
        try {
            keyArr[3] = timeout.refreshTimeoutListener(keyArr[3], 5500L);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Refresh failed: " + e.getMessage());
        }
        long diffT = keyArr[3].getMillis() - System.currentTimeMillis();
        Assert.assertTrue("ERROR: refresh failed", Math.abs(5500L - diffT) <= 30L);
        keyArr[0] = timeout.addTimeoutListener(dummy, 1000L, "timer-1000");
        keyArr[1] = timeout.addTimeoutListener(dummy, 1000L, "timer-1000");
        long span = timeout.spanToTimeout(keyArr[2]);
        Assert.assertTrue("*****ERROR: This short span to timeout = " + span + " is probably wrong, or you have a very slow computer.", span >= 3000L);
        Timestamp key = timeout.addTimeoutListener(dummy, 1000L, "timer-1000");
        timeout.removeTimeoutListener(key);
        try {
            key = timeout.refreshTimeoutListener(key, 1500L);
        }
        catch (XmlBlasterException e) {
            this.log.info(this.ME, "Refresh failed which is OK (it is a test): " + e.getMessage());
        }
        Assert.assertEquals("Should not be expired", false, timeout.isExpired(keyArr[2]));
        try {
            Thread.currentThread();
            Thread.sleep(7000L);
        }
        catch (Exception e) {
            Assert.fail("*****ERROR: main interrupt: " + e.toString());
        }
        Assert.assertEquals("Should be expired", true, timeout.isExpired(keyArr[2]));
        System.out.println("***TimeoutTest: testFunctionality [SUCCESS]");
    }

    public void testStressLoad() {
        System.out.println("***TimeoutTest: testStressLoad ...");
        String ME = "Timeout-Tester";
        Timeout timeout = new Timeout();
        int numTimers = 10000;
        timeout.shutdown();
        timeout = new Timeout();
        class Dummy2
        implements I_Timeout {
            private String ME;
            private long start;
            private final /* synthetic */ TimeoutTest this$0;

            Dummy2(TimeoutTest this$0) {
                this.this$0 = this$0;
                this.ME = "Dummy2";
                this.start = 0L;
            }

            public void timeout(Object userData) {
                if (TimeoutTest.access$300(this.this$0) == 0) {
                    this.start = System.currentTimeMillis();
                }
                TimeoutTest.access$308(this.this$0);
                if (TimeoutTest.access$300(this.this$0) == 10000) {
                    long diff = System.currentTimeMillis() - this.start;
                    Assert.assertTrue("Error testing 10000 timers, all updates needed " + diff + " millis", diff < 4000L);
                    TimeoutTest.access$200(this.this$0).info(this.ME, "Success, tested 10000 timers, all updates came in " + diff + " millis");
                }
            }
        }
        Dummy2 dummy2 = new Dummy2(this);
        long start = System.currentTimeMillis();
        int ii = 0;
        while (ii < 10000) {
            timeout.addTimeoutListener(dummy2, 6000L, "timer-" + ii);
            ++ii;
        }
        Assert.assertEquals("Expected 10000 instead of " + timeout.getSize() + " active timers", 10000, timeout.getSize());
        this.log.info(ME, "Feeding of 10000 done, " + (long)(1.0E7 / (double)(System.currentTimeMillis() - start)) + " adds/sec");
        while (this.counter != 10000) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception e) {
                Assert.fail("*****ERROR:main interrupt: " + e.toString());
            }
        }
        System.out.println("***TimeoutTest: testStressLoad [SUCCESS]");
    }

    static /* synthetic */ int access$300(TimeoutTest x0) {
        return x0.counter;
    }

    static /* synthetic */ int access$308(TimeoutTest x0) {
        return x0.counter++;
    }
}

