/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;

public class TimestampTest
extends TestCase {
    private String ME = "TimestampTest";
    private LogChannel log = Global.instance().getLog(null);
    private boolean event = false;
    private int counter = 0;
    int iThread;

    public TimestampTest(String name) {
        super(name);
    }

    public void testTimestamp() {
        Timestamp ts1 = new Timestamp();
        Timestamp ts2 = new Timestamp();
        Assert.assertFalse("Same timestamp", ts1.equals(ts2));
        Assert.assertTrue("timestamp descending", ts2.compareTo(ts1) == 1);
        Assert.assertEquals("string parse", ts2.toString(), Timestamp.valueOf(ts2.toString()).toString());
        System.out.println("***TimestampTest: testTimestamp [SUCCESS]");
    }

    public void testUnique() {
        long last = 0L;
        int n = 10000;
        int i = 0;
        while (i < n) {
            Timestamp ts = new Timestamp();
            Assert.assertTrue("Timestamp not ascending or unique last=" + last + " curr=" + ts.getTimestamp(), ts.getTimestamp() > last);
            last = ts.getTimestamp();
            ++i;
        }
        System.out.println("***TimestampTest: testUnique [SUCCESS]");
    }

    public void testSync() {
        int n = 20;
        int m = 10000;
        final Set set = Collections.synchronizedSet(new HashSet());
        Thread[] threadArr = new Thread[20];
        this.iThread = 0;
        while (this.iThread < 20) {
            threadArr[this.iThread] = new Thread(){

                public void run() {
                    super.setName("" + TimestampTest.this.iThread);
                    long last = 0L;
                    int j = 0;
                    while (j < 10000) {
                        Timestamp ts = new Timestamp();
                        set.add(ts.getTimestampLong());
                        Assert.assertTrue("Timestamp not ascending or unique", ts.getTimestamp() > last);
                        last = ts.getTimestamp();
                        ++j;
                    }
                    System.out.println("Thread #" + super.getName() + " done");
                }
            };
            threadArr[this.iThread].start();
            System.out.println("Started #" + this.iThread);
            ++this.iThread;
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        int i = 0;
        while (i < 20) {
            try {
                threadArr[i].join();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            ++i;
        }
        Assert.assertEquals("Missing timestamps", 200000, set.size());
        System.out.println("***TimestampTest: testSync [SUCCESS]");
    }
}

