/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.protocol.I_CallbackServer;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.Address;

public class XmlBlasterAccessTest
extends TestCase {
    private String ME = "XmlBlasterAccessTest";
    private Global glob;
    private LogChannel log;

    public XmlBlasterAccessTest() {
        this(null, "XmlBlasterAccessTest");
    }

    public XmlBlasterAccessTest(Global glob, String name) {
        super(name);
        this.glob = glob == null ? Global.instance() : glob;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("client");
    }

    public void testCreation() {
        System.out.println("***XmlBlasterAccessTest: testCreation ...");
        I_XmlBlasterAccess xmlBlasterAccess = null;
        int i = 0;
        while (i < 3) {
            if (i == 0) {
                Global nullGlobal = null;
                xmlBlasterAccess = new XmlBlasterAccess(nullGlobal);
            } else if (i == 1) {
                String[] nullArgs = null;
                xmlBlasterAccess = new XmlBlasterAccess(nullArgs);
            } else {
                xmlBlasterAccess = this.glob.getXmlBlasterAccess();
            }
            try {
                ConnectQos connectQos = new ConnectQos(this.glob);
                Address address = new Address(this.glob);
                address.setBootstrapPort(8999);
                address.setRetries(0);
                connectQos.setAddress(address);
                ConnectReturnQos connectReturnQos = xmlBlasterAccess.connect(connectQos, null);
                Assert.fail("Not expected successful connect");
            }
            catch (XmlBlasterException e) {
                if (e.isUser()) {
                    this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                }
                Assert.fail("testDefaultConnectWithoutServer failed: " + e.getMessage());
            }
            if (xmlBlasterAccess.isAlive()) {
                this.log.error(this.ME, "No testing possible when xmlBlaster is running - ignoring this test");
                xmlBlasterAccess.disconnect(null);
            } else {
                Assert.assertTrue("", null != xmlBlasterAccess.getQueue());
                Assert.assertEquals("", false, xmlBlasterAccess.isAlive());
                Assert.assertEquals("", false, xmlBlasterAccess.isPolling());
                Assert.assertEquals("", false, xmlBlasterAccess.isDead());
                this.log.info(this.ME, "SUCCESS: Check I_ConnectionHandler");
                Assert.assertEquals("", false, xmlBlasterAccess.isConnected());
                xmlBlasterAccess.registerConnectionListener(null);
                Assert.assertTrue("", xmlBlasterAccess.getCbServer() == null);
                try {
                    I_CallbackServer cbServer = xmlBlasterAccess.initCbServer(null, null);
                    Assert.assertTrue("", cbServer != null);
                    Assert.assertTrue("", cbServer.getCbProtocol() != null);
                    Assert.assertTrue("", cbServer.getCbAddress() != null);
                    this.log.info(this.ME, "SUCCESS: initCbServer protocol=" + cbServer.getCbProtocol() + " address=" + cbServer.getCbAddress());
                    cbServer.shutdown();
                    this.log.info(this.ME, "SUCCESS: CbServer.shutdown()");
                    Assert.assertTrue("", xmlBlasterAccess.getCbServer() == null);
                }
                catch (XmlBlasterException e) {
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                Assert.assertTrue("", xmlBlasterAccess.getSecurityPlugin() != null);
                Assert.assertEquals("", true, xmlBlasterAccess.disconnect(null));
                Assert.assertTrue("", xmlBlasterAccess.getConnectReturnQos() == null);
                Assert.assertTrue("", xmlBlasterAccess.getConnectQos() == null);
                Assert.assertTrue("", xmlBlasterAccess.getId() != null);
                Assert.assertTrue("", xmlBlasterAccess.getSessionName() == null);
                xmlBlasterAccess.setServerNodeId(null);
                Assert.assertTrue("", xmlBlasterAccess.getServerNodeId() == null);
                xmlBlasterAccess.setServerNodeId("FRISH FISH");
                Assert.assertEquals("", "FRISH FISH", xmlBlasterAccess.getServerNodeId());
                try {
                    xmlBlasterAccess.subscribe((SubscribeKey)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.subscribe((String)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.subscribe((SubscribeKey)null, null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.get((String)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.get((GetKey)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.unSubscribe((String)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.unSubscribe((UnSubscribeKey)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.publish(null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.publishOneway(null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.publishArr(null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.erase((String)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                try {
                    xmlBlasterAccess.erase((EraseKey)null, null);
                }
                catch (XmlBlasterException e) {
                    if (e.isUser()) {
                        this.log.info(this.ME, "Exception is OK if not connected: " + e.getErrorCode());
                    }
                    Assert.fail("testCreation failed: " + e.getMessage());
                }
                Assert.assertTrue("", xmlBlasterAccess.getGlobal() != null);
                Assert.assertTrue("", xmlBlasterAccess.toXml() != null);
                this.log.info(this.ME, "SUCCESS: Check I_XmlBlasterAccess");
            }
            ++i;
        }
        System.out.println("***XmlBlasterAccessTest: testCreation [SUCCESS]");
    }

    public void testDefaultConnectWithoutServer() {
        System.out.println("***XmlBlasterAccessTest: testDefaultConnectWithoutServer ...");
        Global nullGlobal = null;
        XmlBlasterAccess xmlBlasterAccess = new XmlBlasterAccess(nullGlobal);
        Assert.assertEquals("", false, xmlBlasterAccess.isConnected());
        ConnectQos q = new ConnectQos(null);
        this.log.info(this.ME, "Default ConnectQos=" + q.toXml() + " retries=" + q.getAddress().getRetries() + " delay=" + q.getAddress().getDelay());
        Assert.assertEquals("", -1, q.getAddress().getRetries());
        Assert.assertEquals("", q.getAddress().getDefaultDelay(), q.getAddress().getDelay());
        Assert.assertTrue("", q.getAddress().getDelay() > 0L);
        this.log.info(this.ME, "TEST MISSING");
        System.out.println("***XmlBlasterAccessTest: testDefaultConnectWithoutServer [SUCCESS]");
    }

    public static void main(String[] args) {
        XmlBlasterAccessTest testSub = new XmlBlasterAccessTest(new Global(args, true, false), "XmlBlasterAccessTest");
        testSub.setUp();
        testSub.testCreation();
        testSub.testDefaultConnectWithoutServer();
    }
}

