/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.JUtilsException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class XmlBlasterExceptionTest
extends TestCase {
    protected Global glob;
    int counter = 0;

    public XmlBlasterExceptionTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
    }

    public void testConstructor() {
        System.out.println("***XmlBlasterExceptionTest: testConstructor ...");
        XmlBlasterException ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, "LOC", "Bla bla");
        Assert.assertEquals("", ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, ex.getErrorCode());
        Assert.assertEquals("", ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES.getErrorCode(), ex.getErrorCodeStr());
        Assert.assertEquals("", this.glob.getId(), ex.getNode());
        Assert.assertEquals("", "LOC", ex.getLocation());
        Assert.assertEquals("", "en", ex.getLang());
        Assert.assertEquals("", "Bla bla", ex.getRawMessage());
        Assert.assertEquals("", null, ex.getEmbeddedException());
        Assert.assertEquals("", "", ex.getEmbeddedMessage());
        Assert.assertEquals("", "<transaction/>", ex.getTransactionInfo());
        Assert.assertEquals("", false, ex.isInternal());
        Assert.assertEquals("", true, ex.isResource());
        Assert.assertEquals("", false, ex.isCommunication());
        Assert.assertEquals("", false, ex.isUser());
        Assert.assertEquals("", false, ex.isTransaction());
        System.out.println("***XmlBlasterExceptionTest: testConstructor [SUCCESS]");
    }

    public void testParse() {
        System.out.println("***XmlBlasterExceptionTest: testParse ...");
        XmlBlasterException ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, "LOC", "Bla bla");
        byte[] serial = ex.toByteArr();
        XmlBlasterException back = XmlBlasterException.parseByteArr(this.glob, serial);
        Assert.assertEquals("", ex.getErrorCode().toString(), back.getErrorCode().toString());
        Assert.assertEquals("", ex.getErrorCodeStr(), back.getErrorCodeStr());
        Assert.assertEquals("", ex.getNode(), back.getNode());
        Assert.assertEquals("", ex.getLocation(), back.getLocation());
        Assert.assertEquals("", ex.getLang(), back.getLang());
        Assert.assertEquals("", ex.getRawMessage(), back.getRawMessage());
        Assert.assertEquals("", ex.getMessage(), back.getMessage());
        Assert.assertEquals("", ex.getVersionInfo(), back.getVersionInfo());
        Assert.assertEquals("", ex.getTimestamp().getTimestamp(), back.getTimestamp().getTimestamp());
        Assert.assertEquals("", ex.getEmbeddedException(), back.getEmbeddedException());
        Assert.assertEquals("", ex.getStackTraceStr(), back.getStackTraceStr());
        Assert.assertEquals("", ex.getEmbeddedMessage(), back.getEmbeddedMessage());
        Assert.assertEquals("", ex.getTransactionInfo(), back.getTransactionInfo());
        Assert.assertEquals("", ex.isInternal(), back.isInternal());
        Assert.assertEquals("", ex.isResource(), back.isResource());
        Assert.assertEquals("", ex.isCommunication(), back.isCommunication());
        Assert.assertEquals("", ex.isUser(), back.isUser());
        Assert.assertEquals("", ex.isTransaction(), back.isTransaction());
        Assert.assertEquals("", ex.toString(), back.toString());
        System.out.println("***XmlBlasterExceptionTest: testParse [SUCCESS]");
    }

    public void testParseToString() {
        System.out.println("***XmlBlasterExceptionTest: testParseToString ...");
        XmlBlasterException ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, "LOC", "Bla bla");
        String serial = ex.toString();
        XmlBlasterException back = XmlBlasterException.parseToString(this.glob, serial);
        System.out.println("ORIGINAL:\n" + ex.toXml());
        System.out.println("BACK:\n" + back.toXml());
        Assert.assertEquals("", ex.getErrorCode().toString(), back.getErrorCode().toString());
        Assert.assertEquals("", ex.getErrorCodeStr(), back.getErrorCodeStr());
        Assert.assertEquals("", ex.isInternal(), back.isInternal());
        Assert.assertEquals("", ex.isResource(), back.isResource());
        Assert.assertEquals("", ex.isCommunication(), back.isCommunication());
        Assert.assertEquals("", ex.isUser(), back.isUser());
        Assert.assertEquals("", ex.isTransaction(), back.isTransaction());
        Assert.assertEquals("", ex.toString(), back.toString());
        System.out.println("***XmlBlasterExceptionTest: testParseToString [SUCCESS]");
    }

    public void testEmbeddedException() {
        System.out.println("***XmlBlasterExceptionTest: testEmbeddedException ...");
        IllegalArgumentException il = new IllegalArgumentException("SUPER");
        XmlBlasterException ex = new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, "HERE", "OK", il);
        byte[] serial = ex.toByteArr();
        XmlBlasterException back = XmlBlasterException.parseByteArr(this.glob, serial);
        System.out.println(back.getStackTraceStr());
        System.out.println(back.toXml());
        Assert.assertEquals("", "HERE", back.getLocation());
        Assert.assertEquals("", "java.lang.IllegalArgumentException: SUPER", back.getEmbeddedMessage());
        Assert.assertEquals("", true, back.isInternal());
        Assert.assertEquals("", false, back.isResource());
        Assert.assertEquals("", false, back.isCommunication());
        Assert.assertEquals("", false, back.isUser());
        Assert.assertEquals("", false, back.isTransaction());
        Assert.assertEquals("", ex.getErrorCode().toString(), back.getErrorCode().toString());
        Assert.assertEquals("", ex.getErrorCodeStr(), back.getErrorCodeStr());
        Assert.assertEquals("", ex.getNode(), back.getNode());
        Assert.assertEquals("", ex.getLocation(), back.getLocation());
        Assert.assertEquals("", ex.getLang(), back.getLang());
        Assert.assertEquals("", ex.getRawMessage(), back.getRawMessage());
        Assert.assertEquals("", ex.getMessage(), back.getMessage());
        Assert.assertEquals("", ex.getVersionInfo(), back.getVersionInfo());
        Assert.assertEquals("", ex.getTimestamp().getTimestamp(), back.getTimestamp().getTimestamp());
        Assert.assertEquals("", il, ex.getEmbeddedException());
        Assert.assertEquals("", null, back.getEmbeddedException());
        Assert.assertEquals("", ex.getStackTraceStr(), back.getStackTraceStr());
        Assert.assertEquals("", ex.getEmbeddedMessage(), back.getEmbeddedMessage());
        Assert.assertEquals("", ex.getTransactionInfo(), back.getTransactionInfo());
        Assert.assertEquals("", ex.isInternal(), back.isInternal());
        Assert.assertEquals("", ex.isResource(), back.isResource());
        Assert.assertEquals("", ex.isCommunication(), back.isCommunication());
        Assert.assertEquals("", ex.isUser(), back.isUser());
        Assert.assertEquals("", ex.isTransaction(), back.isTransaction());
        Assert.assertEquals("", ex.toString(), back.toString());
        System.out.println("***XmlBlasterExceptionTest: testEmbeddedException [SUCCESS]");
    }

    public void testIllegalFormat() {
        System.out.println("***XmlBlasterExceptionTest: testIllegalFormat ...");
        String logFormat = "errorCode=[{0}] node=[{-100}] location=[{2}] message=[{4} : {99}]";
        Global globTmp = this.glob.getClone(null);
        try {
            globTmp.getProperty().set("XmlBlasterException.logFormat", logFormat);
            globTmp.getProperty().set("XmlBlasterException.logFormat.internal", logFormat);
        }
        catch (JUtilsException e) {
            Assert.fail(e.toString());
        }
        IllegalArgumentException il = new IllegalArgumentException("SUPER");
        XmlBlasterException ex = new XmlBlasterException(globTmp, ErrorCode.INTERNAL_UNKNOWN, "HERE", "OK", il);
        ex.setLogFormatInternal(logFormat);
        byte[] serial = ex.toByteArr();
        XmlBlasterException back = XmlBlasterException.parseByteArr(globTmp, serial);
        System.out.println(back.getStackTraceStr());
        System.out.println(back.toXml());
        Assert.assertEquals("", "HERE", back.getLocation());
        Assert.assertEquals("", "java.lang.IllegalArgumentException: SUPER", back.getEmbeddedMessage());
        Assert.assertEquals("", true, back.isInternal());
        Assert.assertEquals("", false, back.isResource());
        Assert.assertEquals("", false, back.isCommunication());
        Assert.assertEquals("", false, back.isUser());
        Assert.assertEquals("", false, back.isTransaction());
        Assert.assertEquals("", ex.getErrorCode().toString(), back.getErrorCode().toString());
        Assert.assertEquals("", ex.getErrorCodeStr(), back.getErrorCodeStr());
        Assert.assertEquals("", ex.getNode(), back.getNode());
        Assert.assertEquals("", ex.getLocation(), back.getLocation());
        Assert.assertEquals("", ex.getLang(), back.getLang());
        Assert.assertEquals("", ex.getRawMessage(), back.getRawMessage());
        Assert.assertEquals("", ex.getMessage(), back.getMessage());
        Assert.assertEquals("", ex.getVersionInfo(), back.getVersionInfo());
        Assert.assertEquals("", ex.getTimestamp().getTimestamp(), back.getTimestamp().getTimestamp());
        Assert.assertEquals("", il, ex.getEmbeddedException());
        Assert.assertEquals("", null, back.getEmbeddedException());
        Assert.assertEquals("", ex.getStackTraceStr(), back.getStackTraceStr());
        Assert.assertEquals("", ex.getEmbeddedMessage(), back.getEmbeddedMessage());
        Assert.assertEquals("", ex.getTransactionInfo(), back.getTransactionInfo());
        Assert.assertEquals("", ex.isInternal(), back.isInternal());
        Assert.assertEquals("", ex.isResource(), back.isResource());
        Assert.assertEquals("", ex.isCommunication(), back.isCommunication());
        Assert.assertEquals("", ex.isUser(), back.isUser());
        Assert.assertEquals("", ex.isTransaction(), back.isTransaction());
        Assert.assertEquals("", ex.toString(), back.toString());
        System.out.println("***XmlBlasterExceptionTest: testIllegalFormat [SUCCESS]");
    }

    public static void main(String[] args) {
        XmlBlasterExceptionTest testSub = new XmlBlasterExceptionTest("XmlBlasterExceptionTest");
        testSub.setUp();
        testSub.testConstructor();
        testSub.testParse();
        testSub.testParseToString();
        testSub.testEmbeddedException();
        testSub.testIllegalFormat();
    }
}

