/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import junit.framework.Assert;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.script.XmlScriptInterpreter;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class XmlScriptInterpreterTest
extends XMLTestCase {
    protected static final String ME = "XmlScriptInterpreterTest";
    protected Global glob;
    protected LogChannel log;
    protected XmlScriptInterpreter interpreter;
    private TestAccessor accessor;
    private ByteArrayOutputStream out;
    private HashMap attachments;

    public XmlScriptInterpreterTest(String name) {
        this(new Global(), name);
    }

    public XmlScriptInterpreterTest(Global global, String name) {
        super(name);
        boolean doRemoteCalls = false;
        this.accessor = new TestAccessor(global, doRemoteCalls);
        this.out = new ByteArrayOutputStream();
        this.attachments = new HashMap();
        String contentRef = "QmxhQmxhQmxh";
        this.attachments.put("attachment1", contentRef);
        this.interpreter = new XmlScriptInterpreter(global, (I_XmlBlasterAccess)this.accessor, this.out, this.out, this.attachments);
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    protected void testConnect() throws Exception {
        String tmp = "<xmlBlaster>\n  <connect>\n      <qos>\n         <securityService type='htpasswd' version='1.0'>\n           <![CDATA[           <user>michele</user>           <passwd>secret</passwd>           ]]>         </securityService>\n         <session name='client/joe/3' timeout='3600000' maxSessions='10'                     clearSessions='false' reconnectSameClientOnly='false'/>\n         <ptp>true</ptp>\n         <duplicateUpdates>false</duplicateUpdates>\n         <queue relating='callback' maxEntries='1000' maxBytes='4000000'>\n            <callback type='IOR' sessionId='4e56890ghdFzj0' pingInterval='10000'\n                retries='-1' delay='10000' oneway='false' dispatchPlugin='undef'>\n               IOR:10000010033200000099000010....\n               <burstMode collectTime='400' />\n               <compress type='gzip' minSize='3000'/>\n               <ptp>true</ptp>\n            </callback>\n         </queue>\n         <!-- a client specific property: here it could be the bean to invoke on updates -->\n         <clientProperty name='onMessageDefault'>beanName</clientProperty>\n      </qos>\n   </connect>\n</xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(tmp.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        this.assertXpathExists("/qos/securityService[@type='htpasswd']", qos);
        this.assertXpathExists("/qos/session", qos);
        this.assertXpathExists("/qos/ptp", qos);
        this.assertXpathExists("/qos/duplicateUpdates", qos);
        this.assertXpathExists("/qos/queue/callback", qos);
        this.assertXpathExists("/qos/clientProperty[@name='onMessageDefault']", qos);
        this.assertXpathExists("/qos/duplicateUpdates", qos);
        this.assertXpathExists("/qos/duplicateUpdates", qos);
    }

    protected void testSubscribe() throws Exception {
        String qosRef = "    <qos>\n      <subscribe id='_subId:1'/>\n      <erase forceDestroy='true'/>\n      <meta>false</meta>\n      <content>false</content>\n      <multiSubscribe>false</multiSubscribe>\n      <local>false</local>\n      <initialUpdate>false</initialUpdate>\n      <notify>false</notify>\n      <filter type='GnuRegexFilter' version='1.0'>^H.*$</filter>\n      <history numEntries='20'/>\n    </qos>\n";
        String keyRef = "    <key oid='' queryType='XPATH'> /xmlBlaster/key[starts-with(@oid,'radar.')] </key>\n";
        String cmd = "<xmlBlaster>\n  <subscribe>\n" + qosRef + keyRef + "  </subscribe>\n" + "</xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        this.log.info(ME, "testSubscribe: qos: '" + qos + "'");
        this.log.info(ME, "testSubscribe: key: '" + key + "'");
        this.assertXMLEqual(qosRef, qos);
        this.assertXMLEqual(keyRef, key);
    }

    protected void testPublish() throws Exception {
        String keyRef = "<key oid='MyMessageOid' contentMime='text/xml'><some><qos type='xxx'><content /></qos><key>xxx</key></some></key>";
        String qosRef = "<qos><priority>HIGH</priority></qos>";
        String contentRef = "<some><content>Hello World</content><qos></qos><key><key><qos><qos></qos></qos></key></key></some>";
        String cmd = "<xmlBlaster id='xxyyzz'><publish>" + keyRef + "<content>" + contentRef + "</content>" + qosRef + "</publish></xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.out.reset();
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        String content = new String(this.accessor.getContent()).trim();
        this.log.info(ME, "testPublish: qos: '" + qos + "' '" + qosRef + "'");
        this.log.info(ME, "testPublish: key: '" + key + "' '" + keyRef + "'");
        this.log.info(ME, "testPublish: content: '" + content + "' and should be '" + contentRef);
        this.assertXMLEqual(keyRef, key);
        this.assertXMLEqual(qosRef, qos);
        Assert.assertEquals(contentRef, content);
        String response = new String(this.out.toByteArray());
        this.log.info(ME, "testPublish: response: '" + response + "'");
        this.assertXpathExists("/xmlBlasterResponse[@id='xxyyzz']", response);
    }

    protected void testPublishArr() throws Exception {
        String keyRef = "<key oid='MyMessageOid' contentMime='text/xml'/>";
        String qosRef = "<qos><priority>HIGH</priority></qos>";
        String contentRef = "QmxhQmxhQmxh";
        String contentShould = "BlaBlaBla";
        String cmd = "<xmlBlaster><publishArr><message>" + keyRef + "<content link='attachment1' encoding='base64'>" + "</content>" + qosRef + "</message></publishArr></xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        String content = new String(this.accessor.getContent()).trim();
        this.log.info(ME, "testPublishArr: qos: '" + qos + "' '" + qosRef + "'");
        this.log.info(ME, "testPublishArr: key: '" + key + "' '" + keyRef + "'");
        this.log.info(ME, "testPublishArr: content: '" + content + "'");
        this.assertXMLEqual(keyRef, key);
        this.assertXMLEqual(qosRef, qos);
        Assert.assertEquals(contentShould, content);
    }

    protected void testDisconnect() throws Exception {
        String qosRef = "<qos><deleteSubjectQueue/><clearSessions>false</clearSessions></qos>";
        String cmd = "<xmlBlaster><disconnect>" + qosRef + "</disconnect></xmlBlaster>";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        this.log.info(ME, "testDisconnect: qos: '" + qos + "' '" + qosRef + "'");
        this.assertXMLEqual(qosRef, qos);
    }

    protected void testUnSubscribe() throws Exception {
        String qosRef = "<qos/>";
        String keyRef = "<key queryType='XPATH'>//key</key>";
        String cmd = "<xmlBlaster>\n  <unSubscribe>\n" + qosRef + keyRef + "  </unSubscribe>\n" + "</xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        this.log.info(ME, "testUnSubscribe: qos: '" + qos + "'");
        this.log.info(ME, "testUnSubscribe: key: '" + key + "'");
        this.assertXMLEqual(qosRef, qos);
        this.assertXMLEqual(keyRef, key);
    }

    protected void testErase() throws Exception {
        String qosRef = "<qos><erase forceDestroy='false'/></qos>";
        String keyRef = "<key oid='MyTopic'/>";
        String cmd = "<xmlBlaster>\n  <erase>\n" + qosRef + keyRef + "  </erase>\n" + "</xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        this.log.info(ME, "testErase: qos: '" + qos + "'");
        this.log.info(ME, "testErase: key: '" + key + "'");
        this.assertXMLEqual(qosRef, qos);
        this.assertXMLEqual(keyRef, key);
    }

    protected void testGet() throws Exception {
        String qosRef = "<qos><content>false</content><filter type='GnuRegexFilter' version='1.0'>^H.*$</filter><history numEntries='20'/></qos>";
        String keyRef = "<key oid='MyMessage' />";
        String cmd = "<xmlBlaster>\n  <get>\n" + qosRef + keyRef + "  </get>\n" + "</xmlBlaster>\n";
        ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
        this.interpreter.parse(new InputStreamReader(in));
        String qos = this.accessor.getQos();
        String key = this.accessor.getKey();
        this.log.info(ME, "testGet: qos: '" + qos + "'");
        this.log.info(ME, "testGet: key: '" + key + "'");
        this.assertXMLEqual(qosRef, qos);
        this.assertXMLEqual(keyRef, key);
    }

    public static void main(String[] args) {
        try {
            Global global = new Global(args);
            XmlScriptInterpreterTest test = new XmlScriptInterpreterTest(global, ME);
            test.setUp();
            test.testConnect();
            test.testSubscribe();
            test.testPublishArr();
            test.testDisconnect();
            test.testGet();
            test.testErase();
            test.testUnSubscribe();
            test.testPublish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public class TestAccessor
    extends XmlBlasterAccess {
        private boolean doRemoteCalls;
        private String key;
        private String qos;
        private byte[] content;

        public TestAccessor(Global global, boolean doRemoteCalls) {
            super(global);
            this.doRemoteCalls = doRemoteCalls;
        }

        public String getQos() {
            return this.qos;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getContent() {
            return this.content;
        }

        public ConnectReturnQos connect(ConnectQos qos, I_Callback callback) throws XmlBlasterException {
            this.qos = qos.toXml();
            if (this.doRemoteCalls) {
                return super.connect(qos, callback);
            }
            return null;
        }

        public SubscribeReturnQos subscribe(String key, String qos) throws XmlBlasterException {
            this.qos = qos;
            this.key = key;
            this.log.trace(XmlScriptInterpreterTest.ME, "subscribe: " + key + " " + qos);
            if (this.doRemoteCalls) {
                return super.subscribe(key, qos);
            }
            return null;
        }

        public UnSubscribeReturnQos[] unSubscribe(String key, String qos) throws XmlBlasterException {
            this.qos = qos;
            this.key = key;
            this.log.trace(XmlScriptInterpreterTest.ME, "unSubscribe: " + key + " " + qos);
            if (this.doRemoteCalls) {
                return super.unSubscribe(key, qos);
            }
            return null;
        }

        public PublishReturnQos publish(MsgUnit msgUnit) throws XmlBlasterException {
            this.qos = msgUnit.getQos();
            this.key = msgUnit.getKey();
            this.content = msgUnit.getContent();
            this.log.trace(XmlScriptInterpreterTest.ME, "publish: " + this.key + " " + this.qos);
            if (this.doRemoteCalls) {
                return super.publish(msgUnit);
            }
            return null;
        }

        public PublishReturnQos[] publishArr(MsgUnit[] msgUnits) throws XmlBlasterException {
            this.qos = msgUnits[0].getQos();
            this.key = msgUnits[0].getKey();
            this.content = msgUnits[0].getContent();
            this.log.trace(XmlScriptInterpreterTest.ME, "publishArr: " + this.key + " " + this.qos);
            if (this.doRemoteCalls) {
                return super.publishArr(msgUnits);
            }
            return null;
        }

        public MsgUnit[] get(String key, String qos) throws XmlBlasterException {
            this.qos = qos;
            this.key = key;
            this.log.trace(XmlScriptInterpreterTest.ME, "get: " + key + " " + qos);
            if (this.doRemoteCalls) {
                return super.get(key, qos);
            }
            return null;
        }

        public EraseReturnQos[] erase(String key, String qos) throws XmlBlasterException {
            this.qos = qos;
            this.key = key;
            this.log.trace(XmlScriptInterpreterTest.ME, "erase: " + key + " " + qos);
            if (this.doRemoteCalls) {
                return super.erase(key, qos);
            }
            return null;
        }

        public boolean disconnect(DisconnectQos qos) {
            this.qos = qos.toXml();
            this.log.trace(XmlScriptInterpreterTest.ME, "disconnect: " + this.key + " " + qos);
            if (this.doRemoteCalls) {
                return super.disconnect(qos);
            }
            return false;
        }
    }
}

