/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.key;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.custommonkey.xmlunit.XMLTestCase;
import org.custommonkey.xmlunit.XMLUnit;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.GetReturnKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.I_MsgKeyFactory;
import org.xmlBlaster.util.key.MsgKeyData;
import org.xmlBlaster.util.key.MsgKeySaxFactory;

public class MsgKeyFactoryTest
extends XMLTestCase {
    private String ME = "MsgKeyFactoryTest";
    protected final Global glob;
    protected final LogChannel log;
    private String currImpl;
    private I_MsgKeyFactory factory;
    static I_MsgKeyFactory[] IMPL = new I_MsgKeyFactory[]{new MsgKeySaxFactory(Global.instance())};

    public MsgKeyFactoryTest(Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.factory = IMPL[currImpl];
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    protected void setUp() {
        this.log.info(this.ME, "Testing parser factory " + this.factory.getName());
    }

    public void testParse() {
        MsgKeyData key;
        String xml;
        System.out.println("***MsgKeyFactoryTest: testParse ...");
        try {
            xml = "<key oid='HELLO' contentMime='image/gif' contentMimeExtended='2.0' domain='RUGBY'>\n   <filter><subtag></subtag></filter>\n</key>\n";
            key = this.factory.readObject(xml);
            Assert.assertEquals("", "HELLO", key.getOid());
            Assert.assertEquals("", "image/gif", key.getContentMime());
            Assert.assertEquals("", "2.0", key.getContentMimeExtended());
            Assert.assertEquals("", "RUGBY", key.getDomain());
            Assert.assertEquals("", "<filter><subtag></subtag></filter>", key.getClientTags());
            Assert.assertEquals("", false, key.isInternal());
            Assert.assertEquals("", false, key.isPluginInternal());
            Assert.assertEquals("", false, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            xml = "<key oid='__HELLO'/>";
            key = this.factory.readObject(xml);
            Assert.assertEquals("", "__HELLO", key.getOid());
            Assert.assertEquals("", true, key.isInternal());
            Assert.assertEquals("", false, key.isPluginInternal());
            Assert.assertEquals("", false, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            xml = "<key oid='_HELLO'/>";
            key = this.factory.readObject(xml);
            Assert.assertEquals("", "_HELLO", key.getOid());
            Assert.assertEquals("", false, key.isInternal());
            Assert.assertEquals("", true, key.isPluginInternal());
            Assert.assertEquals("", false, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            xml = "<key oid='__sys__deadMessage'/>";
            key = this.factory.readObject(xml);
            Assert.assertEquals("", "__sys__deadMessage", key.getOid());
            Assert.assertEquals("", true, key.isInternal());
            Assert.assertEquals("", false, key.isPluginInternal());
            Assert.assertEquals("", true, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        try {
            xml = "<key/>";
            key = this.factory.readObject(xml);
            Assert.assertTrue("", (String)null != key.getOid());
            Assert.assertEquals("", false, key.isInternal());
            Assert.assertEquals("", false, key.isPluginInternal());
            Assert.assertEquals("", false, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: testParse [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***MsgKeyFactoryTest: testDefault ...");
        try {
            MsgKeyData key = this.factory.readObject(null);
            Assert.assertTrue("", (String)null != key.getOid());
            Assert.assertEquals("", null, key.getClientTags());
            Assert.assertEquals("", "text/plain", key.getContentMime());
            Assert.assertEquals("", null, key.getContentMimeExtended());
            Assert.assertEquals("", null, key.getDomain());
            Assert.assertEquals("", false, key.isInternal());
            Assert.assertEquals("", false, key.isPluginInternal());
            Assert.assertEquals("", false, key.isDeadMessage());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: testDefault [SUCCESS]");
    }

    public void testToXml() {
        System.out.println("***MsgKeyFactoryTest: testToXml ...");
        try {
            String xml = "<key oid='HELLO' contentMime='image/gif' contentMimeExtended='1.0' domain='RUGBY'>\n   <filter><subtag></subtag></filter>\n</key>\n";
            MsgKeyData key = this.factory.readObject(xml);
            String newXml = key.toXml();
            this.log.info(this.ME, "New XML=" + newXml);
            key = this.factory.readObject(newXml);
            Assert.assertEquals("", "HELLO", key.getOid());
            Assert.assertEquals("", "image/gif", key.getContentMime());
            Assert.assertEquals("", "1.0", key.getContentMimeExtended());
            Assert.assertEquals("", "RUGBY", key.getDomain());
            Assert.assertEquals("", "<filter><subtag></subtag></filter>", key.getClientTags());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testToXml failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: testToXml [SUCCESS]");
    }

    public void testPublishKey() {
        System.out.println("***MsgKeyFactoryTest: PublishKey ...");
        try {
            String clientTags = "<a><b></b></a><c></c>";
            PublishKey publishKey = new PublishKey(this.glob, "oid");
            publishKey.setDomain("domain");
            publishKey.setClientTags(clientTags);
            publishKey.setContentMime("image/png");
            publishKey.setContentMimeExtended("2");
            System.out.println("PublishKey: " + publishKey.toXml());
            MsgKeyData key = this.factory.readObject(publishKey.toXml());
            Assert.assertEquals("", "oid", key.getOid());
            Assert.assertEquals("", "domain", key.getDomain());
            Assert.assertEquals("Input='" + clientTags + "' output='" + key.getClientTags() + "'", clientTags, key.getClientTags());
            Assert.assertEquals("", "image/png", key.getContentMime());
            Assert.assertEquals("", "2", key.getContentMimeExtended());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: PublishKey [SUCCESS]");
    }

    public void testGetReturnKey() {
        System.out.println("***MsgKeyFactoryTest: GetReturnKey ...");
        try {
            String clientTags = "   <filter><subtag></subtag></filter>\n";
            String xml = "<key oid='HELLO' contentMime='image/png' contentMimeExtended='2.5' domain='RUGBY'>\n" + clientTags + "</key>\n";
            MsgKeyData key = this.factory.readObject(xml);
            GetReturnKey getKey = new GetReturnKey(this.glob, xml);
            System.out.println("GetReturnKey: " + getKey.toXml());
            Assert.assertEquals("", "HELLO", getKey.getOid());
            Assert.assertEquals("", "RUGBY", getKey.getDomain());
            Assert.assertEquals("", "image/png", getKey.getContentMime());
            Assert.assertEquals("", "2.5", getKey.getContentMimeExtended());
            Assert.assertEquals("Input='" + clientTags + "' output='" + key.getClientTags() + "'", clientTags.trim(), getKey.getClientTags());
            Assert.assertEquals("", false, getKey.isInternal());
            Assert.assertEquals("", false, getKey.isPluginInternal());
            Assert.assertEquals("", false, getKey.isDeadMessage());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: GetReturnKey [SUCCESS]");
    }

    public void testUpdateKey() {
        System.out.println("***MsgKeyFactoryTest: UpdateKey ...");
        try {
            String clientTags = "   <filter><subtag></subtag></filter>\n";
            String xml = "<key oid='HELLO' contentMime='image/png' contentMimeExtended='2.5' domain='RUGBY'>\n" + clientTags + "</key>\n";
            MsgKeyData key = this.factory.readObject(xml);
            UpdateKey updateKey = new UpdateKey(this.glob, xml);
            System.out.println("UpdateKey: " + updateKey.toXml());
            Assert.assertEquals("", "HELLO", updateKey.getOid());
            Assert.assertEquals("", "RUGBY", updateKey.getDomain());
            Assert.assertEquals("", "image/png", updateKey.getContentMime());
            Assert.assertEquals("", "2.5", updateKey.getContentMimeExtended());
            Assert.assertEquals("Input='" + clientTags + "' output='" + key.getClientTags() + "'", clientTags.trim(), updateKey.getClientTags());
            Assert.assertEquals("", false, updateKey.isInternal());
            Assert.assertEquals("", false, updateKey.isPluginInternal());
            Assert.assertEquals("", false, updateKey.isDeadMessage());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: UpdateKey [SUCCESS]");
    }

    public void testEmbeddedKeyTag() {
        System.out.println("***MsgKeyFactoryTest: embeddedKeyTag ...");
        try {
            String keyLiteral = "<key oid='oid' ><client><xkey><xqos><xkey>xxx</xkey></xqos></xkey></client></key>";
            MsgKeyData key = this.factory.readObject(keyLiteral);
            this.log.info(this.ME, "testEmbeddedKeyTag: key (should)='" + keyLiteral);
            this.log.info(this.ME, "testEmbeddedKeyTag: key (is)    ='" + key.toXml());
            this.assertXMLEqual(keyLiteral, key.toXml());
            keyLiteral = "<key oid='oid' ><client><key><qos><key>xxx</key></qos></key></client></key>";
            key = this.factory.readObject(keyLiteral);
            this.log.info(this.ME, "testEmbeddedKeyTag: key (should)='" + keyLiteral);
            this.log.info(this.ME, "testEmbeddedKeyTag: key (is)    ='" + key.toXml());
            this.assertXMLEqual(keyLiteral, key.toXml());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***MsgKeyFactoryTest: EmbeddedKeyTag [SUCCESS]");
    }

    protected void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < IMPL.length) {
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testDefault", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testParse", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testToXml", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testPublishKey", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testUpdateKey", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testGetReturnKey", i)));
            suite.addTest((Test)((Object)new MsgKeyFactoryTest(glob, "testEmbeddedKeyTag", i)));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < IMPL.length) {
            MsgKeyFactoryTest testSub = new MsgKeyFactoryTest(glob, "MsgKeyFactoryTest", i);
            testSub.setUp();
            testSub.testDefault();
            testSub.testParse();
            testSub.testToXml();
            testSub.testPublishKey();
            testSub.testUpdateKey();
            testSub.testGetReturnKey();
            testSub.testEmbeddedKeyTag();
            testSub.tearDown();
            ++i;
        }
    }
}

