/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.key;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.key.I_QueryKeyFactory;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.key.QueryKeyData;
import org.xmlBlaster.util.key.QueryKeySaxFactory;
import org.xmlBlaster.util.qos.AccessFilterQos;

public class QueryKeyFactoryTest
extends TestCase {
    private String ME = "QueryKeyFactoryTest";
    protected final Global glob;
    protected final LogChannel log;
    private String currImpl;
    private I_QueryKeyFactory factory;
    static I_QueryKeyFactory[] IMPL = new I_QueryKeyFactory[]{new QueryKeySaxFactory(Global.instance())};

    public QueryKeyFactoryTest(Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.factory = IMPL[currImpl];
    }

    protected void setUp() {
        this.log.info(this.ME, "Testing parser factory " + this.factory.getName());
    }

    public void testParse() {
        System.out.println("***QueryKeyFactoryTest: testParse ...");
        try {
            String xml = "<key oid='HELLO' contentMime='image/gif' contentMimeExtended='1.0' domain='RUGBY' queryType='XPATH'>\n   <filter type='myPlugin' version='1.0'>a!=100</filter>\n   <filter type='anotherPlugin' version='1.1'><![CDATA[b<100|a[0]>10]]></filter>\n   //key\n</key>\n";
            QueryKeyData key = this.factory.readObject(xml);
            Assert.assertEquals("", "HELLO", key.getOid());
            Assert.assertEquals("", "XPATH", key.getQueryType());
            Assert.assertEquals("Got '" + key.getQueryString() + "'", "//key", key.getQueryString().trim());
            Assert.assertEquals("", "image/gif", key.getContentMime());
            Assert.assertEquals("", "1.0", key.getContentMimeExtended());
            Assert.assertEquals("", "RUGBY", key.getDomain());
            AccessFilterQos[] filterArr = key.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "myPlugin", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "a!=100", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "anotherPlugin", filterArr[1].getType());
            Assert.assertEquals("", "1.1", filterArr[1].getVersion());
            Assert.assertEquals("", "b<100|a[0]>10", filterArr[1].getQuery().toString());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: testParse [SUCCESS]");
    }

    public void testCdata() {
        System.out.println("***QueryKeyFactoryTest: testCdata ...");
        try {
            String queryData = "<database:adapter xmlns:database='http://www.xmlBlaster.org/jdbc'><database:url>jdbc:dbfFile:.</database:url><database:username>joe</database:username><database:password>secret</database:password><database:interaction type='update'></database:interaction><database:command><![CDATA[ DROP TABLE IF EXISTS cars < 100 ]]></database:command><database:connectionlifespan ttl='1'></database:connectionlifespan><database:rowlimit max='1'></database:rowlimit><database:confirmation confirm='true'></database:confirmation></database:adapter>";
            String xml = "<key oid='__sys__jdbc'>\n" + queryData + "</key>\n";
            QueryKeyData key = this.factory.readObject(xml);
            Assert.assertEquals("", "__sys__jdbc", key.getOid());
            Assert.assertEquals("queryData expected:\n'" + queryData.trim() + "'\n but is\n'" + key.getQueryString().trim() + "'\n", queryData.trim(), key.getQueryString().trim());
            this.log.info(this.ME, "Parsed and recreated successfully CDATA section:\n" + key.getQueryString().trim() + "");
        }
        catch (XmlBlasterException e) {
            Assert.fail("testCdata failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: testCdata [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***QueryKeyFactoryTest: testDefault ...");
        try {
            QueryKeyData key = this.factory.readObject(null);
            Assert.assertEquals("", null, key.getOid());
            Assert.assertEquals("", "EXACT", key.getQueryType());
            Assert.assertEquals("", null, key.getQueryString());
            Assert.assertEquals("", "text/plain", key.getContentMime());
            Assert.assertEquals("", null, key.getContentMimeExtended());
            Assert.assertEquals("", null, key.getDomain());
            AccessFilterQos[] filterArr = key.getAccessFilterArr();
            Assert.assertTrue("", null == filterArr);
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: testDefault [SUCCESS]");
    }

    public void testToXml() {
        System.out.println("***QueryKeyFactoryTest: testToXml ...");
        try {
            String xml = "<key oid='HELLO' contentMime='image/gif' contentMimeExtended='1.0' domain='RUGBY' queryType='XPATH'>\n   //key\n   <filter type='myPlugin' version='1.0'>a!=100</filter>\n   <filter type='anotherPlugin' version='1.1'><![CDATA[b<100|a[0]>10]]></filter>\n</key>\n";
            QueryKeyData key = this.factory.readObject(xml);
            String newXml = key.toXml();
            this.log.info(this.ME, "New XML=" + newXml);
            key = this.factory.readObject(newXml);
            Assert.assertEquals("", "HELLO", key.getOid());
            Assert.assertEquals("", "XPATH", key.getQueryType());
            Assert.assertEquals("", "//key", key.getQueryString());
            Assert.assertEquals("", "image/gif", key.getContentMime());
            Assert.assertEquals("", "1.0", key.getContentMimeExtended());
            Assert.assertEquals("", "RUGBY", key.getDomain());
            AccessFilterQos[] filterArr = key.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "myPlugin", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "a!=100", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "anotherPlugin", filterArr[1].getType());
            Assert.assertEquals("", "1.1", filterArr[1].getVersion());
            Assert.assertEquals("", "b<100|a[0]>10", filterArr[1].getQuery().toString());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testToXml failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: testToXml [SUCCESS]");
    }

    public void testSubscribeKey() {
        System.out.println("***QueryKeyFactoryTest: SubscribeKey ...");
        try {
            SubscribeKey subscribeKey = new SubscribeKey(this.glob, "oid");
            subscribeKey.setDomain("domain");
            subscribeKey.setQueryString("//query");
            System.out.println("SubscribeKey: " + subscribeKey.toXml());
            QueryKeyData key = this.factory.readObject(subscribeKey.toXml());
            Assert.assertEquals("", "oid", key.getOid());
            Assert.assertEquals("", "domain", key.getDomain());
            Assert.assertEquals("", "//query", key.getQueryString());
            Assert.assertEquals("", "XPATH", key.getQueryType());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: SubscribeKey [SUCCESS]");
    }

    public void testExactSubscribeKey() {
        QueryKeyData key;
        SubscribeKey subscribeKey;
        System.out.println("***QueryKeyFactoryTest: testExactSubscribeKey ...");
        try {
            subscribeKey = new SubscribeKey(this.glob, "myOid", "EXACT");
            Assert.assertEquals("", "myOid", subscribeKey.getOid());
            System.out.println("SubscribeKey: " + subscribeKey.toXml());
            key = this.factory.readObject(subscribeKey.toXml());
            Assert.assertEquals("", "myOid", key.getOid());
            Assert.assertEquals("", "text/plain", key.getContentMime());
            Assert.assertEquals("", KeyData.CONTENTMIMEEXTENDED_DEFAULT, key.getContentMimeExtended());
            Assert.assertEquals("", null, key.getDomain());
            Assert.assertEquals("", "EXACT", key.getQueryType());
            Assert.assertEquals("", null, key.getQueryString());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        try {
            subscribeKey = new SubscribeKey(this.glob, "//myTag", "XPATH");
            subscribeKey.getData().setContentMime("AAA");
            subscribeKey.getData().setContentMimeExtended("BBB");
            subscribeKey.setDomain("CCC");
            Assert.assertEquals("", "myOid", subscribeKey.getOid());
            System.out.println("SubscribeKey: " + subscribeKey.toXml());
            key = this.factory.readObject(subscribeKey.toXml());
            Assert.assertEquals("", null, key.getOid());
            Assert.assertEquals("", "AAA", key.getContentMime());
            Assert.assertEquals("", "BBB", key.getContentMimeExtended());
            Assert.assertEquals("", "CCC", key.getDomain());
            Assert.assertEquals("", "XPATH", key.getQueryType());
            Assert.assertEquals("", "//myTag", key.getQueryString());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***QueryKeyFactoryTest: testExactSubscribeKey [SUCCESS]");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < IMPL.length) {
            suite.addTest(new QueryKeyFactoryTest(glob, "testDefault", i));
            suite.addTest(new QueryKeyFactoryTest(glob, "testParse", i));
            suite.addTest(new QueryKeyFactoryTest(glob, "testCdata", i));
            suite.addTest(new QueryKeyFactoryTest(glob, "testToXml", i));
            suite.addTest(new QueryKeyFactoryTest(glob, "testSubscribeKey", i));
            suite.addTest(new QueryKeyFactoryTest(glob, "testExactSubscribeKey", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        glob.init(args);
        int i = 0;
        while (i < IMPL.length) {
            QueryKeyFactoryTest testSub = new QueryKeyFactoryTest(glob, "QueryKeyFactoryTest", i);
            testSub.setUp();
            testSub.testDefault();
            testSub.testParse();
            testSub.testCdata();
            testSub.testToXml();
            testSub.testSubscribeKey();
            testSub.testExactSubscribeKey();
            ++i;
        }
    }
}

