/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.msgstore;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.msgstore.I_Map;
import org.xmlBlaster.engine.msgstore.I_MapEntry;
import org.xmlBlaster.engine.msgstore.StoragePluginManager;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.StorageId;

public class I_MapTest
extends TestCase {
    private String ME = "I_MapTest";
    protected org.xmlBlaster.engine.Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private final boolean IS_DURABLE = true;
    private final boolean IS_TRANSIENT = false;
    private I_Map currMap;
    private int currImpl;
    static String[] PLUGIN_TYPES = new String[]{new String("RAM"), new String("JDBC"), new String("CACHE")};

    public I_MapTest(String name, int currImpl) {
        super(name);
        this.currImpl = currImpl;
        String[] args = new String[]{"-persistence.persistentQueue", "JDBC,1.0", "-persistence.transientQueue", "RAM,1.0"};
        this.glob = new org.xmlBlaster.engine.Global(args);
        this.log = this.glob.getLog(null);
    }

    protected void setUp() {
        try {
            this.glob.getProperty().set("topic.queue.persistent.tableNamePrefix", "TEST");
            String type = PLUGIN_TYPES[this.currImpl];
            StoragePluginManager pluginManager = this.glob.getStoragePluginManager();
            PluginInfo pluginInfo = new PluginInfo((Global)this.glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
            pluginInfo = new PluginInfo((Global)this.glob, (I_PluginManager)pluginManager, type, "1.0");
            MsgUnitStoreProperty storeProp = new MsgUnitStoreProperty(this.glob, "/node/test");
            StorageId queueId = new StorageId("msgUnitStore", "SomeMapId");
            this.currMap = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)storeProp);
            this.currMap.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'topic.queue.persistent.tableNamePrefix' to 'TEST': " + ex.getMessage());
        }
    }

    private MsgUnit createMsgUnit(boolean persistent) {
        return this.createMsgUnit(persistent, -1L);
    }

    private MsgUnit createMsgUnit(boolean persistent, long contentLen_) {
        try {
            int contentLen = (int)contentLen_;
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos/>");
            publishQosServer.getData().setPersistent(persistent);
            String contentStr = "content";
            if (contentLen >= 0) {
                StringBuffer content = new StringBuffer(contentLen);
                int i = 0;
                while (i < contentLen) {
                    content.append("X");
                    ++i;
                }
                contentStr = content.toString();
            }
            return new MsgUnit((Global)this.glob, "<key oid='Hi'/>", contentStr.getBytes(), publishQosServer.toXml());
        }
        catch (XmlBlasterException ex) {
            Assert.fail("msgUnit not constructed: " + ex.getMessage());
            return null;
        }
    }

    public void testConfig() {
        this.config(this.currMap);
    }

    private void config(I_Map i_map) {
        this.ME = "I_MapTest.config(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        MsgUnitStoreProperty prop1 = null;
        QueuePropertyBase prop = null;
        try {
            prop1 = new MsgUnitStoreProperty(this.glob, "/node/test");
            int max = 12;
            prop1.setMaxEntries(max);
            prop1.setMaxEntriesCache(max);
            Assert.assertEquals(this.ME + ": Wrong capacity", (long)max, prop1.getMaxEntries());
            Assert.assertEquals(this.ME + ": Wrong cache capacity", (long)max, prop1.getMaxEntriesCache());
            StorageId queueId = new StorageId("msgUnitStore", "SomeMapId");
            i_map.initialize(queueId, prop1);
            Assert.assertEquals(this.ME + ": Wrong queue ID", queueId, i_map.getStorageId());
            try {
                prop = new MsgUnitStoreProperty(this.glob, "/node/test");
                prop.setMaxEntries(99L);
                prop.setMaxEntriesCache(99L);
                i_map.setProperties(prop);
            }
            catch (XmlBlasterException e) {
                Assert.fail("Changing properties failed: " + e.getMessage());
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
        long len = prop.getMaxEntries();
        Assert.assertEquals(this.ME + ": Wrong capacity", prop.getMaxEntries(), i_map.getMaxNumOfEntries());
        Assert.assertEquals(this.ME + ": Wrong capacity", prop.getMaxEntries(), ((QueuePropertyBase)i_map.getProperties()).getMaxEntries());
        Assert.assertEquals(this.ME + ": Wrong size", 0L, i_map.getNumOfEntries());
        try {
            int ii = 0;
            while ((long)ii < len) {
                i_map.put(new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()));
                ++ii;
            }
            Assert.assertEquals(this.ME + ": Wrong total size", len, i_map.getNumOfEntries());
            try {
                MsgUnitWrapper queueEntry = new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId());
                i_map.put(queueEntry);
                i_map.put(queueEntry);
                Assert.fail("Did expect an exception on overflow getMaxNumOfEntries=" + i_map.getMaxNumOfEntries() + " size=" + i_map.getNumOfEntries());
            }
            catch (XmlBlasterException e) {
                this.log.info(this.ME, "SUCCESS the exception is OK: " + e.getMessage());
            }
            this.log.info(this.ME, "toXml() test:" + i_map.toXml(""));
            this.log.info(this.ME, "usage() test:" + i_map.usage());
            Assert.assertEquals(this.ME + ": should not be shutdown", false, i_map.isShutdown());
            i_map.shutdown();
            Assert.assertEquals(this.ME + ": should be shutdown", true, i_map.isShutdown());
            this.log.info(this.ME, "#2 Success, filled " + i_map.getNumOfEntries() + " messages into queue");
            System.out.println("***" + this.ME + " [SUCCESS]");
            i_map.shutdown();
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testPutMsg() {
        String queueType = "unknown";
        try {
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            queueType = this.currMap.toString();
            StorageId queueId = new StorageId("msgUnitStore", "MapPlugin/putMsg");
            this.currMap.initialize(queueId, prop);
            this.currMap.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.currMap.getNumOfEntries());
            this.putMsg(this.currMap);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType + ": " + ex.getMessage());
        }
    }

    private void putMsg(I_Map i_map) {
        this.ME = "I_MapTest.putMsg(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            int numLoop = 10;
            ArrayList<MsgUnitWrapper> list = new ArrayList<MsgUnitWrapper>();
            int ii = 0;
            while (ii < numLoop) {
                MsgUnitWrapper[] queueEntries = new MsgUnitWrapper[]{new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId())};
                int i = 0;
                while (i < queueEntries.length) {
                    i_map.put(queueEntries[i]);
                    ++i;
                }
                int i2 = 0;
                while (i2 < 3) {
                    list.add(queueEntries[i2]);
                    ++i2;
                }
                this.checkSizeAndEntries(" put(I_MapEntry[]) ", list, i_map);
                Assert.assertEquals(this.ME + ": Wrong size", (long)((ii + 1) * queueEntries.length), i_map.getNumOfEntries());
                ++ii;
            }
            int total = numLoop * 3;
            Assert.assertEquals(this.ME + ": Wrong total size", (long)total, i_map.getNumOfEntries());
            this.log.info(this.ME, "#1 Success, filled " + i_map.getNumOfEntries() + " messages into queue");
            int ii2 = 0;
            while (ii2 < numLoop) {
                MsgUnitWrapper queueEntry = new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId());
                list.add(queueEntry);
                i_map.put(queueEntry);
                ++ii2;
            }
            Assert.assertEquals(this.ME + ": Wrong total size", (long)(numLoop + total), i_map.getNumOfEntries());
            this.checkSizeAndEntries(" put(I_MapEntry) ", list, i_map);
            this.log.info(this.ME, "#2 Success, filled " + i_map.getNumOfEntries() + " messages into queue");
            i_map.clear();
            this.checkSizeAndEntries("Test 2 put()", new I_MapEntry[0], i_map);
            Assert.assertEquals(this.ME + ": Wrong empty size", 0L, i_map.getNumOfEntries());
            System.out.println("***" + this.ME + " [SUCCESS]");
            i_map.shutdown();
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testByteOverflow() {
        I_Map i_map = this.currMap;
        this.ME = "I_MapTest.testByteOverflow(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            StorageId storageId = new StorageId("msgUnitStore", "ByteOverflowMapId");
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            MsgUnitWrapper mu = new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 0L), storageId);
            long sizeEmpty = mu.getSizeInBytes();
            MsgUnitWrapper[] queueEntries = new MsgUnitWrapper[]{new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 0L), storageId), new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 0L), storageId), new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 0L), storageId), new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 2L * sizeEmpty - 1L), storageId), new MsgUnitWrapper(this.glob, this.createMsgUnit(false, 0L), storageId)};
            long maxBytesCache = 4L * sizeEmpty;
            prop.setMaxBytes(1000000L);
            prop.setMaxBytesCache(maxBytesCache);
            Assert.assertEquals(this.ME + ": Wrong capacity", 1000000L, prop.getMaxBytes());
            Assert.assertEquals(this.ME + ": Wrong cache capacity", maxBytesCache, prop.getMaxBytesCache());
            i_map.initialize(storageId, prop);
            Assert.assertEquals(this.ME + ": Wrong queue ID", storageId, i_map.getStorageId());
            long numOfBytes = 0L;
            int i = 0;
            while (i < queueEntries.length) {
                i_map.put(queueEntries[i]);
                numOfBytes += queueEntries[i].getSizeInBytes();
                ++i;
            }
            Assert.assertEquals(this.ME + ": Wrong size", (long)queueEntries.length, i_map.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong bytes", numOfBytes, i_map.getNumOfBytes());
            System.out.println("***" + this.ME + " [SUCCESS]");
            i_map.clear();
            i_map.shutdown();
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "Exception thrown: " + e.getMessage());
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testGetMsg() {
        String queueType = "unknown";
        try {
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            queueType = this.currMap.toString();
            StorageId queueId = new StorageId("msgUnitStore", "MapPlugin/getMsg");
            this.currMap.initialize(queueId, prop);
            this.currMap.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.currMap.getNumOfEntries());
            this.getMsg(this.currMap);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing getMsg probably due to failed initialization of the queue " + queueType + ": " + ex.getMessage());
        }
    }

    private void getMsg(I_Map i_map) {
        this.ME = "I_MapTest.getMsg(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            MsgUnitWrapper[] queueEntries = new MsgUnitWrapper[]{new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(true), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(true), i_map.getStorageId())};
            int i = 0;
            while (i < queueEntries.length) {
                i_map.put(queueEntries[i]);
                this.log.info(this.ME, "#" + i + " id=" + queueEntries[i].getUniqueId() + " numSizeBytes()=" + queueEntries[i].getSizeInBytes());
                ++i;
            }
            this.log.info(this.ME, "storage bytes sum=" + i_map.getNumOfBytes() + " with persistent bytes=" + i_map.getNumOfPersistentBytes());
            Assert.assertEquals("", 3L, i_map.getNumOfEntries());
            Assert.assertEquals("", 2L, i_map.getNumOfPersistentEntries());
            int ii = 0;
            while (ii < 10) {
                I_MapEntry result = i_map.get(queueEntries[0].getUniqueId());
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[0].getUniqueId(), result.getUniqueId());
                result = i_map.get(queueEntries[1].getUniqueId());
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[1].getUniqueId(), result.getUniqueId());
                result = i_map.get(queueEntries[2].getUniqueId());
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[2].getUniqueId(), result.getUniqueId());
                ++ii;
            }
            Assert.assertEquals("", 3L, i_map.getNumOfEntries());
            Assert.assertEquals("", 2L, i_map.getNumOfPersistentEntries());
            this.log.info(this.ME, "storage before remove [0], bytes sum=" + i_map.getNumOfBytes() + " with persistent bytes=" + i_map.getNumOfPersistentBytes());
            i_map.remove(queueEntries[0]);
            this.log.info(this.ME, "storage after remove [0], bytes sum=" + i_map.getNumOfBytes() + " with persistent bytes=" + i_map.getNumOfPersistentBytes());
            ArrayList<MsgUnitWrapper> list = new ArrayList<MsgUnitWrapper>();
            list.add(queueEntries[1]);
            list.add(queueEntries[2]);
            this.checkSizeAndEntries(" getMsg() ", list, i_map);
            int ii2 = 0;
            while (ii2 < 10) {
                I_MapEntry result = i_map.get(queueEntries[1].getUniqueId());
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[1].getUniqueId(), result.getUniqueId());
                ++ii2;
            }
            i_map.remove(queueEntries[1]);
            Assert.assertEquals("", 1L, i_map.getNumOfEntries());
            Assert.assertEquals("", 1L, i_map.getNumOfPersistentEntries());
            int ii3 = 0;
            while (ii3 < 10) {
                I_MapEntry result = i_map.get(queueEntries[2].getUniqueId());
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[2].getUniqueId(), result.getUniqueId());
                ++ii3;
            }
            i_map.remove(queueEntries[2]);
            int ii4 = 0;
            while (ii4 < 10) {
                I_MapEntry result = i_map.get(queueEntries[0].getUniqueId());
                Assert.assertTrue("Unexpected entry", result == null);
                ++ii4;
            }
            Assert.assertEquals("", 0L, i_map.getNumOfEntries());
            Assert.assertEquals("", 0L, i_map.getNumOfPersistentEntries());
            this.log.info(this.ME, "#1 Success, get()");
            System.out.println("***" + this.ME + " [SUCCESS]");
            i_map.clear();
            i_map.shutdown();
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testGetAllMsgs() {
        String queueType = "unknown";
        try {
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            queueType = this.currMap.toString();
            StorageId queueId = new StorageId("msgUnitStore", "MapPlugin/getAllMsgs");
            this.currMap.initialize(queueId, prop);
            this.currMap.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.currMap.getNumOfEntries());
            this.getAllMsgs(this.currMap);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing getAllMsgs probably due to failed initialization of the queue " + queueType + ": " + ex.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private void getAllMsgs(I_Map i_map) {
        block10: {
            this.ME = "I_MapTest.getAllMsgs(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
            System.out.println("***" + this.ME);
            MsgUnitWrapper[] queueEntries = new MsgUnitWrapper[]{new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(true), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(true), i_map.getStorageId())};
            int i = 0;
            while (i < queueEntries.length) {
                i_map.put(queueEntries[i]);
                this.log.info(this.ME, "#" + i + " id=" + queueEntries[i].getUniqueId() + " numSizeBytes()=" + queueEntries[i].getSizeInBytes());
                ++i;
            }
            this.log.info(this.ME, "storage bytes sum=" + i_map.getNumOfBytes() + " with persistent bytes=" + i_map.getNumOfPersistentBytes());
            Assert.assertEquals("", 3L, i_map.getNumOfEntries());
            Assert.assertEquals("", 2L, i_map.getNumOfPersistentEntries());
            int ii = 0;
            while (ii < 10) {
                I_MapEntry[] results = i_map.getAll();
                Assert.assertEquals("Missing entry", queueEntries.length, results.length);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[0].getUniqueId(), results[0].getUniqueId());
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[1].getUniqueId(), results[1].getUniqueId());
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[2].getUniqueId(), results[2].getUniqueId());
                ++ii;
            }
            Assert.assertEquals("", 3L, i_map.getNumOfEntries());
            Assert.assertEquals("", 2L, i_map.getNumOfPersistentEntries());
            i_map.clear();
            this.log.info(this.ME, "#1 Success, getAll()");
            System.out.println("***" + this.ME + " [SUCCESS]");
            Object var7_7 = null;
            try {
                i_map.clear();
                i_map.shutdown();
            }
            catch (XmlBlasterException e2) {
                e2.printStackTrace();
                Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
            }
            break block10;
            {
                catch (XmlBlasterException e) {
                    e.printStackTrace();
                    Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
                    Object var7_8 = null;
                    try {
                        i_map.clear();
                        i_map.shutdown();
                    }
                    catch (XmlBlasterException e2) {
                        e2.printStackTrace();
                        Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                try {
                    i_map.clear();
                    i_map.shutdown();
                }
                catch (XmlBlasterException e2) {
                    e2.printStackTrace();
                    Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    public void testGetAllSwappedMsgs() {
        String queueType = "unknown";
        try {
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            queueType = this.currMap.toString();
            StorageId queueId = new StorageId("msgUnitStore", "MapPlugin/getAllSwappedMsgs");
            prop.setMaxEntries(10L);
            prop.setMaxEntriesCache(2L);
            this.currMap.initialize(queueId, prop);
            this.currMap.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.currMap.getNumOfEntries());
            this.getAllSwappedMsgs(this.currMap);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing getAllSwappedMsgs probably due to failed initialization of the queue " + queueType + ": " + ex.getMessage());
        }
    }

    /*
     * Loose catch block
     */
    private void getAllSwappedMsgs(I_Map i_map) {
        block11: {
            this.ME = "I_MapTest.getAllSwappedMsgs(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
            System.out.println("***" + this.ME);
            QueuePropertyBase prop = (QueuePropertyBase)i_map.getProperties();
            Assert.assertEquals(this.ME + ": Wrong capacity", 10L, prop.getMaxEntries());
            Assert.assertEquals(this.ME + ": Wrong cache capacity", 2L, prop.getMaxEntriesCache());
            this.log.info(this.ME, "Current settings: " + prop.toXml());
            MsgUnitWrapper[] queueEntries = new MsgUnitWrapper[]{new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId()), new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId())};
            int i = 0;
            while (i < queueEntries.length) {
                i_map.put(queueEntries[i]);
                this.log.info(this.ME, "#" + i + " id=" + queueEntries[i].getUniqueId() + " numSizeBytes()=" + queueEntries[i].getSizeInBytes());
                ++i;
            }
            this.log.info(this.ME, "storage state=" + i_map.toXml(""));
            Assert.assertEquals("", (long)queueEntries.length, i_map.getNumOfEntries());
            int ii = 0;
            while (ii < 10) {
                I_MapEntry[] results = i_map.getAll();
                int jj = 0;
                while (jj < results.length) {
                    this.log.info(this.ME, "#" + jj + ": " + results[jj].getUniqueId());
                    ++jj;
                }
                Assert.assertEquals("Missing entry", queueEntries.length, results.length);
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[0].getUniqueId(), results[0].getUniqueId());
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[1].getUniqueId(), results[1].getUniqueId());
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[2].getUniqueId(), results[2].getUniqueId());
                Assert.assertEquals(this.ME + ": Wrong result", queueEntries[3].getUniqueId(), results[3].getUniqueId());
                ++ii;
            }
            Assert.assertEquals("", 4L, i_map.getNumOfEntries());
            Assert.assertEquals("", 0L, i_map.getNumOfPersistentEntries());
            this.log.info(this.ME, "#1 Success, getAllSwapped()");
            System.out.println("***" + this.ME + " [SUCCESS]");
            Object var9_9 = null;
            try {
                i_map.clear();
                i_map.shutdown();
            }
            catch (XmlBlasterException e2) {
                e2.printStackTrace();
                Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
            }
            break block11;
            {
                catch (XmlBlasterException e) {
                    e.printStackTrace();
                    Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
                    Object var9_10 = null;
                    try {
                        i_map.clear();
                        i_map.shutdown();
                    }
                    catch (XmlBlasterException e2) {
                        e2.printStackTrace();
                        Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    i_map.clear();
                    i_map.shutdown();
                }
                catch (XmlBlasterException e2) {
                    e2.printStackTrace();
                    Assert.fail(this.ME + ": Exception thrown in cleanup: " + e2.getMessage());
                }
                throw throwable;
            }
        }
    }

    public void testPutEntriesTwice() {
        String queueType = "unknown";
        try {
            MsgUnitStoreProperty prop = new MsgUnitStoreProperty(this.glob, "/node/test");
            queueType = this.currMap.toString();
            StorageId queueId = new StorageId("msgUnitStore", "MapPlugin/putEntriesTwice");
            this.currMap.initialize(queueId, prop);
            this.currMap.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.currMap.getNumOfEntries());
            this.putEntriesTwice(this.currMap);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing putEntriesTwice probably due to failed initialization of the queue " + queueType + ": " + ex.getMessage());
        }
    }

    private void putEntriesTwice(I_Map i_map) {
        this.ME = "I_MapTest.putEntriesTwice(" + i_map.getStorageId() + ")[" + i_map.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "putEntriesTwice test 1");
            int imax = 5;
            long size = 0L;
            MsgUnitWrapper[] entries = new MsgUnitWrapper[imax];
            int i = 0;
            while (i < entries.length) {
                entries[i] = new MsgUnitWrapper(this.glob, this.createMsgUnit(false), i_map.getStorageId());
                size += entries[i].getSizeInBytes();
                ++i;
            }
            int i2 = 0;
            while (i2 < entries.length) {
                int numPut = i_map.put(entries[i2]);
                Assert.assertEquals("Putting first entry should be OK", 1, numPut);
                numPut = i_map.put(entries[i2]);
                Assert.assertEquals("Putting entries twices should fail", 0, numPut);
                ++i2;
            }
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries twice", (long)entries.length, i_map.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong size after putting same entries twice", size, i_map.getNumOfBytes());
            i_map.clear();
            Assert.assertEquals(this.ME + ": Wrong num entries after cleaning", i_map.getNumOfEntries(), 0L);
            System.out.println("***" + this.ME + " [SUCCESS]");
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void tearDown() {
        try {
            this.currMap.destroy();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "error when tearing down " + ex.getMessage());
        }
    }

    private void checkSizeAndEntries(String txt, ArrayList queueEntries, I_Map map) {
        this.checkSizeAndEntries(txt, queueEntries.toArray(new I_MapEntry[queueEntries.size()]), map);
    }

    private void checkSizeAndEntries(String txt, I_MapEntry[] queueEntries, I_Map i_map) {
        long sizeOfTransients = 0L;
        long numOfPersistents = 0L;
        long numOfTransients = 0L;
        long sizeOfPersistents = 0L;
        int i = 0;
        while (i < queueEntries.length) {
            I_MapEntry entry = queueEntries[i];
            if (entry.isPersistent()) {
                sizeOfPersistents += entry.getSizeInBytes();
                ++numOfPersistents;
            } else {
                sizeOfTransients += entry.getSizeInBytes();
                ++numOfTransients;
            }
            ++i;
        }
        long queueNumOfPersistents = i_map.getNumOfPersistentEntries();
        long queueNumOfTransients = i_map.getNumOfEntries() - queueNumOfPersistents;
        long queueSizeOfPersistents = i_map.getNumOfPersistentBytes();
        long queueSizeOfTransients = i_map.getNumOfBytes() - queueSizeOfPersistents;
        txt = txt + " getNumOfPersistentEntries=" + queueNumOfPersistents + " NumOfTransients=" + queueNumOfTransients;
        txt = txt + " getNumOfPersistentBytes=" + queueSizeOfPersistents + " SizeOfTransients=" + queueSizeOfTransients;
        Assert.assertEquals(this.ME + ": " + txt + " wrong number of persistents   ", numOfPersistents, queueNumOfPersistents);
        Assert.assertEquals(this.ME + ": " + txt + " wrong number of transients ", numOfTransients, queueNumOfTransients);
        Assert.assertEquals(this.ME + ": " + txt + " wrong size of persistents     ", sizeOfPersistents, queueSizeOfPersistents);
        Assert.assertEquals(this.ME + ": " + txt + " wrong size of transients   ", sizeOfTransients, queueSizeOfTransients);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global();
        suite.addTest(new I_MapTest("testByteOverflow", 2));
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new I_MapTest("testConfig", i));
            suite.addTest(new I_MapTest("testPutMsg", i));
            suite.addTest(new I_MapTest("testGetMsg", i));
            suite.addTest(new I_MapTest("testGetAllMsgs", i));
            suite.addTest(new I_MapTest("testGetAllSwappedMsgs", i));
            suite.addTest(new I_MapTest("testPutEntriesTwice", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global(args);
        I_MapTest testSub = new I_MapTest("I_MapTest", 2);
        long startTime = System.currentTimeMillis();
        testSub.setUp();
        testSub.testByteOverflow();
        testSub.tearDown();
        long usedTime = System.currentTimeMillis() - startTime;
        testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
    }
}

