/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.msgstore;

import java.io.ByteArrayInputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.queue.I_EntryFactory;
import org.xmlBlaster.util.queue.StorageId;

public class MsgUnitWrapperTest
extends TestCase {
    private String ME = "MsgUnitWrapperTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();

    public MsgUnitWrapperTest(String name) {
        super(name);
        this.glob = new Global();
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
    }

    public void testSerialize() {
        this.ME = "MsgUnitWrapperTest.testSerialize()";
        System.out.println("***" + this.ME);
        try {
            PublishKey publishKey = new PublishKey(this.glob, "HA", "text/xy", "1.7");
            Timestamp timestamp = new Timestamp();
            String xml = "<qos>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>7</priority>\n   <expiration lifeTime='2400' remainingLife='12000'/>\n   <rcvTimestamp nanos='" + timestamp.getTimestamp() + "'/>\n" + "   <persistent/>\n" + "   <forceUpdate>false</forceUpdate>\n" + "   <route>\n" + "      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n" + "      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n" + "      <node id='heron' stratum='0' timestamp='9408630564'/>\n" + "   </route>\n" + "   <topic readonly='true'/>\n" + "</qos>\n";
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, xml, true);
            MsgUnit msgUnit = new MsgUnit(publishKey.getData(), "HO".getBytes(), publishQosServer.getData());
            StorageId storageId = new StorageId("mystore", "someid");
            MsgUnitWrapper msgUnitWrapper = new MsgUnitWrapper(this.glob, msgUnit, storageId);
            I_EntryFactory factory = this.glob.getEntryFactory();
            int priority = msgUnitWrapper.getPriority();
            long uniqueId = msgUnitWrapper.getUniqueId();
            String type = msgUnitWrapper.getEmbeddedType();
            boolean persistent = msgUnitWrapper.isPersistent();
            long sizeInBytes = msgUnitWrapper.getSizeInBytes();
            byte[] blob = factory.toBlob(msgUnitWrapper);
            MsgUnitWrapper newWrapper = (MsgUnitWrapper)factory.createEntry(priority, uniqueId, type, persistent, sizeInBytes, new ByteArrayInputStream(blob), storageId);
            Assert.assertEquals("", msgUnitWrapper.getPriority(), newWrapper.getPriority());
            Assert.assertEquals("", msgUnitWrapper.getReferenceCounter(), newWrapper.getReferenceCounter());
            Assert.assertEquals("", msgUnitWrapper.isExpired(), newWrapper.isExpired());
            Assert.assertEquals("", msgUnitWrapper.isPersistent(), newWrapper.isPersistent());
            Assert.assertEquals("", msgUnitWrapper.getMsgUnit().getContentStr(), newWrapper.getMsgUnit().getContentStr());
            Assert.assertEquals("", msgUnitWrapper.getKeyOid(), newWrapper.getKeyOid());
            Assert.assertEquals("", msgUnitWrapper.getContentMime(), newWrapper.getContentMime());
            Assert.assertEquals("", msgUnitWrapper.getContentMimeExtended(), newWrapper.getContentMimeExtended());
            Assert.assertEquals("", msgUnitWrapper.getDomain(), newWrapper.getDomain());
            Assert.assertEquals("", msgUnitWrapper.getSizeInBytes(), newWrapper.getSizeInBytes());
            Assert.assertEquals("", msgUnitWrapper.getUniqueId(), newWrapper.getUniqueId());
            Assert.assertEquals("", msgUnitWrapper.getLogId(), newWrapper.getLogId());
            Assert.assertEquals("", msgUnitWrapper.isInternal(), newWrapper.isInternal());
            Assert.assertEquals("", msgUnitWrapper.getEmbeddedType(), newWrapper.getEmbeddedType());
            MsgQosData qos = newWrapper.getMsgQosData();
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", true, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.HIGH_PRIORITY.toString(), qos.getPriority().toString());
            Assert.assertEquals("", timestamp.getTimestamp(), qos.getRcvTimestamp().getTimestamp());
            System.out.println("SUCCESS BEFORE: " + msgUnitWrapper.toXml());
            System.out.println("SUCCESS AFTER: " + newWrapper.toXml());
            Assert.assertEquals("", msgUnitWrapper.getMsgQosData().toXml().length(), newWrapper.getMsgQosData().toXml().length());
            Assert.assertEquals("", msgUnitWrapper.getMsgKeyData().toXml(), newWrapper.getMsgKeyData().toXml());
            Assert.assertTrue("Not different instances", msgUnitWrapper != newWrapper);
            this.log.info(this.ME, "*** [SUCCESS]");
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new MsgUnitWrapperTest("testSerialize"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        MsgUnitWrapperTest testSub = new MsgUnitWrapperTest("MsgUnitWrapperTest");
        long startTime = System.currentTimeMillis();
        testSub.setUp();
        testSub.testSerialize();
        testSub.tearDown();
        long usedTime = System.currentTimeMillis() - startTime;
        System.out.println("time used for tests: " + usedTime / 1000L + " seconds");
    }
}

