/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.qos;

import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.qos.address.Address;

public class AddressBaseTest
extends TestCase {
    private final String ME = "AddressBaseTest";
    protected Global glob;
    protected LogChannel log;
    int counter = 0;

    public AddressBaseTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    public void testSet() {
        System.out.println("***AddressBaseTest: testSet ...");
        try {
            Global glob = new Global();
            Address a = new Address(glob);
            a.setType("SOCKET");
            a.setBootstrapHostname("oioihost");
            a.setBootstrapPort(9999);
            a.setRawAddress("127.0.0.1:7600");
            a.setCollectTime(12345L);
            a.setPingInterval(54321L);
            a.setRetries(17);
            a.setDelay(7890L);
            a.setOneway(true);
            a.setSecretSessionId("0x4546hwi89");
            System.out.println(a.toXml());
            Assert.assertEquals("", "SOCKET", a.getType());
            Assert.assertEquals("", "oioihost", a.getBootstrapHostname());
            Assert.assertEquals("", 9999, a.getBootstrapPort());
            Assert.assertEquals("", "127.0.0.1:7600", a.getRawAddress());
            Assert.assertEquals("", 12345L, a.getCollectTime());
            Assert.assertEquals("", 54321L, a.getPingInterval());
            Assert.assertEquals("", 17, a.getRetries());
            Assert.assertEquals("", 7890L, a.getDelay());
            Assert.assertEquals("", true, a.oneway());
            Assert.assertEquals("", "0x4546hwi89", a.getSecretSessionId());
            glob = new Global();
            a = new Address(glob);
            a.setRawAddress("127.0.0.1:7600");
            a.setBootstrapHostname("oioihost");
            a.setBootstrapPort(9999);
            System.out.println(a.toXml());
            Assert.assertEquals("", "oioihost", a.getBootstrapHostname());
            Assert.assertEquals("", 9999, a.getBootstrapPort());
            Assert.assertEquals("", "127.0.0.1:7600", a.getRawAddress());
            glob = new Global();
            a = new Address(glob);
            a.setBootstrapHostname("oioihost");
            a.setBootstrapPort(9999);
            System.out.println(a.toXml());
            Assert.assertEquals("", "oioihost", a.getBootstrapHostname());
            Assert.assertEquals("", 9999, a.getBootstrapPort());
            Assert.assertEquals("", "", a.getRawAddress());
            String nodeId = "heron";
            Vector<String> vec = new Vector<String>();
            vec.addElement("-sessionId");
            vec.addElement("ERROR");
            vec.addElement("-sessionId[" + nodeId + "]");
            vec.addElement("OK");
            vec.addElement("-pingInterval");
            vec.addElement("8888");
            vec.addElement("-delay[" + nodeId + "]");
            vec.addElement("8888");
            String[] args = vec.toArray(new String[0]);
            Global glob2 = new Global(args);
            Address a2 = new Address(glob2, "RMI", nodeId);
            System.out.println(a2.toXml());
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("TestFailed: " + e.toString());
            Assert.fail(e.toString());
        }
        System.out.println("***AddressBaseTest: testSet [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***AddressBaseTest: testDefault ...");
        Address a = new Address(this.glob);
        Assert.assertEquals("", "xmlBlaster://" + this.glob.getLocalIP() + ":3412", this.glob.getBootstrapAddress().getRawAddress());
        Assert.assertEquals("", "", a.getRawAddress());
        System.out.println("***AddressBaseTest: testDefault [SUCCESS]");
    }

    public static void main(String[] args) {
        AddressBaseTest testSub = new AddressBaseTest("AddressBaseTest");
        testSub.setUp();
        testSub.testSet();
        testSub.testDefault();
    }
}

