/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.qos;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.qos.GetReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.MsgQosSaxFactory;
import org.xmlBlaster.util.qos.TopicProperty;
import org.xmlBlaster.util.qos.address.Destination;
import org.xmlBlaster.util.qos.storage.HistoryQueueProperty;
import org.xmlBlaster.util.qos.storage.MsgUnitStoreProperty;

public class MsgQosFactoryTest
extends TestCase {
    private final String ME = "MsgQosFactoryTest";
    protected org.xmlBlaster.util.Global glob;
    protected LogChannel log;
    int counter = 0;

    public MsgQosFactoryTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = org.xmlBlaster.util.Global.instance();
        this.log = this.glob.getLog("test");
    }

    public void testParse() {
        System.out.println("***MsgQosFactoryTest: testParse ...");
        try {
            String xml = "<qos>\n   <state id='AA' info='SOMETHING'/>\n   <subscribable>true</subscribable>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>MIN</priority>\n   <administrative/>\n   <persistent/>\n   <forceUpdate>false</forceUpdate>\n   <route>\n      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n      <node id='heron' stratum='0' timestamp='9408630564'/>\n   </route>\n</qos>\n";
            MsgQosSaxFactory factory = new MsgQosSaxFactory(this.glob);
            MsgQosData qos = factory.readObject(xml);
            Assert.assertEquals("", "AA", qos.getState());
            Assert.assertEquals("", "SOMETHING", qos.getStateInfo());
            Assert.assertEquals("", true, qos.isPtp());
            Assert.assertEquals("", true, qos.isAdministrative());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", false, qos.isForceUpdate());
            Assert.assertEquals("", false, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 0L, qos.getLifeTime());
            Assert.assertEquals("", -1L, qos.getRemainingLifeStatic());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.MIN_PRIORITY, qos.getPriority());
            Assert.assertEquals("", false, qos.isFromPersistenceStore());
            Assert.assertTrue("no receive timestamp expected", qos.getRcvTimestamp() == null);
            Assert.assertEquals("", true, qos.isSubscribable());
            Assert.assertEquals("", 2, qos.getDestinations().size());
            Assert.assertEquals("", true, ((Destination)qos.getDestinations().get(0)).forceQueuing());
            Assert.assertEquals("", true, ((Destination)qos.getDestinations().get(0)).isExactAddress());
            Assert.assertEquals("", false, ((Destination)qos.getDestinations().get(0)).isXPathQuery());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testParse [SUCCESS]");
    }

    public void testToXml() {
        System.out.println("***MsgQosFactoryTest: testToXml ...");
        try {
            String xml = "<qos>\n   <state id='AA' info='SOMETHING'/>\n   <subscribable>false</subscribable>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>MIN</priority>\n   <expiration lifeTime='2400' remainingLife='12000' forceDestroy='true'/>\n   <rcvTimestamp nanos='1234'/>\n   <administrative/>\n   <persistent/>\n   <forceUpdate>false</forceUpdate>\n   <route>\n      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n      <node id='heron' stratum='0' timestamp='9408630564'/>\n   </route>\n   <topic readonly='true' destroyDelay='120000' createDomEntry='true'>\n      <persistence relating='msgUnitStore' type='TO' version='3.0' maxEntries='4' maxBytes='40' onOverflow='deadMessage'/>\n      <queue relating='history' type='HI' version='2.0' maxEntries='3' maxBytes='30' onOverflow='deadMessage'/>\n   </topic>\n</qos>\n";
            MsgQosSaxFactory factory = new MsgQosSaxFactory(this.glob);
            MsgQosData qos = factory.readObject(xml);
            String newXml = qos.toXml();
            this.log.info("MsgQosFactoryTest", "lifeTime=" + qos.getLifeTimeProp().toXml());
            this.log.info("MsgQosFactoryTest", "New XML=" + newXml);
            qos = factory.readObject(newXml);
            Assert.assertEquals("", "AA", qos.getState());
            Assert.assertEquals("", "SOMETHING", qos.getStateInfo());
            Assert.assertEquals("", true, qos.isPtp());
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", true, qos.isAdministrative());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", false, qos.isForceUpdate());
            Assert.assertEquals("", true, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 2400L, qos.getLifeTime());
            Assert.assertEquals("", 12000L, qos.getRemainingLifeStatic());
            Assert.assertEquals("", 1234L, qos.getRcvTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.isForceDestroy());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.MIN_PRIORITY, qos.getPriority());
            Assert.assertEquals("", false, qos.isFromPersistenceStore());
            Assert.assertEquals("", false, qos.isSubscribable());
            Assert.assertEquals("", 2, qos.getDestinations().size());
            Assert.assertEquals("", true, ((Destination)qos.getDestinations().get(0)).forceQueuing());
            Assert.assertEquals("", true, ((Destination)qos.getDestinations().get(0)).isExactAddress());
            Assert.assertEquals("", false, ((Destination)qos.getDestinations().get(0)).isXPathQuery());
            Assert.assertEquals("", true, qos.hasTopicProperty());
            TopicProperty topicProperty = qos.getTopicProperty();
            Assert.assertEquals("", true, topicProperty.isReadonly());
            Assert.assertEquals("", 120000L, topicProperty.getDestroyDelay());
            Assert.assertEquals("", true, topicProperty.createDomEntry());
            Assert.assertEquals("", true, topicProperty.hasMsgUnitStoreProperty());
            MsgUnitStoreProperty cache = topicProperty.getMsgUnitStoreProperty();
            Assert.assertEquals("", "msgUnitStore", cache.getRelating());
            Assert.assertEquals("", "TO", cache.getType());
            Assert.assertEquals("", "3.0", cache.getVersion());
            Assert.assertEquals("", 4L, cache.getMaxEntries());
            Assert.assertEquals("", 40L, cache.getMaxBytes());
            Assert.assertEquals("", "deadMessage", cache.getOnOverflow());
            Assert.assertEquals("", true, topicProperty.hasHistoryQueueProperty());
            HistoryQueueProperty hist = topicProperty.getHistoryQueueProperty();
            Assert.assertEquals("", "history", hist.getRelating());
            Assert.assertEquals("", "HI", hist.getType());
            Assert.assertEquals("", "2.0", hist.getVersion());
            Assert.assertEquals("", 3L, hist.getMaxEntries());
            Assert.assertEquals("", 30L, hist.getMaxBytes());
            Assert.assertEquals("", "deadMessage", hist.getOnOverflow());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testToXml failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testToXml [SUCCESS]");
    }

    public void testPublishQosServer() {
        System.out.println("***MsgQosFactoryTest: testPublishQosServer ...");
        try {
            String xml = "<qos>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>7</priority>\n   <expiration lifeTime='2400' remainingLife='12000'/>\n   <persistent/>\n   <forceUpdate>false</forceUpdate>\n   <route>\n      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n      <node id='heron' stratum='0' timestamp='9408630564'/>\n   </route>\n</qos>\n";
            PublishQosServer qos = new PublishQosServer(new Global(), xml);
            Assert.assertEquals("", true, qos.isSubscribable());
            Assert.assertEquals("", true, qos.isPtp());
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", false, qos.isForceUpdate());
            Assert.assertEquals("", false, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.HIGH_PRIORITY, qos.getPriority());
            Assert.assertEquals("", false, qos.isFromPersistenceStore());
            Timestamp timestamp = new Timestamp();
            Assert.assertTrue("timestamp.getTimestamp()=" + timestamp.getTimestamp() + " qos.getRcvTimestamp().getTimestamp()=" + qos.getRcvTimestamp().getTimestamp(), timestamp.getTimestamp() > qos.getRcvTimestamp().getTimestamp());
            Assert.assertTrue("timestamp.getTimestamp()=" + timestamp.getTimestamp() + " qos.getRcvTimestamp().getTimestamp()=" + qos.getRcvTimestamp().getTimestamp(), timestamp.getTimestamp() < qos.getRcvTimestamp().getTimestamp() + 10000000L);
            Assert.assertEquals("", 2, qos.getDestinations().size());
            Assert.assertEquals("", true, ((Destination)qos.getDestinations().get(0)).forceQueuing());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testPublishQosServer failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testPublishQosServer [SUCCESS]");
    }

    public void testGetReturnQos() {
        System.out.println("***MsgQosFactoryTest: testGetReturnQos ...");
        try {
            Timestamp timestamp = new Timestamp();
            String xml = "<qos>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>7</priority>\n   <expiration lifeTime='2400' remainingLife='12000'/>\n   <rcvTimestamp nanos='" + timestamp.getTimestamp() + "'/>\n" + "   <persistent/>\n" + "   <forceUpdate>false</forceUpdate>\n" + "   <route>\n" + "      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n" + "      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n" + "      <node id='heron' stratum='0' timestamp='9408630564'/>\n" + "   </route>\n" + "</qos>\n";
            GetReturnQos qos = new GetReturnQos(this.glob, xml);
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", false, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.HIGH_PRIORITY, qos.getPriority());
            Assert.assertEquals("", timestamp.getTimestamp(), qos.getRcvTimestamp().getTimestamp());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testGetReturnQos failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testGetReturnQos [SUCCESS]");
    }

    public void testUpdateQos() {
        System.out.println("***MsgQosFactoryTest: testUpdateQos ...");
        try {
            Timestamp timestamp = new Timestamp();
            String xml = "<qos>\n   <destination queryType='EXACT' forceQueuing='true'>\n      Tim\n   </destination>\n   <destination queryType='EXACT'>\n      Ben\n   </destination>\n   <sender>\n      Gesa\n   </sender>\n   <priority>7</priority>\n   <expiration lifeTime='2400' remainingLife='12000'/>\n   <rcvTimestamp nanos='" + timestamp.getTimestamp() + "'/>\n" + "   <persistent/>\n" + "   <forceUpdate>false</forceUpdate>\n" + "   <route>\n" + "      <node id='bilbo' stratum='2' timestamp='9408630500' dirtyRead='true'/>\n" + "      <node id='frodo' stratum='1' timestamp='9408630538' dirtyRead='false'/>\n" + "      <node id='heron' stratum='0' timestamp='9408630564'/>\n" + "   </route>\n" + "   <topic readonly='true'/>\n" + "</qos>\n";
            UpdateQos qos = new UpdateQos(this.glob, xml);
            Assert.assertEquals("", true, qos.isSubscribable());
            Assert.assertEquals("", true, qos.isPtp());
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", true, qos.isPersistent());
            Assert.assertEquals("", true, qos.isReadonly());
            Assert.assertEquals("", "Gesa", qos.getSender().getLoginName());
            Assert.assertEquals("", 3, qos.getRouteNodes().length);
            Assert.assertEquals("", 2, qos.getRouteNodes()[0].getStratum());
            Assert.assertEquals("", 0, qos.getRouteNodes()[2].getStratum());
            Assert.assertEquals("", 9408630500L, qos.getRouteNodes()[0].getTimestamp().getTimestamp());
            Assert.assertEquals("", true, qos.getRouteNodes()[0].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[1].getDirtyRead());
            Assert.assertEquals("", false, qos.getRouteNodes()[2].getDirtyRead());
            Assert.assertEquals("", PriorityEnum.HIGH_PRIORITY, qos.getPriority());
            Assert.assertEquals("", timestamp.getTimestamp(), qos.getRcvTimestamp().getTimestamp());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testUpdateQos failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testUpdateQos [SUCCESS]");
    }

    public void testFromPersistentStore() {
        System.out.println("***MsgQosFactoryTest: testFromPersistentStore ...");
        try {
            Timestamp timestamp = new Timestamp();
            String xml = "<qos>\n   <rcvTimestamp nanos='" + timestamp.getTimestamp() + "'/>\n" + "</qos>\n";
            MsgQosSaxFactory factory = new MsgQosSaxFactory(this.glob);
            MsgQosData qos = factory.readObject(xml);
            Assert.assertEquals("", timestamp.getTimestamp(), qos.getRcvTimestamp().getTimestamp());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testFromPersistentStore failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testFromPersistentStore [SUCCESS]");
    }

    public void testAdministrative() {
        System.out.println("***MsgQosFactoryTest: testAdministrative ...");
        MsgQosData msgQosData = new MsgQosData(this.glob, MethodName.PUBLISH);
        msgQosData.setAdministrative(true);
        Assert.assertEquals("", PriorityEnum.MAX_PRIORITY.getInt(), msgQosData.getPriority().getInt());
        String xml = msgQosData.toXml();
        this.log.info("MsgQosFactoryTest", "Created administrative publish" + xml);
        Assert.assertTrue("Missing administrative in " + xml, xml.indexOf("<administrative/>") > -1);
        Assert.assertTrue("Wrong priority in " + xml, xml.indexOf("9") > -1 || xml.indexOf("MAX") > -1);
        System.out.println("***MsgQosFactoryTest: testAdministrative [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***MsgQosFactoryTest: testDefault ...");
        try {
            MsgQosSaxFactory factory = new MsgQosSaxFactory(this.glob);
            MsgQosData qos = factory.readObject(null);
            Assert.assertEquals("", true, qos.isSubscribable());
            Assert.assertEquals("", false, qos.isPtp());
            Assert.assertEquals("", false, qos.isVolatile());
            Assert.assertEquals("", false, qos.isAdministrative());
            Assert.assertEquals("", false, qos.isPersistent());
            Assert.assertEquals("", true, qos.isForceUpdate());
            Assert.assertEquals("", false, qos.isReadonly());
            Assert.assertEquals("", null, qos.getSender());
            Assert.assertEquals("", 0, qos.getRouteNodes().length);
            Assert.assertEquals("", PriorityEnum.NORM_PRIORITY, qos.getPriority());
            Assert.assertEquals("", false, qos.isFromPersistenceStore());
            Assert.assertTrue("", qos.getRcvTimestamp() == null);
            Assert.assertEquals("", null, qos.getDestinations());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***MsgQosFactoryTest: testDefault [SUCCESS]");
    }

    public static void main(String[] args) {
        MsgQosFactoryTest testSub = new MsgQosFactoryTest("MsgQosFactoryTest");
        testSub.setUp();
        testSub.testParse();
        testSub.testToXml();
        testSub.testFromPersistentStore();
        testSub.testAdministrative();
        testSub.testPublishQosServer();
        testSub.testGetReturnQos();
        testSub.testUpdateQos();
        testSub.testDefault();
    }
}

