/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.qos;

import java.util.Hashtable;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.codec.binary.Base64;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.qos.ClientProperty;
import org.xmlBlaster.util.qos.MsgQosData;

public class MsgQosTest
extends TestCase {
    private final String ME = "MsgQosTest";
    protected Global glob;
    protected LogChannel log;
    int counter = 0;

    public MsgQosTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
    }

    public void testMethods() {
        System.out.println("***MsgQosTest: testMethods ...");
        MsgQosData qos = new MsgQosData(this.glob, MethodName.UPDATE);
        qos.setState("AA");
        Assert.assertEquals("state", "AA", qos.getState());
        ClientProperty cp = new ClientProperty(this.glob, "aKey", "byte[]", "base64", "bla");
        qos.addClientProperty(cp);
        Hashtable jxPath = qos.toJXPath();
        String value = (String)jxPath.get("/qos/clientProperty[@name='aKey']/text()");
        byte[] bla = Base64.encodeBase64((byte[])"bla".getBytes(), (boolean)false);
        Assert.assertEquals("JXPATH", new String(bla), value);
        String type = (String)jxPath.get("/qos/clientProperty[@name='aKey']/@type");
        Assert.assertEquals("JXPATH", "byte[]", type);
        String encoding = (String)jxPath.get("/qos/clientProperty[@name='aKey']/@encoding");
        Assert.assertEquals("JXPATH", "base64", encoding);
        System.out.println("***MsgQosTest: testParse [SUCCESS]");
    }

    public static void main(String[] args) {
        MsgQosTest testSub = new MsgQosTest("MsgQosTest");
        testSub.setUp();
        testSub.testMethods();
    }
}

