/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.engine.mime.Query;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.AccessFilterQos;
import org.xmlBlaster.util.qos.HistoryQos;
import org.xmlBlaster.util.qos.I_QueryQosFactory;
import org.xmlBlaster.util.qos.QueryQosData;
import org.xmlBlaster.util.qos.QueryQosSaxFactory;

public class QueryQosFactoryTest
extends TestCase {
    private String ME = "QueryQosFactoryTest";
    protected final Global glob;
    protected final LogChannel log;
    private String currImpl;
    private I_QueryQosFactory factory;
    static I_QueryQosFactory[] IMPL = new I_QueryQosFactory[]{new QueryQosSaxFactory(Global.instance())};

    public QueryQosFactoryTest(Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.factory = IMPL[currImpl];
    }

    protected void setUp() {
        this.log.info(this.ME, "Testing parser factory " + this.factory.getName());
    }

    public void testParse() {
        System.out.println("***QueryQosFactoryTest: testParse ...");
        try {
            String xml = "<qos>\n   <subscribe id='_subId:1'/>\n   <erase forceDestroy='true'/>\n   <meta>false</meta>\n   <content>false</content>\n   <local>false</local>\n   <initialUpdate>false</initialUpdate>\n   <filter type='myPlugin' version='1.0'>a!=100</filter>\n   <filter type='anotherPlugin' version='1.1'><![CDATA[b<100|a[0]>10]]></filter>\n</qos>\n";
            QueryQosData qos = this.factory.readObject(xml);
            Assert.assertEquals("", "_subId:1", qos.getSubscriptionId());
            Assert.assertEquals("", true, qos.getForceDestroy());
            Assert.assertEquals("", false, qos.getWantMeta());
            Assert.assertEquals("", false, qos.getWantContent());
            Assert.assertEquals("", false, qos.getWantLocal());
            Assert.assertEquals("", false, qos.getWantInitialUpdate());
            AccessFilterQos[] filterArr = qos.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "myPlugin", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "a!=100", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "anotherPlugin", filterArr[1].getType());
            Assert.assertEquals("", "1.1", filterArr[1].getVersion());
            Assert.assertEquals("", "b<100|a[0]>10", filterArr[1].getQuery().toString());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: testParse [SUCCESS]");
    }

    public void testToXml() {
        System.out.println("***QueryQosFactoryTest: testToXml ...");
        try {
            String xml = "<qos>\n   <subscribe id='_subId:1'/>\n   <erase forceDestroy='true'/>\n   <meta>false</meta>\n   <content>false</content>\n   <local>false</local>\n   <initialUpdate>false</initialUpdate>\n   <history numEntries='20' newestFirst='false'/>\n   <filter type='myPlugin' version='1.0'>a!=100</filter>\n   <filter type='anotherPlugin' version='1.1'><![CDATA[b<100|a[0]>10]]></filter>\n</qos>\n";
            QueryQosData qos = this.factory.readObject(xml);
            String newXml = qos.toXml();
            this.log.info(this.ME, "New XML=" + newXml);
            qos = this.factory.readObject(newXml);
            Assert.assertEquals("", "_subId:1", qos.getSubscriptionId());
            Assert.assertEquals("", true, qos.getForceDestroy());
            Assert.assertEquals("", false, qos.getWantMeta());
            Assert.assertEquals("", false, qos.getWantContent());
            Assert.assertEquals("", false, qos.getWantLocal());
            Assert.assertEquals("", false, qos.getWantInitialUpdate());
            Assert.assertEquals("", 20, qos.getHistoryQos().getNumEntries());
            Assert.assertEquals("", false, qos.getHistoryQos().getNewestFirst());
            AccessFilterQos[] filterArr = qos.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "myPlugin", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "a!=100", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "anotherPlugin", filterArr[1].getType());
            Assert.assertEquals("", "1.1", filterArr[1].getVersion());
            Assert.assertEquals("", "b<100|a[0]>10", filterArr[1].getQuery().toString());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testToXml failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: testToXml [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***QueryQosFactoryTest: testDefault ...");
        try {
            QueryQosData qos = this.factory.readObject(null);
            Assert.assertEquals("", null, qos.getSubscriptionId());
            Assert.assertEquals("", true, qos.getWantMeta());
            Assert.assertEquals("", true, qos.getWantContent());
            Assert.assertEquals("", true, qos.getWantLocal());
            Assert.assertEquals("", true, qos.getWantInitialUpdate());
            Assert.assertEquals("", 1, qos.getHistoryQos().getNumEntries());
            Assert.assertEquals("", true, qos.getHistoryQos().getNewestFirst());
            AccessFilterQos[] filterArr = qos.getAccessFilterArr();
            Assert.assertTrue("", null == filterArr);
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: testDefault [SUCCESS]");
    }

    public void testEraseQos() {
        System.out.println("***QueryQosFactoryTest: EraseQos ...");
        try {
            EraseQos eraseQos = new EraseQos(this.glob);
            eraseQos.setForceDestroy(true);
            System.out.println("EraseQos: " + eraseQos.toXml());
            QueryQosData qos = this.factory.readObject(eraseQos.toXml());
            Assert.assertEquals("", true, qos.getForceDestroy());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: EraseQos [SUCCESS]");
    }

    public void testSubscribeQos() {
        System.out.println("***QueryQosFactoryTest: SubscribeQos ...");
        try {
            SubscribeQos subscribeQos = new SubscribeQos(this.glob);
            subscribeQos.setWantContent(false);
            subscribeQos.setSubscriptionId("MyOwnSentSubscribeId");
            HistoryQos hh = new HistoryQos(this.glob, 33);
            hh.setNewestFirst(false);
            subscribeQos.setHistoryQos(hh);
            subscribeQos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", new Query(this.glob, "800")));
            subscribeQos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter2", "3.2", new Query(this.glob, "a<10")));
            subscribeQos.setPersistent(true);
            System.out.println("SubscribeQos: " + subscribeQos.toXml());
            QueryQosData qos = this.factory.readObject(subscribeQos.toXml());
            Assert.assertEquals("", false, qos.getWantContent());
            Assert.assertEquals("", "MyOwnSentSubscribeId", qos.getSubscriptionId());
            Assert.assertEquals("", 33, qos.getHistoryQos().getNumEntries());
            Assert.assertEquals("", false, qos.getHistoryQos().getNewestFirst());
            AccessFilterQos[] filterArr = qos.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "ContentLenFilter", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "800", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "ContentLenFilter2", filterArr[1].getType());
            Assert.assertEquals("", "3.2", filterArr[1].getVersion());
            Assert.assertEquals("", "a<10", filterArr[1].getQuery().toString());
            Assert.assertEquals("", true, qos.getPersistentProp().getValue());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: SubscribeQos [SUCCESS]");
    }

    public void testGetQos() {
        System.out.println("***QueryQosFactoryTest: GetQos ...");
        try {
            GetQos getQos = new GetQos(this.glob);
            getQos.setWantContent(false);
            HistoryQos hh = new HistoryQos(this.glob, 33);
            hh.setNewestFirst(false);
            getQos.setHistoryQos(hh);
            getQos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter", "1.0", new Query(this.glob, "800")));
            getQos.addAccessFilter(new AccessFilterQos(this.glob, "ContentLenFilter2", "3.2", new Query(this.glob, "a<10")));
            System.out.println("GetQos: " + getQos.toXml());
            QueryQosData qos = this.factory.readObject(getQos.toXml());
            Assert.assertEquals("", false, qos.getWantContent());
            Assert.assertEquals("", 33, qos.getHistoryQos().getNumEntries());
            Assert.assertEquals("", false, qos.getHistoryQos().getNewestFirst());
            AccessFilterQos[] filterArr = qos.getAccessFilterArr();
            Assert.assertEquals("", 2, filterArr.length);
            Assert.assertEquals("", "ContentLenFilter", filterArr[0].getType());
            Assert.assertEquals("", "1.0", filterArr[0].getVersion());
            Assert.assertEquals("", "800", filterArr[0].getQuery().toString());
            Assert.assertEquals("", "ContentLenFilter2", filterArr[1].getType());
            Assert.assertEquals("", "3.2", filterArr[1].getVersion());
            Assert.assertEquals("", "a<10", filterArr[1].getQuery().toString());
        }
        catch (Throwable e) {
            System.out.println("Test failed: " + e.toString());
        }
        System.out.println("***QueryQosFactoryTest: GetQos [SUCCESS]");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < IMPL.length) {
            suite.addTest(new QueryQosFactoryTest(glob, "testDefault", i));
            suite.addTest(new QueryQosFactoryTest(glob, "testParse", i));
            suite.addTest(new QueryQosFactoryTest(glob, "testToXml", i));
            suite.addTest(new QueryQosFactoryTest(glob, "testEraseQos", i));
            suite.addTest(new QueryQosFactoryTest(glob, "testSubscribeQos", i));
            suite.addTest(new QueryQosFactoryTest(glob, "testGetQos", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < IMPL.length) {
            QueryQosFactoryTest testSub = new QueryQosFactoryTest(glob, "QueryQosFactoryTest", i);
            testSub.setUp();
            testSub.testDefault();
            testSub.testParse();
            testSub.testToXml();
            testSub.testEraseQos();
            testSub.testSubscribeQos();
            testSub.testGetQos();
            ++i;
        }
    }
}

