/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.I_StatusQosFactory;
import org.xmlBlaster.util.qos.StatusQosData;
import org.xmlBlaster.util.qos.StatusQosQuickParseFactory;
import org.xmlBlaster.util.qos.StatusQosSaxFactory;

public class StatusQosFactoryTest
extends TestCase {
    private String ME = "StatusQosFactoryTest";
    protected final Global glob;
    protected final LogChannel log;
    private String currImpl;
    private I_StatusQosFactory factory;
    static I_StatusQosFactory[] IMPL = new I_StatusQosFactory[]{new StatusQosSaxFactory(Global.instance()), new StatusQosQuickParseFactory(Global.instance())};

    public StatusQosFactoryTest(Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.factory = IMPL[currImpl];
    }

    protected void setUp() {
        this.log.info(this.ME, "Testing parser factory " + this.factory.getName());
    }

    public void testParse() {
        System.out.println("***StatusQosFactoryTest: testParse ...");
        try {
            String xml = "<qos>\n   <state id='ERASED' info='QUEUED[bilbo]'/>\n   <key oid='yourMessageOid'/>\n   <subscribe id='_subId:1'/>\n</qos>\n";
            StatusQosData qos = this.factory.readObject(xml);
            Assert.assertEquals("", "ERASED", qos.getState());
            Assert.assertEquals("", false, qos.isOk());
            Assert.assertEquals("", true, qos.isErased());
            Assert.assertEquals("", false, qos.isTimeout());
            Assert.assertEquals("", false, qos.isForwardError());
            Assert.assertEquals("", "QUEUED[bilbo]", qos.getStateInfo());
            Assert.assertEquals("", "yourMessageOid", qos.getKeyOid());
            Assert.assertEquals("", "_subId:1", qos.getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testParse failed: " + e.toString());
        }
        System.out.println("***StatusQosFactoryTest: testParse [SUCCESS]");
    }

    public void testToXml() {
        System.out.println("***StatusQosFactoryTest: testToXml ...");
        try {
            String xml = "<qos>\n   <state id='ERASED' info='QUEUED[bilbo]'/>\n   <key oid='yourMessageOid'/>\n   <subscribe id='_subId:1'/>\n</qos>\n";
            StatusQosData qos = this.factory.readObject(xml);
            String newXml = qos.toXml();
            this.log.info(this.ME, "New XML=" + newXml);
            qos = this.factory.readObject(newXml);
            Assert.assertEquals("", "ERASED", qos.getState());
            Assert.assertEquals("", false, qos.isOk());
            Assert.assertEquals("", true, qos.isErased());
            Assert.assertEquals("", false, qos.isTimeout());
            Assert.assertEquals("", false, qos.isForwardError());
            Assert.assertEquals("", "QUEUED[bilbo]", qos.getStateInfo());
            Assert.assertEquals("", "yourMessageOid", qos.getKeyOid());
            Assert.assertEquals("", "_subId:1", qos.getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testToXml failed: " + e.toString());
        }
        System.out.println("***StatusQosFactoryTest: testToXml [SUCCESS]");
    }

    public void testDefault() {
        System.out.println("***StatusQosFactoryTest: testDefault ...");
        try {
            StatusQosData qos = this.factory.readObject(null);
            Assert.assertEquals("", "OK", qos.getState());
            Assert.assertEquals("", true, qos.isOk());
            Assert.assertEquals("", false, qos.isErased());
            Assert.assertEquals("", false, qos.isTimeout());
            Assert.assertEquals("", false, qos.isForwardError());
            Assert.assertEquals("", null, qos.getStateInfo());
            Assert.assertEquals("", null, qos.getKeyOid());
            Assert.assertEquals("", null, qos.getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            Assert.fail("testDefault failed: " + e.toString());
        }
        System.out.println("***StatusQosFactoryTest: testDefault [SUCCESS]");
    }

    public void testPerformance() {
        System.out.println("***StatusQosFactoryTest: testPerformance ...");
        try {
            String xml = "<qos>\n   <state id='ERASED' info='QUEUED[bilbo]'/>\n   <key oid='yourMessageOid'/>\n   <subscribe id='_subId:1'/>\n</qos>\n";
            int j = 0;
            while (j < 5) {
                int num = 1000;
                long start = System.currentTimeMillis();
                int i = 0;
                while (i < num) {
                    StatusQosData qos = this.factory.readObject(xml);
                    ++i;
                }
                long elapsed = System.currentTimeMillis() - start;
                this.log.info(this.ME, num + " parses for " + this.factory.getName() + ": " + elapsed + " millisec -> " + (double)elapsed * 1000.0 * 1000.0 / (double)num + " nanosec/parse");
                ++j;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail("testPerformance failed: " + e.toString());
        }
        System.out.println("***StatusQosFactoryTest: testPerformance [SUCCESS]");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < IMPL.length) {
            suite.addTest(new StatusQosFactoryTest(glob, "testDefault", i));
            suite.addTest(new StatusQosFactoryTest(glob, "testParse", i));
            suite.addTest(new StatusQosFactoryTest(glob, "testToXml", i));
            suite.addTest(new StatusQosFactoryTest(glob, "testPerformance", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < IMPL.length) {
            StatusQosFactoryTest testSub = new StatusQosFactoryTest(glob, "StatusQosFactoryTest", i);
            testSub.setUp();
            testSub.testDefault();
            testSub.testParse();
            testSub.testPerformance();
            testSub.testToXml();
            ++i;
        }
    }
}

