/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class CacheQueueDisconnectTest
extends TestCase {
    private String ME = "CacheQueueDisconnectTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private int numOfQueues = 10;
    private int numOfMsg = 10000;
    private long sizeOfMsg = 100L;
    private I_Queue queue = null;
    public ArrayList queueList = null;
    public static String[] PLUGIN_TYPES = new String[]{new String("CACHE")};
    public int count = 0;
    boolean suppressTest = false;

    public CacheQueueDisconnectTest(Global glob, String name, int currImpl) {
        super(name);
        this.initialize(glob, name, currImpl);
    }

    private void initialize(Global glob, String name, int currImpl) {
        this.glob = Global.instance();
        this.log = glob.getLog(null);
        this.numOfQueues = glob.getProperty().get("queues", 2);
        this.numOfMsg = glob.getProperty().get("entries", 100);
        this.sizeOfMsg = glob.getProperty().get("sizes", 10L);
        this.suppressTest = false;
        this.count = currImpl;
        try {
            String type = PLUGIN_TYPES[currImpl];
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(glob);
            PluginInfo pluginInfo = new PluginInfo(glob, (I_PluginManager)pluginManager, type, "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            CbQueueProperty cbProp = new CbQueueProperty(glob, "callback", "/node/test");
            StorageId queueId = new StorageId("callback", "SetupQueue");
            this.queue = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'");
        }
    }

    protected void setUp() {
        this.log = this.glob.getLog("test");
        try {
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            this.ME = "CacheQueueDisconnectTest with class: " + PLUGIN_TYPES[this.count];
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'" + ex.getMessage());
        }
        Object prop = null;
        try {
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
            this.suppressTest = true;
        }
    }

    public void tearDown() {
        try {
            this.queue.clear();
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp " + ex.getMessage());
        }
    }

    public void testPutWithBreak() {
        if (this.suppressTest) {
            this.log.error(this.ME, "JDBC test is not driven as no database was found");
            return;
        }
        try {
            this.putWithBreak();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutWithBreak probably d\u001bue to failed initialization of the queue of type " + PLUGIN_TYPES[this.count] + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void putWithBreak() throws XmlBlasterException {
        String me = this.ME + ".putWithBreak";
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(10000L);
        StorageId queueId = new StorageId("callback", "putWithBreak");
        this.queue.initialize(queueId, prop);
        this.queue.clear();
        int sweeps = 50;
        int num = 20;
        long sleepDelay = 50L;
        block2: while (true) {
            DummyEntry[] entries = new DummyEntry[num];
            int i = 0;
            while (i < num) {
                this.log.info(me, "put one entry");
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), this.sizeOfMsg, true);
                this.queue.put(entries[i], false);
                try {
                    Thread.currentThread();
                    Thread.sleep(sleepDelay);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i;
            }
            ArrayList lst = this.queue.peek(-1, -1L);
            Assert.assertEquals(me + ": wrong number of entries in queue", entries.length, lst.size());
            int i2 = 0;
            while (true) {
                if (i2 >= entries.length) continue block2;
                long uniqueId = ((DummyEntry)lst.get(i2)).getUniqueId();
                Assert.assertEquals(me + ": wrong order in entries: ", entries[i2].getUniqueId(), uniqueId);
                this.log.info(me, "remove one entry");
                this.queue.removeRandom(entries[i2]);
                ++i2;
            }
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new CacheQueueDisconnectTest(glob, "testPutWithBreak", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            CacheQueueDisconnectTest testSub = new CacheQueueDisconnectTest(glob, "CacheQueueDisconnectTest", i);
            testSub.setUp();
            testSub.testPutWithBreak();
            testSub.tearDown();
            ++i;
        }
    }
}

