/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.cache.CacheQueueInterceptorPlugin;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class CacheQueueTest
extends TestCase {
    private String ME = "CacheQueueTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private CacheQueueInterceptorPlugin queue = null;
    private I_Queue[] queues;
    public ArrayList queueList = null;

    public CacheQueueTest(String name) {
        this(Global.instance(), name);
    }

    public CacheQueueTest(Global glob, String name) {
        super(name);
        this.glob = glob;
    }

    protected void setUp() {
        this.glob = Global.instance();
        this.log = this.glob.getLog("test");
        CbQueueProperty cbProp = null;
        try {
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            cbProp = new CbQueueProperty(this.glob, "callback", "/node/test");
            StorageId queueId = new StorageId("callback", "SetupQueue");
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(this.glob);
            PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
            pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "CACHE", "1.0");
            this.queue = (CacheQueueInterceptorPlugin)pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            this.queues = new I_Queue[3];
            pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "RAM", "1.0");
            this.queues[0] = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            this.queues[1] = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            this.queues[2] = this.queue;
            int i = 0;
            while (i < 3) {
                this.queues[i].shutdown();
                ++i;
            }
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
        }
    }

    public void tearDown() {
        try {
            int i = 0;
            while (i < 3) {
                this.queues[i].clear();
                this.queues[i].shutdown();
                ++i;
            }
        }
        catch (Exception ex) {
            this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp");
        }
    }

    public void testConfig() {
        String queueType = "CACHE";
        try {
            this.config();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType);
            ex.printStackTrace();
        }
    }

    public void config() throws XmlBlasterException {
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(20L);
        prop.setMaxEntriesCache(10L);
        prop.setMaxBytes(500L);
        prop.setMaxBytesCache(200L);
        StorageId queueId = new StorageId("callback", "CacheQueueTest/config");
        this.queue.initialize(queueId, prop);
        long persistentSize = this.queue.getPersistentQueue().getMaxNumOfBytes();
        long persistentMsg = this.queue.getPersistentQueue().getMaxNumOfEntries();
        long transientSize = this.queue.getTransientQueue().getMaxNumOfBytes();
        long transientMsg = this.queue.getTransientQueue().getMaxNumOfEntries();
        Assert.assertEquals("Wrong persistent size", 500L, persistentSize);
        Assert.assertEquals("Wrong persistent num of msg", 20L, persistentMsg);
        if (200L != transientSize) {
            this.log.error(this.ME, "ERROR: Wrong transient size" + this.queue.getTransientQueue().toXml(""));
        }
        Assert.assertEquals("Wrong transient size" + this.queue.getTransientQueue().toXml(""), 200L, transientSize);
        Assert.assertEquals("Wrong num of transient msg", 10L, transientMsg);
    }

    private boolean checkIfPossible(long transientNumOfBytes, long persistentNumOfBytes, long maxTransientNumOfBytes, long maxPersistentNumOfBytes) {
        this.log.trace(this.ME, "checkIfPossible: transient number of bytes: " + transientNumOfBytes + " of (max) " + maxTransientNumOfBytes + " , persistent number of bytes: " + persistentNumOfBytes + " of (max) " + maxPersistentNumOfBytes);
        if (transientNumOfBytes > maxTransientNumOfBytes) {
            return false;
        }
        return persistentNumOfBytes <= maxPersistentNumOfBytes;
    }

    public void testPutPeekRemove() {
        String queueType = this.glob.getProperty().get("queueType", "CACHE");
        this.log.info(this.ME, "testPutPeekRemove will be done with a queue of type '" + queueType + "'");
        this.log.info(this.ME, "if you want to test with another queue type invoke '-queueType $TYPE' on the cmd line where $TYPE is either RAM JDBC or CACHE");
        int index = 2;
        if ("RAM".equalsIgnoreCase(queueType)) {
            index = 0;
        } else if ("JDBC".equalsIgnoreCase(queueType)) {
            index = 1;
        }
        try {
            this.putPeekRemove(this.queues[index]);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType);
            ex.printStackTrace();
        }
    }

    public void putPeekRemove(I_Queue refQueue) throws XmlBlasterException {
        long entrySize = 100L;
        String lastSuccessfulLocation = "";
        long[] maxNumOfBytesCache = new long[]{700L, 10000L};
        long[] maxNumOfBytes = new long[]{700L, 50000L};
        int[] numOfTransientEntries = new int[]{2, 50, 200};
        int[] numOfPersistentEntries = new int[]{0, 2, 50, 200};
        int ic = 0;
        while (ic < maxNumOfBytesCache.length) {
            int is = 0;
            while (is < maxNumOfBytes.length) {
                this.log.info(this.ME, "**** TEST maxNumOfBytesCache[" + ic + "]=" + maxNumOfBytesCache[ic] + " maxNumOfBytes[" + is + "]=" + maxNumOfBytes[is]);
                CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
                prop.setMaxEntries(2000L);
                prop.setMaxEntriesCache(1000L);
                prop.setMaxBytes(maxNumOfBytes[is]);
                prop.setMaxBytesCache(maxNumOfBytesCache[ic]);
                StorageId queueId = new StorageId("callback", "CacheQueueTest/jdbc" + maxNumOfBytes[is] + "/ram" + maxNumOfBytesCache[ic]);
                refQueue.clear();
                refQueue.shutdown();
                refQueue.initialize(queueId, prop);
                int it = 0;
                while (it < numOfTransientEntries.length) {
                    int id = 0;
                    while (id < numOfPersistentEntries.length) {
                        this.log.info(this.ME, "**** SUB-TEST maxNumOfBytesCache[" + ic + "]=" + maxNumOfBytesCache[ic] + " maxNumOfBytes[" + is + "]=" + maxNumOfBytes[is] + " -> numOfTransientEntries[" + it + "]=" + numOfTransientEntries[it] + " numOfPersistentEntries[" + id + "]=" + numOfPersistentEntries[id]);
                        if (!refQueue.isShutdown()) {
                            refQueue.shutdown();
                        }
                        refQueue.initialize(queueId, prop);
                        refQueue.clear();
                        long maxPersistentNumOfBytes = maxNumOfBytes[is];
                        long maxTransientNumOfBytes = maxNumOfBytesCache[ic];
                        long transientNumOfBytes = 0L;
                        long persistentNumOfBytes = 0L;
                        Assert.assertEquals(this.ME + " the number of bytes of the queue should be zero ", 0L, refQueue.getNumOfBytes());
                        Assert.assertEquals(this.ME + " the number of entries in the queue should be zero ", 0L, refQueue.getNumOfEntries());
                        Assert.assertEquals(this.ME + " the number of bytes of the persistent entries in the queue should be zero ", 0L, refQueue.getNumOfPersistentBytes());
                        Assert.assertEquals(this.ME + " the number of persistent entries in the queue should be zero ", 0L, refQueue.getNumOfPersistentEntries());
                        Assert.assertEquals(this.ME + " the maximum number of entries is wrong ", maxNumOfBytes[is], refQueue.getMaxNumOfBytes());
                        try {
                            refQueue.clear();
                            transientNumOfBytes = entrySize * (long)numOfTransientEntries[it];
                            persistentNumOfBytes = entrySize * (long)numOfPersistentEntries[id];
                            Hashtable[] inputTable = new Hashtable[3];
                            int i = 0;
                            while (i < 3) {
                                inputTable[i] = new Hashtable();
                                ++i;
                            }
                            DummyEntry[] transients = new DummyEntry[numOfTransientEntries[it]];
                            DummyEntry[] persistentEntries = new DummyEntry[numOfPersistentEntries[id]];
                            this.log.info(this.ME, "putPeekRemove " + queueId + " persistent: " + persistentEntries.length + " transient: " + transients.length);
                            boolean persistent = false;
                            int i2 = 0;
                            while (i2 < transients.length) {
                                DummyEntry entry;
                                int prio = i2 % 3;
                                PriorityEnum enumer = PriorityEnum.toPriorityEnum(prio + 4);
                                transients[i2] = entry = new DummyEntry(this.glob, enumer, refQueue.getStorageId(), entrySize, persistent);
                                inputTable[prio].put(new Long(entry.getUniqueId()), entry);
                                ++i2;
                            }
                            persistent = true;
                            int i3 = 0;
                            while (i3 < persistentEntries.length) {
                                DummyEntry entry;
                                int prio = i3 % 3;
                                PriorityEnum enumer = PriorityEnum.toPriorityEnum(prio + 4);
                                persistentEntries[i3] = entry = new DummyEntry(this.glob, enumer, refQueue.getStorageId(), entrySize, persistent);
                                inputTable[prio].put(new Long(entry.getUniqueId()), entry);
                                ++i3;
                            }
                            Assert.assertEquals(this.ME + " number of persistent entries is wrong ", 0L, refQueue.getNumOfPersistentEntries());
                            Assert.assertEquals(this.ME + " number of entries is wrong ", 0L, refQueue.getNumOfEntries());
                            int i4 = 0;
                            while (i4 < transients.length) {
                                lastSuccessfulLocation = "transientEntries put #" + i4;
                                refQueue.put(transients[i4], false);
                                ++i4;
                            }
                            Assert.assertEquals(this.ME + " number of entries after putting transients is wrong ", (long)transients.length, refQueue.getNumOfEntries());
                            int i5 = 0;
                            while (i5 < persistentEntries.length) {
                                lastSuccessfulLocation = "persistentEntries put #" + i5;
                                refQueue.put(persistentEntries[i5], false);
                                ++i5;
                            }
                            Assert.assertEquals(this.ME + " number of entries after putting transients is wrong ", (long)(persistentEntries.length + transients.length), refQueue.getNumOfEntries());
                            long nPersistents = refQueue.getNumOfPersistentEntries();
                            long nTransient = refQueue.getNumOfEntries() - nPersistents;
                            Assert.assertEquals(this.ME + " number of persistent entries is wrong ", (long)persistentEntries.length, nPersistents);
                            Assert.assertEquals(this.ME + " number of transient entries is wrong ", (long)transients.length, nTransient);
                            ArrayList total = new ArrayList();
                            ArrayList ret = refQueue.peekSamePriority(-1, -1L);
                            refQueue.removeRandom(ret.toArray(new I_QueueEntry[ret.size()]));
                            while (ret.size() > 0) {
                                total.addAll(ret);
                                ret = refQueue.peekSamePriority(-1, -1L);
                                if (ret.size() <= 0) continue;
                                refQueue.removeRandom(ret.toArray(new I_QueueEntry[ret.size()]));
                            }
                            int mustEntries = inputTable[0].size() + inputTable[1].size() + inputTable[2].size();
                            long totNumOfBytes = entrySize * (long)(numOfPersistentEntries[id] + numOfTransientEntries[it]);
                            this.log.trace(this.ME, "total number of bytes: " + totNumOfBytes + " maxNumOfBytes: " + maxNumOfBytes[is]);
                            this.log.trace(this.ME, "entries must be: " + mustEntries);
                            Assert.assertTrue("Overflow is not allowed " + refQueue.toXml("") + "total number of bytes " + totNumOfBytes + " max number of bytes: " + maxNumOfBytes[is], totNumOfBytes <= maxNumOfBytes[is]);
                            Assert.assertEquals(this.ME + " number of returned values differe from input values " + refQueue.toXml(""), mustEntries, total.size());
                            this.log.info(this.ME, "SUCCESS: cacheSize=" + maxNumOfBytesCache[ic] + " maxBytes=" + maxNumOfBytes[is] + " .... looks OK");
                            int count = 0;
                            int j = 0;
                            while (j < 3) {
                                Hashtable table = inputTable[j];
                                Enumeration keys = table.keys();
                                while (keys.hasMoreElements()) {
                                    long refId = ((I_QueueEntry)table.get(keys.nextElement())).getUniqueId();
                                    long outId = ((I_QueueEntry)total.get(count)).getUniqueId();
                                    Assert.assertEquals("uniqueId differe for count " + count + " " + refQueue.toXml(""), mustEntries, total.size());
                                    ++count;
                                }
                                ++j;
                            }
                        }
                        catch (XmlBlasterException e) {
                            this.log.dump(this.ME, "Exception (might be ok): " + e.toString());
                            Assert.assertTrue("Overflow is not allowed on location '" + lastSuccessfulLocation + "' " + refQueue.toXml("") + "total number of bytes " + entrySize * (long)(numOfPersistentEntries[id] + numOfTransientEntries[it]) + " max muber of bytes: " + maxNumOfBytes[is], entrySize * (long)(numOfPersistentEntries[id] + numOfTransientEntries[it]) > maxNumOfBytes[is]);
                            this.log.info(this.ME, "SUCCESS: Exception is OK: " + e.toString());
                        }
                        ++id;
                    }
                    ++it;
                }
                ++is;
            }
            ++ic;
        }
    }

    public void testAvailability() {
        String queueType = "CACHE";
        try {
            this.availability();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing availability probably due to failed initialization of the queue of type " + queueType);
            ex.printStackTrace();
        }
    }

    public void availability() throws XmlBlasterException {
        long maxNumOfBytesCache = 10000L;
        long maxNumOfBytes = 50000L;
        int numOfTransientEntries = 200;
        int numOfPersistentEntries = 200;
        long entrySize = 100L;
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(2000L);
        prop.setMaxEntriesCache(1000L);
        prop.setMaxBytes(maxNumOfBytes);
        prop.setMaxBytesCache(maxNumOfBytesCache);
        StorageId queueId = new StorageId("callback", "CacheQueueTest/jdbc" + maxNumOfBytes + "/ram" + maxNumOfBytesCache);
        this.queue.clear();
        this.queue.shutdown();
        this.queue.initialize(queueId, prop);
        if (!this.queue.isShutdown()) {
            this.queue.shutdown();
        }
        this.queue.initialize(queueId, prop);
        this.queue.clear();
        long maxPersistentNumOfBytes = maxNumOfBytes;
        long maxTransientNumOfBytes = maxNumOfBytesCache;
        long transientNumOfBytes = 0L;
        long persistentNumOfBytes = 0L;
        int numOfEntries = 20;
        int entries1 = 5;
        int entries2 = 10;
        this.queue.clear();
        transientNumOfBytes = entrySize * (long)numOfTransientEntries;
        persistentNumOfBytes = entrySize * (long)numOfPersistentEntries;
        DummyEntry[] entries = new DummyEntry[numOfEntries];
        PriorityEnum prio = PriorityEnum.toPriorityEnum(4);
        boolean persistent = false;
        int i = 0;
        while (i < numOfEntries) {
            persistent = i % 2 == 0;
            entries[i] = new DummyEntry(this.glob, prio, this.queue.getStorageId(), entrySize, persistent);
            ++i;
        }
        int i2 = 0;
        while (i2 < entries1) {
            this.queue.put(entries[i2], false);
            ++i2;
        }
        CacheQueueInterceptorPlugin cacheQueue = this.queue;
        cacheQueue.storageUnavailable(1);
        int i3 = entries1;
        while (i3 < entries2) {
            this.queue.put(entries[i3], false);
            ++i3;
        }
        ArrayList list = this.queue.peek(-1, -1L);
        Assert.assertEquals(this.ME + " number of entries when retrieving is wrong ", entries2, list.size());
        int i4 = 0;
        while (i4 < list.size()) {
            long uniqueId = ((I_QueueEntry)list.get(i4)).getUniqueId();
            Assert.assertEquals(this.ME + " entry sequence is wrong ", entries[i4].getUniqueId(), uniqueId);
            ++i4;
        }
        long ret = 0L;
        boolean[] tmpArr = this.queue.removeRandom(list.toArray(new I_QueueEntry[list.size()]));
        int i5 = 0;
        while (i5 < tmpArr.length) {
            if (tmpArr[i5]) {
                ++ret;
            }
            ++i5;
        }
        Assert.assertEquals(this.ME + " number of entries removed is wrong ", (long)entries2, ret);
        list = this.queue.peek(-1, -1L);
        Assert.assertEquals(this.ME + " number of entries peeked after removal is wrong ", 0, list.size());
        long num = this.queue.getNumOfEntries();
        Assert.assertEquals(this.ME + " number of entries after removal is wrong ", 0L, num);
        cacheQueue.storageAvailable(0);
        list = this.queue.peek(-1, -1L);
        Assert.assertEquals(this.ME + " number of entries peeked after reconnecting is wrong ", 0, list.size());
        num = this.queue.getNumOfEntries();
        Assert.assertEquals(this.ME + " number of entries after reconnecting is wrong ", 0L, num);
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        CacheQueueTest testSub = new CacheQueueTest(glob, "CacheQueueTest");
        long startTime = System.currentTimeMillis();
        testSub.setUp();
        testSub.testAvailability();
        testSub.tearDown();
        testSub.setUp();
        testSub.testPutPeekRemove();
        testSub.tearDown();
        long usedTime = System.currentTimeMillis() - startTime;
        testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
    }
}

