/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.io.IOException;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.queuemsg.MsgQueueConnectEntry;
import org.xmlBlaster.client.queuemsg.MsgQueuePublishEntry;
import org.xmlBlaster.client.queuemsg.MsgQueueSubscribeEntry;
import org.xmlBlaster.engine.Global;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.queue.StorageId;

public class EntrySize {
    private String ME = "EntrySize";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();

    public EntrySize(Global glob) {
        this.glob = glob;
        this.ME = "EntrySize";
        this.log = glob.getLog("test");
        String testcase = this.glob.getProperty().get("testcase", "subscribe");
        if ("update".equalsIgnoreCase(testcase)) {
            this.updateEntry();
        } else if ("history".equalsIgnoreCase(testcase)) {
            this.historyEntry();
        } else if ("msgUnitWrapper".equalsIgnoreCase(testcase)) {
            this.msgUnitWrapperEntry();
        } else if ("publish".equalsIgnoreCase(testcase)) {
            this.publishEntry();
        } else if ("subscribe".equalsIgnoreCase(testcase)) {
            this.subscribeEntry();
        } else if ("connect".equalsIgnoreCase(testcase)) {
            this.connectEntry();
        } else {
            this.log.error(this.ME, "Unkonwn testcase '" + testcase + "' please provide e.g. 'publish'");
        }
    }

    public void updateEntry() {
        this.log.info(this.ME, "************ Starting updateEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        StorageId storageId = new StorageId("callback", "updateEntry");
        try {
            SessionName receiver = new SessionName(this.glob, "receiver1");
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos/>");
            MsgUnit msgUnit = new MsgUnit((org.xmlBlaster.util.Global)this.glob, "<key oid='XX'/>", new byte[0], publishQosServer.toXml());
            Global global = new Global();
            MsgUnitWrapper msgWrapper = new MsgUnitWrapper(this.glob, msgUnit, storageId);
            int step = 1000;
            int numCreate = 1000000;
            MsgQueueUpdateEntry[] entryArr = new MsgQueueUpdateEntry[numCreate];
            int i = 0;
            while (i < numCreate) {
                entryArr[i] = new MsgQueueUpdateEntry(global, msgWrapper, storageId, receiver, "__subId");
                MsgUnitWrapper w = entryArr[i].getMsgUnitWrapper();
                if (i % step == 0) {
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgQueueUpdateEntry instances, hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Dump meat: " + w.toXml());
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public void historyEntry() {
        this.log.info(this.ME, "************ Starting historyEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        StorageId storageId = new StorageId("history", "historyEntry");
        try {
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos/>");
            MsgUnit msgUnit = new MsgUnit((org.xmlBlaster.util.Global)this.glob, "<key oid='XX'/>", new byte[0], publishQosServer.toXml());
            Global global = new Global();
            MsgUnitWrapper msgWrapper = new MsgUnitWrapper(this.glob, msgUnit, storageId);
            int step = 1000;
            int numCreate = 1000000;
            MsgQueueHistoryEntry[] entryArr = new MsgQueueHistoryEntry[numCreate];
            int i = 0;
            while (i < numCreate) {
                entryArr[i] = new MsgQueueHistoryEntry(global, msgWrapper, storageId);
                MsgUnitWrapper w = entryArr[i].getMsgUnitWrapper();
                if (i % step == 0) {
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgQueueHistoryEntry instances, hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Dump meat: " + w.toXml());
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public void msgUnitWrapperEntry() {
        this.log.info(this.ME, "************ Starting msgUnitWrapperEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        try {
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos/>");
            StorageId storageId = new StorageId("msgUnitStore", "msgUnitWrapperEntry");
            int step = 1000;
            int numCreate = 1000000;
            MsgUnitWrapper[] entryArr = new MsgUnitWrapper[numCreate];
            this.log.info(this.ME, "Hit a key for new MsgUnitWrapper RAM size test ...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            int i = 0;
            while (i < numCreate) {
                MsgUnit msgUnit = new MsgUnit((org.xmlBlaster.util.Global)this.glob, "<key oid='XX'/>", new byte[0], publishQosServer.toXml());
                entryArr[i] = new MsgUnitWrapper(this.glob, msgUnit, storageId);
                if (i > 0 && i % step == 0) {
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgUnitWrapper instances, msgUnitSize=" + msgUnit.size() + ", hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public void publishEntry() {
        this.log.info(this.ME, "************ Starting publishEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        try {
            PublishQos publishQos = new PublishQos(this.glob);
            StorageId storageId = new StorageId("connection", "publishEntry");
            int step = 1000;
            int numCreate = 1000000;
            MsgQueuePublishEntry[] entryArr = new MsgQueuePublishEntry[numCreate];
            this.log.info(this.ME, "Hit a key for new MsgQueuePublishEntry RAM size test ...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            int i = 0;
            while (i < numCreate) {
                MsgUnit msgUnit = new MsgUnit((org.xmlBlaster.util.Global)this.glob, "<key oid='XX'/>", new byte[0], publishQos.toXml());
                entryArr[i] = new MsgQueuePublishEntry(this.glob, msgUnit, storageId);
                if (i > 0 && i % step == 0) {
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgQueuePublishEntry instances, msgUnitSize=" + msgUnit.size() + ", hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Dump publish meat: " + entryArr[i].toXml());
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public void subscribeEntry() {
        this.log.info(this.ME, "************ Starting subscribeEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        try {
            SubscribeQos subscribeQos = new SubscribeQos(this.glob);
            StorageId storageId = new StorageId("connection", "subscribeEntry");
            int step = 1000;
            int numCreate = 1000000;
            MsgQueueSubscribeEntry[] entryArr = new MsgQueueSubscribeEntry[numCreate];
            this.log.info(this.ME, "Hit a key for new MsgQueueSubscribeEntry RAM size test ...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            int i = 0;
            while (i < numCreate) {
                SubscribeKey sk = new SubscribeKey((org.xmlBlaster.util.Global)this.glob, "XX");
                SubscribeQos sq = new SubscribeQos(this.glob);
                entryArr[i] = new MsgQueueSubscribeEntry(this.glob, storageId, sk.getData(), sq.getData());
                if (i > 0 && i % step == 0) {
                    int loadSize = sk.toXml().length() + sq.toXml().length();
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgQueueSubscribeEntry instances, key+qos size=" + loadSize + ", hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Dump meat: " + entryArr[i].toXml());
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public void connectEntry() {
        this.log.info(this.ME, "************ Starting connectEntry " + System.getProperty("java.vm.vendor") + ": " + System.getProperty("java.vm.version"));
        try {
            StorageId storageId = new StorageId("connection", "connectEntry");
            int step = 1000;
            int numCreate = 1000000;
            MsgQueueConnectEntry[] entryArr = new MsgQueueConnectEntry[numCreate];
            this.log.info(this.ME, "Hit a key for new MsgQueueConnectEntry RAM size test ...");
            try {
                System.in.read();
            }
            catch (IOException e) {
                // empty catch block
            }
            int i = 0;
            while (i < numCreate) {
                ConnectQos connectQos = new ConnectQos(this.glob);
                entryArr[i] = new MsgQueueConnectEntry(this.glob, storageId, connectQos.getData());
                if (i > 0 && i % step == 0) {
                    this.log.info(this.ME, "Overall created #" + i + ": Created " + step + " new MsgQueueConnectEntry instances, connectQosSize=" + connectQos.size() + ", hit a key to create more ...");
                    try {
                        System.in.read();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Dump publis meat: " + entryArr[i].toXml());
                }
                ++i;
            }
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
        }
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        EntrySize entrySize = new EntrySize(glob);
    }
}

