/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.I_QueueSizeListener;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.cache.CacheQueueInterceptorPlugin;
import org.xmlBlaster.util.queuemsg.DummyEntry;
import org.xmlBlaster.util.queuemsg.MsgQueueEntry;

public class I_QueueTest
extends TestCase {
    private String ME = "I_QueueTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private I_Queue queue;
    private QueueSizeListener queueSizeListener = new QueueSizeListener();
    static String[] PLUGIN_TYPES = new String[]{new String("RAM"), new String("JDBC"), new String("CACHE")};

    public I_QueueTest(String name, int currImpl, Global glob) {
        super(name);
        this.glob = glob == null ? Global.instance() : glob;
        this.log = glob.getLog("test");
        try {
            String type = PLUGIN_TYPES[currImpl];
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(glob);
            PluginInfo pluginInfo = new PluginInfo(glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
            pluginInfo = new PluginInfo(glob, (I_PluginManager)pluginManager, type, "1.0");
            StorageId queueId = new StorageId("callback", "SomeQueueId");
            this.queue = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)new CbQueueProperty(this.glob, "callback", this.glob.getStrippedId()));
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'");
        }
    }

    protected void setUp() {
    }

    public void testConfig() {
        this.config(this.queue);
    }

    private void config(I_Queue queue) {
        this.ME = "I_QueueTest.config(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        CbQueueProperty prop1 = null;
        QueuePropertyBase prop = null;
        try {
            prop1 = new CbQueueProperty(this.glob, "callback", "/node/test");
            int max = 12;
            prop1.setMaxEntries(max);
            prop1.setMaxEntriesCache(max);
            Assert.assertEquals(this.ME + ": Wrong capacity", (long)max, prop1.getMaxEntries());
            Assert.assertEquals(this.ME + ": Wrong cache capacity", (long)max, prop1.getMaxEntriesCache());
            StorageId queueId = new StorageId("callback", "SomeQueueId");
            queue.initialize(queueId, prop1);
            Assert.assertEquals(this.ME + ": Wrong queue ID", queueId, queue.getStorageId());
            try {
                prop = new CbQueueProperty(this.glob, "subject", "/node/test");
                prop.setMaxEntries(99L);
                prop.setMaxEntriesCache(99L);
                queue.setProperties(prop);
            }
            catch (XmlBlasterException e) {
                Assert.fail("Changing properties failed");
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
        long len = prop.getMaxEntries();
        Assert.assertEquals(this.ME + ": Wrong capacity", prop.getMaxEntries(), queue.getMaxNumOfEntries());
        Assert.assertEquals(this.ME + ": Wrong capacity", prop.getMaxEntries(), ((QueuePropertyBase)queue.getProperties()).getMaxEntries());
        Assert.assertEquals(this.ME + ": Wrong size", 0L, queue.getNumOfEntries());
        try {
            int ii = 0;
            while ((long)ii < len) {
                queue.put(new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), false);
                ++ii;
            }
            Assert.assertEquals(this.ME + ": Wrong total size", len, queue.getNumOfEntries());
            try {
                DummyEntry queueEntry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                queue.put(queueEntry, false);
                queue.put(queueEntry, false);
                Assert.fail("Did expect an exception on overflow");
            }
            catch (XmlBlasterException e) {
                this.log.info(this.ME, "SUCCESS the exception is OK: " + e.getMessage());
            }
            this.log.info(this.ME, "toXml() test:" + queue.toXml(""));
            this.log.info(this.ME, "usage() test:" + queue.usage());
            Assert.assertEquals(this.ME + ": should not be shutdown", false, queue.isShutdown());
            queue.shutdown();
            Assert.assertEquals(this.ME + ": should be shutdown", true, queue.isShutdown());
            this.log.info(this.ME, "#2 Success, filled " + queue.getNumOfEntries() + " messages into queue");
            System.out.println("***" + this.ME + " [SUCCESS]");
            queue.shutdown();
            queue = null;
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testSize1() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            int max = 1;
            prop.setMaxEntries(max);
            prop.setMaxEntriesCache(max);
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/size1");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            Assert.assertEquals(this.ME, 1L, this.queue.getMaxNumOfEntries());
            this.size1(this.queue);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing Size1 probably due to failed initialization of the queue of type " + queueType);
        }
    }

    private void size1(I_Queue queue) {
        this.queue = queue;
        this.ME = "I_QueueTest.size1(" + queue.getStorageId() + ")[" + this.queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        int maxEntries = (int)queue.getMaxNumOfEntries();
        try {
            ArrayList entryList;
            block10: {
                int numLoop = 10;
                ArrayList<DummyEntry> list = new ArrayList<DummyEntry>();
                this.queue.removeQueueSizeListener(null);
                this.queue.addQueueSizeListener(this.queueSizeListener);
                this.queueSizeListener.clear();
                int ii = 0;
                while (ii < numLoop) {
                    block9: {
                        DummyEntry queueEntry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                        try {
                            queue.put(queueEntry, false);
                            Assert.assertEquals("number of entries incremented on last invocation", 1L, this.queueSizeListener.getLastIncrementEntries());
                            Assert.assertEquals("number of bytes incremented on last invocation", queueEntry.getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
                            if (ii > maxEntries) {
                                Assert.fail("Didn't expect more than " + maxEntries + " entries" + queue.toXml(""));
                            } else {
                                list.add(queueEntry);
                            }
                        }
                        catch (XmlBlasterException e) {
                            if (ii > maxEntries) break block9;
                            Assert.fail("Didn't expect exception" + e.getMessage());
                        }
                    }
                    ++ii;
                }
                Assert.assertEquals("number of invocations for queue size listener is wrong", maxEntries + 1, this.queueSizeListener.getCount());
                Assert.assertEquals(this.ME + ": Wrong total size " + queue.toXml(""), (long)(maxEntries + 1), queue.getNumOfEntries());
                this.checkSizeAndEntries(" put(I_QueueEntry) ", list, queue);
                this.log.info(this.ME, "#2 Success, filled " + queue.getNumOfEntries() + " messages into queue");
                entryList = null;
                try {
                    entryList = queue.peekLowest(1, -1L, null, false);
                    Assert.assertEquals("PEEK #1 failed" + queue.toXml(""), 1, entryList.size());
                    this.log.info(this.ME, "curr entries=" + queue.getNumOfEntries());
                }
                catch (XmlBlasterException e) {
                    if (e.getErrorCode() == ErrorCode.INTERNAL_NOTIMPLEMENTED) break block10;
                    throw e;
                }
            }
            entryList = queue.takeLowest(1, -1L, null, false);
            long singleSize = ((I_QueueEntry)entryList.get(0)).getSizeInBytes();
            long totalSize = singleSize * (long)entryList.size();
            Assert.assertEquals("TAKE #1 failed" + queue.toXml(""), 1, entryList.size());
            this.log.info(this.ME, "curr entries=" + queue.getNumOfEntries());
            Assert.assertEquals("number of entries incremented on last invocation", -1L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -singleSize, this.queueSizeListener.getLastIncrementBytes());
            entryList = queue.takeLowest(1, -1L, null, false);
            Assert.assertEquals("TAKE #2 failed" + queue.toXml(""), 1, entryList.size());
            Assert.assertEquals("number of entries incremented on last invocation", -1L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -singleSize, this.queueSizeListener.getLastIncrementBytes());
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong empty size", 0L, queue.getNumOfEntries());
            System.out.println("***" + this.ME + " [SUCCESS]");
            queue.shutdown();
            queue = null;
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
        this.log.info(this.ME, "SUCCESS");
    }

    public void testPutMsg() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/putMsg");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.putMsg(this.queue);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType);
        }
    }

    private void checkSizeAndEntries(String txt, ArrayList queueEntries, I_Queue queue) {
        this.checkSizeAndEntries(txt, queueEntries.toArray(new I_QueueEntry[queueEntries.size()]), queue);
    }

    private void checkSizeAndEntries(String txt, I_QueueEntry[] queueEntries, I_Queue queue) {
        long sizeOfTransients = 0L;
        long numOfPersistents = 0L;
        long numOfTransients = 0L;
        long sizeOfPersistents = 0L;
        int i = 0;
        while (i < queueEntries.length) {
            I_QueueEntry entry = queueEntries[i];
            if (entry.isPersistent()) {
                sizeOfPersistents += entry.getSizeInBytes();
                ++numOfPersistents;
            } else {
                sizeOfTransients += entry.getSizeInBytes();
                ++numOfTransients;
            }
            ++i;
        }
        long queueNumOfPersistents = queue.getNumOfPersistentEntries();
        long queueNumOfTransients = queue.getNumOfEntries() - queueNumOfPersistents;
        long queueSizeOfPersistents = queue.getNumOfPersistentBytes();
        long queueSizeOfTransients = queue.getNumOfBytes() - queueSizeOfPersistents;
        txt = txt + " NumPersistents=" + queueNumOfPersistents + " NumOfTransients=" + queueNumOfTransients;
        txt = txt + " SizeOfPersistents=" + queueSizeOfPersistents + " SizeOfTransients=" + queueSizeOfTransients;
        Assert.assertEquals(this.ME + ": " + txt + " wrong number of persistents   ", numOfPersistents, queueNumOfPersistents);
        Assert.assertEquals(this.ME + ": " + txt + " wrong number of transients ", numOfTransients, queueNumOfTransients);
        Assert.assertEquals(this.ME + ": " + txt + " wrong size of persistents     ", sizeOfPersistents, queueSizeOfPersistents);
        Assert.assertEquals(this.ME + ": " + txt + " wrong size of transients   ", sizeOfTransients, queueSizeOfTransients);
    }

    private void putMsg(I_Queue queue) {
        this.ME = "I_QueueTest.putMsg(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            int numLoop = 10;
            ArrayList<I_QueueEntry> list = new ArrayList<I_QueueEntry>();
            this.queue.removeQueueSizeListener(null);
            this.queue.addQueueSizeListener(this.queueSizeListener);
            this.queueSizeListener.clear();
            int ii = 0;
            while (ii < numLoop) {
                I_QueueEntry[] queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true)};
                queue.put(queueEntries, false);
                Assert.assertEquals("number of entries incremented on last invocation", 3L, this.queueSizeListener.getLastIncrementEntries());
                Assert.assertEquals("number of bytes incremented on last invocation", 3L * ((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
                int i = 0;
                while (i < 3) {
                    list.add(queueEntries[i]);
                    ++i;
                }
                this.checkSizeAndEntries(" put(I_QueueEntry[]) ", list, queue);
                Assert.assertEquals(this.ME + ": Wrong size", (long)((ii + 1) * queueEntries.length), queue.getNumOfEntries());
                ++ii;
            }
            Assert.assertEquals("number of invocations for queue size listener is wrong", numLoop, this.queueSizeListener.getCount());
            int total = numLoop * 3;
            Assert.assertEquals(this.ME + ": Wrong total size", (long)total, queue.getNumOfEntries());
            this.log.info(this.ME, "#1 Success, filled " + queue.getNumOfEntries() + " messages into queue");
            int ii2 = 0;
            while (ii2 < numLoop) {
                DummyEntry queueEntry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                list.add(queueEntry);
                queue.put(queueEntry, false);
                ++ii2;
            }
            Assert.assertEquals(this.ME + ": Wrong total size", (long)(numLoop + total), queue.getNumOfEntries());
            this.checkSizeAndEntries(" put(I_QueueEntry) ", list, queue);
            this.log.info(this.ME, "#2 Success, filled " + queue.getNumOfEntries() + " messages into queue");
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong empty size", 0L, queue.getNumOfEntries());
            System.out.println("***" + this.ME + " [SUCCESS]");
            queue.shutdown();
            queue = null;
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testPeekMsg() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/peekMsg");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.peekMsg(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing peekMsg probably due to failed initialization of the queue " + queueType);
        }
    }

    private void peekMsg(I_Queue queue) {
        this.ME = "I_QueueTest.peekMsg(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            I_QueueEntry[] queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            int ii = 0;
            while (ii < 10) {
                I_QueueEntry result = queue.peek();
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", ((MsgQueueEntry)queueEntries[0]).getUniqueId(), result.getUniqueId());
                ++ii;
            }
            queue.remove();
            int ii2 = 0;
            while (ii2 < 10) {
                I_QueueEntry result = queue.peek();
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", ((MsgQueueEntry)queueEntries[1]).getUniqueId(), result.getUniqueId());
                ++ii2;
            }
            queue.remove();
            int ii3 = 0;
            while (ii3 < 10) {
                I_QueueEntry result = queue.peek();
                Assert.assertTrue("Missing entry", result != null);
                Assert.assertEquals(this.ME + ": Wrong result", ((MsgQueueEntry)queueEntries[2]).getUniqueId(), result.getUniqueId());
                ++ii3;
            }
            queue.remove();
            int ii4 = 0;
            while (ii4 < 10) {
                I_QueueEntry result = queue.peek();
                Assert.assertTrue("Unexpected entry", result == null);
                ++ii4;
            }
            this.log.info(this.ME, "#1 Success, peek()");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            ii = -1;
            while (ii < 100) {
                ArrayList results = queue.peek(ii, -1L);
                Assert.assertTrue("Missing entry", results != null);
                int expected = ii;
                if (ii == -1 || ii >= queueEntries.length) {
                    expected = queueEntries.length;
                }
                Assert.assertEquals(this.ME + ": Wrong number of entries returned ii=" + ii, expected, results.size());
                ++ii;
            }
            queue.clear();
            this.log.info(this.ME, "#2 Success, peek(int)");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            int[] prios = new int[]{9, 7, 5};
            int j = 0;
            while (j < prios.length) {
                ii3 = 0;
                while (ii3 < 10) {
                    ArrayList results = queue.peekSamePriority(-1, -1L);
                    Assert.assertTrue("Expected results", results != null);
                    Assert.assertEquals(this.ME + ": Wrong number of 9 priorities", 4, results.size());
                    int k = 0;
                    while (k < results.size()) {
                        Assert.assertEquals(this.ME + ": Wrong priority returned", prios[j], ((I_QueueEntry)results.get(k)).getPriority());
                        ++k;
                    }
                    ++ii3;
                }
                ii4 = 0;
                while (ii4 < 4) {
                    int num = queue.remove();
                    Assert.assertEquals(this.ME + ": Expected remove", 1, num);
                    ++ii4;
                }
                ++j;
            }
            Assert.assertEquals(this.ME + ": Expected empty queue", 0L, queue.getNumOfEntries());
            this.log.info(this.ME, "#3 Success, peekSamePriority()");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MIN_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            ii = 0;
            while (ii < 10) {
                ArrayList results = queue.peekWithPriority(-1, -1L, 7, 9);
                Assert.assertTrue("Expected results", results != null);
                Assert.assertEquals(this.ME + ": Wrong number of 9 priorities", 8, results.size());
                int k = 0;
                while (k < results.size()) {
                    Assert.assertEquals(this.ME + ": Wrong priority returned", k < 4 ? 9L : 7L, (long)((I_QueueEntry)results.get(k)).getPriority());
                    ++k;
                }
                ++ii;
            }
            queue.clear();
            Assert.assertEquals(this.ME + ": Expected empty queue", 0L, queue.getNumOfEntries());
            this.log.info(this.ME, "#4 Success, peekWithPriority()");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), 80L, true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), 80L, true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), 80L, true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), 80L, true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), 80L, true)};
            queue.put(queueEntries, false);
            try {
                ArrayList results = queue.peek(100, 60L);
                Assert.assertNotNull(this.ME + ": the result should not be null");
                Assert.assertEquals(this.ME + ": Expected one entry on peek(100,60)", 1, results.size());
            }
            catch (XmlBlasterException e) {
                e.printStackTrace();
                Assert.assertTrue("An exception should not occur here " + e.getMessage(), false);
            }
            queue.clear();
            Assert.assertEquals(this.ME + ": Expected empty queue", 0L, queue.getNumOfEntries());
            this.log.info(this.ME, "#5 Success, peek(100, 60)");
            System.out.println("***" + this.ME + " [SUCCESS]");
            queue.shutdown();
        }
        catch (XmlBlasterException e) {
            e.printStackTrace();
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testRemoveWithPriority() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/removeWithPriority");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.removeWithPriority(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing removeWithpriority probably due to failed initialization of the queue " + queueType);
        }
    }

    private void removeWithPriority(I_Queue queue) {
        this.ME = "I_QueueTest.removeWithPriority(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            I_QueueEntry[] queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MIN_PRIORITY, queue.getStorageId(), true)};
            this.queue.removeQueueSizeListener(null);
            this.queue.addQueueSizeListener(this.queueSizeListener);
            this.queueSizeListener.clear();
            queue.put(queueEntries, false);
            long numRemoved = queue.removeWithPriority(-1L, -1L, 7, 9);
            Assert.assertEquals("number of invocations", 2, this.queueSizeListener.getCount());
            Assert.assertEquals("number of entries incremented on last invocation", -8L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -8L * ((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
            Assert.assertEquals(this.ME + ": Wrong number removed", 8L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", (long)(queueEntries.length - 8), queue.getNumOfEntries());
            numRemoved = queue.removeWithPriority(-1L, -1L, 27, 99);
            long sizeInBytes = (long)(queueEntries.length - 8) * ((DummyEntry)queueEntries[0]).getSizeInBytes();
            Assert.assertEquals(this.ME + ": Wrong size in bytes ", sizeInBytes, queue.getNumOfBytes());
            Assert.assertEquals(this.ME + ": Wrong number removed", 0L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong number of entries ", (long)(queueEntries.length - 8), queue.getNumOfEntries());
            queue.clear();
            this.log.info(this.ME, "#1 Success, fill and remove");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.HIGH_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.MIN_PRIORITY, queue.getStorageId(), true)};
            this.queue.removeQueueSizeListener(null);
            this.queue.addQueueSizeListener(this.queueSizeListener);
            this.queueSizeListener.clear();
            queue.put(queueEntries, false);
            numRemoved = queue.removeWithPriority(2L, -1L, 7, 9);
            Assert.assertEquals(this.ME + ": Wrong number removed", 2L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", (long)(queueEntries.length - 2), queue.getNumOfEntries());
            Assert.assertEquals("number of invocations", 2, this.queueSizeListener.getCount());
            Assert.assertEquals("number of entries incremented on last invocation", -2L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -2L * ((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
            this.log.info(this.ME, "#2 Success, fill and remove");
            queue.shutdown();
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testRemoveRandom() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/removeRandom");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.removeRandom(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing removeRandom probably due to failed initialization of the queue " + queueType);
        }
    }

    private void removeRandom(I_Queue queue) {
        this.ME = "I_QueueTest.removeRandom(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "][" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.queue.removeQueueSizeListener(null);
            this.queue.addQueueSizeListener(this.queueSizeListener);
            this.queueSizeListener.clear();
            I_QueueEntry[] queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            I_Entry[] testEntryArr = new I_QueueEntry[]{queueEntries[0]};
            long numRemoved = 0L;
            boolean[] tmpArr = queue.removeRandom(testEntryArr);
            int i = 0;
            while (i < tmpArr.length) {
                if (tmpArr[i]) {
                    ++numRemoved;
                }
                ++i;
            }
            Assert.assertEquals("number of entries incremented on last invocation", -1L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
            Assert.assertEquals(this.ME + ": Wrong number removed", 1L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", 0L, queue.getNumOfEntries());
            this.log.info(this.ME, "#1 Success, fill and random remove");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            testEntryArr = new I_QueueEntry[]{queueEntries[0], queueEntries[2]};
            numRemoved = 0L;
            tmpArr = queue.removeRandom(testEntryArr);
            i = 0;
            while (i < tmpArr.length) {
                if (tmpArr[i]) {
                    ++numRemoved;
                }
                ++i;
            }
            Assert.assertEquals("number of entries incremented on last invocation", -2L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -2L * ((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
            Assert.assertEquals(this.ME + ": Wrong number removed", 2L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", 1L, queue.getNumOfEntries());
            I_QueueEntry result = queue.peek();
            Assert.assertEquals(this.ME + ": Wrong timestamp", ((MsgQueueEntry)queueEntries[1]).getUniqueId(), result.getUniqueId());
            queue.clear();
            this.log.info(this.ME, "#2 Success, fill and random remove");
            queueEntries = new DummyEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true)};
            queue.put(queueEntries, false);
            I_Entry[] dataIdArr = new I_QueueEntry[]{new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), queueEntries[0], new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true), queueEntries[2]};
            numRemoved = 0L;
            tmpArr = queue.removeRandom(dataIdArr);
            i = 0;
            while (i < tmpArr.length) {
                if (tmpArr[i]) {
                    ++numRemoved;
                }
                ++i;
            }
            Assert.assertEquals("number of entries incremented on last invocation", -2L, this.queueSizeListener.getLastIncrementEntries());
            Assert.assertEquals("number of bytes incremented on last invocation", -2L * ((DummyEntry)queueEntries[0]).getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
            Assert.assertEquals(this.ME + ": Wrong number removed", 2L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", 1L, queue.getNumOfEntries());
            I_QueueEntry entry = queue.peek();
            Assert.assertTrue("Missing entry", (I_QueueEntry)null != entry);
            Assert.assertEquals(this.ME + ": Wrong entry removed", ((MsgQueueEntry)queueEntries[1]).getUniqueId(), entry.getUniqueId());
            queue.clear();
            this.log.info(this.ME, "#3 Success, fill and random remove");
            queueEntries = new DummyEntry[]{};
            queue.put(queueEntries, false);
            dataIdArr = new I_QueueEntry[]{};
            numRemoved = 0L;
            tmpArr = queue.removeRandom(dataIdArr);
            i = 0;
            while (i < tmpArr.length) {
                if (tmpArr[i]) {
                    ++numRemoved;
                }
                ++i;
            }
            Assert.assertEquals(this.ME + ": Wrong number removed", 0L, numRemoved);
            Assert.assertEquals(this.ME + ": Wrong size", 0L, queue.getNumOfEntries());
            queue.clear();
            this.log.info(this.ME, "#4 Success, fill and random remove");
            queue.put((I_QueueEntry[])null, false);
            long numRemoved2 = 0L;
            boolean[] tmpArr2 = queue.removeRandom((I_Entry[])null);
            int i2 = 0;
            while (i2 < tmpArr2.length) {
                if (tmpArr2[i2]) {
                    ++numRemoved2;
                }
                ++i2;
            }
            Assert.assertEquals(this.ME + ": Wrong number removed", 0L, numRemoved2);
            Assert.assertEquals(this.ME + ": Wrong size", 0L, queue.getNumOfEntries());
            queue.clear();
            this.log.info(this.ME, "#5 Success, fill and random remove");
            queue.shutdown();
            System.out.println("***" + this.ME + " [SUCCESS]");
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testTakeLowest() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/takeLowest");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.takeLowest(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing removeRandomLong probably due to failed initialization of the queue " + queueType);
        }
    }

    private final int assertCheckForTakeLowest(I_Queue queue, int numEntries, long numBytes, I_QueueEntry refEntry, boolean leaveOne, I_QueueEntry[] origEntries, int entriesLeft, int currentEntries, long size) throws XmlBlasterException {
        ArrayList list;
        String me;
        block4: {
            me = this.ME + "/" + numEntries + "/" + numBytes + "/" + leaveOne + "/" + entriesLeft + "/" + currentEntries;
            if (this.log.TRACE) {
                this.log.trace(me, "");
            }
            Assert.assertEquals(me + ": Wrong size of entry ", size, origEntries[0].getSizeInBytes());
            Assert.assertEquals(me + ": Wrong amount of entries in queue before takeLowest invocation ", (long)entriesLeft, queue.getNumOfEntries());
            Assert.assertEquals(me + ": Wrong size of entries in queue before takeLowest invocation ", size * (long)entriesLeft, queue.getNumOfBytes());
            Assert.assertEquals(me + ": Wrong amount of persistent entries in queue before takeLowest invocation ", (long)entriesLeft, queue.getNumOfPersistentEntries());
            Assert.assertEquals(me + ": Wrong size of persistent entries in queue before takeLowest invocation ", size * (long)entriesLeft, queue.getNumOfPersistentBytes());
            list = null;
            try {
                list = queue.peekLowest(numEntries, numBytes, refEntry, leaveOne);
                Assert.assertEquals(me + ": Wrong number of entries in peekLowest return ", currentEntries, list.size());
                Assert.assertEquals(me + ": Wrong number of entries in queue after peekLowest invocation ", (long)entriesLeft, queue.getNumOfEntries());
                Assert.assertEquals(me + ": Wrong number of bytes in queue after peekLowest invocation ", size * (long)entriesLeft, queue.getNumOfBytes());
                Assert.assertEquals(me + ": Wrong number of persistent bytes in queue after takeLowest invocation ", size * (long)entriesLeft, queue.getNumOfPersistentBytes());
            }
            catch (XmlBlasterException e) {
                if (e.getErrorCode() == ErrorCode.INTERNAL_NOTIMPLEMENTED) break block4;
                throw e;
            }
        }
        list = queue.takeLowest(numEntries, numBytes, refEntry, leaveOne);
        Assert.assertEquals("number of entries incremented on last invocation", (long)(-currentEntries), this.queueSizeListener.getLastIncrementEntries());
        Assert.assertEquals("number of bytes incremented on last invocation", (long)(-currentEntries) * origEntries[0].getSizeInBytes(), this.queueSizeListener.getLastIncrementBytes());
        Assert.assertEquals(me + ": Wrong number of entries in takeLowest return ", currentEntries, list.size());
        Assert.assertEquals(me + ": Wrong number of entries in queue after takeLowest invocation ", (long)(entriesLeft - currentEntries), queue.getNumOfEntries());
        Assert.assertEquals(me + ": Wrong number of bytes in queue after takeLowest invocation ", size * (long)(entriesLeft - currentEntries), queue.getNumOfBytes());
        Assert.assertEquals(me + ": Wrong number of persistent bytes in queue after takeLowest invocation ", size * (long)(entriesLeft - currentEntries), queue.getNumOfPersistentBytes());
        int i = entriesLeft - currentEntries;
        while (i < entriesLeft) {
            int j = entriesLeft - 1 - i;
            long ref = ((I_QueueEntry)list.get(j)).getUniqueId();
            Assert.assertEquals(me + ": Wrong sequence in takeLowest", origEntries[i].getUniqueId(), ref);
            ++i;
        }
        return entriesLeft - currentEntries;
    }

    private void takeLowest(I_Queue queue) {
        if (queue instanceof CacheQueueInterceptorPlugin) {
            return;
        }
        this.ME = "I_QueueTest.takeLowest(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "takeLowest test 1");
            int imax = 50;
            long size = 0L;
            long msgSize = 100L;
            int entriesLeft = imax;
            this.queue.removeQueueSizeListener(null);
            this.queue.addQueueSizeListener(this.queueSizeListener);
            this.queueSizeListener.clear();
            DummyEntry queueEntry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), msgSize, true);
            I_QueueEntry[] entries = new DummyEntry[imax];
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), msgSize, true);
                size += entries[i].getSizeInBytes();
                queue.put(entries[i], false);
                ++i;
            }
            Assert.assertEquals(this.ME + ": Wrong number put", (long)imax, queue.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong expected size in bytes of entries", msgSize * (long)imax, size);
            Assert.assertEquals(this.ME + ": Wrong size in bytes put", size, queue.getNumOfBytes());
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, -1L, null, true, entries, entriesLeft, 0, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, -1L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, -1L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, 0L, null, true, entries, entriesLeft, 0, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, 0L, null, true, entries, entriesLeft, 0, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, 0L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, 0L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, 50L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, 50L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, 50L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, 50L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, 100L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, 100L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, 100L, null, true, entries, entriesLeft, 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, 100L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, 150L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, 150L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, 150L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, 150L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, 200L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 0, 200L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 1, 200L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, 2, 200L, null, true, entries, entriesLeft, 2, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, -1L, null, true, entries, entriesLeft, entriesLeft - 1, msgSize);
            entriesLeft = this.assertCheckForTakeLowest(queue, -1, -1L, null, false, entries, entriesLeft, 1, msgSize);
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", queue.getNumOfEntries(), 0L);
            queue.clear();
            this.log.trace(this.ME, "takeLowest test 2");
            imax = 20;
            size = 0L;
            DummyEntry[] entries2 = new DummyEntry[imax];
            int i2 = 0;
            while (i2 < imax) {
                entries2[i2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                size += entries2[i2].getSizeInBytes();
                queue.put(entries2[i2], false);
                ++i2;
            }
            DummyEntry queueEntry2 = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            Assert.assertEquals(this.ME + ": Wrong number put", (long)imax, queue.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong size in bytes put", size, queue.getNumOfBytes());
            ArrayList list = queue.takeLowest(-1, -1L, queueEntry2, true);
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest return ", 0, list.size());
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", 0L, queue.getNumOfEntries());
            this.log.trace(this.ME, "takeLowest test 3");
            imax = 20;
            size = 0L;
            entries2 = new DummyEntry[imax];
            i2 = 0;
            while (i2 < imax) {
                entries2[i2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                size += entries2[i2].getSizeInBytes();
                queue.put(entries2[i2], false);
                ++i2;
            }
            queueEntry2 = entries2[6];
            Assert.assertEquals(this.ME + ": Wrong number put", (long)imax, queue.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong size in bytes put", size, queue.getNumOfBytes());
            list = queue.takeLowest(-1, -1L, queueEntry2, true);
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest return ", list.size(), imax - 6 - 1);
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", queue.getNumOfEntries(), 0L);
            this.log.trace(this.ME, "takeLowest test 4 (with entry null)");
            imax = 20;
            size = 0L;
            DummyEntry queueEntry3 = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            DummyEntry[] entries3 = new DummyEntry[imax];
            int i3 = 0;
            while (i3 < imax) {
                entries3[i3] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                size += entries3[i3].getSizeInBytes();
                queue.put(entries3[i3], false);
                ++i3;
            }
            Assert.assertEquals(this.ME + ": Wrong number put", (long)imax, queue.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong size in bytes put", size, queue.getNumOfBytes());
            list = queue.takeLowest(-1, -1L, null, true);
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest return ", list.size(), entries3.length - 1);
            int i4 = 1;
            while (i4 < imax) {
                int j = imax - 1 - i4;
                long ref = ((I_QueueEntry)list.get(j)).getUniqueId();
                Assert.assertEquals(this.ME + ": Wrong unique ID", entries3[i4].getUniqueId(), ref);
                ++i4;
            }
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", queue.getNumOfEntries(), 0L);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testWrongOrder() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/takeLowest");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + "wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.wrongOrder(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing removeRandomLong probably due to failed initialization of the queue " + queueType);
        }
    }

    private void wrongOrder(I_Queue queue) {
        this.ME = "I_QueueTest.wrongOrder(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "wrongOrder test 1");
            int imax = 5;
            long size = 0L;
            DummyEntry[] entries = new DummyEntry[imax];
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                size += entries[i].getSizeInBytes();
                ++i;
            }
            I_QueueEntry[] putEntries = new DummyEntry[imax];
            putEntries[0] = entries[3];
            putEntries[1] = entries[4];
            putEntries[2] = entries[2];
            putEntries[3] = entries[0];
            putEntries[4] = entries[1];
            queue.put(putEntries, false);
            Assert.assertEquals(this.ME + ": Wrong number put", (long)imax, queue.getNumOfEntries());
            Assert.assertEquals(this.ME + ": Wrong size in bytes put", size, queue.getNumOfBytes());
            ArrayList listPeekSamePrio = queue.peekSamePriority(-1, -1L);
            ArrayList listPeekWithPrio = queue.peekWithPriority(-1, -1L, 0, 10);
            ArrayList listPeek = queue.peek(-1, -1L);
            int i2 = 0;
            while (i2 < imax) {
                long id = entries[i2].getUniqueId();
                long idPeekSamePrio = ((I_QueueEntry)listPeekSamePrio.get(i2)).getUniqueId();
                long idPeekWithPrio = ((I_QueueEntry)listPeekWithPrio.get(i2)).getUniqueId();
                long idPeek = ((I_QueueEntry)listPeek.get(i2)).getUniqueId();
                Assert.assertEquals(this.ME + ": Wrong entry for peekSamePrio ", id, idPeekSamePrio);
                Assert.assertEquals(this.ME + ": Wrong entry for peekWithPrio ", id, idPeekWithPrio);
                Assert.assertEquals(this.ME + ": Wrong entry for peek ", id, idPeek);
                ++i2;
            }
            queue.clear();
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", queue.getNumOfEntries(), 0L);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testPutEntriesTwice() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/putEntriesTwice");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.putEntriesTwice(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing putEntriesTwice probably due to failed initialization of the queue " + queueType);
        }
    }

    private void putEntriesTwice(I_Queue queue) {
        this.ME = "I_QueueTest.putEntriesTwice(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "putEntriesTwice test 1");
            int imax = 5;
            long size = 0L;
            I_Entry[] entries = new DummyEntry[imax];
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                size += ((DummyEntry)entries[i]).getSizeInBytes();
                ++i;
            }
            queue.put((I_QueueEntry[])entries, false);
            queue.put((I_QueueEntry[])entries, false);
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries twice ", (long)imax, queue.getNumOfEntries());
            queue.removeRandom(entries);
            Assert.assertEquals(this.ME + ": Wrong size in takeLowest after cleaning ", queue.getNumOfEntries(), 0L);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testPeekWithLimitEntry() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/peekWithLimitEntry");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.peekWithLimitEntry(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing peekWithLimitEntry probably due to failed initialization of the queue " + queueType);
        }
    }

    private void peekWithLimitEntry(I_Queue queue) {
        this.ME = "I_QueueTest.peekWithLimitEntry(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "peekWithLimitEntry test 1");
            int imax = 5;
            I_Entry[] entries = new DummyEntry[imax];
            entries[0] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[3] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[1] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[4] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            queue.put((I_QueueEntry[])entries, false);
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries ", (long)imax, queue.getNumOfEntries());
            ArrayList list = queue.peekWithLimitEntry(entries[3]);
            Assert.assertEquals(this.ME + ": Wrong number of peeked entries (with limit) ", 3, list.size());
            int i = 0;
            while (i < list.size()) {
                Assert.assertEquals(this.ME + ": Wrong order in peeked entries (with limit): ", ((MsgQueueEntry)entries[i]).getUniqueId(), ((I_QueueEntry)list.get(i)).getUniqueId());
                ++i;
            }
            queue.removeRandom(entries);
            Assert.assertEquals(this.ME + ": Wrong size in peekWithLimitEntry after cleaning ", queue.getNumOfEntries(), 0L);
            this.log.trace(this.ME, "peekWithLimitEntry test 2");
            imax = 5;
            entries = new DummyEntry[imax];
            entries[0] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[3] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[1] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[4] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            DummyEntry limitEntry = new DummyEntry(this.glob, PriorityEnum.HIGH8_PRIORITY, queue.getStorageId(), true);
            queue.put((I_QueueEntry[])entries, false);
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries ", (long)imax, queue.getNumOfEntries());
            ArrayList list2 = queue.peekWithLimitEntry(limitEntry);
            Assert.assertEquals(this.ME + ": Wrong number of peeked entries (with limit) ", 0, list2.size());
            queue.removeRandom(entries);
            Assert.assertEquals(this.ME + ": Wrong size in peekWithLimitEntry after cleaning ", queue.getNumOfEntries(), 0L);
            this.log.trace(this.ME, "peekWithLimitEntry test 3");
            imax = 5;
            entries = new DummyEntry[imax];
            entries[0] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[3] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[1] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[4] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            limitEntry = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            queue.put((I_QueueEntry[])entries, false);
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries ", (long)imax, queue.getNumOfEntries());
            list2 = queue.peekWithLimitEntry(limitEntry);
            Assert.assertEquals(this.ME + ": Wrong number of peeked entries (with limit) ", imax, list2.size());
            int i2 = 0;
            while (i2 < list2.size()) {
                Assert.assertEquals(this.ME + ": Wrong order in peeked entries (with limit): ", ((MsgQueueEntry)entries[i2]).getUniqueId(), ((I_QueueEntry)list2.get(i2)).getUniqueId());
                ++i2;
            }
            queue.removeRandom(entries);
            Assert.assertEquals(this.ME + ": Wrong size in peekWithLimitEntry after cleaning ", queue.getNumOfEntries(), 0L);
            this.log.trace(this.ME, "peekWithLimitEntry test 4");
            imax = 5;
            entries = new DummyEntry[imax];
            entries[0] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[3] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[1] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            entries[4] = new DummyEntry(this.glob, PriorityEnum.LOW_PRIORITY, queue.getStorageId(), true);
            entries[2] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
            queue.put((I_QueueEntry[])entries, false);
            Assert.assertEquals(this.ME + ": Wrong number of entries after putting same entries ", (long)imax, queue.getNumOfEntries());
            list = queue.peekWithLimitEntry(null);
            Assert.assertEquals(this.ME + ": Wrong number of peeked entries (with limit) ", 0, list.size());
            queue.removeRandom(entries);
            Assert.assertEquals(this.ME + ": Wrong size in peekWithLimitEntry after cleaning ", queue.getNumOfEntries(), 0L);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testSizesCheck() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/testSizes");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.sizesCheck(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing sizesCheck probably due to failed initialization of the queue " + queueType);
        }
    }

    private void sizesCheck(I_Queue queue) {
        this.ME = "I_QueueTest.sizesCheck(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "sizesCheck test 1");
            int imax = 20;
            I_Entry[] entries = new DummyEntry[imax];
            ArrayList<I_QueueEntry> list = new ArrayList<I_QueueEntry>();
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), true);
                list.add(entries[i]);
                ++i;
            }
            queue.put((I_QueueEntry[])entries, false);
            this.checkSizeAndEntries("sizesCheck test 1: ", list, queue);
            if (queue instanceof CacheQueueInterceptorPlugin) {
                return;
            }
            ArrayList subList = queue.takeLowest(2, 100L, null, true);
            this.log.info(this.ME, "size of list before: " + list.size());
            list.remove(list.size() - 1);
            list.remove(list.size() - 1);
            this.log.info(this.ME, "size of list after: " + list.size());
            this.checkSizeAndEntries("sizesCheck test 1 (after takeLowest): ", list, queue);
            queue.removeRandom(entries);
            ((AbstractCollection)list).removeAll(list);
            this.checkSizeAndEntries("sizesCheck test 1 (after removing): ", list, queue);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testBigEntries() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/testSizes");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.bigEntries(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing sizesCheck probably due to failed initialization of the queue " + queueType);
        }
    }

    private void bigEntries(I_Queue queue) {
        this.ME = "I_QueueTest.bigEntries(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "start test");
            int imax = 3;
            long msgSize = 202010L;
            I_Entry[] entries = new DummyEntry[imax];
            ArrayList<I_Entry> list = new ArrayList<I_Entry>();
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), msgSize, true);
                list.add(entries[i]);
                ++i;
            }
            queue.put((I_QueueEntry[])entries, false);
            this.checkSizeAndEntries("sizesCheck test 1: ", list, queue);
            queue.removeRandom(entries);
            ((AbstractCollection)list).removeAll(list);
            this.checkSizeAndEntries("sizesCheck test 1 (after removing): ", list, queue);
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void testOverflow() {
        String queueType = "unknown";
        try {
            CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
            prop.setMaxEntries(1L);
            prop.setMaxEntriesCache(1L);
            queueType = this.queue.toString();
            StorageId queueId = new StorageId("callback", "QueuePlugin/testOverflow");
            this.queue.initialize(queueId, prop);
            this.queue.clear();
            Assert.assertEquals(this.ME + " wrong size before starting ", 0L, this.queue.getNumOfEntries());
            this.overflow(this.queue);
        }
        catch (XmlBlasterException ex) {
            this.log.error(this.ME, "Exception when testing overflowCheck probably due to failed initialization of the queue " + queueType);
        }
    }

    private void overflow(I_Queue queue) {
        this.ME = "I_QueueTest.overflow(" + queue.getStorageId() + ")[" + queue.getClass().getName() + "]";
        System.out.println("***" + this.ME);
        try {
            this.log.trace(this.ME, "start test");
            int imax = 4;
            long msgSize = 100L;
            boolean isPersistent = true;
            DummyEntry[] entries = new DummyEntry[imax];
            int i = 0;
            while (i < imax) {
                entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, queue.getStorageId(), msgSize, isPersistent);
                ++i;
            }
            queue.put(entries[0], false);
            queue.put(entries[1], false);
            try {
                queue.put(entries[2], false);
                Assert.assertTrue("here we expect an overflow exception", false);
            }
            catch (XmlBlasterException ex) {
                this.log.info(this.ME, "overflow: an exception here is OK since it was expected due to overflow of the queue");
            }
            try {
                queue.put(entries[3], false);
                Assert.assertTrue("here we expect an overflow exception", false);
            }
            catch (XmlBlasterException ex) {
                this.log.info(this.ME, "overflow: an exception here is OK since it was expected due to overflow of the queue");
            }
            ArrayList ret = queue.peek(4, -1L);
            Assert.assertEquals("the number of entries in the queue", 2, ret.size());
            int i2 = 0;
            while (i2 < 2) {
                Assert.assertEquals(this.ME + ".overflow: entry '" + i2 + "' in sequence is wrong", entries[i2].getUniqueId(), ((I_QueueEntry)ret.get(i2)).getUniqueId());
                ++i2;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(this.ME + ": Exception thrown: " + e.getMessage());
        }
    }

    public void tearDown() {
        try {
            this.queue.clear();
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "error when tearing down " + ex.getMessage());
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new I_QueueTest("testConfig", i, glob));
            suite.addTest(new I_QueueTest("testSize1", i, glob));
            suite.addTest(new I_QueueTest("testPutMsg", i, glob));
            suite.addTest(new I_QueueTest("testPeekMsg", i, glob));
            suite.addTest(new I_QueueTest("testRemoveRandom", i, glob));
            suite.addTest(new I_QueueTest("testRemoveWithPriority", i, glob));
            suite.addTest(new I_QueueTest("testTakeLowest", i, glob));
            suite.addTest(new I_QueueTest("testPutEntriesTwice", i, glob));
            suite.addTest(new I_QueueTest("testPeekWithLimitEntry", i, glob));
            suite.addTest(new I_QueueTest("testSizesCheck", i, glob));
            suite.addTest(new I_QueueTest("testBigEntries", i, glob));
            suite.addTest(new I_QueueTest("testOverflow", i, glob));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            I_QueueTest testSub = new I_QueueTest("I_QueueTest", i, glob);
            long startTime = System.currentTimeMillis();
            testSub.setUp();
            testSub.testConfig();
            testSub.tearDown();
            testSub.setUp();
            testSub.testSize1();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPutMsg();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPeekMsg();
            testSub.tearDown();
            testSub.setUp();
            testSub.testRemoveRandom();
            testSub.tearDown();
            testSub.setUp();
            testSub.testRemoveWithPriority();
            testSub.tearDown();
            testSub.setUp();
            testSub.testTakeLowest();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPutEntriesTwice();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPeekWithLimitEntry();
            testSub.tearDown();
            testSub.setUp();
            testSub.testSizesCheck();
            testSub.tearDown();
            testSub.setUp();
            testSub.testBigEntries();
            testSub.tearDown();
            testSub.setUp();
            testSub.testOverflow();
            testSub.tearDown();
            long usedTime = System.currentTimeMillis() - startTime;
            testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
            ++i;
        }
    }

    class QueueSizeListener
    implements I_QueueSizeListener {
        private long lastNumEntries = 0L;
        private long lastNumBytes = 0L;
        private long lastIncrementEntries = 0L;
        private long lastIncrementBytes = 0L;
        private int count = 0;

        QueueSizeListener() {
        }

        public long getLastIncrementEntries() {
            return this.lastIncrementEntries;
        }

        public long getLastIncrementBytes() {
            return this.lastIncrementBytes;
        }

        public int getCount() {
            return this.count;
        }

        public void clear() {
            this.lastNumEntries = 0L;
            this.lastNumBytes = 0L;
            this.lastIncrementEntries = 0L;
            this.lastIncrementBytes = 0L;
            this.count = 0;
        }

        public void changed(I_Queue queue, long numEntries, long numBytes) {
            this.lastIncrementEntries = numEntries - this.lastNumEntries;
            this.lastIncrementBytes = numBytes - this.lastNumBytes;
            this.lastNumEntries = numEntries;
            this.lastNumBytes = numBytes;
            ++this.count;
        }
    }
}

