/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.ReturnDataHolder;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.jdbc.JdbcConnectionPool;
import org.xmlBlaster.util.queue.jdbc.JdbcManagerCommonTable;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class JdbcManagerCommonTableTest
extends TestCase {
    private String ME = "JdbcManagerCommonTableTest";
    protected Global glob;
    protected LogChannel log;
    private JdbcManagerCommonTable manager;

    public JdbcManagerCommonTableTest(Global glob, String name) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
    }

    protected void setUp() {
        String me = this.ME + ".setUp";
        try {
            QueuePluginManager pluginManager = new QueuePluginManager(this.glob);
            PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties prop = (Properties)((Hashtable)pluginInfo.getParameters()).clone();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            JdbcConnectionPool pool = new JdbcConnectionPool();
            pool.initialize(this.glob, prop);
            this.manager = new JdbcManagerCommonTable(pool, this.glob.getEntryFactory(), pluginInfo.getTypeVersion());
            this.manager.wipeOutDB(false);
        }
        catch (Exception ex) {
            this.log.error(me, "exception occured " + ex.toString());
            Assert.assertTrue(me, false);
        }
    }

    public void testManager() {
        this.manager();
    }

    private void manager() {
        String me = this.ME + ".manager";
        this.log.info(me, "starting testing");
        try {
            boolean hasTables = this.manager.tablesCheckAndSetup(false);
            Assert.assertEquals(me + " initially the tables should not exist yet", false, hasTables);
            if (this.log.TRACE) {
                this.log.trace(me, "going to set up");
            }
            this.manager.setUp();
            this.log.info(me, "testing addition and removal of nodes");
            boolean ret = this.manager.addNode("Fritz");
            Assert.assertEquals(me + " adding the first node should give 'true'", true, ret);
            ret = this.manager.addNode("Fritz");
            Assert.assertEquals(me + " adding the second time the same node should give 'false'", false, ret);
            ret = this.manager.removeNode("Fritz");
            Assert.assertEquals(me + " removing the node the first time should give 'true'", true, ret);
            ret = this.manager.removeNode("Fritz");
            Assert.assertEquals(me + " removing the node the second time should give 'false'", false, ret);
            this.log.info(me, "testing addition and removal of queues");
            StorageId storageId = new StorageId(this.glob, "cb:queue1");
            String queueName = storageId.getStrippedId();
            try {
                this.manager.addQueue(queueName, "Fritz", 1000L, 3000L);
            }
            catch (XmlBlasterException ex) {
                Assert.assertTrue(me + " an exception here should not occur since addQueue adds also a node if it does not exist", false);
            }
            ret = this.manager.addNode("Fritz");
            if (this.log.TRACE) {
                this.log.trace(me, " re-adding the first node should give 'false'");
            }
            Assert.assertEquals(me + " re-adding the first node should give 'false' since it has been implicitly added with addQueue ", false, ret);
            ret = this.manager.addQueue(queueName, "Fritz", 1000L, 3000L);
            Assert.assertEquals(me + " adding the second time a queue should give false", ret, false);
            ret = this.manager.removeNode("Fritz");
            Assert.assertEquals(me + " removing a node the first time should give 'true'", true, ret);
            ret = this.manager.removeNode("Fritz");
            Assert.assertEquals(me + " removing a node the second time should give 'false'", false, ret);
            ret = this.manager.removeQueue(queueName, "Fritz");
            Assert.assertEquals(me + " removing a queue after removing the node should give 'false' since already deleted", false, ret);
            long size = 100L;
            DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            try {
                this.manager.addEntry(queueName, "Fritz", entry);
                Assert.assertTrue(me + " adding an entry with no queue nor node associated should fail", false);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the previous exception is expected and is OK in this context");
            }
            this.manager.addNode("Fritz");
            try {
                this.manager.addEntry(queueName, "Fritz", entry);
                Assert.assertTrue(me + " adding an entry with no queue associated should fail", false);
            }
            catch (XmlBlasterException ex) {
                this.log.info(me, "the previous exception is expected and is OK in this context");
            }
            ret = this.manager.addQueue(queueName, "Fritz", 200000L, 1000L);
            Assert.assertEquals(me + " adding a queue should be successful here ", true, ret);
            ret = this.manager.addEntry(queueName, "Fritz", entry);
            Assert.assertEquals(me + " adding an entry should give back true", true, ret);
            long totalSize = size;
            ret = this.manager.addEntry(queueName, "Fritz", entry);
            Assert.assertEquals(me + " adding an entry the second time should give back 'false'", false, ret);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            this.manager.addEntry(queueName, "Fritz", entry);
            totalSize += size;
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, false);
            this.manager.addEntry(queueName, "Fritz", entry);
            totalSize += size;
            long oldNumOfEntries = this.manager.getNumOfEntries(queueName, "Fritz");
            long oldNumOfBytes = this.manager.getNumOfBytes(queueName, "Fritz");
            entry.setPersistent(true);
            this.manager.modifyEntry(queueName, "Fritz", entry);
            long[] dataIds = new long[]{entry.getUniqueId()};
            ArrayList tmp = this.manager.getEntries(storageId, "Fritz", dataIds);
            Assert.assertEquals(me + " modified entry is not correct ", true, ((DummyEntry)tmp.get(0)).isPersistent());
            entry.setPersistent(false);
            this.manager.modifyEntry(queueName, "Fritz", entry);
            dataIds = new long[]{entry.getUniqueId()};
            tmp = this.manager.getEntries(storageId, "Fritz", dataIds);
            Assert.assertEquals(me + " modified entry is not correct ", false, ((DummyEntry)tmp.get(0)).isPersistent());
            Assert.assertEquals(me + " modification did change the number of entries", oldNumOfEntries, this.manager.getNumOfEntries(queueName, "Fritz"));
            Assert.assertEquals(me + " modification did change the number of bytes", oldNumOfBytes, this.manager.getNumOfBytes(queueName, "Fritz"));
            long numOfBytes = this.manager.getNumOfBytes(queueName, "Fritz");
            Assert.assertEquals(me + " num of bytes in queue 'queue1'", totalSize, numOfBytes);
            this.manager.deleteAllTransient(queueName, "Fritz");
            numOfBytes = this.manager.getNumOfBytes(queueName, "Fritz");
            Assert.assertEquals(me + " num of bytes in queue 'queue1' after deleting transients", totalSize -= size, numOfBytes);
            ReturnDataHolder retHolder = this.manager.getAndDeleteLowest(storageId, "Fritz", 2, -1L, 10, -1L, false, true);
            Assert.assertEquals(me + " getAndDeleteLowest check", 2L, retHolder.countEntries);
            long[] entriesToDelete = new long[2];
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            entriesToDelete[0] = entry.getUniqueId();
            this.manager.addEntry(queueName, "Fritz", entry);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            this.manager.addEntry(queueName, "Fritz", entry);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            entriesToDelete[1] = entry.getUniqueId();
            this.manager.addEntry(queueName, "Fritz", entry);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            this.manager.addEntry(queueName, "Fritz", entry);
            boolean[] tmpArr = this.manager.deleteEntries(queueName, "Fritz", entriesToDelete);
            int numOfDel = 0;
            int i = 0;
            while (i < tmpArr.length) {
                if (tmpArr[i]) {
                    ++numOfDel;
                }
                ++i;
            }
            Assert.assertEquals(me + " deleteEntries check", 2, numOfDel);
            retHolder = this.manager.deleteFirstEntries(queueName, "Fritz", 1L, 10000L);
            Assert.assertEquals(me + " deleteFirstEntries check", 1L, retHolder.countEntries);
            ArrayList arrayList = this.manager.getEntriesByPriority(storageId, "Fritz", -1, -1L, 0, 9);
            Assert.assertEquals(me + " getEntriesByPriority check", 1, arrayList.size());
            long[] entriesToGet = new long[2];
            entry = new DummyEntry(this.glob, PriorityEnum.MAX_PRIORITY, storageId, size, true);
            entriesToGet[0] = entry.getUniqueId();
            this.manager.addEntry(queueName, "Fritz", entry);
            arrayList = this.manager.getEntriesBySamePriority(storageId, "Fritz", -1, -1L);
            Assert.assertEquals(me + " getEntriesBySamePriority check", 1, arrayList.size());
            arrayList = this.manager.getEntries(storageId, "Fritz", -1, -1L);
            Assert.assertEquals(me + " getEntries check", 2, arrayList.size());
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, storageId, size, true);
            entriesToGet[1] = entry.getUniqueId();
            this.manager.addEntry(queueName, "Fritz", entry);
            arrayList = this.manager.getEntriesWithLimit(storageId, "Fritz", entry);
            Assert.assertEquals(me + " getEntriesWithLimit check", 2, arrayList.size());
            arrayList = this.manager.getEntries(storageId, "Fritz", entriesToGet);
            Assert.assertEquals(me + " getEntries check", 2, arrayList.size());
            long num = this.manager.getNumOfEntries(queueName, "Fritz");
            Assert.assertEquals(me + " getNumOfEntries check", 3L, num);
            num = this.manager.getNumOfPersistents(queueName, "Fritz");
            Assert.assertEquals(me + " getNumOfPersistents check", 3L, num);
            num = this.manager.getSizeOfPersistents(queueName, "Fritz");
            Assert.assertEquals(me + " getSizeOfPersistents check", 3L * size, num);
            boolean pingOK = this.manager.ping();
            Assert.assertEquals(me + " check ping command", true, pingOK);
            int numOfPings = this.glob.getProperty().get("numOfPings", 0);
            int i2 = 0;
            while (i2 < numOfPings) {
                this.log.info(this.ME, "going to ping");
                this.manager.ping();
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                ++i2;
            }
            this.log.info(me, "successfully completed the tests");
        }
        catch (Exception ex) {
            Assert.assertEquals(me + " exception occured when testing 'manager' " + ex.toString(), 0, 1);
        }
    }

    public void tearDown() {
        String me = this.ME + ".tearDown";
        try {
            this.manager.wipeOutDB(false);
        }
        catch (Exception ex) {
            this.log.error(me, "exception occured " + ex.toString());
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        suite.addTest(new JdbcManagerCommonTableTest(glob, "testJdbcManagerCommonTable"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        glob.init(args);
        JdbcManagerCommonTableTest testSub = new JdbcManagerCommonTableTest(glob, "JdbcManagerCommonTableTest");
        testSub.setUp();
        testSub.testManager();
        testSub.tearDown();
    }
}

