/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.qos.storage.QueuePropertyBase;
import org.xmlBlaster.util.queue.I_Entry;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queue.jdbc.JdbcConnectionPool;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class JdbcQueueTest
extends TestCase {
    int exceptionCount = 0;
    private String ME = "JdbcQueueTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private int numOfQueues = 10;
    private int numOfMsg = 10000;
    private long sizeOfMsg = 100L;
    private I_Queue queue = null;
    public ArrayList queueList = null;
    public static String[] PLUGIN_TYPES = new String[]{new String("JDBC")};
    public int count = 0;
    boolean suppressTest = false;
    boolean doExecute = true;

    public JdbcQueueTest(Global glob, String name, int currImpl, boolean doExecute) {
        super(name);
        this.doExecute = doExecute;
        this.initialize(glob, name, currImpl);
    }

    private void initialize(Global glob, String name, int currImpl) {
        this.glob = Global.instance();
        this.log = glob.getLog(null);
        this.numOfQueues = glob.getProperty().get("queues", 2);
        this.numOfMsg = glob.getProperty().get("entries", 100);
        this.sizeOfMsg = glob.getProperty().get("sizes", 10L);
        this.suppressTest = false;
        this.count = currImpl;
        try {
            String type = PLUGIN_TYPES[currImpl];
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(glob);
            PluginInfo pluginInfo = new PluginInfo(glob, (I_PluginManager)pluginManager, type, "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            CbQueueProperty cbProp = new CbQueueProperty(glob, "callback", "/node/test");
            StorageId queueId = new StorageId("callback", "SetupQueue");
            this.queue = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'");
        }
    }

    protected void setUp() {
        this.log = this.glob.getLog("test");
        try {
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            this.ME = "JdbcQueueTest with class: " + PLUGIN_TYPES[this.count];
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'" + ex.getMessage());
        }
        Object prop = null;
        try {
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
            this.suppressTest = true;
        }
    }

    public void tearDown() {
        try {
            this.queue.clear();
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp " + ex.getMessage());
        }
    }

    public void testPutWithBreak() {
        if (this.suppressTest) {
            this.log.error(this.ME, "JDBC test is not driven as no database was found");
            return;
        }
        try {
            if (this.doExecute) {
                this.putWithBreak();
            } else {
                this.log.warn(this.ME, "test desactivated since needs to be run manually");
                this.log.warn(this.ME, "please invoke it as 'java org.xmlBlaster.test.classtest.queue.JdbcQueueTest'");
            }
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutWithBreak probably due to failed initialization of the queue of type " + PLUGIN_TYPES[this.count] + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void putWithBreak() throws XmlBlasterException {
        String me = this.ME + ".putWithBreak";
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(10000L);
        StorageId queueId = new StorageId("callback", "putWithBreak");
        this.queue.initialize(queueId, prop);
        this.queue.clear();
        int num = 30;
        boolean success = false;
        int i = 0;
        while (i < num) {
            try {
                this.log.info(me, "put with break entry " + i + "/" + num + " please kill the DB manually to test reconnect");
                DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), this.sizeOfMsg, true);
                this.queue.put(entry, false);
                try {
                    Thread.sleep(5000L);
                }
                catch (Exception ex) {}
            }
            catch (XmlBlasterException ex) {
                if (this.log.TRACE) {
                    this.log.trace(me, ex.getMessage());
                }
                if ("resource.db.unavailable".equalsIgnoreCase(ex.getErrorCodeStr())) {
                    this.log.info(me, "the communication to the db has been lost");
                    success = true;
                    break;
                }
                throw ex;
            }
            ++i;
        }
        Assert.assertTrue(me + ": Timed out when waiting to loose the connection to the DB", success);
        success = false;
        this.log.info(me, "preparing to reconnect again ...");
        int i2 = 0;
        while (i2 < num) {
            try {
                this.log.info(me, "put with break entry " + i2 + "/" + num + " please restart the the DB to test reconnect");
                DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), this.sizeOfMsg, true);
                this.queue.put(entry, false);
                this.log.info(me, "the communication to the db has been reestablished");
                success = true;
                break;
            }
            catch (XmlBlasterException ex) {
                if (this.log.TRACE) {
                    this.log.trace(me, ex.getMessage());
                }
                if ("resource.db.unavailable".equalsIgnoreCase(ex.getErrorCodeStr())) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {}
                } else {
                    throw ex;
                }
                ++i2;
            }
        }
        Assert.assertTrue(me + ": Timed out when waiting to regain the connection to the DB", success);
        this.log.info(me, "successfully ended");
    }

    public void testInitialEntries() {
        if (this.suppressTest) {
            this.log.error(this.ME, "JDBC test is not driven as no database was found");
            return;
        }
        try {
            this.initialEntries();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing InitialEntries probably due to failed initialization of the queue of type " + PLUGIN_TYPES[this.count] + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void initialEntries() throws XmlBlasterException {
        this.log.info(this.ME, "initialEntries test starts");
        CbQueueProperty cbProp = new CbQueueProperty(this.glob, "callback", "/node/test");
        cbProp.setMaxEntries(10000L);
        cbProp.setMaxBytes(200000L);
        StorageId queueId = new StorageId("callback", "initialEntries");
        try {
            String type = PLUGIN_TYPES[this.count];
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(this.glob);
            PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, type, "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            I_Queue tmpQueue = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            tmpQueue.clear();
            DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), 100L, true);
            tmpQueue.put(entry, false);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), 100L, true);
            tmpQueue.put(entry, false);
            entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), 100L, true);
            tmpQueue.put(entry, false);
            tmpQueue.shutdown();
            I_Queue tmpQueue2 = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            long numOfEntries = tmpQueue2.getNumOfEntries();
            Assert.assertEquals("Wrong number of entries in queue", 3L, numOfEntries);
            ArrayList lst = tmpQueue2.peek(-1, -1L);
            Assert.assertEquals("Wrong number of entries retrieved from queue", 3, lst.size());
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'");
            ex.printStackTrace();
            Assert.assertTrue("exception occured when testing initialEntries", false);
        }
        this.log.info(this.ME, "initialEntries test successfully ended");
    }

    public void testMultiplePut() {
        try {
            this.multiplePut();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing multiplePut probably due to failed initialization of the queue of type " + PLUGIN_TYPES[this.count] + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void multiplePut() throws XmlBlasterException {
        this.log.info(this.ME, "initialEntries test starts");
        CbQueueProperty cbProp = new CbQueueProperty(this.glob, "callback", "/node/test");
        cbProp.setMaxEntries(10000L);
        cbProp.setMaxBytes(200000L);
        StorageId queueId = new StorageId("callback", "initialEntries");
        try {
            String type = PLUGIN_TYPES[this.count];
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = new QueuePluginManager(this.glob);
            PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, type, "1.0");
            Properties prop = pluginInfo.getParameters();
            ((Hashtable)prop).put("tableNamePrefix", "TEST");
            ((Hashtable)prop).put("nodesTableName", "_nodes");
            ((Hashtable)prop).put("queuesTableName", "_queues");
            ((Hashtable)prop).put("entriesTableName", "_entries");
            I_Queue tmpQueue = pluginManager.getPlugin(pluginInfo, queueId, (QueuePropertyBase)cbProp);
            tmpQueue.clear();
            int nmax = 1;
            int size = 100;
            int j = 0;
            while (j < 4) {
                I_Entry[] entries = new DummyEntry[nmax];
                int i = 0;
                while (i < nmax) {
                    entries[i] = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), size, true);
                    ++i;
                }
                long time1 = System.currentTimeMillis();
                tmpQueue.put((I_QueueEntry[])entries, false);
                long delta = System.currentTimeMillis() - time1;
                this.log.info(this.ME, "multiple put '" + nmax + "' entries took '" + 0.001 * (double)delta + "' seconds which is '" + 1.0 * (double)delta / (double)nmax + "' ms per entry");
                ArrayList list = tmpQueue.peek(-1, -1L);
                Assert.assertEquals("Wrong number of entries in queue", nmax, list.size());
                time1 = System.currentTimeMillis();
                tmpQueue.removeRandom(entries);
                delta = System.currentTimeMillis() - time1;
                this.log.info(this.ME, "multiple remove '" + nmax + "' entries took '" + 0.001 * (double)delta + "' seconds which is '" + 1.0 * (double)delta / (double)nmax + "' ms per entry");
                tmpQueue.clear();
                time1 = System.currentTimeMillis();
                int i2 = 0;
                while (i2 < nmax) {
                    tmpQueue.put((I_QueueEntry)entries[i2], false);
                    ++i2;
                }
                delta = System.currentTimeMillis() - time1;
                this.log.info(this.ME, "repeated single put '" + nmax + "' entries took '" + 0.001 * (double)delta + "' seconds which is '" + 1.0 * (double)delta / (double)nmax + "' ms per entry");
                time1 = System.currentTimeMillis();
                int i3 = 0;
                while (i3 < nmax) {
                    tmpQueue.removeRandom(entries[i3]);
                    ++i3;
                }
                delta = System.currentTimeMillis() - time1;
                this.log.info(this.ME, "repeated single remove '" + nmax + "' entries took '" + 0.001 * (double)delta + "' seconds which is '" + 1.0 * (double)delta / (double)nmax + "' ms per entry");
                nmax *= 10;
                ++j;
            }
            tmpQueue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'");
            ex.printStackTrace();
            Assert.assertTrue("exception occured when testing initialEntries", false);
        }
        this.log.info(this.ME, "initialEntries test successfully ended");
    }

    public void testConnectionPool() {
        try {
            String me = this.ME + "-testConnectionPool";
            this.log.info(me, " starting ");
            int numConn = 3;
            int maxWaitingThreads = 10;
            Global ownGlobal = this.glob.getClone(null);
            QueuePluginManager pluginManager = new QueuePluginManager(ownGlobal);
            PluginInfo pluginInfo = new PluginInfo(ownGlobal, (I_PluginManager)pluginManager, "JDBC", "1.0");
            ((Hashtable)pluginInfo.getParameters()).put("connectionBusyTimeout", "10000");
            ((Hashtable)pluginInfo.getParameters()).put("maxWaitingThreads", "" + maxWaitingThreads);
            ((Hashtable)pluginInfo.getParameters()).put("connectionPoolSize", "" + numConn);
            JdbcConnectionPool pool = new JdbcConnectionPool();
            pool.initialize(ownGlobal, pluginInfo.getParameters());
            Connection[] conn = new Connection[numConn];
            int i = 0;
            while (i < numConn) {
                this.log.info(me, " getting connection " + i);
                conn[i] = pool.getConnection();
                Assert.assertNotNull("The connection " + i + " shall not be null", conn[i]);
                ++i;
            }
            this.log.info(me, " getting extra connection");
            Connection extraConn = null;
            try {
                extraConn = pool.getConnection();
                Assert.assertTrue("An Exception should have occured here: ", false);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Assert.assertNull("the extra connection should be null", extraConn);
            pool.releaseConnection(conn[0]);
            extraConn = pool.getConnection();
            Assert.assertNotNull("the extra connection should not be null", extraConn);
            this.exceptionCount = 0;
            int expectedEx = 4;
            int i2 = 0;
            while (i2 < maxWaitingThreads + expectedEx) {
                ConnectionConsumer cc = new ConnectionConsumer(pool, i2);
                ++i2;
            }
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            Assert.assertEquals("Number of exceptions due to too many waiting threads is wrong", expectedEx, this.exceptionCount);
            this.log.info(me, " successfully ended ");
        }
        catch (Exception ex) {
            Assert.fail("Exception when testing multiplePut probably due to failed initialization of the queue of type " + PLUGIN_TYPES[this.count] + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new JdbcQueueTest(glob, "testConnectionPool", i, true));
            suite.addTest(new JdbcQueueTest(glob, "testMultiplePut", i, true));
            suite.addTest(new JdbcQueueTest(glob, "testPutWithBreak", i, false));
            suite.addTest(new JdbcQueueTest(glob, "testInitialEntries", i, true));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            JdbcQueueTest testSub = new JdbcQueueTest(glob, "JdbcQueueTest", i, true);
            testSub.setUp();
            testSub.testConnectionPool();
            testSub.tearDown();
            testSub.setUp();
            testSub.testMultiplePut();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPutWithBreak();
            testSub.tearDown();
            testSub.setUp();
            testSub.testInitialEntries();
            testSub.tearDown();
            ++i;
        }
    }

    public class ConnectionConsumer
    extends Thread {
        private JdbcConnectionPool pool;
        private int count;
        static /* synthetic */ Class class$org$xmlBlaster$test$classtest$queue$JdbcQueueTest;

        public ConnectionConsumer(JdbcConnectionPool pool, int count) {
            this.pool = pool;
            this.count = count;
            this.start();
        }

        public void run() {
            block6: {
                try {
                    JdbcQueueTest.this.log.info(JdbcQueueTest.this.ME, "connectionConsumer " + this.count + " starting");
                    Connection conn = this.pool.getConnection();
                    JdbcQueueTest.this.log.info(JdbcQueueTest.this.ME, "connectionConsumer " + this.count + " got the connection " + conn);
                    if (conn != null) {
                        this.pool.releaseConnection(conn);
                    }
                }
                catch (XmlBlasterException ex) {
                    JdbcQueueTest.this.log.info(JdbcQueueTest.this.ME, "connectionConsumer exception " + ex.getMessage());
                    if (!ex.getErrorCode().getErrorCode().equals(ErrorCode.RESOURCE_TOO_MANY_THREADS.getErrorCode())) break block6;
                    Class clazz = class$org$xmlBlaster$test$classtest$queue$JdbcQueueTest == null ? (class$org$xmlBlaster$test$classtest$queue$JdbcQueueTest = ConnectionConsumer.class$("org.xmlBlaster.test.classtest.queue.JdbcQueueTest")) : class$org$xmlBlaster$test$classtest$queue$JdbcQueueTest;
                    synchronized (clazz) {
                        ++JdbcQueueTest.this.exceptionCount;
                    }
                }
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

