/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;
import org.xmlBlaster.util.queuemsg.DummyEntry;

public class QueueExtendedTest
extends TestCase {
    private String ME = "QueueExtendedTest";
    protected org.xmlBlaster.engine.Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private int numOfQueues = 10;
    private int numOfMsg = 10000;
    private int sizeOfMsg = 100;
    private I_Queue[] queues = null;
    public ArrayList queueList = null;
    public static String[] PLUGIN_TYPES = new String[]{new String("RAM"), new String("JDBC"), new String("CACHE")};
    public int count = 0;

    public QueueExtendedTest(org.xmlBlaster.engine.Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.ME = "QueueExtendedTest with class: " + PLUGIN_TYPES[currImpl];
        this.numOfQueues = glob.getProperty().get("queues", 2);
        this.numOfMsg = glob.getProperty().get("entries", 100);
        this.sizeOfMsg = glob.getProperty().get("sizes", 10);
        this.count = currImpl;
        try {
            glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = this.glob.getQueuePluginManager();
            PluginInfo pluginInfo = new PluginInfo((Global)glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties pluginProp = pluginInfo.getParameters();
            ((Hashtable)pluginProp).put("tableNamePrefix", "TEST");
            ((Hashtable)pluginProp).put("nodesTableName", "_nodes");
            ((Hashtable)pluginProp).put("queuesTableName", "_queues");
            ((Hashtable)pluginProp).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
        }
    }

    protected void setUp() {
    }

    public void tearDown() {
        if (this.queues != null) {
            int i = 0;
            while (i < this.queues.length) {
                try {
                    this.queues[i].clear();
                    this.queues[i].shutdown();
                }
                catch (Exception ex) {
                    this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp " + ex.getMessage());
                }
                ++i;
            }
        }
    }

    public void testPerfomancePut() {
        String queueType = "unknown";
        try {
            this.performancePut(this.numOfQueues, this.numOfMsg, this.sizeOfMsg);
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType + ": " + ex.getMessage());
        }
    }

    public void performancePut(int numOfQueues, int numOfMsg, int sizeOfMsg) throws XmlBlasterException {
        int i;
        this.queues = new I_Queue[numOfQueues];
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        this.log.info(this.ME, "performancePut: number of queues: " + numOfQueues + ", number of messages per queue: " + numOfMsg + ", size of each message: " + sizeOfMsg);
        prop.setMaxEntries(numOfMsg + 1);
        this.log.info(this.ME, "starting setting up " + numOfQueues + " queues");
        long t0 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < numOfQueues) {
            StorageId queueId = new StorageId("callback", "perfomance/Put_" + i2);
            this.queues[i2] = this.glob.getQueuePluginManager().getPlugin(PLUGIN_TYPES[this.count], "1.0", queueId, prop);
            this.queues[i2].clear();
            ++i2;
        }
        long t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "setting up " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        ArrayList<DummyEntry> entryList = new ArrayList<DummyEntry>(numOfMsg * numOfQueues);
        t0 = System.currentTimeMillis();
        int j = 0;
        while (j < numOfMsg) {
            i = 0;
            while (i < numOfQueues) {
                DummyEntry entry = new DummyEntry((Global)this.glob, PriorityEnum.NORM_PRIORITY, this.queues[i].getStorageId(), sizeOfMsg, true);
                entryList.add(entry);
                this.queues[i].put(entry, false);
                ++i;
            }
            ++j;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "putting " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        t0 = System.currentTimeMillis();
        i = 0;
        while (i < numOfQueues) {
            this.queues[i].peek(numOfMsg, -1L);
            ++i;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "peek in one sweep " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        t0 = System.currentTimeMillis();
        int j2 = 0;
        while (j2 < numOfMsg) {
            int i3 = 0;
            while (i3 < numOfQueues) {
                this.queues[i3].removeRandom((DummyEntry)entryList.get(i3 + j2 * numOfQueues));
                ++i3;
            }
            ++j2;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "remove one by one " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
    }

    public void testPerfomanceMultiPut() {
        String queueType = "unknown";
        try {
            this.performanceMultiPut(this.numOfQueues, this.numOfMsg, this.sizeOfMsg);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing PutMsg probably due to failed initialization of the queue of type " + queueType + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void performanceMultiPut(int numOfQueues, int numOfMsg, int sizeOfMsg) throws XmlBlasterException {
        int j;
        this.queues = new I_Queue[numOfQueues];
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(numOfMsg + 1);
        this.log.info(this.ME, "starting setting up " + numOfQueues + " queues");
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < numOfQueues) {
            StorageId queueId = new StorageId("callback", "perfomance/MultiPut_" + i);
            this.queues[i] = this.glob.getQueuePluginManager().getPlugin(PLUGIN_TYPES[this.count], "1.0", queueId, prop);
            this.queues[i].clear();
            ++i;
        }
        long t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "setting up " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        ArrayList<I_QueueEntry> entryList = new ArrayList<I_QueueEntry>(numOfQueues * numOfMsg);
        t0 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < numOfQueues) {
            I_QueueEntry[] entries = new DummyEntry[numOfMsg];
            j = 0;
            while (j < numOfMsg) {
                entries[j] = new DummyEntry((Global)this.glob, PriorityEnum.NORM_PRIORITY, this.queues[i2].getStorageId(), sizeOfMsg, true);
                entryList.add(entries[j]);
                ++j;
            }
            this.queues[i2].put(entries, false);
            ++i2;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "multi-putting " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        t0 = System.currentTimeMillis();
        int j2 = 0;
        while (j2 < numOfMsg) {
            int i3 = 0;
            while (i3 < numOfQueues) {
                I_QueueEntry entry = this.queues[i3].peek();
                this.queues[i3].removeRandom(entry);
                ++i3;
            }
            ++j2;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "peek /removeRandom one by one " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        t0 = System.currentTimeMillis();
        j = 0;
        while (j < numOfMsg) {
            int i4 = 0;
            while (i4 < numOfQueues) {
                this.queues[i4].removeRandom((I_QueueEntry)entryList.get(i4 + j * numOfQueues));
                ++i4;
            }
            ++j;
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "remove one by one " + numOfMsg + " messages in " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new QueueExtendedTest(glob, "testPerfomancePut", i));
            suite.addTest(new QueueExtendedTest(glob, "testPerfomanceMultiPut", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            QueueExtendedTest testSub = new QueueExtendedTest(glob, "QueueExtendedTest", i);
            long startTime = System.currentTimeMillis();
            testSub.setUp();
            testSub.testPerfomancePut();
            testSub.tearDown();
            testSub.setUp();
            testSub.testPerfomanceMultiPut();
            testSub.tearDown();
            long usedTime = System.currentTimeMillis() - startTime;
            testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
            ++i;
        }
    }
}

