/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.engine.MsgUnitWrapper;
import org.xmlBlaster.engine.qos.PublishQosServer;
import org.xmlBlaster.engine.queuemsg.MsgQueueHistoryEntry;
import org.xmlBlaster.engine.queuemsg.MsgQueueUpdateEntry;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.MsgQosData;
import org.xmlBlaster.util.qos.MsgQosSaxFactory;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.I_QueueEntry;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;

public class QueueServerEntryTest
extends TestCase {
    private String ME = "QueueServerEntryTest";
    protected org.xmlBlaster.engine.Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private int numOfQueues = 10;
    private int numOfMsg = 10000;
    private int sizeOfMsg = 100;
    private I_Queue queue = null;
    public ArrayList queueList = null;
    public static String[] PLUGIN_TYPES = new String[]{new String("RAM"), new String("JDBC"), new String("CACHE")};
    public int count = 0;

    public QueueServerEntryTest(org.xmlBlaster.engine.Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.ME = "QueueServerEntryTest with class: " + PLUGIN_TYPES[this.count];
        this.log = glob.getLog("test");
        this.numOfQueues = glob.getProperty().get("queues", 2);
        this.numOfMsg = glob.getProperty().get("entries", 100);
        this.sizeOfMsg = glob.getProperty().get("sizes", 10);
        this.count = currImpl;
        try {
            glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            QueuePluginManager pluginManager = this.glob.getQueuePluginManager();
            PluginInfo pluginInfo = new PluginInfo((Global)glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties pluginProp = pluginInfo.getParameters();
            ((Hashtable)pluginProp).put("tableNamePrefix", "TEST");
            ((Hashtable)pluginProp).put("nodesTableName", "_nodes");
            ((Hashtable)pluginProp).put("queuesTableName", "_queues");
            ((Hashtable)pluginProp).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
            CbQueueProperty cbProp = new CbQueueProperty(glob, "callback", "/node/test");
            StorageId queueId = new StorageId("callback", "updateEntry");
            this.queue = pluginManager.getPlugin(PLUGIN_TYPES[currImpl], "1.0", queueId, cbProp);
            this.queue.shutdown();
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
        }
    }

    protected void setUp() {
        try {
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            this.ME = "QueueServerEntryTest with class: " + PLUGIN_TYPES[this.count];
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'" + ex.getMessage());
        }
        if (this.queue != null) {
            this.queue.shutdown();
        }
    }

    public void tearDown() {
        if (this.queue != null) {
            try {
                this.queue.clear();
                this.queue.shutdown();
                this.queue = null;
            }
            catch (Exception ex) {
                this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp " + ex.getMessage());
            }
        }
    }

    public void testUpdateEntry() {
        String queueType = "unknown";
        try {
            this.updateEntry();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing UpdateEntry probably due to failed initialization of the queue of type " + queueType + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void updateEntry() throws XmlBlasterException {
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        this.log.info(this.ME, "************ Starting updateEntry Test");
        long t0 = System.currentTimeMillis();
        StorageId queueId = new StorageId("callback", "updateEntry");
        this.queue.initialize(queueId, prop);
        this.queue.clear();
        long t1 = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        try {
            byte[] content = "this is the content".getBytes();
            PublishKey key = new PublishKey((Global)this.glob, "someKey");
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos><persistent/></qos>");
            MsgQosData msgQosData = publishQosServer.getData();
            ((MsgQosSaxFactory)this.glob.getMsgQosFactory()).sendRemainingLife(false);
            String state = "EXPIRED";
            msgQosData.setState(state);
            msgQosData.setSubscriptionId("someId");
            msgQosData.setPersistent(true);
            msgQosData.setForceUpdate(false);
            msgQosData.setReadonly(true);
            msgQosData.setSender(new SessionName(this.glob, "somebody"));
            msgQosData.setRedeliver(4);
            msgQosData.setQueueSize(1000L);
            msgQosData.setQueueIndex(500L);
            msgQosData.setPriority(PriorityEnum.LOW4_PRIORITY);
            msgQosData.setFromPersistenceStore(true);
            msgQosData.setLifeTime(4000L);
            msgQosData.setRemainingLifeStatic(6000L);
            MsgUnit msgUnit = new MsgUnit(key.toXml(), content, msgQosData.toXml());
            this.log.trace(this.ME, "Testing" + msgQosData.toXml());
            SessionName receiver = new SessionName(this.glob, "receiver1");
            String subscriptionId = "subid";
            int redeliverCounter = 2;
            org.xmlBlaster.engine.Global global = new org.xmlBlaster.engine.Global();
            MsgUnitWrapper msgWrapper = new MsgUnitWrapper(this.glob, msgUnit, this.queue.getStorageId());
            MsgQueueUpdateEntry entry = new MsgQueueUpdateEntry(global, msgWrapper, this.queue.getStorageId(), receiver, subscriptionId);
            entry.incrRedeliverCounter();
            entry.incrRedeliverCounter();
            this.queue.put(entry, false);
            I_QueueEntry returnEntry = this.queue.peek();
            boolean isUpdate = returnEntry instanceof MsgQueueUpdateEntry;
            Assert.assertTrue("updateEntry: the return value is not an update ", isUpdate);
            MsgQueueUpdateEntry updateEntry = (MsgQueueUpdateEntry)returnEntry;
            Assert.assertEquals("The subscriptionId of the entry is different ", subscriptionId, updateEntry.getSubscriptionId());
            Assert.assertEquals("The state of the entry is different ", state, updateEntry.getState());
            Assert.assertEquals("The redeliverCounter of the entry is different ", redeliverCounter, updateEntry.getRedeliverCounter());
            Assert.assertEquals("The priority of the entry is different ", entry.getPriority(), updateEntry.getPriority());
            Assert.assertEquals("The persistent of the entry is different ", entry.isPersistent(), updateEntry.isPersistent());
            Assert.assertEquals("The receiver of the entry is different ", entry.getReceiver().toString(), updateEntry.getReceiver().toString());
            Assert.assertEquals("The uniqueId of the entry is different ", entry.getUniqueId(), updateEntry.getUniqueId());
            Assert.assertEquals("The msgUnitWrapperUniqueId of the entry is different ", entry.getMsgUnitWrapperUniqueId(), updateEntry.getMsgUnitWrapperUniqueId());
            Assert.assertEquals("The topic oid of the entry is different ", entry.getKeyOid(), updateEntry.getKeyOid());
            Assert.assertEquals("The topic oid of the entry is different ", entry.getStorageId().getId(), updateEntry.getStorageId().getId());
            this.log.info(this.ME, "SUCCESS: MsgQueueUpdateEntry: Persistent fields are read as expected");
            MsgUnit retMsgUnit = null;
            try {
                retMsgUnit = updateEntry.getMsgUnit();
            }
            catch (Throwable e) {
                this.log.error(this.ME, "Lookup failed, probably engine.Global has no Requestbroker, wi ignore the problem: " + e.getMessage());
                e.printStackTrace();
                return;
            }
            MsgQosData retMsgQosData = updateEntry.getMsgQosData();
            this.log.trace(this.ME, "Received" + retMsgQosData.toXml());
            Assert.assertEquals("The key of the message unit is different ", key.getOid(), retMsgUnit.getKeyData().getOid());
            Assert.assertEquals("The content of the message unit is different ", new String(retMsgUnit.getContent()), new String(content));
            String oldXml = publishQosServer.toXml().trim();
            String newXml = retMsgUnit.getQosData().toXml().trim();
            Assert.assertEquals("msgQosData check failure: getSubscriptionId      ", msgQosData.getSubscriptionId(), retMsgQosData.getSubscriptionId());
            Assert.assertEquals("msgQosData check failure: getSender              ", msgQosData.getSender().toString(), retMsgQosData.getSender().toString());
            Assert.assertEquals("msgQosData check failure: getRedeliver           ", msgQosData.getRedeliver(), retMsgQosData.getRedeliver());
            Assert.assertEquals("msgQosData check failure: getQueueSize           ", msgQosData.getQueueSize(), retMsgQosData.getQueueSize());
            Assert.assertEquals("msgQosData check failure: getQueueIndex          ", msgQosData.getQueueIndex(), retMsgQosData.getQueueIndex());
            Assert.assertEquals("msgQosData check failure: getPriority            ", msgQosData.getPriority().getInt(), retMsgQosData.getPriority().getInt());
            Assert.assertEquals("msgQosData check failure: getLifeTime            ", msgQosData.getLifeTime(), retMsgQosData.getLifeTime());
            Assert.assertEquals("msgQosData check failure: receiver", receiver, updateEntry.getReceiver());
            this.queue.removeRandom(returnEntry);
            this.log.info(this.ME, "successfully completed tests for the updateEntry");
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
            throw ex;
        }
    }

    public void testHistoryEntry() {
        String queueType = "unknown";
        try {
            this.historyEntry();
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing HistoryEntry probably due to failed initialization of the queue of type " + queueType + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void historyEntry() throws XmlBlasterException {
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        this.log.info(this.ME, "********* Starting historyEntry Test");
        long t0 = System.currentTimeMillis();
        StorageId queueId = new StorageId("history", "historyEntry");
        this.queue.initialize(queueId, prop);
        this.queue.clear();
        long t1 = System.currentTimeMillis() - t0;
        t0 = System.currentTimeMillis();
        try {
            byte[] content = "this is the content".getBytes();
            PublishKey key = new PublishKey((Global)this.glob, "someKey");
            PublishQosServer publishQosServer = new PublishQosServer(this.glob, "<qos><persistent/></qos>");
            MsgQosData msgQosData = publishQosServer.getData();
            ((MsgQosSaxFactory)this.glob.getMsgQosFactory()).sendRemainingLife(false);
            msgQosData.setState("state");
            msgQosData.setSubscriptionId("someId");
            msgQosData.setPersistent(true);
            msgQosData.setForceUpdate(false);
            msgQosData.setReadonly(true);
            msgQosData.setSender(new SessionName(this.glob, "somebody"));
            msgQosData.setRedeliver(4);
            msgQosData.setQueueSize(1000L);
            msgQosData.setQueueIndex(500L);
            msgQosData.setPriority(PriorityEnum.LOW4_PRIORITY);
            msgQosData.setFromPersistenceStore(true);
            msgQosData.setLifeTime(4000L);
            msgQosData.setRemainingLifeStatic(6000L);
            MsgUnit msgUnit = new MsgUnit(key.toXml(), content, msgQosData.toXml());
            this.log.trace(this.ME, "Testing" + msgQosData.toXml());
            org.xmlBlaster.engine.Global global = new org.xmlBlaster.engine.Global();
            MsgUnitWrapper msgWrapper = new MsgUnitWrapper(this.glob, msgUnit, this.queue.getStorageId());
            MsgQueueHistoryEntry entry = new MsgQueueHistoryEntry(global, msgWrapper, this.queue.getStorageId());
            this.queue.put(entry, false);
            I_QueueEntry returnEntry = this.queue.peek();
            boolean isHistory = returnEntry instanceof MsgQueueHistoryEntry;
            Assert.assertTrue("historyEntry: the return value is not an update ", isHistory);
            MsgQueueHistoryEntry historyEntry = (MsgQueueHistoryEntry)returnEntry;
            Assert.assertEquals("The priority of the entry is different ", entry.getPriority(), historyEntry.getPriority());
            Assert.assertEquals("The persistent of the entry is different ", entry.isPersistent(), historyEntry.isPersistent());
            Assert.assertEquals("The uniqueId of the entry is different ", entry.getUniqueId(), historyEntry.getUniqueId());
            Assert.assertEquals("The msgUnitWrapperUniqueId of the entry is different ", entry.getMsgUnitWrapperUniqueId(), historyEntry.getMsgUnitWrapperUniqueId());
            Assert.assertEquals("The topic oid of the entry is different ", entry.getKeyOid(), historyEntry.getKeyOid());
            Assert.assertEquals("The topic oid of the entry is different ", entry.getStorageId().getId(), historyEntry.getStorageId().getId());
            this.log.info(this.ME, "Persistent fields are read as expected");
            MsgUnit retMsgUnit = null;
            try {
                retMsgUnit = historyEntry.getMsgUnit();
            }
            catch (Throwable e) {
                this.log.error(this.ME, "Lookup failed, probably engine.Global has no Requestbroker, wi ignore the problem: " + e.getMessage());
                e.printStackTrace();
                return;
            }
            MsgQosData retMsgQosData = historyEntry.getMsgQosData();
            this.log.trace(this.ME, "Received" + retMsgQosData.toXml());
            Assert.assertEquals("The key of the message unit is different ", key.getOid(), retMsgUnit.getKeyData().getOid());
            Assert.assertEquals("The content of the message unit is different ", new String(retMsgUnit.getContent()), new String(content));
            String oldXml = publishQosServer.toXml().trim();
            Assert.assertEquals("msgQosData check failure: getSubscriptionId      ", msgQosData.getSubscriptionId(), retMsgQosData.getSubscriptionId());
            Assert.assertEquals("msgQosData check failure: getSender              ", msgQosData.getSender().toString(), retMsgQosData.getSender().toString());
            Assert.assertEquals("msgQosData check failure: getRedeliver           ", msgQosData.getRedeliver(), retMsgQosData.getRedeliver());
            Assert.assertEquals("msgQosData check failure: getQueueSize           ", msgQosData.getQueueSize(), retMsgQosData.getQueueSize());
            Assert.assertEquals("msgQosData check failure: getQueueIndex          ", msgQosData.getQueueIndex(), retMsgQosData.getQueueIndex());
            Assert.assertEquals("msgQosData check failure: getPriority            ", msgQosData.getPriority().getInt(), retMsgQosData.getPriority().getInt());
            Assert.assertEquals("msgQosData check failure: getLifeTime            ", msgQosData.getLifeTime(), retMsgQosData.getLifeTime());
            this.queue.removeRandom(returnEntry);
            this.log.info(this.ME, "successfully completed tests for the historyEntry");
        }
        catch (XmlBlasterException ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "exception occured : " + ex.getMessage());
            throw ex;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new QueueServerEntryTest(glob, "testUpdateEntry", i));
            suite.addTest(new QueueServerEntryTest(glob, "testHistoryEntry", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        org.xmlBlaster.engine.Global glob = new org.xmlBlaster.engine.Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            QueueServerEntryTest testSub = new QueueServerEntryTest(glob, "QueueServerEntryTest", i);
            long startTime = System.currentTimeMillis();
            testSub.setUp();
            testSub.testUpdateEntry();
            testSub.tearDown();
            testSub.setUp();
            testSub.testHistoryEntry();
            testSub.tearDown();
            long usedTime = System.currentTimeMillis() - startTime;
            testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
            ++i;
        }
    }
}

