/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.sql.SQLException;
import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.PriorityEnum;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queuemsg.DummyEntry;

class QueueThread
extends Thread {
    private static final String ME = "QueueThread";
    private I_Queue queue = null;
    private int sweeps = 5;
    private LogChannel log = null;
    private String name = null;
    private int sizeOfMsg = 0;
    private Global glob = null;
    public static int counter = 0;
    private ArrayList entryList;

    public QueueThread(Global glob, String name, I_Queue queue, LogChannel log, int sweeps, int sizeOfMsg) throws XmlBlasterException, SQLException {
        this.glob = glob;
        this.log = this.glob.getLog("queuethread");
        this.name = name;
        this.queue = queue;
        this.sweeps = sweeps;
        this.sizeOfMsg = sizeOfMsg;
        ++counter;
    }

    protected void runPut() {
        this.entryList = new ArrayList(this.sweeps);
        int i = 0;
        while (i < this.sweeps) {
            this.log.trace(this.name, "runPut sweep " + i + " entered");
            try {
                this.log.trace(this.name, "runPut sweep: " + i + " still running: " + counter);
                DummyEntry entry = new DummyEntry(this.glob, PriorityEnum.NORM_PRIORITY, this.queue.getStorageId(), this.sizeOfMsg, true);
                this.entryList.add(entry);
                this.queue.put(entry, false);
                this.log.trace(this.name, "after invocation");
            }
            catch (Exception ex) {
                this.log.error(this.name, "exception in thread " + ex.getMessage());
                ex.printStackTrace();
            }
            ++i;
        }
    }

    protected void runPeekAllRemoveOneByOne() {
        try {
            this.queue.peek(this.sweeps, -1L);
            int j = 0;
            while (j < this.sweeps) {
                this.queue.removeRandom((DummyEntry)this.entryList.get(j));
                ++j;
            }
        }
        catch (Exception ex) {
            this.log.error(this.name, "exception in thread " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void run() {
        this.log.call(ME, "run method entered");
        this.runPut();
        --counter;
    }
}

