/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.classtest.queue;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.test.classtest.queue.QueueThread;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.plugin.I_PluginManager;
import org.xmlBlaster.util.plugin.PluginInfo;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;
import org.xmlBlaster.util.queue.I_Queue;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.queue.StorageId;

public class QueueThreadingTest
extends TestCase {
    private String ME = "QueueThreadingTest";
    protected Global glob;
    protected LogChannel log;
    private StopWatch stopWatch = new StopWatch();
    private int numOfQueues = 10;
    private int numOfMsg = 10000;
    private int sizeOfMsg = 100;
    private I_Queue[] queues = null;
    public ArrayList queueList = null;
    public static String[] PLUGIN_TYPES = new String[]{new String("RAM"), new String("JDBC"), new String("CACHE")};
    public int count = 0;

    public QueueThreadingTest(Global glob, String name, int currImpl) {
        super(name);
        this.glob = glob;
        this.numOfQueues = glob.getProperty().get("queues", 2);
        this.numOfMsg = glob.getProperty().get("entries", 100);
        this.sizeOfMsg = glob.getProperty().get("sizes", 10);
        this.count = currImpl;
    }

    protected void setUp() {
        this.log = this.glob.getLog("test");
        try {
            this.glob.getProperty().set("cb.queue.persistent.tableNamePrefix", "TEST");
            this.ME = "QueueThreadingTest with class: " + PLUGIN_TYPES[this.count];
        }
        catch (Exception ex) {
            this.log.error(this.ME, "setUp: error when setting the property 'cb.queue.persistent.tableNamePrefix' to 'TEST'" + ex.getMessage());
        }
        Object prop = null;
        try {
            QueuePluginManager pluginManager = new QueuePluginManager(this.glob);
            PluginInfo pluginInfo = new PluginInfo(this.glob, (I_PluginManager)pluginManager, "JDBC", "1.0");
            Properties pluginProp = pluginInfo.getParameters();
            ((Hashtable)pluginProp).put("tableNamePrefix", "TEST");
            ((Hashtable)pluginProp).put("nodesTableName", "_nodes");
            ((Hashtable)pluginProp).put("queuesTableName", "_queues");
            ((Hashtable)pluginProp).put("entriesTableName", "_entries");
            this.glob.getProperty().set("QueuePlugin[JDBC][1.0]", pluginInfo.dumpPluginParameters());
        }
        catch (Exception ex) {
            this.log.error(this.ME, "could not propertly set up the database: " + ex.getMessage());
        }
    }

    public void tearDown() {
        int i = 0;
        while (i < this.queues.length) {
            try {
                this.queues[i].clear();
                this.queues[i].shutdown();
            }
            catch (Exception ex) {
                this.log.warn(this.ME, "error when tearing down " + ex.getMessage() + " this normally happens when invoquing multiple times cleanUp " + ex.getMessage());
            }
            ++i;
        }
    }

    public void testPerfomancePutMultiThread() {
        String queueType = "unknown";
        try {
            this.performancePutMultiThread(this.numOfQueues, this.numOfMsg, this.sizeOfMsg);
        }
        catch (XmlBlasterException ex) {
            Assert.fail("Exception when testing performancePutMultiThread probably due to failed initialization of the queue of type " + queueType + " " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    public void performancePutMultiThread(int numOfQueues, int numOfMsg, int sizeOfMsg) throws XmlBlasterException {
        this.queues = new I_Queue[numOfQueues];
        int threadsPerQueue = 5;
        QueueThread[] queueThreads = new QueueThread[numOfQueues * threadsPerQueue];
        CbQueueProperty prop = new CbQueueProperty(this.glob, "callback", "/node/test");
        prop.setMaxEntries(numOfMsg * threadsPerQueue + 1);
        this.log.info(this.ME, "starting setting up " + numOfQueues + " queues");
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < numOfQueues) {
            try {
                StorageId queueId = new StorageId("callback", "perfomance/Put_" + i);
                this.queues[i] = this.glob.getQueuePluginManager().getPlugin(PLUGIN_TYPES[i], "1.0", queueId, prop);
                this.queues[i].clear();
            }
            catch (Exception ex) {
                Assert.fail(this.ME + " exception when constructing the queue object. " + ex.getMessage());
            }
            try {
                int j = 0;
                while (j < threadsPerQueue) {
                    queueThreads[i * threadsPerQueue + j] = new QueueThread(this.glob, "queue" + i, this.queues[i], this.log, numOfMsg, sizeOfMsg);
                    ++j;
                }
            }
            catch (Exception ex) {
                this.log.error(this.ME, "Exception when instantiating the thread " + i + " " + ex.getMessage());
            }
            ++i;
        }
        long t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "setting up " + numOfQueues + " queues took " + 1.0 * (double)t1 / 1000.0 + " seconds");
        t0 = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < numOfQueues * threadsPerQueue) {
            queueThreads[i2].start();
            ++i2;
        }
        try {
            while (QueueThread.counter > 0) {
                Thread.currentThread();
                Thread.sleep(100L);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        t1 = System.currentTimeMillis() - t0;
        this.log.info(this.ME, "performacePutMultiThread putting " + numOfMsg + " messages in " + numOfQueues + " queues with " + threadsPerQueue + " threads per queue took " + 1.0 * (double)t1 / 1000.0 + " seconds");
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        Global glob = new Global();
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            suite.addTest(new QueueThreadingTest(glob, "testPerfomancePutMultiThread", i));
            ++i;
        }
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int i = 0;
        while (i < PLUGIN_TYPES.length) {
            QueueThreadingTest testSub = new QueueThreadingTest(glob, "QueueThreadingTest", i);
            long startTime = System.currentTimeMillis();
            testSub.setUp();
            testSub.testPerfomancePutMultiThread();
            testSub.tearDown();
            long usedTime = System.currentTimeMillis() - startTime;
            testSub.log.info(testSub.ME, "time used for tests: " + usedTime / 1000L + " seconds");
            ++i;
        }
    }
}

