/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.Address;

public class TestFailSafe
extends TestCase
implements I_ConnectionStateListener {
    private static String ME = "TestFailSafe";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private I_XmlBlasterAccess con;
    private String senderName;
    private int numPublish = 8;
    private int numStop = 3;
    private int numStart = 5;
    private final String contentMime = "text/plain";
    private final long reconnectDelay = 2000L;

    public TestFailSafe(String testName) {
        this(null, testName);
    }

    public TestFailSafe(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? Global.instance() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
        this.log.info(ME, "XmlBlaster is ready for testing on bootstrapPort " + this.serverPort);
        try {
            this.con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(2000L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(-1L);
            this.con.registerConnectionListener(this);
            connectQos.setAddress(addressProp);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.con.connect(connectQos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.getMessage());
            Assert.fail("setUp() - login fail: " + e.getMessage());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login fail: " + e.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafe-AGENT</key>";
        String qos = "<qos><forceDestroy>true</forceDestroy></qos>";
        try {
            try {
                EraseReturnQos[] arr = this.con.erase(xmlKey, qos);
                PropString defaultPlugin = new PropString("CACHE,1.0");
                String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
                this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
                if (defaultPlugin.getValue().startsWith("RAM")) {
                    Assert.assertEquals("Wrong number of message erased", this.numPublish - this.numStop, arr.length);
                }
                Assert.assertEquals("Wrong number of message erased", this.numPublish, arr.length);
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
                Object var7_8 = null;
                this.con.disconnect(null);
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.glob);
                this.glob = null;
                this.con = null;
                Global.instance().shutdown();
                return;
            }
            Object var7_7 = null;
            this.con.disconnect(null);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.con.disconnect(null);
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts(this.glob);
            this.glob = null;
            this.con = null;
            Global.instance().shutdown();
            throw throwable;
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.glob);
        this.glob = null;
        this.con = null;
        Global.instance().shutdown();
    }

    public void doSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafe-AGENT</key>";
        String qos = "<qos></qos>";
        try {
            SubscribeReturnQos subscriptionId = this.con.subscribe(xmlKey, qos);
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + subscriptionId.getSubscriptionId() + " done");
            Assert.assertTrue("returned null subscriptionId", subscriptionId != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish(int counter) throws XmlBlasterException {
        String oid = "Message-" + counter;
        this.log.info(ME, "Publishing a message " + oid + " ...");
        String xmlKey = "<key oid='" + oid + "' contentMime='" + "text/plain" + "'>\n" + "   <TestFailSafe-AGENT id='192.168.124.10' subId='1' type='generic'>" + "   </TestFailSafe-AGENT>" + "</key>";
        String content = "" + counter;
        PublishQos qosWrapper = new PublishQos(this.glob);
        MsgUnit msgUnit = new MsgUnit(xmlKey, content.getBytes(), qosWrapper.toXml());
        this.con.publish(msgUnit);
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    public void testFailSafe() {
        this.log.info(ME, "Going to publish " + this.numPublish + " messages, xmlBlaster will be down for message 3 and 4");
        int ii = 0;
        while (ii < this.numPublish) {
            try {
                if (ii == this.numStop) {
                    this.log.info(ME, "Stopping xmlBlaster, but continue with publishing ...");
                    EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                    this.serverThread = null;
                }
                if (ii == this.numStart) {
                    this.log.info(ME, "Starting xmlBlaster again, expecting the previous published two messages ...");
                    this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
                    this.log.info(ME, "xmlBlaster started, waiting on tail back messsages");
                    Assert.assertEquals("", 2, this.updateInterceptor.waitOnUpdate(4000L, 2));
                    this.updateInterceptor.clear();
                }
                this.doPublish(ii + 1);
                if (ii < this.numStop || ii >= this.numStart) {
                    Assert.assertEquals("", 1, this.updateInterceptor.waitOnUpdate(4000L, 1));
                }
                this.updateInterceptor.clear();
            }
            catch (XmlBlasterException e) {
                if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_POLLING) {
                    this.log.warn(ME, "Lost connection, my connection layer is polling: " + e.getMessage());
                }
                if (e.getErrorCode() == ErrorCode.COMMUNICATION_NOCONNECTION_DEAD) {
                    Assert.assertTrue("Lost connection, my connection layer is NOT polling", false);
                }
                Assert.assertTrue("Publishing problems: " + e.getMessage(), false);
            }
            ++ii;
        }
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener: We were lucky, reconnected to xmlBlaster");
        this.doSubscribe();
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.warn(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.POLLING);
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.out.println(ME + ": Init failed");
            System.exit(1);
        }
        TestFailSafe testSub = new TestFailSafe(glob, "TestFailSafe");
        testSub.setUp();
        testSub.testFailSafe();
        testSub.tearDown();
    }
}

