/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.client;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.property.PropString;
import org.xmlBlaster.util.qos.address.Address;

public class TestFailSafeAsync
extends TestCase
implements I_Callback,
I_ConnectionStateListener {
    private static String ME = "TestFailSafeAsync";
    private Global glob;
    private LogChannel log;
    private boolean messageArrived = false;
    private int serverPort = 7604;
    private EmbeddedXmlBlaster serverThread;
    private MsgInterceptor updateInterceptor;
    private I_XmlBlasterAccess con;
    private String senderName;
    private int numReceived;
    private int numTailbackReceived;
    private int numNormalPublishReceived;
    private final String contentMime = "text/plain";
    private boolean reconnected;
    private boolean allTailbackAreFlushed;
    private final int maxEntries = 100;
    private final int failMsg = 20;
    private final int reconnectMsg = 40;
    private final long publishRate = 5L;
    private final long pullbackRate = 1L;
    PublishKey publishKeyWrapper;
    PublishQos publishQosWrapper;

    public TestFailSafeAsync(String testName) {
        this(null, testName);
    }

    public TestFailSafeAsync(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.senderName = testName;
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        this.numReceived = 0;
        this.numTailbackReceived = 0;
        this.numNormalPublishReceived = 0;
        this.reconnected = false;
        this.allTailbackAreFlushed = true;
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(Util.getOtherServerPorts(this.serverPort));
        try {
            this.numReceived = 0;
            this.con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            Address addressProp = new Address(this.glob);
            addressProp.setDelay(400L);
            addressProp.setRetries(-1);
            addressProp.setPingInterval(400L);
            this.con.registerConnectionListener(this);
            connectQos.setAddress(addressProp);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, this);
            this.con.connect(connectQos, this.updateInterceptor);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "setUp() - login failed: " + e.toString());
            Assert.fail("setUp() - login failed: " + e.toString());
        }
        catch (Exception e) {
            this.log.error(ME, "setUp() - login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("setUp() - login failed: " + e.toString());
        }
        this.publishKeyWrapper = new PublishKey(this.glob, "emptyOid", "text/plain");
        this.publishKeyWrapper.setClientTags("<TestFailSafeAsync-AGENT id='192.168.124.10' subId='1' type='generic'/>");
        this.publishQosWrapper = new PublishQos(this.glob);
    }

    protected void tearDown() {
        block9: {
            this.log.info(ME, "Entering tearDown(), test is finished");
            String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafeAsync-AGENT</key>";
            EraseQos eraseQos = new EraseQos(this.glob);
            eraseQos.setForceDestroy(true);
            try {
                try {
                    EraseReturnQos[] arr = this.con.erase(xmlKey, eraseQos.toXml());
                    PropString defaultPlugin = new PropString("CACHE,1.0");
                    String propName = defaultPlugin.setFromEnv(this.glob, this.glob.getStrippedId(), null, "persistence", "topicStore", "defaultPlugin");
                    this.log.info(ME, "Lookup of propName=" + propName + " defaultValue=" + defaultPlugin.getValue());
                    if (defaultPlugin.getValue().startsWith("RAM")) {
                        Assert.assertEquals("Wrong number of message erased", 80, arr.length);
                    } else {
                        Assert.assertEquals("Wrong number of message erased", 100, arr.length);
                    }
                }
                catch (XmlBlasterException e) {
                    Assert.assertTrue("tearDown - XmlBlasterException: " + e.getMessage(), false);
                }
                this.con.disconnect(null);
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    Thread.currentThread();
                    Thread.sleep(200L);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.resetPorts(this.glob);
                this.glob = null;
                this.log = null;
                this.con = null;
                this.updateInterceptor = null;
                Global.instance().shutdown();
                this.publishKeyWrapper = null;
                this.publishQosWrapper = null;
                throw throwable;
            }
            try {
                Thread.currentThread();
                Thread.sleep(200L);
                break block9;
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            {
            }
        }
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.con = null;
        this.updateInterceptor = null;
        Global.instance().shutdown();
        this.publishKeyWrapper = null;
        this.publishQosWrapper = null;
    }

    public void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   //TestFailSafeAsync-AGENT</key>";
        String qos = "<qos></qos>";
        try {
            String subscribeOid = this.con.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void publish(int counter) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        long publishDelay = 200L;
        String oid = "MSG-" + counter;
        try {
            this.publishKeyWrapper.setOid(oid);
            String content = "" + counter;
            MsgUnit msgUnit = new MsgUnit(this.publishKeyWrapper.toXml(), content.getBytes(), this.publishQosWrapper.toXml());
            this.con.publish(msgUnit);
            Util.delay(publishDelay);
        }
        catch (XmlBlasterException e) {
            Assert.fail(ME + ": Publish failed: " + e.toString());
        }
        this.log.info(ME, "Success: Publishing of " + oid + " done");
    }

    public void testFailSafe() {
        int ii = 0;
        while (ii < 100) {
            if (ii == 20) {
                EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
                this.serverThread = null;
                Util.delay(600L);
                this.log.info(ME, "lostConnection, sending message " + ii + " - " + 39);
            }
            if (ii == 40) {
                this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
                while (!this.reconnected) {
                    Util.delay(10L);
                }
                this.log.info(ME, "Reconnected, sending message " + ii + " - " + 99);
            }
            this.publish(ii);
            ++ii;
        }
        int numFailsave = 20;
        int numPublish = 100 - numFailsave;
        long wait = 5000L + (long)(1000.0 * (double)numPublish / 5.0 + 1000.0 * (double)numFailsave / 1.0);
        Assert.assertEquals("", 100, this.updateInterceptor.waitOnUpdate(wait, 100));
        this.log.info(ME, "******* testFailSafe() DONE");
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener: We were lucky, (re)connected to xmlBlaster");
        this.subscribe();
        this.reconnected = true;
        this.allTailbackAreFlushed = true;
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.warn(ME, "I_ConnectionStateListener: Lost connection to xmlBlaster");
        }
        this.allTailbackAreFlushed = false;
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        TestFailSafeAsync testFailSafeAsync = this;
        synchronized (testFailSafeAsync) {
            String oid = updateKey.getOid();
            if (updateQos.isErased()) {
                String string = "";
                return string;
            }
            ++this.numReceived;
            Assert.assertEquals("Wrong sender", this.senderName, updateQos.getSender().getLoginName());
            Assert.assertEquals("Message contentMime is corrupted", "text/plain", updateKey.getContentMime());
            int ii = 0;
            try {
                ii = Integer.parseInt(oid.substring("MSG-".length()));
            }
            catch (NumberFormatException e) {
                this.log.error(ME, "Can't extract message number " + oid);
                Assert.fail("Can't extract message number " + oid);
            }
            if (ii >= 20 && ii < 40) {
                ++this.numTailbackReceived;
            } else {
                ++this.numNormalPublishReceived;
            }
            try {
                int contentCounter = 0;
                String cnt = new String(content);
                contentCounter = Integer.parseInt(cnt);
                Assert.assertEquals("Wrong counter in content", ii, contentCounter);
            }
            catch (NumberFormatException e) {
                this.log.error(ME, "Can't extract message number '" + new String(content) + "': " + updateQos.toXml());
            }
            this.log.info(ME, "Update message oid=" + oid + " numReceived=" + this.numReceived + ", numNormalPublishReceived=" + this.numNormalPublishReceived + " numTailbackReceived=" + this.numTailbackReceived + " ...");
            this.messageArrived = true;
        }
        return "";
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            glob.getLog(null).error(ME, "Init failed");
            System.exit(1);
        }
        TestFailSafeAsync testSub = new TestFailSafeAsync(glob, "TestFailSafeAsync");
        testSub.setUp();
        testSub.testFailSafe();
        testSub.tearDown();
    }
}

